/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.function.real;

import net.imglib2.ops.function.Function;
import net.imglib2.type.numeric.RealType;

public class RealDistanceFromPointFunction<T extends RealType<T>>
implements Function<long[], T> {
    private final T var;
    private final double[] pt;

    public RealDistanceFromPointFunction(double[] pt, T var) {
        this.var = (RealType)var.createVariable();
        this.pt = (double[])pt.clone();
    }

    @Override
    public void compute(long[] input, T output) {
        double sum = 0.0;
        for (int i = 0; i < input.length; ++i) {
            double delta = (double)input[i] - this.pt[i];
            sum += delta * delta;
        }
        double dist = Math.sqrt(sum);
        output.setReal(dist);
    }

    @Override
    public T createOutput() {
        return (T)((RealType)this.var.createVariable());
    }

    public RealDistanceFromPointFunction<T> copy() {
        return new RealDistanceFromPointFunction<T>(this.pt, this.var);
    }
}

