/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.function.real;

import net.imglib2.ops.function.Function;
import net.imglib2.ops.function.real.RealWeightedSumFunction;
import net.imglib2.ops.pointset.PointSet;
import net.imglib2.type.numeric.RealType;

public class RealConvolutionFunction<T extends RealType<T>>
implements Function<PointSet, T> {
    private final Function<long[], T> otherFunc;
    private final double[] kernel;
    private final RealWeightedSumFunction<T> weightedSum;

    public RealConvolutionFunction(Function<long[], T> otherFunc, double[] kernel) {
        this.otherFunc = otherFunc;
        this.kernel = kernel;
        this.weightedSum = new RealWeightedSumFunction<T>(otherFunc, kernel);
    }

    @Override
    public void compute(PointSet input, T output) {
        this.weightedSum.compute(input, output);
    }

    @Override
    public T createOutput() {
        return (T)((RealType)this.otherFunc.createOutput());
    }

    public RealConvolutionFunction<T> copy() {
        return new RealConvolutionFunction<T>(this.otherFunc.copy(), (double[])this.kernel.clone());
    }
}

