/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.function.real;

import net.imglib2.ops.function.Function;
import net.imglib2.type.numeric.RealType;

public class RealContinuousIntegralFunction<T extends RealType<T>>
implements Function<double[], T> {
    private final Function<double[], T> otherFunc;
    private final double[] deltas;
    private final double[] ranges;
    private final double cellSize;
    private final T variable;
    private final double[] position;

    public RealContinuousIntegralFunction(Function<double[], T> otherFunc, double[] ranges, double[] deltas) {
        this.otherFunc = otherFunc;
        this.ranges = (double[])ranges.clone();
        this.deltas = (double[])deltas.clone();
        this.variable = this.createOutput();
        this.cellSize = this.cellSize(deltas);
        this.position = new double[deltas.length];
    }

    @Override
    public void compute(double[] point, T output) {
        for (int i = 0; i < this.position.length; ++i) {
            this.position[i] = point[i];
        }
        double sum = 0.0;
        boolean done = false;
        while (!done) {
            this.otherFunc.compute(this.position, this.variable);
            sum += this.variable.getRealDouble() * this.cellSize;
            done = !this.nextPosition(this.position, point);
        }
        output.setReal(sum);
    }

    public RealContinuousIntegralFunction<T> copy() {
        return new RealContinuousIntegralFunction<T>(this.otherFunc.copy(), this.ranges, this.deltas);
    }

    @Override
    public T createOutput() {
        return (T)((RealType)this.otherFunc.createOutput());
    }

    private double cellSize(double[] sizes) {
        if (sizes.length == 0) {
            return 0.0;
        }
        double totalSize = 1.0;
        for (double size : sizes) {
            totalSize *= size;
        }
        return totalSize;
    }

    private boolean nextPosition(double[] pos, double[] startPt) {
        for (int i = 0; i < pos.length; ++i) {
            int n = i;
            pos[n] = pos[n] + this.deltas[i];
            if (pos[i] <= startPt[i] + this.ranges[i]) {
                return true;
            }
            pos[i] = startPt[i];
        }
        return false;
    }
}

