/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.function.real;

import net.imglib2.ops.function.Function;
import net.imglib2.type.numeric.RealType;

public class RealAngleFromOriginFunction<T extends RealType<T>>
implements Function<long[], T> {
    private final T var;
    private final int axisU;
    private final int axisV;

    public RealAngleFromOriginFunction(int axisU, int axisV, T var) {
        this.var = (RealType)var.createVariable();
        this.axisU = axisU;
        this.axisV = axisV;
    }

    @Override
    public void compute(long[] input, T output) {
        double du = input[this.axisU];
        double dv = input[this.axisV];
        output.setReal(Math.atan2(dv, du));
    }

    @Override
    public T createOutput() {
        return (T)((RealType)this.var.createVariable());
    }

    public RealAngleFromOriginFunction<T> copy() {
        return new RealAngleFromOriginFunction<T>(this.axisU, this.axisV, this.var);
    }
}

