/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.function.real;

import java.util.ArrayList;
import java.util.List;
import net.imglib2.ops.function.Function;
import net.imglib2.ops.function.real.PrimitiveDoubleArray;
import net.imglib2.ops.function.real.RealSampleCollector;
import net.imglib2.ops.pointset.PointSet;
import net.imglib2.type.numeric.RealType;

public class RealAdaptiveMedianFunction<T extends RealType<T>>
implements Function<PointSet, T> {
    private final Function<long[], T> otherFunc;
    private final List<PointSet> pointSets;
    private final PrimitiveDoubleArray values;
    private final RealSampleCollector<T> collector;
    private final T currValue;
    private final long[] tmpDeltas;

    public RealAdaptiveMedianFunction(Function<long[], T> otherFunc, List<PointSet> pointSets) {
        this.otherFunc = otherFunc;
        this.pointSets = pointSets;
        this.values = new PrimitiveDoubleArray();
        this.collector = new RealSampleCollector();
        this.currValue = this.createOutput();
        if (pointSets.size() < 1) {
            throw new IllegalArgumentException("must provide at least one point set");
        }
        for (PointSet ps : pointSets) {
            if (ps.numDimensions() == pointSets.get(0).numDimensions()) continue;
            throw new IllegalArgumentException("all point sets must have same dimensionality");
        }
        this.tmpDeltas = new long[pointSets.get(0).numDimensions()];
    }

    @Override
    public void compute(PointSet points, T output) {
        double zMed = 0.0;
        for (int p = 0; p < this.pointSets.size(); ++p) {
            PointSet pointSet = this.pointSets.get(p);
            this.move(pointSet, points.getOrigin());
            this.collector.collect(pointSet, this.otherFunc, this.values);
            this.values.sortValues();
            zMed = this.medianValue();
            double zMin = this.minValue();
            double zMax = this.maxValue();
            if (!(zMin < zMed) || !(zMed < zMax)) continue;
            this.otherFunc.compute(pointSet.getOrigin(), this.currValue);
            double zXY = this.currValue.getRealDouble();
            if (zMin < zXY && zXY < zMax) {
                output.setReal(zXY);
            } else {
                output.setReal(zMed);
            }
            return;
        }
        output.setReal(zMed);
    }

    public RealAdaptiveMedianFunction<T> copy() {
        ArrayList<PointSet> pointSetsCopy = new ArrayList<PointSet>();
        for (int i = 0; i < this.pointSets.size(); ++i) {
            PointSet ps = this.pointSets.get(i);
            pointSetsCopy.add(ps.copy());
        }
        return new RealAdaptiveMedianFunction<T>(this.otherFunc.copy(), pointSetsCopy);
    }

    @Override
    public T createOutput() {
        return (T)((RealType)this.otherFunc.createOutput());
    }

    private double medianValue() {
        int numElements = this.values.size();
        if (numElements == 0) {
            throw new IllegalArgumentException("cannot find median: no samples provided");
        }
        if (numElements % 2 == 1) {
            return this.values.get(numElements / 2);
        }
        double value1 = this.values.get(numElements / 2 - 1);
        double value2 = this.values.get(numElements / 2);
        return (value1 + value2) / 2.0;
    }

    private double minValue() {
        return this.values.get(0);
    }

    private double maxValue() {
        return this.values.get(this.values.size() - 1);
    }

    private void move(PointSet ps, long[] origin) {
        boolean mustTranslate = false;
        long[] psOrg = ps.getOrigin();
        for (int i = 0; i < this.tmpDeltas.length; ++i) {
            this.tmpDeltas[i] = origin[i] - psOrg[i];
            mustTranslate |= this.tmpDeltas[i] != 0L;
        }
        if (mustTranslate) {
            ps.translate(this.tmpDeltas);
        }
    }
}

