/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.function.real;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;

public class PrimitiveDoubleArray {
    private double[] values = new double[9];
    private int top = 0;

    public void clear() {
        this.top = 0;
    }

    public void add(double v) {
        if (this.top == this.values.length) {
            int newLen = this.top * 2;
            this.values = Arrays.copyOf(this.values, newLen);
        }
        this.values[this.top++] = v;
    }

    public double get(int index) {
        return this.values[index];
    }

    public int size() {
        return this.top;
    }

    public void sortValues() {
        Arrays.sort(this.values, 0, this.top);
    }

    private static void speedTest() {
        int j;
        int i;
        ArrayList<Double> list = new ArrayList<Double>();
        PrimitiveDoubleArray array = new PrimitiveDoubleArray();
        for (int i2 = 0; i2 < 1000; ++i2) {
            list.add(Double.valueOf(i2));
            array.add(i2);
        }
        Random rng = new Random();
        rng.setSeed(100L);
        long start = System.currentTimeMillis();
        for (i = 0; i < 500; ++i) {
            list.clear();
            for (j = 0; j < 100; ++j) {
                list.add(rng.nextDouble());
            }
            Collections.sort(list);
        }
        long stop = System.currentTimeMillis();
        System.out.println("ArrayList time = " + (stop - start));
        rng.setSeed(100L);
        start = System.currentTimeMillis();
        for (i = 0; i < 500; ++i) {
            array.clear();
            for (j = 0; j < 100; ++j) {
                array.add(rng.nextDouble());
            }
            array.sortValues();
        }
        stop = System.currentTimeMillis();
        System.out.println("Primitive array time = " + (stop - start));
    }

    public static void main(String[] args) {
        PrimitiveDoubleArray.speedTest();
    }
}

