/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.function.real;

import net.imglib2.ops.function.Function;
import net.imglib2.ops.function.real.StatCalculator;
import net.imglib2.ops.pointset.PointSet;
import net.imglib2.type.numeric.RealType;

public abstract class AbstractRealStatFunction<T extends RealType<T>>
implements Function<PointSet, T> {
    protected final Function<long[], T> otherFunc;
    private StatCalculator<T> calculator;

    public AbstractRealStatFunction(Function<long[], T> otherFunc) {
        this.otherFunc = otherFunc;
        this.calculator = null;
    }

    @Override
    public void compute(PointSet input, T output) {
        if (this.calculator == null) {
            this.calculator = new StatCalculator<T>(this.otherFunc, input);
        } else {
            this.calculator.reset(this.otherFunc, input);
        }
        double value = this.value(this.calculator);
        output.setReal(value);
    }

    @Override
    public T createOutput() {
        return (T)((RealType)this.otherFunc.createOutput());
    }

    protected abstract double value(StatCalculator<T> var1);
}

