/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.function.general;

import net.imglib2.ops.function.Function;

public class DiscreteTranslationFunction<T>
implements Function<long[], T> {
    private final Function<long[], T> otherFunc;
    private final long[] deltas;
    private final long[] localPoint;

    public DiscreteTranslationFunction(Function<long[], T> otherFunc, long[] deltas) {
        this.otherFunc = otherFunc;
        this.deltas = deltas;
        this.localPoint = new long[deltas.length];
    }

    @Override
    public void compute(long[] point, T output) {
        for (int i = 0; i < this.deltas.length; ++i) {
            this.localPoint[i] = point[i] + this.deltas[i];
        }
        this.otherFunc.compute(this.localPoint, output);
    }

    @Override
    public T createOutput() {
        return this.otherFunc.createOutput();
    }

    public DiscreteTranslationFunction<T> copy() {
        return new DiscreteTranslationFunction<T>(this.otherFunc.copy(), (long[])this.deltas.clone());
    }
}

