/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.function.general;

import net.imglib2.ops.condition.Condition;
import net.imglib2.ops.function.Function;

public class ConditionalFunction<INPUT, T>
implements Function<INPUT, T> {
    private final Condition<INPUT> condition;
    private final Function<INPUT, T> f1;
    private final Function<INPUT, T> f2;

    public ConditionalFunction(Condition<INPUT> condition, Function<INPUT, T> f1, Function<INPUT, T> f2) {
        this.condition = condition;
        this.f1 = f1;
        this.f2 = f2;
    }

    @Override
    public void compute(INPUT input, T output) {
        if (this.condition.isTrue(input)) {
            this.f1.compute(input, output);
        } else {
            this.f2.compute(input, output);
        }
    }

    @Override
    public T createOutput() {
        return this.f1.createOutput();
    }

    @Override
    public ConditionalFunction<INPUT, T> copy() {
        return new ConditionalFunction<INPUT, T>(this.condition.copy(), this.f1.copy(), this.f2.copy());
    }
}

