/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.function.general;

import java.util.ArrayList;
import net.imglib2.ops.function.Function;

public class AlternatingFunction<T>
implements Function<long[], T> {
    private final ArrayList<Function<long[], T>> functions = new ArrayList();
    private long[] relativePosition;
    private final int dimension;

    public AlternatingFunction(int dim) {
        this.dimension = dim;
        this.relativePosition = null;
    }

    public void add(Function<long[], T> function) {
        this.functions.add(function);
    }

    @Override
    public void compute(long[] point, T output) {
        if (this.relativePosition == null) {
            this.relativePosition = new long[point.length];
        }
        for (int i = 0; i < this.relativePosition.length; ++i) {
            this.relativePosition[i] = point[i];
        }
        int n = this.dimension;
        this.relativePosition[n] = this.relativePosition[n] / (long)this.functions.size();
        int funcNum = (int)(point[this.dimension] % (long)this.functions.size());
        this.functions.get(funcNum).compute(this.relativePosition, output);
    }

    @Override
    public T createOutput() {
        if (this.functions.size() > 0) {
            return this.functions.get(0).createOutput();
        }
        throw new IllegalArgumentException("AlternatingFunction has not been initialized yet.");
    }

    public AlternatingFunction<T> copy() {
        AlternatingFunction<T> newFunc = new AlternatingFunction<T>(this.dimension);
        for (Function<long[], T> f : this.functions) {
            newFunc.add(f.copy());
        }
        return newFunc;
    }
}

