/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.function.complex;

import net.imglib2.RandomAccess;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.ops.function.Function;
import net.imglib2.ops.function.complex.ComplexImageFunction;
import net.imglib2.ops.operation.complex.binary.ComplexAdd;
import net.imglib2.ops.operation.complex.binary.ComplexMultiply;
import net.imglib2.ops.operation.complex.unary.ComplexExp;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.type.numeric.complex.ComplexDoubleType;

public class IDFTFunction<T extends ComplexType<T>>
implements Function<long[], T> {
    private final Function<long[], T> freqFunction;
    private final long[] span;
    private final ImgFactory<ComplexDoubleType> imgFactory;
    private final ComplexImageFunction<ComplexDoubleType, ComplexDoubleType> dataArray;
    private final ComplexAdd<T, T, T> adder;
    private final ComplexExp<T, T> exper;
    private final ComplexMultiply<T, T, T> multiplier;
    private final T TWO_PI_I;
    private final T constant;
    private final T expVal;
    private final T funcVal;
    private final T spatialExponent;
    private final ComplexDoubleType tmp;

    public IDFTFunction(ImgFactory<ComplexDoubleType> factory, Function<long[], T> freqFunction, long[] span) {
        if (span.length != 2) {
            throw new IllegalArgumentException("IDFTFunction is only designed for two dimensional functions");
        }
        this.tmp = new ComplexDoubleType();
        this.freqFunction = freqFunction;
        this.span = (long[])span.clone();
        this.imgFactory = factory;
        this.adder = new ComplexAdd();
        this.exper = new ComplexExp();
        this.multiplier = new ComplexMultiply();
        this.TWO_PI_I = (ComplexType)freqFunction.createOutput();
        this.constant = (ComplexType)freqFunction.createOutput();
        this.expVal = (ComplexType)freqFunction.createOutput();
        this.funcVal = (ComplexType)freqFunction.createOutput();
        this.spatialExponent = (ComplexType)freqFunction.createOutput();
        this.TWO_PI_I.setComplexNumber(0.0, Math.PI * 2);
        this.dataArray = this.createDataArray();
    }

    @Override
    public void compute(long[] point, T output) {
        this.dataArray.compute(point, this.tmp);
        output.setComplexNumber(this.tmp.getRealDouble(), this.tmp.getImaginaryDouble());
    }

    public IDFTFunction<T> copy() {
        return new IDFTFunction<T>(this.imgFactory, this.freqFunction.copy(), (long[])this.span.clone());
    }

    @Override
    public T createOutput() {
        return (T)((ComplexType)this.freqFunction.createOutput());
    }

    private ComplexImageFunction<ComplexDoubleType, ComplexDoubleType> createDataArray() {
        Img<ComplexDoubleType> img = this.imgFactory.create(this.span, new ComplexDoubleType());
        RandomAccess oAccessor = img.randomAccess();
        long[] iPosition = new long[2];
        long[] oPosition = new long[2];
        ComplexType sum = (ComplexType)this.freqFunction.createOutput();
        ComplexType uvTerm = (ComplexType)this.freqFunction.createOutput();
        int ou = 0;
        while ((long)ou < this.span[0]) {
            oPosition[0] = ou;
            int ov = 0;
            while ((long)ov < this.span[1]) {
                oPosition[1] = ov;
                sum.setZero();
                int iu = 0;
                while ((long)iu < this.span[0]) {
                    iPosition[0] = iu;
                    int iv = 0;
                    while ((long)iv < this.span[1]) {
                        iPosition[1] = iv;
                        this.calcTermAtPoint(oPosition, iPosition, uvTerm);
                        this.adder.compute((T)sum, (T)uvTerm, (T)sum);
                        ++iv;
                    }
                    ++iu;
                }
                sum.setComplexNumber(sum.getRealDouble() / (double)(this.span[0] * this.span[1]), sum.getImaginaryDouble() / (double)(this.span[0] * this.span[1]));
                oAccessor.setPosition(oPosition);
                ((ComplexDoubleType)oAccessor.get()).setComplexNumber(sum.getRealDouble(), sum.getImaginaryDouble());
                ++ov;
            }
            ++ou;
        }
        return new ComplexImageFunction<ComplexDoubleType, ComplexDoubleType>(img, new ComplexDoubleType());
    }

    private void calcTermAtPoint(long[] oPosition, long[] iPosition, T uvTerm) {
        this.freqFunction.compute(iPosition, this.funcVal);
        double val = (double)oPosition[0] * (double)iPosition[0] / (double)this.span[0];
        this.spatialExponent.setComplexNumber(val += (double)oPosition[1] * (double)iPosition[1] / (double)this.span[1], 0.0);
        this.multiplier.compute(this.TWO_PI_I, this.spatialExponent, this.constant);
        this.exper.compute(this.constant, this.expVal);
        this.multiplier.compute(this.funcVal, this.expVal, uvTerm);
    }
}

