/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.data;

import net.imglib2.type.numeric.RealType;

public final class Histogram2D {
    private final int[] m_hist;
    private final int m_size;
    private final double m_min;
    private final double m_max;
    private final double m_scale;

    public Histogram2D(int size, double min, double max) {
        this.m_size = size;
        this.m_hist = new int[size * size];
        this.m_min = min;
        this.m_max = max;
        this.m_scale = (double)(this.m_size - 1) / (this.m_max - this.m_min);
    }

    public <T extends RealType<T>> Histogram2D(int bins, T type) {
        this(bins, type.getMinValue(), type.getMaxValue());
    }

    public <T extends RealType<T>> Histogram2D(T type) {
        this(256, type);
    }

    public final void clear() {
        for (int i = 0; i < this.m_hist.length; ++i) {
            this.m_hist[i] = 0;
        }
    }

    public final int numBins() {
        return this.m_size;
    }

    public final double min() {
        return this.m_min;
    }

    public final double max() {
        return this.m_max;
    }

    public final int get(int x, int y) {
        return this.m_hist[y * this.m_size + x];
    }

    public final void inc(int x, int y) {
        int n = y * this.m_size + x;
        this.m_hist[n] = this.m_hist[n] + 1;
    }

    public final int getByValue(double x, double y) {
        return this.get(this.valueToBin(x), this.valueToBin(y));
    }

    public final void incByValue(double x, double y) {
        this.inc(this.valueToBin(x), this.valueToBin(y));
    }

    public final int valueToBin(double v) {
        return (int)((v - this.m_min) * this.m_scale);
    }

    public final double binToValue(int i) {
        return (double)i / this.m_scale + this.m_min;
    }
}

