/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.data;

import java.util.Arrays;

public class CooccurrenceMatrix {
    private double[][] m_matrix = null;
    private double[] m_haralickFeatures;

    public CooccurrenceMatrix(int size) {
        this.m_matrix = new double[size][size];
    }

    public final double getValueAt(int row, int col) {
        return this.m_matrix[row][col];
    }

    public final void incValueAt(int row, int col) {
        double[] dArray = this.m_matrix[row];
        int n = col;
        dArray[n] = dArray[n] + 1.0;
    }

    public final void divideBy(int divisor) {
        for (int row = 0; row < this.m_matrix.length; ++row) {
            int col = 0;
            while (col < this.m_matrix[row].length) {
                double[] dArray = this.m_matrix[row];
                int n = col++;
                dArray[n] = dArray[n] / (double)divisor;
            }
        }
    }

    public void clear() {
        for (int row = 0; row < this.m_matrix.length; ++row) {
            Arrays.fill(this.m_matrix[row], 0.0);
        }
    }

    public void setFeatures(double[] h) {
        this.m_haralickFeatures = h;
    }

    public double getFeature(int id) {
        if (this.m_haralickFeatures == null || id < 0 || id >= this.m_haralickFeatures.length) {
            return Double.NaN;
        }
        return this.m_haralickFeatures[id];
    }

    public static enum MatrixOrientation {
        DIAGONAL(1, -1),
        ANTIDIAGONAL(1, 1),
        HORIZONTAL(1, 0),
        VERTICAL(0, 1);

        public final int dx;
        public final int dy;

        private MatrixOrientation(int dx, int dy) {
            this.dx = dx;
            this.dy = dy;
        }
    }
}

