/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.condition;

import net.imglib2.ops.condition.Condition;
import net.imglib2.ops.function.Function;
import net.imglib2.type.numeric.RealType;

public class WithinRangeCondition<T extends RealType<T>>
implements Condition<long[]> {
    private Function<long[], T> valueFunc;
    private double min;
    private double max;
    private T tmp;

    public WithinRangeCondition(Function<long[], T> func, double min, double max) {
        this.valueFunc = func;
        this.min = min;
        this.max = max;
        this.tmp = (RealType)func.createOutput();
    }

    @Override
    public boolean isTrue(long[] input) {
        this.valueFunc.compute(input, this.tmp);
        double val = this.tmp.getRealDouble();
        return this.min <= val && val <= this.max;
    }

    @Override
    public WithinRangeCondition<T> copy() {
        return new WithinRangeCondition<T>(this.valueFunc, this.min, this.max);
    }
}

