/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.condition;

import net.imglib2.ops.condition.Condition;
import net.imglib2.ops.function.Function;
import net.imglib2.ops.relation.BinaryRelation;

public class BinaryFunctionalCondition<INPUT, O1, O2>
implements Condition<INPUT> {
    private final Function<INPUT, O1> f1;
    private final Function<INPUT, O2> f2;
    private final O1 f1Val;
    private final O2 f2Val;
    private final BinaryRelation<O1, O2> relation;

    public BinaryFunctionalCondition(Function<INPUT, O1> f1, Function<INPUT, O2> f2, BinaryRelation<O1, O2> relation) {
        this.f1 = f1;
        this.f2 = f2;
        this.f1Val = f1.createOutput();
        this.f2Val = f2.createOutput();
        this.relation = relation;
    }

    @Override
    public boolean isTrue(INPUT input) {
        this.f1.compute(input, this.f1Val);
        this.f2.compute(input, this.f2Val);
        return this.relation.holds(this.f1Val, this.f2Val);
    }

    public BinaryFunctionalCondition<INPUT, O1, O2> copy() {
        return new BinaryFunctionalCondition<INPUT, O1, O2>(this.f1.copy(), this.f2.copy(), this.relation.copy());
    }
}

