/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.io;

import java.io.IOException;
import loci.formats.ChannelSeparator;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.meta.IMetadata;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import mpicbg.imglib.container.ContainerFactory;
import mpicbg.imglib.container.array.ArrayContainerFactory;
import mpicbg.imglib.cursor.LocalizablePlaneCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.numeric.RGBALegacyType;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.imglib.type.numeric.integer.ByteType;
import mpicbg.imglib.type.numeric.integer.ShortType;
import mpicbg.imglib.type.numeric.integer.Unsigned12BitType;
import mpicbg.imglib.type.numeric.integer.UnsignedByteType;
import mpicbg.imglib.type.numeric.real.FloatType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LOCI {
    public static <T extends RealType<T>> Image<T> open(String string) {
        return LOCI.openLOCI("", string, (ContainerFactory)new ArrayContainerFactory());
    }

    public static <T extends RealType<T>> Image<T> openLOCI(String string, ContainerFactory containerFactory) {
        return LOCI.openLOCI("", string, containerFactory);
    }

    public static <T extends RealType<T>> Image<T> openLOCI(String string, String string2, ContainerFactory containerFactory) {
        return LOCI.openLOCI(string, string2, containerFactory, -1, -1);
    }

    public static <T extends RealType<T>> Image<T> openLOCI(String string, String string2, ContainerFactory containerFactory, int n, int n2) {
        string = LOCI.checkPath(string);
        String string3 = string + string2;
        ChannelSeparator channelSeparator = new ChannelSeparator();
        try {
            channelSeparator.setId(string3);
            int n3 = channelSeparator.getPixelType();
            int n4 = channelSeparator.getSizeC();
            String string4 = FormatTools.getPixelTypeString((int)n3);
            if (n3 != 1 && n3 != 3 && n3 != 5 && n3 != 6) {
                System.out.println("LOCI.openLOCI(): PixelType " + string4 + " not supported yet, returning. ");
                return null;
            }
            if (n4 > 1 && n4 <= 3 && n3 == 1) {
                return LOCI.openLOCIRGBALegacyType(string, string2, (ImageFactory<RGBALegacyType>)new ImageFactory((Type)new RGBALegacyType(), containerFactory), n, n2);
            }
            if (n3 == 6 || n3 == 5) {
                return LOCI.openLOCIFloatType(string, string2, (ImageFactory<FloatType>)new ImageFactory((Type)new FloatType(), containerFactory), n, n2);
            }
            if (n3 == 3) {
                return LOCI.openLOCIShortType(string, string2, (ImageFactory<ShortType>)new ImageFactory((Type)new ShortType(), containerFactory), n, n2);
            }
            if (n3 == 1) {
                return LOCI.openLOCIUnsignedByteType(string, string2, (ImageFactory<UnsignedByteType>)new ImageFactory((Type)new UnsignedByteType(), containerFactory), n, n2);
            }
            return null;
        }
        catch (IOException iOException) {
            System.out.println("LOCI.openLOCI(): Sorry, an error occurred: " + iOException.getMessage());
            return null;
        }
        catch (FormatException formatException) {
            System.out.println("LOCI.openLOCI(): Sorry, an error occurred: " + formatException.getMessage());
            return null;
        }
    }

    public static Image<Unsigned12BitType> openLOCIUnsigned12BitType(String string, ContainerFactory containerFactory) {
        return LOCI.openLOCIUnsigned12BitType(string, (ImageFactory<Unsigned12BitType>)new ImageFactory((Type)new Unsigned12BitType(), containerFactory));
    }

    public static Image<Unsigned12BitType> openLOCIUnsigned12BitType(String string, ImageFactory<Unsigned12BitType> imageFactory) {
        return LOCI.openLOCIUnsigned12BitType("", string, imageFactory);
    }

    public static Image<Unsigned12BitType> openLOCIUnsigned12BitType(String string, String string2, ContainerFactory containerFactory) {
        return LOCI.openLOCIUnsigned12BitType(string, string2, (ImageFactory<Unsigned12BitType>)new ImageFactory((Type)new Unsigned12BitType(), containerFactory));
    }

    public static Image<Unsigned12BitType> openLOCIUnsigned12BitType(String string, String string2, ImageFactory<Unsigned12BitType> imageFactory) {
        return LOCI.openLOCIUnsigned12BitType(string, string2, imageFactory, -1, -1);
    }

    public static Image<Unsigned12BitType> openLOCIUnsigned12BitType(String string, String string2, ContainerFactory containerFactory, int n, int n2) {
        return LOCI.openLOCIUnsigned12BitType(string, string2, (ImageFactory<Unsigned12BitType>)new ImageFactory((Type)new Unsigned12BitType(), containerFactory), n, n2);
    }

    public static Image<Unsigned12BitType> openLOCIUnsigned12BitType(String string, String string2, ImageFactory<Unsigned12BitType> imageFactory, int n, int n2) {
        string = LOCI.checkPath(string);
        ChannelSeparator channelSeparator = new ChannelSeparator();
        IMetadata iMetadata = MetadataTools.createOMEXMLMetadata();
        channelSeparator.setMetadataStore((MetadataStore)iMetadata);
        String string3 = string + string2;
        try {
            int n3;
            int n4;
            channelSeparator.setId(string3);
            boolean bl = channelSeparator.isLittleEndian();
            int n5 = channelSeparator.getSizeX();
            int n6 = channelSeparator.getSizeY();
            int n7 = channelSeparator.getSizeZ();
            int n8 = channelSeparator.getSizeT();
            int n9 = channelSeparator.getSizeC();
            int n10 = channelSeparator.getPixelType();
            int n11 = FormatTools.getBytesPerPixel((int)n10);
            String string4 = FormatTools.getPixelTypeString((int)n10);
            if (n8 > 1) {
                System.out.println("LOCI.openLOCI(): More than one timepoint. Not implemented yet. Returning first timepoint");
                n8 = 1;
            }
            if (n9 > 1) {
                System.out.println("LOCI.openLOCI(): More than one channel. Image<ShortType> supports only 1 channel right now, returning the first channel.");
                n9 = 1;
            }
            if (n10 != 1 && n10 != 3) {
                System.out.println("LOCI.openLOCI(): PixelType " + string4 + " not supported by ShortType, returning. ");
                return null;
            }
            if (n < 0 || n2 < 0 || n2 < n) {
                n4 = 0;
                n3 = n7;
            } else {
                n4 = n;
                n3 = n2 > n7 ? n7 : n2;
            }
            Image image = n3 - n4 == 1 ? imageFactory.createImage(new int[]{n5, n6}, string2) : imageFactory.createImage(new int[]{n5, n6, n3 - n4}, string2);
            if (image == null) {
                System.out.println("LOCI.openLOCI():  - Could not create image.");
                return null;
            }
            System.out.println("Opening '" + string2 + "' [" + n5 + "x" + n6 + "x" + n7 + " type=" + string4 + " image=Image<ShortType>]");
            image.setName(string2);
            LOCI.applyMetaData(image, (IFormatReader)channelSeparator);
            byte[][] byArray = new byte[n9][n5 * n6 * n11];
            int[] nArray = new int[3];
            LocalizablePlaneCursor localizablePlaneCursor = image.createLocalizablePlaneCursor();
            for (int i = n4; i < n3; ++i) {
                nArray[2] = i - n4;
                localizablePlaneCursor.reset(0, 1, nArray);
                for (int j = 0; j < n9; ++j) {
                    int n12 = channelSeparator.getIndex(i, j, 0);
                    channelSeparator.openBytes(n12, byArray[j]);
                }
                if (n9 != 1) continue;
                if (n10 == 1) {
                    while (localizablePlaneCursor.hasNext()) {
                        localizablePlaneCursor.fwd();
                        ((Unsigned12BitType)localizablePlaneCursor.getType()).set((short)(byArray[0][localizablePlaneCursor.getPosition(0) + localizablePlaneCursor.getPosition(1) * n5] & 0xFF));
                    }
                    continue;
                }
                while (localizablePlaneCursor.hasNext()) {
                    localizablePlaneCursor.fwd();
                    ((Unsigned12BitType)localizablePlaneCursor.getType()).set(LOCI.getShortValue(byArray[0], (localizablePlaneCursor.getPosition(0) + localizablePlaneCursor.getPosition(1) * n5) * 2, bl));
                }
            }
            localizablePlaneCursor.close();
            return image;
        }
        catch (IOException iOException) {
            System.out.println("LOCI.openLOCI(): Sorry, an error occurred: " + iOException.getMessage());
            return null;
        }
        catch (FormatException formatException) {
            System.out.println("LOCI.openLOCI(): Sorry, an error occurred: " + formatException.getMessage());
            return null;
        }
    }

    public static Image<ShortType> openLOCIShortType(String string, ContainerFactory containerFactory) {
        return LOCI.openLOCIShortType(string, (ImageFactory<ShortType>)new ImageFactory((Type)new ShortType(), containerFactory));
    }

    public static Image<ShortType> openLOCIShortType(String string, ImageFactory<ShortType> imageFactory) {
        return LOCI.openLOCIShortType("", string, imageFactory);
    }

    public static Image<ShortType> openLOCIShortType(String string, String string2, ContainerFactory containerFactory) {
        return LOCI.openLOCIShortType(string, string2, (ImageFactory<ShortType>)new ImageFactory((Type)new ShortType(), containerFactory));
    }

    public static Image<ShortType> openLOCIShortType(String string, String string2, ImageFactory<ShortType> imageFactory) {
        return LOCI.openLOCIShortType(string, string2, imageFactory, -1, -1);
    }

    public static Image<ShortType> openLOCIShortType(String string, String string2, ContainerFactory containerFactory, int n, int n2) {
        return LOCI.openLOCIShortType(string, string2, (ImageFactory<ShortType>)new ImageFactory((Type)new ShortType(), containerFactory), n, n2);
    }

    public static Image<ShortType> openLOCIShortType(String string, String string2, ImageFactory<ShortType> imageFactory, int n, int n2) {
        string = LOCI.checkPath(string);
        ChannelSeparator channelSeparator = new ChannelSeparator();
        IMetadata iMetadata = MetadataTools.createOMEXMLMetadata();
        channelSeparator.setMetadataStore((MetadataStore)iMetadata);
        String string3 = string + string2;
        try {
            int n3;
            int n4;
            channelSeparator.setId(string3);
            boolean bl = channelSeparator.isLittleEndian();
            int n5 = channelSeparator.getSizeX();
            int n6 = channelSeparator.getSizeY();
            int n7 = channelSeparator.getSizeZ();
            int n8 = channelSeparator.getSizeT();
            int n9 = channelSeparator.getSizeC();
            int n10 = channelSeparator.getPixelType();
            int n11 = FormatTools.getBytesPerPixel((int)n10);
            String string4 = FormatTools.getPixelTypeString((int)n10);
            if (n8 > 1) {
                System.out.println("LOCI.openLOCI(): More than one timepoint. Not implemented yet. Returning first timepoint");
                n8 = 1;
            }
            if (n9 > 1) {
                System.out.println("LOCI.openLOCI(): More than one channel. Image<ShortType> supports only 1 channel right now, returning the first channel.");
                n9 = 1;
            }
            if (n10 != 1 && n10 != 3) {
                System.out.println("LOCI.openLOCI(): PixelType " + string4 + " not supported by ShortType, returning. ");
                return null;
            }
            if (n < 0 || n2 < 0 || n2 < n) {
                n4 = 0;
                n3 = n7;
            } else {
                n4 = n;
                n3 = n2 > n7 ? n7 : n2;
            }
            Image image = n3 - n4 == 1 ? imageFactory.createImage(new int[]{n5, n6}, string2) : imageFactory.createImage(new int[]{n5, n6, n3 - n4}, string2);
            if (image == null) {
                System.out.println("LOCI.openLOCI():  - Could not create image.");
                return null;
            }
            System.out.println("Opening '" + string2 + "' [" + n5 + "x" + n6 + "x" + n7 + " type=" + string4 + " image=Image<ShortType>]");
            image.setName(string2);
            LOCI.applyMetaData(image, (IFormatReader)channelSeparator);
            byte[][] byArray = new byte[n9][n5 * n6 * n11];
            int[] nArray = new int[3];
            LocalizablePlaneCursor localizablePlaneCursor = image.createLocalizablePlaneCursor();
            for (int i = n4; i < n3; ++i) {
                nArray[2] = i - n4;
                localizablePlaneCursor.reset(0, 1, nArray);
                for (int j = 0; j < n9; ++j) {
                    int n12 = channelSeparator.getIndex(i, j, 0);
                    channelSeparator.openBytes(n12, byArray[j]);
                }
                if (n9 != 1) continue;
                if (n10 == 1) {
                    while (localizablePlaneCursor.hasNext()) {
                        localizablePlaneCursor.fwd();
                        ((ShortType)localizablePlaneCursor.getType()).set((short)(byArray[0][localizablePlaneCursor.getPosition(0) + localizablePlaneCursor.getPosition(1) * n5] & 0xFF));
                    }
                    continue;
                }
                while (localizablePlaneCursor.hasNext()) {
                    localizablePlaneCursor.fwd();
                    ((ShortType)localizablePlaneCursor.getType()).set(LOCI.getShortValue(byArray[0], (localizablePlaneCursor.getPosition(0) + localizablePlaneCursor.getPosition(1) * n5) * 2, bl));
                }
            }
            localizablePlaneCursor.close();
            return image;
        }
        catch (IOException iOException) {
            System.out.println("LOCI.openLOCI(): Sorry, an error occurred: " + iOException.getMessage());
            return null;
        }
        catch (FormatException formatException) {
            System.out.println("LOCI.openLOCI(): Sorry, an error occurred: " + formatException.getMessage());
            return null;
        }
    }

    protected static void applyMetaData(Image<?> image, IFormatReader iFormatReader) {
        for (int i = 0; i < image.getNumDimensions(); ++i) {
            image.setCalibration(1.0f, i);
        }
        try {
            MetadataRetrieve metadataRetrieve = (MetadataRetrieve)iFormatReader.getMetadataStore();
            float f = metadataRetrieve.getPixelsPhysicalSizeX(0).floatValue();
            if (f == 0.0f) {
                f = 1.0f;
                System.out.println("LOCI.openLOCI(): Warning, calibration for dimension 0 seems corrupted, setting to 1.");
            }
            image.setCalibration(f, 0);
            if (image.getNumDimensions() >= 2) {
                f = metadataRetrieve.getPixelsPhysicalSizeY(0).floatValue();
                if (f == 0.0f) {
                    f = 1.0f;
                    System.out.println("LOCI.openLOCI(): Warning, calibration for dimension 1 seems corrupted, setting to 1.");
                }
                image.setCalibration(f, 1);
            }
            if (image.getNumDimensions() >= 3) {
                f = metadataRetrieve.getPixelsPhysicalSizeZ(0).floatValue();
                if (f == 0.0f) {
                    f = 1.0f;
                    System.out.println("LOCI.openLOCI(): Warning, calibration for dimension 2 seems corrupted, setting to 1.");
                }
                image.setCalibration(f, 2);
            }
            if (image.getNumDimensions() >= 4) {
                f = metadataRetrieve.getPixelsTimeIncrement(0).floatValue();
                if (f == 0.0f) {
                    f = 1.0f;
                    System.out.println("LOCI.openLOCI(): Warning, calibration for dimension 3 seems corrupted, setting to 1.");
                }
                image.setCalibration(f, 3);
            }
        }
        catch (Exception exception) {
            System.out.println("LOCI.openLOCI(): Cannot read metadata, setting calibration to 1");
            return;
        }
    }

    public static Image<FloatType> openLOCIFloatType(String string, ContainerFactory containerFactory) {
        return LOCI.openLOCIFloatType(string, (ImageFactory<FloatType>)new ImageFactory((Type)new FloatType(), containerFactory));
    }

    public static Image<FloatType> openLOCIFloatType(String string, ImageFactory<FloatType> imageFactory) {
        return LOCI.openLOCIFloatType("", string, imageFactory);
    }

    public static Image<FloatType> openLOCIFloatType(String string, String string2, ContainerFactory containerFactory) {
        return LOCI.openLOCIFloatType(string, string2, (ImageFactory<FloatType>)new ImageFactory((Type)new FloatType(), containerFactory));
    }

    public static Image<FloatType> openLOCIFloatType(String string, String string2, ImageFactory<FloatType> imageFactory) {
        return LOCI.openLOCIFloatType(string, string2, imageFactory, -1, -1);
    }

    public static Image<FloatType> openLOCIFloatType(String string, String string2, ContainerFactory containerFactory, int n, int n2) {
        return LOCI.openLOCIFloatType(string, string2, (ImageFactory<FloatType>)new ImageFactory((Type)new FloatType(), containerFactory), n, n2);
    }

    public static Image<FloatType> openLOCIFloatType(String string, String string2, ImageFactory<FloatType> imageFactory, int n, int n2) {
        string = LOCI.checkPath(string);
        ChannelSeparator channelSeparator = new ChannelSeparator();
        IMetadata iMetadata = MetadataTools.createOMEXMLMetadata();
        channelSeparator.setMetadataStore((MetadataStore)iMetadata);
        String string3 = string + string2;
        try {
            int n3;
            int n4;
            channelSeparator.setId(string3);
            boolean bl = channelSeparator.isLittleEndian();
            int n5 = channelSeparator.getSizeX();
            int n6 = channelSeparator.getSizeY();
            int n7 = channelSeparator.getSizeZ();
            int n8 = channelSeparator.getSizeT();
            int n9 = channelSeparator.getSizeC();
            int n10 = channelSeparator.getPixelType();
            int n11 = FormatTools.getBytesPerPixel((int)n10);
            String string4 = FormatTools.getPixelTypeString((int)n10);
            if (n8 > 1) {
                System.out.println("LOCI.openLOCI(): More than one timepoint. Not implemented yet. Returning first timepoint");
                n8 = 1;
            }
            if (n9 > 1) {
                System.out.println("LOCI.openLOCI(): More than one channel. Image<FloatType> supports only 1 channel right now, returning the first channel.");
                n9 = 1;
            }
            if (n10 != 1 && n10 != 3 && n10 != 5 && n10 != 6) {
                System.out.println("LOCI.openLOCI(): PixelType " + string4 + " not supported by FloatType, returning. ");
                return null;
            }
            if (n < 0 || n2 < 0 || n2 < n) {
                n4 = 0;
                n3 = n7;
            } else {
                n4 = n;
                n3 = n2 > n7 ? n7 : n2;
            }
            Image image = n3 - n4 == 1 ? imageFactory.createImage(new int[]{n5, n6}, string2) : imageFactory.createImage(new int[]{n5, n6, n3 - n4}, string2);
            if (image == null) {
                System.out.println("LOCI.openLOCI():  - Could not create image.");
                return null;
            }
            System.out.println("Opening '" + string2 + "' [" + n5 + "x" + n6 + "x" + n7 + " type=" + string4 + " image=Image<FloatType>]");
            image.setName(string2);
            LOCI.applyMetaData(image, (IFormatReader)channelSeparator);
            byte[][] byArray = new byte[n9][n5 * n6 * n11];
            int[] nArray = new int[3];
            LocalizablePlaneCursor localizablePlaneCursor = image.createLocalizablePlaneCursor();
            for (int i = n4; i < n3; ++i) {
                nArray[2] = i - n4;
                localizablePlaneCursor.reset(0, 1, nArray);
                for (int j = 0; j < n9; ++j) {
                    int n12 = channelSeparator.getIndex(i, j, 0);
                    channelSeparator.openBytes(n12, byArray[j]);
                }
                if (n9 != 1) continue;
                if (n10 == 1) {
                    while (localizablePlaneCursor.hasNext()) {
                        localizablePlaneCursor.fwd();
                        ((FloatType)localizablePlaneCursor.getType()).set((float)(byArray[0][localizablePlaneCursor.getPosition(0) + localizablePlaneCursor.getPosition(1) * n5] & 0xFF));
                    }
                    continue;
                }
                if (n10 == 3) {
                    while (localizablePlaneCursor.hasNext()) {
                        localizablePlaneCursor.fwd();
                        ((FloatType)localizablePlaneCursor.getType()).set((float)LOCI.getShortValue(byArray[0], (localizablePlaneCursor.getPosition(0) + localizablePlaneCursor.getPosition(1) * n5) * 2, bl));
                    }
                    continue;
                }
                if (n10 == 5) {
                    while (localizablePlaneCursor.hasNext()) {
                        localizablePlaneCursor.fwd();
                        ((FloatType)localizablePlaneCursor.getType()).set((float)LOCI.getIntValue(byArray[0], (localizablePlaneCursor.getPosition(0) + localizablePlaneCursor.getPosition(1) * n5) * 4, bl));
                    }
                    continue;
                }
                if (n10 != 6) continue;
                while (localizablePlaneCursor.hasNext()) {
                    localizablePlaneCursor.fwd();
                    ((FloatType)localizablePlaneCursor.getType()).set(LOCI.getFloatValue(byArray[0], (localizablePlaneCursor.getPosition(0) + localizablePlaneCursor.getPosition(1) * n5) * 4, bl));
                }
            }
            localizablePlaneCursor.close();
            return image;
        }
        catch (IOException iOException) {
            System.out.println("LOCI.openLOCI(): Sorry, an error occurred: " + iOException.getMessage());
            return null;
        }
        catch (FormatException formatException) {
            System.out.println("LOCI.openLOCI(): Sorry, an error occurred: " + formatException.getMessage());
            return null;
        }
    }

    public static Image<ByteType> openLOCIByteType(String string, ContainerFactory containerFactory) {
        return LOCI.openLOCIByteType("", string, (ImageFactory<ByteType>)new ImageFactory((Type)new ByteType(), containerFactory));
    }

    public static Image<ByteType> openLOCIByteType(String string, ImageFactory<ByteType> imageFactory) {
        return LOCI.openLOCIByteType("", string, imageFactory);
    }

    public static Image<ByteType> openLOCIByteType(String string, String string2, ContainerFactory containerFactory) {
        return LOCI.openLOCIByteType(string, string2, (ImageFactory<ByteType>)new ImageFactory((Type)new ByteType(), containerFactory));
    }

    public static Image<ByteType> openLOCIByteType(String string, String string2, ImageFactory<ByteType> imageFactory) {
        return LOCI.openLOCIByteType(string, string2, imageFactory, -1, -1);
    }

    public static Image<ByteType> openLOCIByteType(String string, String string2, ImageFactory<ByteType> imageFactory, int n, int n2) {
        string = LOCI.checkPath(string);
        ChannelSeparator channelSeparator = new ChannelSeparator();
        IMetadata iMetadata = MetadataTools.createOMEXMLMetadata();
        channelSeparator.setMetadataStore((MetadataStore)iMetadata);
        String string3 = string + string2;
        try {
            int n3;
            int n4;
            channelSeparator.setId(string3);
            int n5 = channelSeparator.getSizeX();
            int n6 = channelSeparator.getSizeY();
            int n7 = channelSeparator.getSizeZ();
            int n8 = channelSeparator.getSizeT();
            int n9 = channelSeparator.getSizeC();
            int n10 = channelSeparator.getPixelType();
            int n11 = FormatTools.getBytesPerPixel((int)n10);
            String string4 = FormatTools.getPixelTypeString((int)n10);
            if (n8 > 1) {
                System.out.println("LOCI.openLOCI(): More than one timepoint. Not implemented yet. Returning first timepoint");
                n8 = 1;
            }
            if (n9 > 1) {
                System.out.println("LOCI.openLOCI(): More than one channel. Image<ByteType> supports only 1 channel right now, returning the first channel.");
                n9 = 1;
            }
            if (n10 != 1) {
                System.out.println("LOCI.openLOCI(): PixelType " + string4 + " not supported by ByteType, returning. ");
                return null;
            }
            if (n < 0 || n2 < 0 || n2 < n) {
                n4 = 0;
                n3 = n7;
            } else {
                n4 = n;
                n3 = n2 > n7 ? n7 : n2;
            }
            Image image = n3 - n4 == 1 ? imageFactory.createImage(new int[]{n5, n6}, string2) : imageFactory.createImage(new int[]{n5, n6, n3 - n4}, string2);
            if (image == null) {
                System.out.println("LOCI.openLOCI():  - Could not create image.");
                return null;
            }
            System.out.println("Opening '" + string2 + "' [" + n5 + "x" + n6 + "x" + n7 + " type=" + string4 + " image=Image<ByteType>]");
            image.setName(string2);
            LOCI.applyMetaData(image, (IFormatReader)channelSeparator);
            byte[][] byArray = new byte[n9][n5 * n6 * n11];
            int[] nArray = new int[3];
            LocalizablePlaneCursor localizablePlaneCursor = image.createLocalizablePlaneCursor();
            ByteType byteType = (ByteType)localizablePlaneCursor.getType();
            for (int i = n4; i < n3; ++i) {
                nArray[2] = i - n4;
                localizablePlaneCursor.reset(0, 1, nArray);
                for (int j = 0; j < n9; ++j) {
                    int n12 = channelSeparator.getIndex(i, j, 0);
                    channelSeparator.openBytes(n12, byArray[j]);
                }
                if (n9 != 1) continue;
                while (localizablePlaneCursor.hasNext()) {
                    localizablePlaneCursor.fwd();
                    byteType.set(byArray[0][localizablePlaneCursor.getPosition(0) + localizablePlaneCursor.getPosition(1) * n5]);
                }
            }
            localizablePlaneCursor.close();
            return image;
        }
        catch (IOException iOException) {
            System.out.println("LOCI.openLOCI(): Sorry, an error occurred: " + iOException.getMessage());
            return null;
        }
        catch (FormatException formatException) {
            System.out.println("LOCI.openLOCI(): Sorry, an error occurred: " + formatException.getMessage());
            return null;
        }
    }

    public static Image<UnsignedByteType> openLOCIUnsignedByteType(String string, ContainerFactory containerFactory) {
        return LOCI.openLOCIUnsignedByteType("", string, (ImageFactory<UnsignedByteType>)new ImageFactory((Type)new UnsignedByteType(), containerFactory));
    }

    public static Image<UnsignedByteType> openLOCIUnsignedByteType(String string, ImageFactory<UnsignedByteType> imageFactory) {
        return LOCI.openLOCIUnsignedByteType("", string, imageFactory);
    }

    public static Image<UnsignedByteType> openLOCIUnsignedByteType(String string, String string2, ContainerFactory containerFactory) {
        return LOCI.openLOCIUnsignedByteType(string, string2, (ImageFactory<UnsignedByteType>)new ImageFactory((Type)new UnsignedByteType(), containerFactory));
    }

    public static Image<UnsignedByteType> openLOCIUnsignedByteType(String string, String string2, ImageFactory<UnsignedByteType> imageFactory) {
        return LOCI.openLOCIUnsignedByteType(string, string2, imageFactory, -1, -1);
    }

    public static Image<UnsignedByteType> openLOCIUnsignedByteType(String string, String string2, ImageFactory<UnsignedByteType> imageFactory, int n, int n2) {
        string = LOCI.checkPath(string);
        ChannelSeparator channelSeparator = new ChannelSeparator();
        IMetadata iMetadata = MetadataTools.createOMEXMLMetadata();
        channelSeparator.setMetadataStore((MetadataStore)iMetadata);
        String string3 = string + string2;
        try {
            int n3;
            int n4;
            channelSeparator.setId(string3);
            int n5 = channelSeparator.getSizeX();
            int n6 = channelSeparator.getSizeY();
            int n7 = channelSeparator.getSizeZ();
            int n8 = channelSeparator.getSizeT();
            int n9 = channelSeparator.getSizeC();
            int n10 = channelSeparator.getPixelType();
            int n11 = FormatTools.getBytesPerPixel((int)n10);
            String string4 = FormatTools.getPixelTypeString((int)n10);
            if (n8 > 1) {
                System.out.println("LOCI.openLOCI(): More than one timepoint. Not implemented yet. Returning first timepoint");
                n8 = 1;
            }
            if (n9 > 1) {
                System.out.println("LOCI.openLOCI(): More than one channel. Image<UnsignedByteType> supports only 1 channel right now, returning the first channel.");
                n9 = 1;
            }
            if (n10 != 1) {
                System.out.println("LOCI.openLOCI(): PixelType " + string4 + " not supported by UnsignedByteType, returning. ");
                return null;
            }
            if (n < 0 || n2 < 0 || n2 < n) {
                n4 = 0;
                n3 = n7;
            } else {
                n4 = n;
                n3 = n2 > n7 ? n7 : n2;
            }
            Image image = n3 - n4 == 1 ? imageFactory.createImage(new int[]{n5, n6}, string2) : imageFactory.createImage(new int[]{n5, n6, n3 - n4}, string2);
            if (image == null) {
                System.out.println("LOCI.openLOCI():  - Could not create image.");
                return null;
            }
            System.out.println("Opening '" + string2 + "' [" + n5 + "x" + n6 + "x" + n7 + " type=" + string4 + " image=Image<ByteType>]");
            image.setName(string2);
            LOCI.applyMetaData(image, (IFormatReader)channelSeparator);
            byte[][] byArray = new byte[n9][n5 * n6 * n11];
            int[] nArray = new int[3];
            LocalizablePlaneCursor localizablePlaneCursor = image.createLocalizablePlaneCursor();
            UnsignedByteType unsignedByteType = (UnsignedByteType)localizablePlaneCursor.getType();
            for (int i = n4; i < n3; ++i) {
                nArray[2] = i - n4;
                localizablePlaneCursor.reset(0, 1, nArray);
                for (int j = 0; j < n9; ++j) {
                    int n12 = channelSeparator.getIndex(i, j, 0);
                    channelSeparator.openBytes(n12, byArray[j]);
                }
                if (n9 != 1) continue;
                while (localizablePlaneCursor.hasNext()) {
                    localizablePlaneCursor.fwd();
                    unsignedByteType.set(UnsignedByteType.getUnsignedByte((byte)byArray[0][localizablePlaneCursor.getPosition(0) + localizablePlaneCursor.getPosition(1) * n5]));
                }
            }
            localizablePlaneCursor.close();
            return image;
        }
        catch (IOException iOException) {
            System.out.println("LOCI.openLOCI(): Sorry, an error occurred: " + iOException.getMessage());
            return null;
        }
        catch (FormatException formatException) {
            System.out.println("LOCI.openLOCI(): Sorry, an error occurred: " + formatException.getMessage());
            return null;
        }
    }

    public static Image<RGBALegacyType> openLOCIRGBALegacyType(String string, String string2, ImageFactory<RGBALegacyType> imageFactory) {
        return LOCI.openLOCIRGBALegacyType(string, string2, imageFactory, -1, -1);
    }

    public static Image<RGBALegacyType> openLOCIRGBALegacyType(String string, String string2, ImageFactory<RGBALegacyType> imageFactory, int n, int n2) {
        string = LOCI.checkPath(string);
        ChannelSeparator channelSeparator = new ChannelSeparator();
        IMetadata iMetadata = MetadataTools.createOMEXMLMetadata();
        channelSeparator.setMetadataStore((MetadataStore)iMetadata);
        String string3 = string + string2;
        try {
            int n3;
            int n4;
            channelSeparator.setId(string3);
            int n5 = channelSeparator.getSizeX();
            int n6 = channelSeparator.getSizeY();
            int n7 = channelSeparator.getSizeZ();
            int n8 = channelSeparator.getSizeT();
            int n9 = channelSeparator.getSizeC();
            int n10 = channelSeparator.getPixelType();
            int n11 = FormatTools.getBytesPerPixel((int)n10);
            String string4 = FormatTools.getPixelTypeString((int)n10);
            if (n8 > 1) {
                System.out.println("LOCI.openLOCI(): More than one timepoint. Not implemented yet. Returning first timepoint");
                n8 = 1;
            }
            if (n9 > 3) {
                System.out.println("LOCI.openLOCI(): More than one channel. Image<RGBALegacyType> supports only 3 channels right now, returning the first 3 channels.");
                n9 = 3;
            }
            if (n10 != 1) {
                System.out.println("LOCI.openLOCI(): PixelType " + string4 + " not supported by RGBALegacyType, returning. ");
                return null;
            }
            if (n < 0 || n2 < 0 || n2 < n) {
                n4 = 0;
                n3 = n7;
            } else {
                n4 = n;
                n3 = n2 > n7 ? n7 : n2;
            }
            Image image = n3 - n4 == 1 ? imageFactory.createImage(new int[]{n5, n6}, string2) : imageFactory.createImage(new int[]{n5, n6, n3 - n4}, string2);
            if (image == null) {
                System.out.println("LOCI.openLOCI():  - Could not create image.");
                return null;
            }
            System.out.println("Opening '" + string2 + "' [" + n5 + "x" + n6 + "x" + n7 + " channels=" + n9 + " type=" + string4 + " image=RGBALegacyTypeImage]");
            image.setName(string2);
            LOCI.applyMetaData(image, (IFormatReader)channelSeparator);
            byte[][] byArray = new byte[n9][n5 * n6 * n11];
            int[] nArray = new int[3];
            LocalizablePlaneCursor localizablePlaneCursor = image.createLocalizablePlaneCursor();
            for (int i = n4; i < n3; ++i) {
                int n12;
                nArray[2] = i - n4;
                localizablePlaneCursor.reset(0, 1, nArray);
                for (int j = 0; j < n9; ++j) {
                    n12 = channelSeparator.getIndex(i, j, 0);
                    channelSeparator.openBytes(n12, byArray[j]);
                }
                byte[] byArray2 = new byte[3];
                while (localizablePlaneCursor.hasNext()) {
                    localizablePlaneCursor.fwd();
                    for (n12 = 0; n12 < n9; ++n12) {
                        byArray2[n9 - n12 - 1] = byArray[n12][localizablePlaneCursor.getPosition(0) + localizablePlaneCursor.getPosition(1) * n5];
                    }
                    ((RGBALegacyType)localizablePlaneCursor.getType()).set(RGBALegacyType.rgba((int)byArray2[0], (int)byArray2[1], (int)byArray2[2], (int)0));
                }
            }
            localizablePlaneCursor.close();
            return image;
        }
        catch (IOException iOException) {
            System.out.println("LOCI.openLOCI(): Sorry, an error occurred: " + iOException.getMessage());
            return null;
        }
        catch (FormatException formatException) {
            System.out.println("LOCI.openLOCI(): Sorry, an error occurred: " + formatException.getMessage());
            return null;
        }
    }

    protected static String checkPath(String string) {
        if (string.length() > 1 && !(string = string.replace('\\', '/')).endsWith("/")) {
            string = string + "/";
        }
        return string;
    }

    private static final float getFloatValue(byte[] byArray, int n, boolean bl) {
        if (bl) {
            return Float.intBitsToFloat(((byArray[n + 3] & 0xFF) << 24) + ((byArray[n + 2] & 0xFF) << 16) + ((byArray[n + 1] & 0xFF) << 8) + (byArray[n] & 0xFF));
        }
        return Float.intBitsToFloat(((byArray[n] & 0xFF) << 24) + ((byArray[n + 1] & 0xFF) << 16) + ((byArray[n + 2] & 0xFF) << 8) + (byArray[n + 3] & 0xFF));
    }

    private static final int getIntValue(byte[] byArray, int n, boolean bl) {
        if (bl) {
            return ((byArray[n + 3] & 0xFF) << 24) + ((byArray[n + 2] & 0xFF) << 16) + ((byArray[n + 1] & 0xFF) << 8) + (byArray[n] & 0xFF);
        }
        return ((byArray[n] & 0xFF) << 24) + ((byArray[n + 1] & 0xFF) << 16) + ((byArray[n + 2] & 0xFF) << 8) + (byArray[n + 3] & 0xFF);
    }

    private static final short getShortValue(byte[] byArray, int n, boolean bl) {
        return (short)LOCI.getShortValueInt(byArray, n, bl);
    }

    private static final int getShortValueInt(byte[] byArray, int n, boolean bl) {
        if (bl) {
            return ((byArray[n + 1] & 0xFF) << 8) + (byArray[n] & 0xFF);
        }
        return ((byArray[n] & 0xFF) << 8) + (byArray[n + 1] & 0xFF);
    }
}

