/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.io;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import loci.common.DataTools;
import loci.common.StatusEvent;
import loci.common.StatusListener;
import loci.common.StatusReporter;
import loci.common.services.ServiceException;
import loci.formats.ChannelFiller;
import loci.formats.ChannelSeparator;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.services.OMEXMLServiceImpl;
import mpicbg.imglib.container.Container;
import mpicbg.imglib.container.ContainerFactory;
import mpicbg.imglib.container.basictypecontainer.PlanarAccess;
import mpicbg.imglib.container.basictypecontainer.array.ArrayDataAccess;
import mpicbg.imglib.container.basictypecontainer.array.ByteArray;
import mpicbg.imglib.container.basictypecontainer.array.CharArray;
import mpicbg.imglib.container.basictypecontainer.array.DoubleArray;
import mpicbg.imglib.container.basictypecontainer.array.FloatArray;
import mpicbg.imglib.container.basictypecontainer.array.IntArray;
import mpicbg.imglib.container.basictypecontainer.array.LongArray;
import mpicbg.imglib.container.basictypecontainer.array.ShortArray;
import mpicbg.imglib.container.planar.PlanarContainerFactory;
import mpicbg.imglib.cursor.LocalizablePlaneCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.imglib.type.numeric.integer.ByteType;
import mpicbg.imglib.type.numeric.integer.IntType;
import mpicbg.imglib.type.numeric.integer.ShortType;
import mpicbg.imglib.type.numeric.integer.UnsignedByteType;
import mpicbg.imglib.type.numeric.integer.UnsignedIntType;
import mpicbg.imglib.type.numeric.integer.UnsignedShortType;
import mpicbg.imglib.type.numeric.real.DoubleType;
import mpicbg.imglib.type.numeric.real.FloatType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageOpener
implements StatusReporter {
    public static final String X = "X";
    public static final String Y = "Y";
    public static final String Z = "Z";
    public static final String TIME = "Time";
    private List<StatusListener> listeners = new ArrayList<StatusListener>();

    public <T extends RealType<T>> Image<T> openImage(String string) throws FormatException, IOException {
        return this.openImage(string, (ContainerFactory)new PlanarContainerFactory());
    }

    public <T extends RealType<T>> Image<T> openImage(String string, ContainerFactory containerFactory) throws FormatException, IOException {
        IFormatReader iFormatReader = this.initializeReader(string);
        T t = ImageOpener.makeType(iFormatReader.getPixelType());
        ImageFactory imageFactory = new ImageFactory(t, containerFactory);
        return this.openImage(iFormatReader, imageFactory);
    }

    public <T extends RealType<T>> Image<T> openImage(String string, ImageFactory<T> imageFactory) throws FormatException, IOException {
        IFormatReader iFormatReader = this.initializeReader(string);
        return this.openImage(iFormatReader, imageFactory);
    }

    public <T extends RealType<T>> Image<T> openImage(IFormatReader iFormatReader, ImageFactory<T> imageFactory) throws FormatException, IOException {
        Object object;
        String[] stringArray = this.getDimTypes(iFormatReader);
        int[] nArray = this.getDimLengths(iFormatReader);
        String string = iFormatReader.getCurrentFile();
        File file = new File(string);
        String string2 = file.exists() ? file.getName() : string;
        string2 = this.encodeName(string2, stringArray);
        Image image = imageFactory.createImage(nArray, string2);
        image.setCalibration(this.getCalibration(iFormatReader, nArray));
        PlanarAccess<ArrayDataAccess<?>> planarAccess = ImageOpener.getPlanarAccess(image);
        T t = ImageOpener.makeType(iFormatReader.getPixelType());
        RealType realType = (RealType)imageFactory.createType();
        boolean bl = realType.getClass().isAssignableFrom(t.getClass());
        long l = System.currentTimeMillis();
        int n = iFormatReader.getImageCount();
        if (planarAccess == null || !bl) {
            object = image.createLocalizablePlaneCursor();
            byte[] byArray = null;
            for (int i = 0; i < n; ++i) {
                this.notifyListeners(new StatusEvent(i, n, "Reading plane " + (i + 1) + "/" + n));
                if (byArray == null) {
                    byArray = iFormatReader.openBytes(i);
                } else {
                    iFormatReader.openBytes(i, byArray);
                }
                this.populatePlane(iFormatReader, i, byArray, (LocalizablePlaneCursor<T>)object);
            }
            object.close();
        } else {
            object = null;
            for (int i = 0; i < n; ++i) {
                this.notifyListeners(new StatusEvent(i, n, "Reading plane " + (i + 1) + "/" + n));
                if (object == null) {
                    object = iFormatReader.openBytes(i);
                } else {
                    iFormatReader.openBytes(i, (byte[])object);
                }
                this.populatePlane(iFormatReader, i, (byte[])object, planarAccess);
            }
        }
        iFormatReader.close();
        long l2 = System.currentTimeMillis();
        float f = (float)(l2 - l) / 1000.0f;
        this.notifyListeners(new StatusEvent(n, n, string + ": read " + n + " planes in " + f + "s"));
        return image;
    }

    public static PlanarAccess<ArrayDataAccess<?>> getPlanarAccess(Image<?> image) {
        PlanarAccess planarAccess = null;
        Container container = image.getContainer();
        if (container instanceof PlanarAccess) {
            planarAccess = (PlanarAccess)container;
        }
        return planarAccess;
    }

    public static <T extends RealType<T>> T makeType(int n) {
        UnsignedByteType unsignedByteType;
        switch (n) {
            case 1: {
                unsignedByteType = new UnsignedByteType();
                break;
            }
            case 0: {
                unsignedByteType = new ByteType();
                break;
            }
            case 3: {
                unsignedByteType = new UnsignedShortType();
                break;
            }
            case 2: {
                unsignedByteType = new ShortType();
                break;
            }
            case 5: {
                unsignedByteType = new UnsignedIntType();
                break;
            }
            case 4: {
                unsignedByteType = new IntType();
                break;
            }
            case 6: {
                unsignedByteType = new FloatType();
                break;
            }
            case 7: {
                unsignedByteType = new DoubleType();
                break;
            }
            default: {
                unsignedByteType = null;
            }
        }
        return (T)unsignedByteType;
    }

    public static ArrayDataAccess<?> makeArray(Object object) {
        Object object2 = object instanceof byte[] ? new ByteArray((byte[])object) : (object instanceof char[] ? new CharArray((char[])object) : (object instanceof double[] ? new DoubleArray((double[])object) : (object instanceof int[] ? new IntArray((int[])object) : (object instanceof float[] ? new FloatArray((float[])object) : (object instanceof short[] ? new ShortArray((short[])object) : (object instanceof long[] ? new LongArray((long[])object) : null))))));
        return object2;
    }

    public static String decodeName(String string) {
        int n = string.lastIndexOf(" [");
        return string.substring(0, n);
    }

    public static String[] decodeTypes(String string) {
        int n = string.lastIndexOf(" [");
        if (n < 0) {
            return new String[0];
        }
        int n2 = string.lastIndexOf("]");
        if (n2 < n) {
            return new String[0];
        }
        return string.substring(n + 2, n2).split(" ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStatusListener(StatusListener statusListener) {
        List<StatusListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(statusListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStatusListener(StatusListener statusListener) {
        List<StatusListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(statusListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListeners(StatusEvent statusEvent) {
        List<StatusListener> list = this.listeners;
        synchronized (list) {
            for (StatusListener statusListener : this.listeners) {
                statusListener.statusUpdated(statusEvent);
            }
        }
    }

    private IFormatReader initializeReader(String string) throws FormatException, IOException {
        this.notifyListeners(new StatusEvent("Initializing " + string));
        ImageReader imageReader = null;
        imageReader = new ImageReader();
        imageReader = new ChannelFiller((IFormatReader)imageReader);
        imageReader = new ChannelSeparator((IFormatReader)imageReader);
        try {
            imageReader.setMetadataStore((MetadataStore)new OMEXMLServiceImpl().createOMEXMLMetadata());
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        imageReader.setId(string);
        return imageReader;
    }

    private String[] getDimTypes(IFormatReader iFormatReader) {
        int n = iFormatReader.getSizeX();
        int n2 = iFormatReader.getSizeY();
        int n3 = iFormatReader.getSizeZ();
        int n4 = iFormatReader.getSizeT();
        String[] stringArray = iFormatReader.getChannelDimTypes();
        int[] nArray = iFormatReader.getChannelDimLengths();
        String string = iFormatReader.getDimensionOrder();
        ArrayList<String> arrayList = new ArrayList<String>();
        block7: for (char c : string.toCharArray()) {
            switch (c) {
                case 'X': {
                    if (n <= 1) continue block7;
                    arrayList.add(X);
                    continue block7;
                }
                case 'Y': {
                    if (n2 <= 1) continue block7;
                    arrayList.add(Y);
                    continue block7;
                }
                case 'Z': {
                    if (n3 <= 1) continue block7;
                    arrayList.add(Z);
                    continue block7;
                }
                case 'T': {
                    if (n4 <= 1) continue block7;
                    arrayList.add(TIME);
                    continue block7;
                }
                case 'C': {
                    for (int i = 0; i < stringArray.length; ++i) {
                        int n5 = nArray[i];
                        if (n5 <= 1) continue;
                        arrayList.add(stringArray[i]);
                    }
                    continue block7;
                }
            }
        }
        return arrayList.toArray(new String[0]);
    }

    private float[] getCalibration(IFormatReader iFormatReader, int[] nArray) {
        float[] fArray = new float[nArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = 1.0f;
        }
        try {
            String string = iFormatReader.getDimensionOrder().toUpperCase();
            MetadataRetrieve metadataRetrieve = (MetadataRetrieve)iFormatReader.getMetadataStore();
            int n = string.indexOf(88);
            Double d = metadataRetrieve.getPixelsPhysicalSizeX(0);
            if (n >= 0 && n < fArray.length && d != null && d.floatValue() != 0.0f) {
                fArray[n] = d.floatValue();
            }
            int n2 = string.indexOf(89);
            d = metadataRetrieve.getPixelsPhysicalSizeY(0);
            if (n2 >= 0 && n2 < fArray.length && d != null && d.floatValue() != 0.0f) {
                fArray[n2] = d.floatValue();
            }
            int n3 = string.indexOf(90);
            d = metadataRetrieve.getPixelsPhysicalSizeZ(0);
            if (n3 >= 0 && n3 < fArray.length && d != null && d.floatValue() != 0.0f) {
                fArray[n3] = d.floatValue();
            }
            int n4 = string.indexOf(84);
            metadataRetrieve.getPixelsTimeIncrement(0);
            d = metadataRetrieve.getPixelsTimeIncrement(0);
            if (n4 >= 0 && n4 < fArray.length && d != null && d.floatValue() != 0.0f) {
                fArray[n4] = d.floatValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fArray;
    }

    private int[] getDimLengths(IFormatReader iFormatReader) {
        int n;
        int n2 = iFormatReader.getSizeX();
        int n3 = iFormatReader.getSizeY();
        int n4 = iFormatReader.getSizeZ();
        int n5 = iFormatReader.getSizeT();
        int[] nArray = iFormatReader.getChannelDimLengths();
        String string = iFormatReader.getDimensionOrder();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        block7: for (int i = 0; i < string.length(); ++i) {
            n = string.charAt(i);
            switch (n) {
                case 88: {
                    if (n2 <= 1) continue block7;
                    arrayList.add(n2);
                    continue block7;
                }
                case 89: {
                    if (n3 <= 1) continue block7;
                    arrayList.add(n3);
                    continue block7;
                }
                case 90: {
                    if (n4 <= 1) continue block7;
                    arrayList.add(n4);
                    continue block7;
                }
                case 84: {
                    if (n5 <= 1) continue block7;
                    arrayList.add(n5);
                    continue block7;
                }
                case 67: {
                    for (int j = 0; j < nArray.length; ++j) {
                        int n6 = nArray[j];
                        if (n6 <= 1) continue;
                        arrayList.add(n6);
                    }
                    continue block7;
                }
            }
        }
        int[] nArray2 = new int[arrayList.size()];
        for (n = 0; n < nArray2.length; ++n) {
            nArray2[n] = (Integer)arrayList.get(n);
        }
        return nArray2;
    }

    private void getPosition(IFormatReader iFormatReader, int n, int[] nArray) {
        int n2 = iFormatReader.getSizeX();
        int n3 = iFormatReader.getSizeY();
        int n4 = iFormatReader.getSizeZ();
        int n5 = iFormatReader.getSizeT();
        int[] nArray2 = iFormatReader.getChannelDimLengths();
        String string = iFormatReader.getDimensionOrder();
        int[] nArray3 = iFormatReader.getZCTCoords(n);
        int n6 = 0;
        block7: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case 'X': {
                    if (n2 <= 1) continue block7;
                    ++n6;
                    continue block7;
                }
                case 'Y': {
                    if (n3 <= 1) continue block7;
                    ++n6;
                    continue block7;
                }
                case 'Z': {
                    if (n4 <= 1) continue block7;
                    nArray[n6++] = nArray3[0];
                    continue block7;
                }
                case 'T': {
                    if (n5 <= 1) continue block7;
                    nArray[n6++] = nArray3[2];
                    continue block7;
                }
                case 'C': {
                    int[] nArray4 = FormatTools.rasterToPosition((int[])nArray2, (int)nArray3[1]);
                    for (int j = 0; j < nArray2.length; ++j) {
                        if (nArray2[j] <= 1) continue;
                        nArray[n6++] = nArray4[j];
                    }
                    continue block7;
                }
            }
        }
    }

    private String encodeName(String string, String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder(string);
        boolean bl = true;
        for (String string2 : stringArray) {
            if (bl) {
                stringBuilder.append(" [");
                bl = false;
            } else {
                stringBuilder.append(" ");
            }
            stringBuilder.append(string2);
        }
        if (!bl) {
            stringBuilder.append("]");
        }
        return stringBuilder.toString();
    }

    private void populatePlane(IFormatReader iFormatReader, int n, byte[] byArray, PlanarAccess planarAccess) {
        boolean bl;
        boolean bl2;
        int n2 = iFormatReader.getPixelType();
        int n3 = FormatTools.getBytesPerPixel((int)n2);
        Object object = DataTools.makeDataArray((byte[])byArray, (int)n3, (boolean)(bl2 = FormatTools.isFloatingPoint((int)n2)), (boolean)(bl = iFormatReader.isLittleEndian()));
        if (object == byArray) {
            byte[] byArray2 = new byte[byArray.length];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            object = byArray2;
        }
        planarAccess.setPlane(n, ImageOpener.makeArray(object));
    }

    private <T extends RealType<T>> void populatePlane(IFormatReader iFormatReader, int n, byte[] byArray, LocalizablePlaneCursor<T> localizablePlaneCursor) {
        int n2 = iFormatReader.getSizeX();
        int n3 = iFormatReader.getPixelType();
        boolean bl = iFormatReader.isLittleEndian();
        int[] nArray = this.getDimLengths(iFormatReader);
        int[] nArray2 = new int[nArray.length];
        this.getPosition(iFormatReader, n, nArray2);
        localizablePlaneCursor.reset(0, 1, nArray2);
        while (localizablePlaneCursor.hasNext()) {
            localizablePlaneCursor.fwd();
            int n4 = localizablePlaneCursor.getPosition(0) + localizablePlaneCursor.getPosition(1) * n2;
            double d = ImageOpener.decodeWord(byArray, n4, n3, bl);
            ((RealType)localizablePlaneCursor.getType()).setReal(d);
        }
    }

    private static double decodeWord(byte[] byArray, int n, int n2, boolean bl) {
        double d;
        switch (n2) {
            case 1: {
                d = byArray[n] & 0xFF;
                break;
            }
            case 0: {
                d = byArray[n];
                break;
            }
            case 3: {
                d = DataTools.bytesToShort((byte[])byArray, (int)(2 * n), (int)2, (boolean)bl) & 0xFFFF;
                break;
            }
            case 2: {
                d = DataTools.bytesToShort((byte[])byArray, (int)(2 * n), (int)2, (boolean)bl);
                break;
            }
            case 5: {
                d = DataTools.bytesToInt((byte[])byArray, (int)(4 * n), (int)4, (boolean)bl) & 0xFFFFFFFF;
                break;
            }
            case 4: {
                d = DataTools.bytesToInt((byte[])byArray, (int)(4 * n), (int)4, (boolean)bl);
                break;
            }
            case 6: {
                d = DataTools.bytesToFloat((byte[])byArray, (int)(4 * n), (int)4, (boolean)bl);
                break;
            }
            case 7: {
                d = DataTools.bytesToDouble((byte[])byArray, (int)(4 * n), (int)4, (boolean)bl);
                break;
            }
            default: {
                d = Double.NaN;
            }
        }
        return d;
    }
}

