/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.newt.opengl.broadcom;

import com.sun.javafx.newt.Window;
import com.sun.javafx.newt.opengl.broadcom.BCEGLDisplay;
import com.sun.opengl.impl.egl.EGLGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.Capabilities;
import javax.media.nativewindow.GraphicsConfigurationFactory;
import javax.media.nativewindow.NativeWindowException;
import javax.media.opengl.GLCapabilities;

public class BCEGLWindow
extends Window {
    private long windowHandleClose;

    protected void createNative(long l, Capabilities capabilities) {
        if (0L != l) {
            throw new RuntimeException("Window parenting not supported (yet)");
        }
        this.config = GraphicsConfigurationFactory.getFactory((AbstractGraphicsDevice)this.getScreen().getDisplay().getGraphicsDevice()).chooseGraphicsConfiguration(capabilities, null, this.getScreen().getGraphicsScreen());
        if (this.config == null) {
            throw new NativeWindowException("Error choosing GraphicsConfiguration creating window: " + (Object)((Object)this));
        }
        this.setSizeImpl(this.getScreen().getWidth(), this.getScreen().getHeight());
    }

    protected void closeNative() {
        if (0L != this.windowHandleClose) {
            this.CloseWindow(this.getDisplayHandle(), this.windowHandleClose);
        }
    }

    public void setVisible(boolean bl) {
        if (this.visible != bl) {
            this.visible = bl;
            if (0L == this.windowHandle) {
                this.windowHandle = this.realizeWindow(true, this.width, this.height);
                if (0L == this.windowHandle) {
                    throw new NativeWindowException("Error native Window Handle is null");
                }
            }
            this.clearEventMask();
        }
    }

    public void setSize(int n, int n2) {
        System.err.println("setSize " + n + "x" + n2 + " n/a in BroadcomEGL");
    }

    void setSizeImpl(int n, int n2) {
        if (0L != this.windowHandle) {
            System.err.println("BCEGLWindow.setSizeImpl n/a in BroadcomEGL with realized window");
        } else {
            if (DEBUG_IMPLEMENTATION) {
                Exception exception = new Exception("BCEGLWindow.setSizeImpl() " + this.width + "x" + this.height + " -> " + n + "x" + n2);
                exception.printStackTrace();
            }
            this.width = n;
            this.height = n2;
        }
    }

    public void setPosition(int n, int n2) {
        System.err.println("setPosition n/a in BroadcomEGL");
    }

    public boolean setFullscreen(boolean bl) {
        System.err.println("setFullscreen n/a in BroadcomEGL");
        return false;
    }

    public boolean surfaceSwap() {
        if (0L != this.windowHandle) {
            this.SwapWindow(this.getDisplayHandle(), this.windowHandle);
            return true;
        }
        return false;
    }

    protected static native boolean initIDs();

    private native long CreateWindow(long var1, boolean var3, int var4, int var5);

    private native void CloseWindow(long var1, long var3);

    private native void SwapWindow(long var1, long var3);

    private long realizeWindow(boolean bl, int n, int n2) {
        long l;
        if (DEBUG_IMPLEMENTATION) {
            System.out.println("BCEGLWindow.realizeWindow() with: chroma " + bl + ", " + n + "x" + n2 + ", " + this.config);
        }
        if (0L == (l = this.CreateWindow(this.getDisplayHandle(), bl, n, n2))) {
            throw new NativeWindowException("Error native Window Handle is null");
        }
        this.windowHandleClose = l;
        return l;
    }

    private void windowCreated(int n, int n2, int n3) {
        this.width = n2;
        this.height = n3;
        GLCapabilities gLCapabilities = (GLCapabilities)this.config.getRequestedCapabilities();
        this.config = EGLGraphicsConfiguration.create((GLCapabilities)gLCapabilities, (AbstractGraphicsScreen)this.screen.getGraphicsScreen(), (int)n);
        if (this.config == null) {
            throw new NativeWindowException("Error creating EGLGraphicsConfiguration from id: " + n + ", " + (Object)((Object)this));
        }
        if (DEBUG_IMPLEMENTATION) {
            System.out.println("BCEGLWindow.windowCreated(): 0x" + Integer.toHexString(n) + ", " + n2 + "x" + n3 + ", " + this.config);
        }
    }

    static {
        BCEGLDisplay.initSingleton();
    }
}

