/*
 * Decompiled with CFR 0.152.
 */
package ij.util;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.StringTokenizer;
import java.util.Vector;

public class Tools {
    public static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String c2hex(Color color) {
        int n = color.getRGB();
        char[] cArray = new char[7];
        cArray[0] = 35;
        for (int i = 6; i >= 1; --i) {
            cArray[i] = hexDigits[n & 0xF];
            n >>>= 4;
        }
        return new String(cArray);
    }

    public static String f2hex(float f) {
        int n = Float.floatToIntBits(f);
        char[] cArray = new char[9];
        cArray[0] = 35;
        for (int i = 8; i >= 1; --i) {
            cArray[i] = hexDigits[n & 0xF];
            n >>>= 4;
        }
        return new String(cArray);
    }

    public static double[] getMinMax(double[] dArray) {
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        for (int i = 0; i < dArray.length; ++i) {
            double d3 = dArray[i];
            if (d3 < d) {
                d = d3;
            }
            if (!(d3 > d2)) continue;
            d2 = d3;
        }
        double[] dArray2 = new double[]{d, d2};
        return dArray2;
    }

    public static double[] getMinMax(float[] fArray) {
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        for (int i = 0; i < fArray.length; ++i) {
            double d3 = fArray[i];
            if (d3 < d) {
                d = d3;
            }
            if (!(d3 > d2)) continue;
            d2 = d3;
        }
        double[] dArray = new double[]{d, d2};
        return dArray;
    }

    public static double[] toDouble(float[] fArray) {
        int n = fArray.length;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = fArray[i];
        }
        return dArray;
    }

    public static float[] toFloat(double[] dArray) {
        int n = dArray.length;
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = (float)dArray[i];
        }
        return fArray;
    }

    public static String fixNewLines(String string) {
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != '\r') continue;
            cArray[i] = 10;
        }
        return new String(cArray);
    }

    public static double parseDouble(String string, double d) {
        if (string == null) {
            return d;
        }
        try {
            d = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return d;
    }

    public static double parseDouble(String string) {
        return Tools.parseDouble(string, Double.NaN);
    }

    public static int getDecimalPlaces(double d, double d2) {
        if ((double)Math.round(d) == d && (double)Math.round(d2) == d2) {
            return 0;
        }
        double d3 = (d = Math.abs(d)) < (d2 = Math.abs(d2)) && d > 0.0 ? d : d2;
        double d4 = Math.abs(d2 - d);
        if (d4 > 0.0 && d4 < d3) {
            d3 = d4;
        }
        int n = 2;
        if (d3 < 100.0) {
            n = 3;
        }
        if (d3 < 0.1) {
            n = 4;
        }
        if (d3 < 0.01) {
            n = 5;
        }
        if (d3 < 0.001) {
            n = 6;
        }
        if (d3 < 1.0E-4) {
            n = 7;
        }
        return n;
    }

    public static String[] split(String string) {
        return Tools.split(string, " \t\n\r");
    }

    public static String[] split(String string, String string2) {
        String[] stringArray;
        if (string2.equals("\n")) {
            return Tools.splitLines(string);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        int n = stringTokenizer.countTokens();
        if (n > 0) {
            stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = stringTokenizer.nextToken();
            }
        } else {
            stringArray = new String[]{string};
            n = 1;
        }
        return stringArray;
    }

    static String[] splitLines(String string) {
        Object object;
        Vector<String> vector = new Vector<String>();
        try {
            String string2;
            object = new BufferedReader(new StringReader(string));
            while ((string2 = ((BufferedReader)object).readLine()) != null) {
                vector.addElement(string2);
            }
            ((BufferedReader)object).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = new String[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public static void quicksort(double[] dArray, int[] nArray) {
        Tools.quicksort(dArray, nArray, 0, dArray.length - 1);
    }

    public static void quicksort(double[] dArray, int[] nArray, int n, int n2) {
        if (n2 <= n) {
            return;
        }
        int n3 = Tools.partition(dArray, nArray, n, n2);
        Tools.quicksort(dArray, nArray, n, n3 - 1);
        Tools.quicksort(dArray, nArray, n3 + 1, n2);
    }

    private static int partition(double[] dArray, int[] nArray, int n, int n2) {
        int n3 = n - 1;
        int n4 = n2;
        while (true) {
            if (dArray[++n3] < dArray[n2]) {
                continue;
            }
            while (!(dArray[n2] >= dArray[--n4]) && n4 != n) {
            }
            if (n3 >= n4) break;
            Tools.exch(dArray, nArray, n3, n4);
        }
        Tools.exch(dArray, nArray, n3, n2);
        return n3;
    }

    private static void exch(double[] dArray, int[] nArray, int n, int n2) {
        double d = dArray[n];
        dArray[n] = dArray[n2];
        dArray[n2] = d;
        int n3 = nArray[n];
        nArray[n] = nArray[n2];
        nArray[n2] = n3;
    }

    public static void quicksort(String[] stringArray, int[] nArray) {
        Tools.quicksort(stringArray, nArray, 0, stringArray.length - 1);
    }

    public static void quicksort(String[] stringArray, int[] nArray, int n, int n2) {
        if (n2 <= n) {
            return;
        }
        int n3 = Tools.partition(stringArray, nArray, n, n2);
        Tools.quicksort(stringArray, nArray, n, n3 - 1);
        Tools.quicksort(stringArray, nArray, n3 + 1, n2);
    }

    private static int partition(String[] stringArray, int[] nArray, int n, int n2) {
        int n3 = n - 1;
        int n4 = n2;
        while (true) {
            if (stringArray[++n3].compareToIgnoreCase(stringArray[n2]) < 0) {
                continue;
            }
            while (stringArray[n2].compareToIgnoreCase(stringArray[--n4]) < 0 && n4 != n) {
            }
            if (n3 >= n4) break;
            Tools.exch(stringArray, nArray, n3, n4);
        }
        Tools.exch(stringArray, nArray, n3, n2);
        return n3;
    }

    private static void exch(String[] stringArray, int[] nArray, int n, int n2) {
        String string = stringArray[n];
        stringArray[n] = stringArray[n2];
        stringArray[n2] = string;
        int n3 = nArray[n];
        nArray[n] = nArray[n2];
        nArray[n2] = n3;
    }
}

