/*
 * Decompiled with CFR 0.152.
 */
package ij.text;

import ij.IJ;
import ij.ImageJ;
import ij.Menus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.io.SaveDialog;
import ij.measure.ResultsTable;
import ij.plugin.filter.Analyzer;
import ij.plugin.frame.Recorder;
import ij.text.TextCanvas;
import ij.text.TextWindow;
import ij.util.Tools;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.Scrollbar;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Vector;

public class TextPanel
extends Panel
implements AdjustmentListener,
MouseListener,
MouseMotionListener,
KeyListener,
ClipboardOwner,
ActionListener,
MouseWheelListener,
Runnable {
    static final int DOUBLE_CLICK_THRESHOLD = 650;
    int iGridWidth;
    int iGridHeight;
    int iX;
    int iY;
    String[] sColHead;
    Vector vData;
    int[] iColWidth;
    int iColCount;
    int iRowCount;
    int iRowHeight;
    int iFirstRow;
    Scrollbar sbHoriz;
    Scrollbar sbVert;
    int iSbWidth;
    int iSbHeight;
    boolean bDrag;
    int iXDrag;
    int iColDrag;
    boolean headings = true;
    String title = "";
    String labels;
    KeyListener keyListener;
    Cursor resizeCursor = new Cursor(11);
    Cursor defaultCursor = new Cursor(0);
    int selStart = -1;
    int selEnd = -1;
    int selOrigin = -1;
    int selLine = -1;
    TextCanvas tc = new TextCanvas(this);
    PopupMenu pm;
    boolean columnsManuallyAdjusted;
    long mouseDownTime;
    String filePath;
    ResultsTable rt;
    boolean unsavedLines;

    public TextPanel() {
        this.setLayout(new BorderLayout());
        this.add("Center", this.tc);
        this.sbHoriz = new Scrollbar(0);
        this.sbHoriz.addAdjustmentListener(this);
        this.sbHoriz.setFocusable(false);
        this.add("South", this.sbHoriz);
        this.sbVert = new Scrollbar(1);
        this.sbVert.addAdjustmentListener(this);
        this.sbVert.setFocusable(false);
        ImageJ imageJ = IJ.getInstance();
        if (imageJ != null) {
            this.sbHoriz.addKeyListener(imageJ);
            this.sbVert.addKeyListener(imageJ);
        }
        this.add("East", this.sbVert);
        this.addPopupMenu();
    }

    public TextPanel(String string) {
        this();
        if (string.equals("Results")) {
            this.pm.addSeparator();
            this.addPopupItem("Clear Results");
            this.addPopupItem("Summarize");
            this.addPopupItem("Distribution...");
            this.addPopupItem("Set Measurements...");
            this.addPopupItem("Rename...");
            this.addPopupItem("Duplicate...");
        }
    }

    void addPopupMenu() {
        this.pm = new PopupMenu();
        this.addPopupItem("Save As...");
        this.pm.addSeparator();
        this.addPopupItem("Cut");
        this.addPopupItem("Copy");
        this.addPopupItem("Clear");
        this.addPopupItem("Select All");
        this.add(this.pm);
    }

    void addPopupItem(String string) {
        MenuItem menuItem = new MenuItem(string);
        menuItem.addActionListener(this);
        this.pm.add(menuItem);
    }

    public synchronized void setColumnHeadings(String string) {
        boolean bl = string.equals(this.labels);
        this.labels = string;
        if (string.equals("")) {
            this.iColCount = 1;
            this.sColHead = new String[1];
            this.sColHead[0] = "";
        } else {
            if (string.endsWith("\t")) {
                this.labels = string.substring(0, string.length() - 1);
            }
            this.sColHead = Tools.split(this.labels, "\t");
            this.iColCount = this.sColHead.length;
        }
        this.flush();
        this.vData = new Vector();
        if (this.iColWidth == null || this.iColWidth.length != this.iColCount || !bl || this.iColCount == 1) {
            this.iColWidth = new int[this.iColCount];
            this.columnsManuallyAdjusted = false;
        }
        this.iRowCount = 0;
        this.resetSelection();
        this.adjustHScroll();
        this.tc.repaint();
    }

    public String getColumnHeadings() {
        return this.labels == null ? "" : this.labels;
    }

    public synchronized void updateColumnHeadings(String string) {
        this.labels = string;
        if (string.equals("")) {
            this.iColCount = 1;
            this.sColHead = new String[1];
            this.sColHead[0] = "";
        } else {
            if (string.endsWith("\t")) {
                this.labels = string.substring(0, string.length() - 1);
            }
            this.sColHead = Tools.split(this.labels, "\t");
            this.iColCount = this.sColHead.length;
            this.iColWidth = new int[this.iColCount];
            this.columnsManuallyAdjusted = false;
        }
    }

    public void setFont(Font font, boolean bl) {
        this.tc.fFont = font;
        this.tc.iImage = null;
        this.tc.fMetrics = null;
        this.tc.antialiased = bl;
        this.iColWidth[0] = 0;
        if (this.isShowing()) {
            this.updateDisplay();
        }
    }

    public void appendLine(String string) {
        if (this.vData == null) {
            this.setColumnHeadings("");
        }
        char[] cArray = string.toCharArray();
        this.vData.addElement(cArray);
        ++this.iRowCount;
        if (this.isShowing()) {
            if (this.iColCount == 1 && this.tc.fMetrics != null) {
                this.iColWidth[0] = Math.max(this.iColWidth[0], this.tc.fMetrics.charsWidth(cArray, 0, cArray.length));
                this.adjustHScroll();
            }
            this.updateDisplay();
            this.unsavedLines = true;
        }
    }

    public void append(String string) {
        int n;
        if (string == null) {
            string = "null";
        }
        if (this.vData == null) {
            this.setColumnHeadings("");
        }
        do {
            if ((n = string.indexOf(10)) < 0) {
                this.appendWithoutUpdate(string);
                break;
            }
            this.appendWithoutUpdate(string.substring(0, n));
        } while (!(string = string.substring(n + 1)).equals(""));
        if (this.isShowing()) {
            this.updateDisplay();
            this.unsavedLines = true;
        }
    }

    public void append(ArrayList arrayList) {
        if (arrayList == null) {
            return;
        }
        if (this.vData == null) {
            this.setColumnHeadings("");
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            this.appendWithoutUpdate((String)arrayList.get(i));
        }
        if (this.isShowing()) {
            this.updateDisplay();
            this.unsavedLines = true;
        }
    }

    public void appendWithoutUpdate(String string) {
        if (this.vData != null) {
            char[] cArray = string.toCharArray();
            this.vData.addElement(cArray);
            ++this.iRowCount;
        }
    }

    public void updateDisplay() {
        this.iY = this.iRowHeight * (this.iRowCount + 1);
        this.adjustVScroll();
        if (this.iColCount > 1 && this.iRowCount <= 10 && !this.columnsManuallyAdjusted) {
            this.iColWidth[0] = 0;
        }
        this.tc.repaint();
    }

    String getCell(int n, int n2) {
        if (n < 0 || n >= this.iColCount || n2 < 0 || n2 >= this.iRowCount) {
            return null;
        }
        return new String(this.tc.getChars(n, n2));
    }

    synchronized void adjustVScroll() {
        if (this.iRowHeight == 0) {
            return;
        }
        Dimension dimension = this.tc.getSize();
        int n = this.iY / this.iRowHeight;
        int n2 = dimension.height / this.iRowHeight;
        int n3 = this.iRowCount + 1;
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > n3) {
            n2 = n3;
        }
        if (n > n3 - n2) {
            n = n3 - n2;
        }
        this.sbVert.setValues(n, n2, 0, n3);
        this.iY = this.iRowHeight * n;
    }

    synchronized void adjustHScroll() {
        if (this.iRowHeight == 0) {
            return;
        }
        Dimension dimension = this.tc.getSize();
        int n = 0;
        for (int i = 0; i < this.iColCount; ++i) {
            n += this.iColWidth[i];
        }
        this.iGridWidth = n;
        this.sbHoriz.setValues(this.iX, dimension.width, 0, this.iGridWidth);
        this.iX = this.sbHoriz.getValue();
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.iX = this.sbHoriz.getValue();
        this.iY = this.iRowHeight * this.sbVert.getValue();
        this.tc.repaint();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (mouseEvent.isPopupTrigger() && mouseEvent.getButton() != 0 || mouseEvent.isMetaDown()) {
            this.pm.show(mouseEvent.getComponent(), n, n2);
        } else if (mouseEvent.isShiftDown()) {
            this.extendSelection(n, n2);
        } else {
            this.select(n, n2);
            this.handleDoubleClick();
        }
    }

    void handleDoubleClick() {
        if (this.selStart < 0 || this.selStart != this.selEnd || this.iColCount != 1) {
            return;
        }
        boolean bl = System.currentTimeMillis() - this.mouseDownTime <= 650L;
        this.mouseDownTime = System.currentTimeMillis();
        if (bl) {
            char[] cArray = (char[])this.vData.elementAt(this.selStart);
            String string = new String(cArray);
            int n = string.indexOf(": ");
            if (n > -1 && !string.endsWith(": ")) {
                string = string.substring(n + 2);
            }
            if (string.indexOf(File.separator) != -1 || string.indexOf(".") != -1) {
                this.filePath = string;
                Thread thread = new Thread((Runnable)this, "Open");
                thread.setPriority(thread.getPriority() - 1);
                thread.start();
            }
        }
    }

    public void run() {
        if (this.filePath != null) {
            IJ.open(this.filePath);
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.bDrag) {
            this.setCursor(this.defaultCursor);
            this.bDrag = false;
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (n2 <= this.iRowHeight) {
            int n3;
            int n4 = n;
            n = n + this.iX - this.iGridWidth;
            for (n3 = this.iColCount - 1; n3 >= 0 && (n <= -7 || n >= 7); n += this.iColWidth[n3], --n3) {
            }
            if (n3 >= 0) {
                if (!this.bDrag) {
                    this.setCursor(this.resizeCursor);
                    this.bDrag = true;
                    this.iXDrag = n4 - this.iColWidth[n3];
                    this.iColDrag = n3;
                }
                return;
            }
        }
        if (this.bDrag) {
            this.setCursor(this.defaultCursor);
            this.bDrag = false;
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() && mouseEvent.getButton() != 0 || mouseEvent.isMetaDown()) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this.bDrag && n < this.tc.getSize().width) {
            int n3 = n - this.iXDrag;
            if (n3 < 0) {
                n3 = 0;
            }
            this.iColWidth[this.iColDrag] = n3;
            this.columnsManuallyAdjusted = true;
            this.adjustHScroll();
            this.tc.repaint();
        } else {
            this.extendSelection(n, n2);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        TextPanel textPanel = this;
        synchronized (textPanel) {
            int n = mouseWheelEvent.getWheelRotation();
            this.sbVert.setValue(this.sbVert.getValue() + n);
            this.iY = this.iRowHeight * this.sbVert.getValue();
            this.tc.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scroll(int n) {
        TextPanel textPanel = this;
        synchronized (textPanel) {
            this.sbVert.setValue(this.sbVert.getValue() + n);
            this.iY = this.iRowHeight * this.sbVert.getValue();
            this.tc.repaint();
        }
    }

    public void addKeyListener(KeyListener keyListener) {
        this.keyListener = keyListener;
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.tc.addMouseListener(mouseListener);
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 8) {
            this.clearSelection();
        } else if (n == 38) {
            this.scroll(-1);
        } else if (n == 40) {
            this.scroll(1);
        } else if (this.keyListener != null && n != 83 && n != 67 && n != 88 && n != 65) {
            this.keyListener.keyPressed(keyEvent);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (this.keyListener != null) {
            this.keyListener.keyTyped(keyEvent);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        this.doCommand(string);
    }

    void doCommand(String string) {
        if (string == null) {
            return;
        }
        if (string.equals("Save As...")) {
            this.saveAs("");
        } else if (string.equals("Cut")) {
            this.cutSelection();
        } else if (string.equals("Copy")) {
            this.copySelection();
        } else if (string.equals("Clear")) {
            this.clearSelection();
        } else if (string.equals("Select All")) {
            this.selectAll();
        } else if (string.equals("Rename...")) {
            this.rename(null);
        } else if (string.equals("Duplicate...")) {
            this.duplicate();
        } else if (string.equals("Summarize")) {
            IJ.doCommand("Summarize");
        } else if (string.equals("Distribution...")) {
            IJ.doCommand("Distribution...");
        } else if (string.equals("Clear Results")) {
            IJ.doCommand("Clear Results");
        } else if (string.equals("Set Measurements...")) {
            IJ.doCommand("Set Measurements...");
        } else if (string.equals("Options...")) {
            IJ.doCommand("Input/Output...");
        }
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    void rename(String string) {
        Object object;
        Container container;
        if (this.rt == null) {
            return;
        }
        if (string != null && string.equals("")) {
            string = null;
        }
        if ((container = this.getParent()) == null || !(container instanceof TextWindow)) {
            return;
        }
        TextWindow textWindow = (TextWindow)container;
        if (string == null) {
            object = new GenericDialog("Rename", textWindow);
            ((GenericDialog)object).addStringField("Title:", "Results2", 20);
            ((GenericDialog)object).showDialog();
            if (((GenericDialog)object).wasCanceled()) {
                return;
            }
            string = ((GenericDialog)object).getNextString();
        }
        object = this.title;
        if (this.title != null && this.title.equals("Results")) {
            IJ.setTextPanel(null);
            Analyzer.setUnsavedMeasurements(false);
            Analyzer.setResultsTable(null);
            Analyzer.resetCounter();
        }
        if (string.equals("Results")) {
            textWindow.dispose();
            WindowManager.removeWindow(textWindow);
            this.flush();
            this.rt.show("Results");
        } else {
            int n;
            textWindow.setTitle(string);
            int n2 = n = textWindow.mb != null ? textWindow.mb.getMenuCount() : 0;
            if (n > 0 && textWindow.mb.getMenu(n - 1).getLabel().equals("Results")) {
                textWindow.mb.remove(n - 1);
            }
            this.title = string;
        }
        Menus.updateWindowMenuItem((String)object, string);
        if (Recorder.record) {
            Recorder.recordString("IJ.renameResults(\"" + string + "\");\n");
        }
    }

    void duplicate() {
        if (this.rt == null) {
            return;
        }
        ResultsTable resultsTable = (ResultsTable)this.rt.clone();
        String string = IJ.getString("Title:", "Results2");
        if (!string.equals("")) {
            if (string.equals("Results")) {
                string = "Results2";
            }
            resultsTable.show(string);
        }
    }

    void select(int n, int n2) {
        Dimension dimension = this.tc.getSize();
        if (this.iRowHeight == 0 || n > dimension.width || n2 > dimension.height) {
            return;
        }
        int n3 = n2 / this.iRowHeight - 1 + this.iFirstRow;
        int n4 = this.iGridWidth;
        if (this.iColCount == 1 && this.tc.fMetrics != null && n3 >= 0 && n3 < this.iRowCount) {
            char[] cArray = (char[])this.vData.elementAt(n3);
            n4 = Math.max(this.tc.fMetrics.charsWidth(cArray, 0, cArray.length), this.iGridWidth);
        }
        if (n3 >= 0 && n3 < this.iRowCount && n < n4) {
            this.selOrigin = n3;
            this.selStart = n3;
            this.selEnd = n3;
        } else {
            this.resetSelection();
            this.selOrigin = n3;
            if (n3 >= this.iRowCount) {
                this.selOrigin = this.iRowCount - 1;
            }
        }
        this.tc.repaint();
        this.selLine = n3;
    }

    void extendSelection(int n, int n2) {
        Dimension dimension = this.tc.getSize();
        if (this.iRowHeight == 0 || n > dimension.width || n2 > dimension.height) {
            return;
        }
        int n3 = n2 / this.iRowHeight - 1 + this.iFirstRow;
        if (n3 >= 0 && n3 < this.iRowCount) {
            if (n3 < this.selOrigin) {
                this.selStart = n3;
                this.selEnd = this.selOrigin;
            } else {
                this.selStart = this.selOrigin;
                this.selEnd = n3;
            }
        }
        this.tc.repaint();
        this.selLine = n3;
    }

    public int rowIndex(int n) {
        if (n > this.tc.getSize().height) {
            return -1;
        }
        return n / this.iRowHeight - 1 + this.iFirstRow;
    }

    public int copySelection() {
        Object object;
        if (Recorder.record && this.title.equals("Results")) {
            Recorder.record("String.copyResults");
        }
        if (this.selStart == -1 || this.selEnd == -1) {
            return this.copyAll();
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (Prefs.copyColumnHeaders && this.labels != null && !this.labels.equals("") && this.selStart == 0 && this.selEnd == this.iRowCount - 1) {
            if (Prefs.noRowNumbers) {
                String string = this.labels;
                int n = string.indexOf("\t");
                if (n != -1) {
                    string = string.substring(n + 1, string.length());
                }
                stringBuffer.append(string);
            } else {
                stringBuffer.append(this.labels);
            }
            stringBuffer.append('\n');
        }
        for (int i = this.selStart; i <= this.selEnd; ++i) {
            char[] cArray = (char[])this.vData.elementAt(i);
            object = new String(cArray);
            if (((String)object).endsWith("\t")) {
                object = ((String)object).substring(0, ((String)object).length() - 1);
            }
            if (Prefs.noRowNumbers) {
                int n = ((String)object).indexOf("\t");
                if (n != -1) {
                    object = ((String)object).substring(n + 1, ((String)object).length());
                }
                stringBuffer.append((String)object);
            } else {
                stringBuffer.append((String)object);
            }
            if (i >= this.selEnd && this.selEnd <= this.selStart) continue;
            stringBuffer.append('\n');
        }
        String string = new String(stringBuffer);
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        if (clipboard == null) {
            return 0;
        }
        object = new StringSelection(string);
        clipboard.setContents((Transferable)object, this);
        if (string.length() > 0) {
            IJ.showStatus(this.selEnd - this.selStart + 1 + " lines copied to clipboard");
            if (this.getParent() instanceof ImageJ) {
                Analyzer.setUnsavedMeasurements(false);
            }
        }
        return string.length();
    }

    int copyAll() {
        this.selectAll();
        int n = this.selEnd - this.selStart;
        if (n > 0) {
            this.copySelection();
        }
        this.resetSelection();
        this.unsavedLines = false;
        return n;
    }

    void cutSelection() {
        if (this.selStart == -1 || this.selEnd == -1) {
            this.selectAll();
        }
        this.copySelection();
        this.clearSelection();
    }

    public void clearSelection() {
        if (this.selStart == -1 || this.selEnd == -1) {
            if (this.getLineCount() > 0) {
                IJ.error("Selection required");
            }
            return;
        }
        if (Recorder.record) {
            Recorder.recordString("IJ.deleteRows(" + this.selStart + ", " + this.selEnd + ");\n");
        }
        if (this.selStart == 0 && this.selEnd == this.iRowCount - 1) {
            this.vData.removeAllElements();
            this.iRowCount = 0;
            if (this.rt != null) {
                if (IJ.isResultsWindow() && IJ.getTextPanel() == this) {
                    Analyzer.setUnsavedMeasurements(false);
                    Analyzer.resetCounter();
                } else {
                    this.rt.reset();
                }
            }
        } else {
            int n;
            int n2 = this.iRowCount;
            boolean bl = n2 - this.selEnd < 8;
            int n3 = this.selEnd - this.selStart + 1;
            for (n = 0; n < n3; ++n) {
                this.vData.removeElementAt(this.selStart);
                --this.iRowCount;
            }
            if (this.rt != null && n2 == this.rt.getCounter()) {
                for (n = 0; n < n3; ++n) {
                    this.rt.deleteRow(this.selStart);
                }
                this.rt.show(this.title);
                if (!bl) {
                    this.iY = 0;
                    this.tc.repaint();
                }
            }
        }
        this.selStart = -1;
        this.selEnd = -1;
        this.selOrigin = -1;
        this.selLine = -1;
        this.adjustVScroll();
        this.tc.repaint();
    }

    public void clear() {
        if (this.vData == null) {
            return;
        }
        this.vData.removeAllElements();
        this.iRowCount = 0;
        this.selStart = -1;
        this.selEnd = -1;
        this.selOrigin = -1;
        this.selLine = -1;
        this.adjustVScroll();
        this.tc.repaint();
    }

    public void selectAll() {
        if (this.selStart == 0 && this.selEnd == this.iRowCount - 1) {
            this.resetSelection();
            return;
        }
        this.selStart = 0;
        this.selEnd = this.iRowCount - 1;
        this.selOrigin = 0;
        this.tc.repaint();
        this.selLine = -1;
    }

    public void resetSelection() {
        this.selStart = -1;
        this.selEnd = -1;
        this.selOrigin = -1;
        this.selLine = -1;
        if (this.iRowCount > 0) {
            this.tc.repaint();
        }
    }

    public void setSelection(int n, int n2) {
        if (n > n2) {
            n2 = n;
        }
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n >= this.iRowCount) {
            n = this.iRowCount - 1;
        }
        if (n2 >= this.iRowCount) {
            n2 = this.iRowCount - 1;
        }
        this.selOrigin = n;
        this.selStart = n;
        this.selEnd = n2;
        int n3 = this.sbVert.getValue();
        int n4 = this.sbVert.getVisibleAmount() - 1;
        if (n < n3) {
            this.sbVert.setValue(n);
            this.iY = this.iRowHeight * n;
        } else if (n2 >= n3 + n4) {
            n3 = n2 - n4 + 1;
            if (n3 < 0) {
                n3 = 0;
            }
            this.sbVert.setValue(n3);
            this.iY = this.iRowHeight * n3;
        }
        this.tc.repaint();
    }

    public void save(PrintWriter printWriter) {
        this.resetSelection();
        if (this.labels != null && !this.labels.equals("")) {
            printWriter.println(this.labels);
        }
        for (int i = 0; i < this.iRowCount; ++i) {
            char[] cArray = (char[])this.vData.elementAt(i);
            String string = new String(cArray);
            if (string.endsWith("\t")) {
                string = string.substring(0, string.length() - 1);
            }
            printWriter.println(string);
        }
        this.unsavedLines = false;
    }

    public boolean saveAs(String string) {
        Object object;
        boolean bl = IJ.isResultsWindow() && IJ.getTextPanel() == this;
        boolean bl2 = false;
        if (bl) {
            object = this.iRowCount >= 2 ? this.getLine(this.iRowCount - 2) : null;
            boolean bl3 = bl2 = object != null && ((String)object).startsWith("Max");
        }
        if (this.rt != null && this.rt.getCounter() != 0 && !bl2) {
            if (string == null || string.equals("")) {
                IJ.wait(10);
                object = bl ? "Results" : this.title;
                SaveDialog saveDialog = new SaveDialog("Save Results", (String)object, Prefs.get("options.ext", ".xls"));
                String string2 = saveDialog.getFileName();
                if (string2 == null) {
                    return false;
                }
                string = saveDialog.getDirectory() + string2;
            }
            try {
                this.rt.saveAs(string);
            }
            catch (IOException iOException) {
                IJ.error("" + iOException);
            }
        } else {
            Object object2;
            Object object3;
            if (string.equals("")) {
                String string3;
                IJ.wait(10);
                boolean bl4 = !this.getColumnHeadings().equals("");
                Object object4 = object3 = bl || bl4 ? Prefs.get("options.ext", ".xls") : ".txt";
                if (((String)object3).equals(".csv")) {
                    object3 = ".txt";
                }
                if ((string3 = ((SaveDialog)(object2 = new SaveDialog("Save as Text", this.title, (String)object3))).getFileName()) == null) {
                    return false;
                }
                string = ((SaveDialog)object2).getDirectory() + string3;
            }
            object = null;
            try {
                object3 = new FileOutputStream(string);
                object2 = new BufferedOutputStream((OutputStream)object3);
                object = new PrintWriter((OutputStream)object2);
            }
            catch (IOException iOException) {
                return true;
            }
            this.save((PrintWriter)object);
            ((PrintWriter)object).close();
        }
        if (bl) {
            Analyzer.setUnsavedMeasurements(false);
            if (Recorder.record && !IJ.isMacro()) {
                Recorder.record("saveAs", "Results", string);
            }
        } else if (this.rt != null) {
            if (Recorder.record && !IJ.isMacro()) {
                Recorder.record("saveAs", "Results", string);
            }
        } else if (Recorder.record && !IJ.isMacro()) {
            Recorder.record("saveAs", "Text", string);
        }
        IJ.showStatus("");
        return true;
    }

    public String getText() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.labels != null && !this.labels.equals("")) {
            stringBuffer.append(this.labels);
            stringBuffer.append('\n');
        }
        for (int i = 0; i < this.iRowCount; ++i) {
            char[] cArray = (char[])this.vData.elementAt(i);
            stringBuffer.append(cArray);
            stringBuffer.append('\n');
        }
        return new String(stringBuffer);
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public int getLineCount() {
        return this.iRowCount;
    }

    public String getLine(int n) {
        if (n < 0 || n >= this.iRowCount) {
            throw new IllegalArgumentException("index out of range: " + n);
        }
        return new String((char[])this.vData.elementAt(n));
    }

    public void setLine(int n, String string) {
        if (n < 0 || n >= this.iRowCount) {
            throw new IllegalArgumentException("index out of range: " + n);
        }
        if (this.vData != null) {
            this.vData.setElementAt(string.toCharArray(), n);
            this.tc.repaint();
        }
    }

    public int getSelectionStart() {
        return this.selStart;
    }

    public int getSelectionEnd() {
        return this.selEnd;
    }

    public void setResultsTable(ResultsTable resultsTable) {
        this.rt = resultsTable;
    }

    public ResultsTable getResultsTable() {
        return this.rt;
    }

    public void scrollToTop() {
        this.sbVert.setValue(0);
        this.iY = 0;
        for (int i = 0; i < this.iColCount; ++i) {
            this.tc.calcAutoWidth(i);
        }
        this.adjustHScroll();
        this.tc.repaint();
    }

    void flush() {
        if (this.vData != null) {
            this.vData.removeAllElements();
        }
        this.vData = null;
    }
}

