/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.IJ;
import ij.plugin.filter.Convolver;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortBlitter;
import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.MemoryImageSource;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Random;

public class ShortProcessor
extends ImageProcessor {
    private int min;
    private int max;
    private int snapshotMin;
    private int snapshotMax;
    private short[] pixels;
    private byte[] pixels8;
    private short[] snapshotPixels;
    private byte[] LUT;
    private boolean fixedScale;

    public ShortProcessor(int n, int n2, short[] sArray, ColorModel colorModel) {
        if (sArray != null && n * n2 != sArray.length) {
            throw new IllegalArgumentException("width*height!=pixels.length");
        }
        this.init(n, n2, sArray, colorModel);
    }

    public ShortProcessor(int n, int n2) {
        this(n, n2, new short[n * n2], null);
    }

    public ShortProcessor(BufferedImage bufferedImage) {
        if (bufferedImage.getType() != 11) {
            throw new IllegalArgumentException("Type!=TYPE_USHORT_GRAY");
        }
        WritableRaster writableRaster = bufferedImage.getRaster();
        DataBuffer dataBuffer = writableRaster.getDataBuffer();
        short[] sArray = ((DataBufferUShort)dataBuffer).getData();
        this.init(writableRaster.getWidth(), writableRaster.getHeight(), sArray, null);
    }

    void init(int n, int n2, short[] sArray, ColorModel colorModel) {
        this.width = n;
        this.height = n2;
        this.pixels = sArray;
        this.cm = colorModel;
        this.resetRoi();
    }

    public ShortProcessor(int n, int n2, short[] sArray, ColorModel colorModel, boolean bl) {
        this(n, n2, sArray, colorModel);
    }

    public ShortProcessor(int n, int n2, boolean bl) {
        this(n, n2);
    }

    public void findMinAndMax() {
        if (this.fixedScale || this.pixels == null) {
            return;
        }
        int n = this.width * this.height;
        this.min = 65535;
        this.max = 0;
        for (int i = 0; i < n; ++i) {
            int n2 = this.pixels[i] & 0xFFFF;
            if (n2 < this.min) {
                this.min = n2;
            }
            if (n2 <= this.max) continue;
            this.max = n2;
        }
        this.minMaxSet = true;
    }

    public Image createImage() {
        boolean bl;
        boolean bl2 = bl = this.pixels8 == null;
        if (bl || !this.lutAnimation) {
            this.create8BitImage();
        }
        if (this.cm == null) {
            this.makeDefaultColorModel();
        }
        if (IJ.isJava16()) {
            return this.createBufferedImage();
        }
        if (this.source == null) {
            this.source = new MemoryImageSource(this.width, this.height, this.cm, this.pixels8, 0, this.width);
            this.source.setAnimated(true);
            this.source.setFullBufferUpdates(true);
            this.img = Toolkit.getDefaultToolkit().createImage(this.source);
        } else if (this.newPixels) {
            this.source.newPixels(this.pixels8, this.cm, 0, this.width);
            this.newPixels = false;
        } else {
            this.source.newPixels();
        }
        this.lutAnimation = false;
        return this.img;
    }

    byte[] create8BitImage() {
        int n = this.width * this.height;
        if (this.pixels8 == null) {
            this.pixels8 = new byte[n];
        }
        int n2 = (int)this.getMin();
        int n3 = (int)this.getMax();
        double d = 256.0 / (double)(n3 - n2 + 1);
        for (int i = 0; i < n; ++i) {
            int n4 = (this.pixels[i] & 0xFFFF) - n2;
            if (n4 < 0) {
                n4 = 0;
            }
            if ((n4 = (int)((double)n4 * d + 0.5)) > 255) {
                n4 = 255;
            }
            this.pixels8[i] = (byte)n4;
        }
        return this.pixels8;
    }

    Image createBufferedImage() {
        if (this.raster == null) {
            SampleModel sampleModel = this.getIndexSampleModel();
            DataBufferByte dataBufferByte = new DataBufferByte(this.pixels8, this.width * this.height, 0);
            this.raster = Raster.createWritableRaster(sampleModel, dataBufferByte, null);
        }
        if (this.image == null || this.cm != this.cm2) {
            if (this.cm == null) {
                this.cm = this.getDefaultColorModel();
            }
            this.image = new BufferedImage(this.cm, this.raster, false, null);
            this.cm2 = this.cm;
        }
        this.lutAnimation = false;
        return this.image;
    }

    public BufferedImage getBufferedImage() {
        return this.convertToByte(true).getBufferedImage();
    }

    public BufferedImage get16BitBufferedImage() {
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 11);
        Raster raster = bufferedImage.getData();
        DataBufferUShort dataBufferUShort = (DataBufferUShort)raster.getDataBuffer();
        System.arraycopy(this.getPixels(), 0, dataBufferUShort.getData(), 0, dataBufferUShort.getData().length);
        bufferedImage.setData(raster);
        return bufferedImage;
    }

    public ImageProcessor createProcessor(int n, int n2) {
        ShortProcessor shortProcessor = new ShortProcessor(n, n2, new short[n * n2], this.getColorModel());
        ((ImageProcessor)shortProcessor).setMinAndMax(this.getMin(), this.getMax());
        shortProcessor.setInterpolationMethod(this.interpolationMethod);
        return shortProcessor;
    }

    public void snapshot() {
        this.snapshotWidth = this.width;
        this.snapshotHeight = this.height;
        this.snapshotMin = (int)this.getMin();
        this.snapshotMax = (int)this.getMax();
        if (this.snapshotPixels == null || this.snapshotPixels != null && this.snapshotPixels.length != this.pixels.length) {
            this.snapshotPixels = new short[this.width * this.height];
        }
        System.arraycopy(this.pixels, 0, this.snapshotPixels, 0, this.width * this.height);
    }

    public void reset() {
        if (this.snapshotPixels == null) {
            return;
        }
        this.min = this.snapshotMin;
        this.max = this.snapshotMax;
        this.minMaxSet = true;
        System.arraycopy(this.snapshotPixels, 0, this.pixels, 0, this.width * this.height);
    }

    public void reset(ImageProcessor imageProcessor) {
        if (imageProcessor == null || this.snapshotPixels == null) {
            return;
        }
        if (imageProcessor.getWidth() != this.roiWidth || imageProcessor.getHeight() != this.roiHeight) {
            throw new IllegalArgumentException(this.maskSizeError(imageProcessor));
        }
        byte[] byArray = (byte[])imageProcessor.getPixels();
        int n = this.roiY;
        int n2 = 0;
        while (n < this.roiY + this.roiHeight) {
            int n3 = n * this.width + this.roiX;
            int n4 = n2 * this.roiWidth;
            for (int i = this.roiX; i < this.roiX + this.roiWidth; ++i) {
                if (byArray[n4++] == 0) {
                    this.pixels[n3] = this.snapshotPixels[n3];
                }
                ++n3;
            }
            ++n;
            ++n2;
        }
    }

    public void swapPixelArrays() {
        if (this.snapshotPixels == null) {
            return;
        }
        for (int i = 0; i < this.pixels.length; ++i) {
            short s = this.pixels[i];
            this.pixels[i] = this.snapshotPixels[i];
            this.snapshotPixels[i] = s;
        }
    }

    public void setSnapshotPixels(Object object) {
        this.snapshotPixels = (short[])object;
        this.snapshotWidth = this.width;
        this.snapshotHeight = this.height;
    }

    public Object getSnapshotPixels() {
        return this.snapshotPixels;
    }

    public double getMin() {
        if (!this.minMaxSet) {
            this.findMinAndMax();
        }
        return this.min;
    }

    public double getMax() {
        if (!this.minMaxSet) {
            this.findMinAndMax();
        }
        return this.max;
    }

    public void setMinAndMax(double d, double d2) {
        if (d == 0.0 && d2 == 0.0) {
            this.resetMinAndMax();
            return;
        }
        if (d < 0.0) {
            d = 0.0;
        }
        if (d2 > 65535.0) {
            d2 = 65535.0;
        }
        this.min = (int)d;
        this.max = (int)d2;
        this.fixedScale = true;
        this.minMaxSet = true;
        this.resetThreshold();
    }

    public void resetMinAndMax() {
        this.fixedScale = false;
        this.findMinAndMax();
        this.resetThreshold();
    }

    public int getPixel(int n, int n2) {
        if (n >= 0 && n < this.width && n2 >= 0 && n2 < this.height) {
            return this.pixels[n2 * this.width + n] & 0xFFFF;
        }
        return 0;
    }

    public final int get(int n, int n2) {
        return this.pixels[n2 * this.width + n] & 0xFFFF;
    }

    public final void set(int n, int n2, int n3) {
        this.pixels[n2 * this.width + n] = (short)n3;
    }

    public final int get(int n) {
        return this.pixels[n] & 0xFFFF;
    }

    public final void set(int n, int n2) {
        this.pixels[n] = (short)n2;
    }

    public final float getf(int n, int n2) {
        return this.pixels[n2 * this.width + n] & 0xFFFF;
    }

    public final void setf(int n, int n2, float f) {
        this.pixels[n2 * this.width + n] = (short)f;
    }

    public final float getf(int n) {
        return this.pixels[n] & 0xFFFF;
    }

    public final void setf(int n, float f) {
        this.pixels[n] = (short)f;
    }

    public double getInterpolatedPixel(double d, double d2) {
        if (this.interpolationMethod == 2) {
            return this.getBicubicInterpolatedPixel(d, d2, this);
        }
        if (d < 0.0) {
            d = 0.0;
        }
        if (d >= (double)this.width - 1.0) {
            d = (double)this.width - 1.001;
        }
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        if (d2 >= (double)this.height - 1.0) {
            d2 = (double)this.height - 1.001;
        }
        return this.getInterpolatedPixel(d, d2, this.pixels);
    }

    public final int getPixelInterpolated(double d, double d2) {
        if (this.interpolationMethod == 1) {
            if (d < 0.0 || d2 < 0.0 || d >= (double)(this.width - 1) || d2 >= (double)(this.height - 1)) {
                return 0;
            }
            return (int)Math.round(this.getInterpolatedPixel(d, d2, this.pixels));
        }
        if (this.interpolationMethod == 2) {
            int n = (int)(this.getBicubicInterpolatedPixel(d, d2, this) + 0.5);
            if (n < 0) {
                n = 0;
            }
            if (n > 65535) {
                n = 65535;
            }
            return n;
        }
        return this.getPixel((int)(d + 0.5), (int)(d2 + 0.5));
    }

    public final void putPixel(int n, int n2, int n3) {
        if (n >= 0 && n < this.width && n2 >= 0 && n2 < this.height) {
            if (n3 > 65535) {
                n3 = 65535;
            }
            if (n3 < 0) {
                n3 = 0;
            }
            this.pixels[n2 * this.width + n] = (short)n3;
        }
    }

    public void putPixelValue(int n, int n2, double d) {
        if (n >= 0 && n < this.width && n2 >= 0 && n2 < this.height) {
            if (this.cTable != null && this.cTable[0] == -32768.0f) {
                d += 32768.0;
            }
            if (d > 65535.0) {
                d = 65535.0;
            } else if (d < 0.0) {
                d = 0.0;
            }
            this.pixels[n2 * this.width + n] = (short)(d + 0.5);
        }
    }

    public void drawPixel(int n, int n2) {
        if (n >= this.clipXMin && n <= this.clipXMax && n2 >= this.clipYMin && n2 <= this.clipYMax) {
            this.putPixel(n, n2, this.fgColor);
        }
    }

    public float getPixelValue(int n, int n2) {
        if (n >= 0 && n < this.width && n2 >= 0 && n2 < this.height) {
            if (this.cTable == null) {
                return this.pixels[n2 * this.width + n] & 0xFFFF;
            }
            return this.cTable[this.pixels[n2 * this.width + n] & 0xFFFF];
        }
        return 0.0f;
    }

    public Object getPixels() {
        return this.pixels;
    }

    public Object getPixelsCopy() {
        if (this.snapshotPixels != null && this.snapshotCopyMode) {
            this.snapshotCopyMode = false;
            return this.snapshotPixels;
        }
        short[] sArray = new short[this.width * this.height];
        System.arraycopy(this.pixels, 0, sArray, 0, this.width * this.height);
        return sArray;
    }

    public void setPixels(Object object) {
        this.pixels = (short[])object;
        this.resetPixels(object);
        if (object == null) {
            this.snapshotPixels = null;
        }
        if (object == null) {
            this.pixels8 = null;
        }
        this.raster = null;
    }

    void getRow2(int n, int n2, int[] nArray, int n3) {
        for (int i = 0; i < n3; ++i) {
            nArray[i] = this.pixels[n2 * this.width + n + i] & 0xFFFF;
        }
    }

    void putColumn2(int n, int n2, int[] nArray, int n3) {
        for (int i = 0; i < n3; ++i) {
            this.pixels[(n2 + i) * this.width + n] = (short)nArray[i];
        }
    }

    public void copyBits(ImageProcessor imageProcessor, int n, int n2, int n3) {
        imageProcessor = imageProcessor.convertToShort(false);
        new ShortBlitter(this).copyBits(imageProcessor, n, n2, n3);
    }

    public void applyTable(int[] nArray) {
        if (nArray.length != 65536) {
            throw new IllegalArgumentException("lut.length!=65536");
        }
        for (int i = this.roiY; i < this.roiY + this.roiHeight; ++i) {
            int n;
            int n2 = i * this.width + this.roiX;
            int n3 = n = n2 + this.roiWidth;
            while (--n3 >= n2) {
                int n4 = nArray[this.pixels[n3] & 0xFFFF];
                this.pixels[n3] = (short)n4;
            }
        }
        this.findMinAndMax();
    }

    private void process(int n, double d) {
        double d2 = this.getMax() - this.getMin();
        int n2 = this.cTable != null && this.cTable[0] == -32768.0f ? 32768 : 0;
        int n3 = (int)this.getMin() - n2;
        int n4 = (int)this.getMax() - n2;
        int n5 = this.fgColor - n2;
        for (int i = this.roiY; i < this.roiY + this.roiHeight; ++i) {
            int n6 = i * this.width + this.roiX;
            for (int j = this.roiX; j < this.roiX + this.roiWidth; ++j) {
                int n7;
                int n8 = (this.pixels[n6] & 0xFFFF) - n2;
                switch (n) {
                    case 0: {
                        n7 = n4 - (n8 - n3);
                        break;
                    }
                    case 1: {
                        n7 = n5;
                        break;
                    }
                    case 2: {
                        n7 = n8 + (int)d;
                        break;
                    }
                    case 3: {
                        n7 = (int)Math.round((double)n8 * d);
                        break;
                    }
                    case 4: {
                        n7 = n8 & (int)d;
                        break;
                    }
                    case 5: {
                        n7 = n8 | (int)d;
                        break;
                    }
                    case 6: {
                        n7 = n8 ^ (int)d;
                        break;
                    }
                    case 7: {
                        if (d2 <= 0.0 || n8 == n3) {
                            n7 = n8;
                            break;
                        }
                        n7 = (int)(Math.exp(d * Math.log((double)(n8 - n3) / d2)) * d2 + (double)n3);
                        break;
                    }
                    case 8: {
                        if (n8 <= 0) {
                            n7 = 0;
                            break;
                        }
                        n7 = (int)(Math.log(n8) * ((double)n4 / Math.log(n4)));
                        break;
                    }
                    case 13: {
                        n7 = (int)Math.exp((double)n8 * (Math.log(n4) / (double)n4));
                        break;
                    }
                    case 11: {
                        double d3 = n8;
                        n7 = (int)(d3 * d3);
                        break;
                    }
                    case 12: {
                        n7 = (int)Math.sqrt(n8);
                        break;
                    }
                    case 14: {
                        n7 = Math.abs(n8);
                        break;
                    }
                    case 9: {
                        if ((double)n8 < d) {
                            n7 = (int)d;
                            break;
                        }
                        n7 = n8;
                        break;
                    }
                    case 10: {
                        if ((double)n8 > d) {
                            n7 = (int)d;
                            break;
                        }
                        n7 = n8;
                        break;
                    }
                    default: {
                        n7 = n8;
                    }
                }
                if ((n7 += n2) < 0) {
                    n7 = 0;
                }
                if (n7 > 65535) {
                    n7 = 65535;
                }
                this.pixels[n6++] = (short)n7;
            }
        }
    }

    public void invert() {
        this.resetMinAndMax();
        this.process(0, 0.0);
    }

    public void add(int n) {
        this.process(2, n);
    }

    public void add(double d) {
        this.process(2, d);
    }

    public void multiply(double d) {
        this.process(3, d);
    }

    public void and(int n) {
        this.process(4, n);
    }

    public void or(int n) {
        this.process(5, n);
    }

    public void xor(int n) {
        this.process(6, n);
    }

    public void gamma(double d) {
        this.process(7, d);
    }

    public void log() {
        this.process(8, 0.0);
    }

    public void exp() {
        this.process(13, 0.0);
    }

    public void sqr() {
        this.process(11, 0.0);
    }

    public void sqrt() {
        this.process(12, 0.0);
    }

    public void abs() {
        this.process(14, 0.0);
    }

    public void min(double d) {
        this.process(9, d);
    }

    public void max(double d) {
        this.process(10, d);
    }

    public void fill() {
        this.process(1, 0.0);
    }

    public void fill(ImageProcessor imageProcessor) {
        if (imageProcessor == null) {
            this.fill();
            return;
        }
        int n = this.roiWidth;
        int n2 = this.roiHeight;
        int n3 = this.roiX;
        int n4 = this.roiY;
        if (imageProcessor.getWidth() != n || imageProcessor.getHeight() != n2) {
            return;
        }
        byte[] byArray = (byte[])imageProcessor.getPixels();
        int n5 = n4;
        int n6 = 0;
        while (n5 < n4 + n2) {
            int n7 = n5 * this.width + n3;
            int n8 = n6 * n;
            for (int i = n3; i < n3 + n; ++i) {
                if (byArray[n8++] != 0) {
                    this.pixels[n7] = (short)this.fgColor;
                }
                ++n7;
            }
            ++n5;
            ++n6;
        }
    }

    public void convolve3x3(int[] nArray) {
        this.filter3x3(5, nArray);
    }

    public void filter(int n) {
        this.filter3x3(n, null);
    }

    void filter3x3(int n, int[] nArray) {
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        if (n == 5) {
            n3 = nArray[0];
            n4 = nArray[1];
            n5 = nArray[2];
            n6 = nArray[3];
            n7 = nArray[4];
            n8 = nArray[5];
            n9 = nArray[6];
            n10 = nArray[7];
            n11 = nArray[8];
            for (n2 = 0; n2 < nArray.length; ++n2) {
                n12 += nArray[n2];
            }
            if (n12 == 0) {
                n12 = 1;
            }
        }
        if ((n2 = this.roiHeight / 25) < 1) {
            n2 = 1;
        }
        short[] sArray = (short[])this.getPixelsCopy();
        int n13 = this.roiX + this.roiWidth;
        int n14 = this.roiY + this.roiHeight;
        for (int i = this.roiY; i < n14; ++i) {
            int n15 = this.roiX + i * this.width;
            int n16 = n15 - (this.roiX > 0 ? 1 : 0);
            int n17 = n16 - (i > 0 ? this.width : 0);
            int n18 = n16 + (i < this.height - 1 ? this.width : 0);
            int n19 = sArray[n17] & 0xFFFF;
            int n20 = sArray[n16] & 0xFFFF;
            int n21 = sArray[n18] & 0xFFFF;
            if (this.roiX > 0) {
                ++n17;
                ++n16;
                ++n18;
            }
            int n22 = sArray[n17] & 0xFFFF;
            int n23 = sArray[n16] & 0xFFFF;
            int n24 = sArray[n18] & 0xFFFF;
            switch (n) {
                case 0: {
                    int n25;
                    int n26;
                    int n27;
                    int n28 = this.roiX;
                    while (n28 < n13) {
                        if (n28 < this.width - 1) {
                            ++n17;
                            ++n16;
                            ++n18;
                        }
                        n27 = n19;
                        n19 = n22;
                        n22 = sArray[n17] & 0xFFFF;
                        n26 = n20;
                        n20 = n23;
                        n23 = sArray[n16] & 0xFFFF;
                        n25 = n21;
                        n21 = n24;
                        n24 = sArray[n18] & 0xFFFF;
                        this.pixels[n15] = (short)((n27 + n19 + n22 + n26 + n20 + n23 + n25 + n21 + n24 + 4) / 9);
                        ++n28;
                        ++n15;
                    }
                    break;
                }
                case 1: {
                    int n25;
                    int n26;
                    int n27;
                    int n28 = this.roiX;
                    while (n28 < n13) {
                        if (n28 < this.width - 1) {
                            ++n17;
                            ++n16;
                            ++n18;
                        }
                        n27 = n19;
                        n19 = n22;
                        n22 = sArray[n17] & 0xFFFF;
                        n26 = n20;
                        n20 = n23;
                        n25 = n21;
                        double d = n27 + 2 * n19 + n22 - n25 - 2 * (n21 = n24) - (n24 = sArray[n18] & 0xFFFF);
                        n23 = sArray[n16] & 0xFFFF;
                        double d2 = n27 + 2 * n26 + n25 - n22 - 2 * n23 - n24;
                        double d3 = Math.sqrt(d * d + d2 * d2);
                        if (d3 > 65535.0) {
                            d3 = 65535.0;
                        }
                        this.pixels[n15] = (short)d3;
                        ++n28;
                        ++n15;
                    }
                    break;
                }
                case 5: {
                    int n25;
                    int n26;
                    int n27;
                    int n28 = this.roiX;
                    while (n28 < n13) {
                        if (n28 < this.width - 1) {
                            ++n17;
                            ++n16;
                            ++n18;
                        }
                        n27 = n19;
                        n19 = n22;
                        n22 = sArray[n17] & 0xFFFF;
                        n26 = n20;
                        n20 = n23;
                        n23 = sArray[n16] & 0xFFFF;
                        n25 = n21;
                        n21 = n24;
                        n24 = sArray[n18] & 0xFFFF;
                        int n29 = n3 * n27 + n4 * n19 + n5 * n22 + n6 * n26 + n7 * n20 + n8 * n23 + n9 * n25 + n10 * n21 + n11 * n24;
                        if ((n29 = (n29 + n12 / 2) / n12) > 65535) {
                            n29 = 65535;
                        }
                        if (n29 < 0) {
                            n29 = 0;
                        }
                        this.pixels[n15] = (short)n29;
                        ++n28;
                        ++n15;
                    }
                    break;
                }
            }
            if (i % n2 != 0) continue;
            this.showProgress((double)(i - this.roiY) / (double)this.roiHeight);
        }
        this.showProgress(1.0);
    }

    public void rotate(double d) {
        int n;
        short[] sArray = (short[])this.getPixelsCopy();
        ShortProcessor shortProcessor = null;
        if (this.interpolationMethod == 2) {
            shortProcessor = new ShortProcessor(this.getWidth(), this.getHeight(), sArray, null);
        }
        double d2 = (double)this.roiX + (double)(this.roiWidth - 1) / 2.0;
        double d3 = (double)this.roiY + (double)(this.roiHeight - 1) / 2.0;
        int n2 = this.roiX + this.roiWidth - 1;
        double d4 = -d / 57.29577951308232;
        double d5 = Math.cos(d4);
        double d6 = Math.sin(d4);
        double d7 = d3 * d6 - d2 * d5;
        double d8 = -d2 * d6 - d3 * d5;
        double d9 = this.width;
        double d10 = this.height;
        double d11 = (double)this.width - 1.0;
        double d12 = (double)this.width - 1.001;
        double d13 = (double)this.height - 1.0;
        double d14 = (double)this.height - 1.001;
        int n3 = n = this.cTable != null && this.cTable[0] == -32768.0f ? 32768 : 0;
        if (this.interpolationMethod == 2) {
            for (int i = this.roiY; i < this.roiY + this.roiHeight; ++i) {
                int n4 = i * this.width + this.roiX;
                double d15 = d7 - (double)i * d6 + d2;
                double d16 = d8 + (double)i * d5 + d3;
                for (int j = this.roiX; j <= n2; ++j) {
                    double d17 = (double)j * d5 + d15;
                    double d18 = (double)j * d6 + d16;
                    int n5 = (int)(this.getBicubicInterpolatedPixel(d17, d18, shortProcessor) + 0.5);
                    if (n5 < 0) {
                        n5 = 0;
                    }
                    if (n5 > 65535) {
                        n5 = 65535;
                    }
                    this.pixels[n4++] = (short)n5;
                }
                if (i % 30 != 0) continue;
                this.showProgress((double)(i - this.roiY) / (double)this.roiHeight);
            }
        } else {
            for (int i = this.roiY; i < this.roiY + this.roiHeight; ++i) {
                int n6 = i * this.width + this.roiX;
                double d19 = d7 - (double)i * d6 + d2;
                double d20 = d8 + (double)i * d5 + d3;
                for (int j = this.roiX; j <= n2; ++j) {
                    double d21 = (double)j * d5 + d19;
                    double d22 = (double)j * d6 + d20;
                    if (d21 >= -0.01 && d21 < d9 && d22 >= -0.01 && d22 < d10) {
                        if (this.interpolationMethod == 1) {
                            if (d21 < 0.0) {
                                d21 = 0.0;
                            }
                            if (d21 >= d11) {
                                d21 = d12;
                            }
                            if (d22 < 0.0) {
                                d22 = 0.0;
                            }
                            if (d22 >= d13) {
                                d22 = d14;
                            }
                            this.pixels[n6++] = (short)(this.getInterpolatedPixel(d21, d22, sArray) + 0.5);
                            continue;
                        }
                        int n7 = (int)(d21 + 0.5);
                        int n8 = (int)(d22 + 0.5);
                        if (n7 >= this.width) {
                            n7 = this.width - 1;
                        }
                        if (n8 >= this.height) {
                            n8 = this.height - 1;
                        }
                        this.pixels[n6++] = sArray[this.width * n8 + n7];
                        continue;
                    }
                    this.pixels[n6++] = (short)n;
                }
                if (i % 30 != 0) continue;
                this.showProgress((double)(i - this.roiY) / (double)this.roiHeight);
            }
        }
        this.showProgress(1.0);
    }

    public void flipVertical() {
        for (int i = 0; i < this.roiHeight / 2; ++i) {
            int n = (this.roiY + i) * this.width + this.roiX;
            int n2 = (this.roiY + this.roiHeight - 1 - i) * this.width + this.roiX;
            for (int j = 0; j < this.roiWidth; ++j) {
                short s = this.pixels[n];
                this.pixels[n++] = this.pixels[n2];
                this.pixels[n2++] = s;
            }
        }
    }

    public void scale(double d, double d2) {
        int n;
        int n2;
        int n3;
        int n4;
        double d3 = (double)this.roiX + (double)this.roiWidth / 2.0;
        double d4 = (double)this.roiY + (double)this.roiHeight / 2.0;
        if (d > 1.0 && d2 > 1.0) {
            n4 = (int)(d3 - (d3 - (double)this.roiX) * d);
            if (n4 < 0) {
                n4 = 0;
            }
            if ((n3 = n4 + (int)((double)this.roiWidth * d) - 1) >= this.width) {
                n3 = this.width - 1;
            }
            if ((n2 = (int)(d4 - (d4 - (double)this.roiY) * d2)) < 0) {
                n2 = 0;
            }
            if ((n = n2 + (int)((double)this.roiHeight * d2) - 1) >= this.height) {
                n = this.height - 1;
            }
        } else {
            n4 = this.roiX;
            n3 = this.roiX + this.roiWidth - 1;
            n2 = this.roiY;
            n = this.roiY + this.roiHeight - 1;
        }
        short[] sArray = (short[])this.getPixelsCopy();
        ShortProcessor shortProcessor = null;
        if (this.interpolationMethod == 2) {
            shortProcessor = new ShortProcessor(this.getWidth(), this.getHeight(), sArray, null);
        }
        boolean bl = d < 1.0 || d2 < 1.0;
        short s = (short)this.getMin();
        if (this.interpolationMethod == 2) {
            for (int i = n2; i <= n; ++i) {
                double d5 = ((double)i - d4) / d2 + d4;
                int n5 = i * this.width + n4;
                for (int j = n4; j <= n3; ++j) {
                    double d6 = ((double)j - d3) / d + d3;
                    int n6 = (int)(this.getBicubicInterpolatedPixel(d6, d5, shortProcessor) + 0.5);
                    if (n6 < 0) {
                        n6 = 0;
                    }
                    if (n6 > 65535) {
                        n6 = 65535;
                    }
                    this.pixels[n5++] = (short)n6;
                }
                if (i % 30 != 0) continue;
                this.showProgress((double)(i - n2) / (double)this.height);
            }
        } else {
            double d7 = (double)this.width - 1.0;
            double d8 = (double)this.width - 1.001;
            double d9 = (double)this.height - 1.0;
            double d10 = (double)this.height - 1.001;
            for (int i = n2; i <= n; ++i) {
                double d11 = ((double)i - d4) / d2 + d4;
                int n7 = (int)d11;
                if (d11 < 0.0) {
                    d11 = 0.0;
                }
                if (d11 >= d9) {
                    d11 = d10;
                }
                int n8 = i * this.width + n4;
                int n9 = this.width * (int)d11;
                for (int j = n4; j <= n3; ++j) {
                    double d12 = ((double)j - d3) / d + d3;
                    int n10 = (int)d12;
                    if (bl && (n10 < n4 || n10 > n3 || n7 < n2 || n7 > n)) {
                        this.pixels[n8++] = s;
                        continue;
                    }
                    if (this.interpolationMethod == 1) {
                        if (d12 < 0.0) {
                            d12 = 0.0;
                        }
                        if (d12 >= d7) {
                            d12 = d8;
                        }
                        this.pixels[n8++] = (short)(this.getInterpolatedPixel(d12, d11, sArray) + 0.5);
                        continue;
                    }
                    this.pixels[n8++] = sArray[n9 + n10];
                }
                if (i % 30 != 0) continue;
                this.showProgress((double)(i - n2) / (double)this.height);
            }
        }
        this.showProgress(1.0);
    }

    private final double getInterpolatedPixel(double d, double d2, short[] sArray) {
        int n = (int)d;
        int n2 = (int)d2;
        double d3 = d - (double)n;
        double d4 = d2 - (double)n2;
        int n3 = n2 * this.width + n;
        int n4 = sArray[n3] & 0xFFFF;
        int n5 = sArray[n3 + 1] & 0xFFFF;
        int n6 = sArray[n3 + this.width + 1] & 0xFFFF;
        int n7 = sArray[n3 + this.width] & 0xFFFF;
        double d5 = (double)n7 + d3 * (double)(n6 - n7);
        double d6 = (double)n4 + d3 * (double)(n5 - n4);
        return d6 + d4 * (d5 - d6);
    }

    public ImageProcessor resize(int n, int n2) {
        double d = (double)this.roiX + (double)this.roiWidth / 2.0;
        double d2 = (double)this.roiY + (double)this.roiHeight / 2.0;
        double d3 = (double)n / 2.0;
        double d4 = (double)n2 / 2.0;
        double d5 = (double)n / (double)this.roiWidth;
        double d6 = (double)n2 / (double)this.roiHeight;
        if (this.interpolationMethod != 0) {
            d3 += d5 / 2.0;
            d4 += d6 / 2.0;
        }
        ImageProcessor imageProcessor = this.createProcessor(n, n2);
        short[] sArray = (short[])imageProcessor.getPixels();
        if (this.interpolationMethod == 2) {
            for (int i = 0; i <= n2 - 1; ++i) {
                double d7 = ((double)i - d4) / d6 + d2;
                int n3 = i * n;
                for (int j = 0; j <= n - 1; ++j) {
                    double d8 = ((double)j - d3) / d5 + d;
                    int n4 = (int)(this.getBicubicInterpolatedPixel(d8, d7, this) + 0.5);
                    if (n4 < 0) {
                        n4 = 0;
                    }
                    if (n4 > 65535) {
                        n4 = 65535;
                    }
                    sArray[n3++] = (short)n4;
                }
                if (i % 30 != 0) continue;
                this.showProgress((double)i / (double)n2);
            }
        } else {
            double d9 = (double)this.width - 1.0;
            double d10 = (double)this.width - 1.001;
            double d11 = (double)this.height - 1.0;
            double d12 = (double)this.height - 1.001;
            for (int i = 0; i <= n2 - 1; ++i) {
                double d13 = ((double)i - d4) / d6 + d2;
                if (this.interpolationMethod == 1) {
                    if (d13 < 0.0) {
                        d13 = 0.0;
                    }
                    if (d13 >= d11) {
                        d13 = d12;
                    }
                }
                int n5 = this.width * (int)d13;
                int n6 = i * n;
                for (int j = 0; j <= n - 1; ++j) {
                    double d14 = ((double)j - d3) / d5 + d;
                    if (this.interpolationMethod == 1) {
                        if (d14 < 0.0) {
                            d14 = 0.0;
                        }
                        if (d14 >= d9) {
                            d14 = d10;
                        }
                        sArray[n6++] = (short)(this.getInterpolatedPixel(d14, d13, this.pixels) + 0.5);
                        continue;
                    }
                    sArray[n6++] = this.pixels[n5 + (int)d14];
                }
                if (i % 30 != 0) continue;
                this.showProgress((double)i / (double)n2);
            }
        }
        this.showProgress(1.0);
        return imageProcessor;
    }

    public ImageProcessor crop() {
        ImageProcessor imageProcessor = this.createProcessor(this.roiWidth, this.roiHeight);
        short[] sArray = (short[])imageProcessor.getPixels();
        for (int i = this.roiY; i < this.roiY + this.roiHeight; ++i) {
            int n = (i - this.roiY) * this.roiWidth;
            int n2 = i * this.width + this.roiX;
            for (int j = 0; j < this.roiWidth; ++j) {
                sArray[n++] = this.pixels[n2++];
            }
        }
        return imageProcessor;
    }

    public synchronized ImageProcessor duplicate() {
        ImageProcessor imageProcessor = this.createProcessor(this.width, this.height);
        short[] sArray = (short[])imageProcessor.getPixels();
        System.arraycopy(this.pixels, 0, sArray, 0, this.width * this.height);
        return imageProcessor;
    }

    public void setColor(Color color) {
        this.drawingColor = color;
        int n = this.getBestIndex(color);
        if (n > 0 && this.getMin() == 0.0 && this.getMax() == 0.0) {
            this.setValue(n);
            this.setMinAndMax(0.0, 255.0);
        } else if (n == 0 && this.getMin() > 0.0 && (color.getRGB() & 0xFFFFFF) == 0) {
            if (this.cTable != null && this.cTable[0] == -32768.0f) {
                this.setValue(32768.0);
            } else {
                this.setValue(0.0);
            }
        } else {
            this.fgColor = (int)(this.getMin() + (this.getMax() - this.getMin()) * ((double)n / 255.0));
        }
    }

    public void setValue(double d) {
        this.fgColor = (int)d;
        if (this.fgColor < 0) {
            this.fgColor = 0;
        }
        if (this.fgColor > 65535) {
            this.fgColor = 65535;
        }
    }

    public void setBackgroundValue(double d) {
    }

    public double getBackgroundValue() {
        return 0.0;
    }

    public int[] getHistogram() {
        if (this.mask != null) {
            return this.getHistogram(this.mask);
        }
        int[] nArray = new int[65536];
        for (int i = this.roiY; i < this.roiY + this.roiHeight; ++i) {
            int n = i * this.width + this.roiX;
            for (int j = this.roiX; j < this.roiX + this.roiWidth; ++j) {
                int n2 = this.pixels[n++] & 0xFFFF;
                nArray[n2] = nArray[n2] + 1;
            }
        }
        return nArray;
    }

    int[] getHistogram(ImageProcessor imageProcessor) {
        if (imageProcessor.getWidth() != this.roiWidth || imageProcessor.getHeight() != this.roiHeight) {
            throw new IllegalArgumentException(this.maskSizeError(imageProcessor));
        }
        byte[] byArray = (byte[])imageProcessor.getPixels();
        int[] nArray = new int[65536];
        int n = this.roiY;
        int n2 = 0;
        while (n < this.roiY + this.roiHeight) {
            int n3 = n * this.width + this.roiX;
            int n4 = n2 * this.roiWidth;
            for (int i = this.roiX; i < this.roiX + this.roiWidth; ++i) {
                if (byArray[n4++] != 0) {
                    int n5 = this.pixels[n3] & 0xFFFF;
                    nArray[n5] = nArray[n5] + 1;
                }
                ++n3;
            }
            ++n;
            ++n2;
        }
        return nArray;
    }

    public void setThreshold(double d, double d2, int n) {
        if (d == -808080.0) {
            this.resetThreshold();
            return;
        }
        if (d < 0.0) {
            d = 0.0;
        }
        if (d2 > 65535.0) {
            d2 = 65535.0;
        }
        int n2 = (int)this.getMin();
        int n3 = (int)this.getMax();
        if (n3 > n2) {
            double d3;
            double d4 = 256.0 / (double)(n3 - n2 + 1);
            double d5 = d - (double)n2;
            if (d5 < 0.0) {
                d5 = 0.0;
            }
            if ((d5 = (double)((int)(d5 * d4 + 0.5))) > 255.0) {
                d5 = 255.0;
            }
            if ((d3 = d2 - (double)n2) < 0.0) {
                d3 = 0.0;
            }
            if ((d3 = (double)((int)(d3 * d4 + 0.5))) > 255.0) {
                d3 = 255.0;
            }
            super.setThreshold(d5, d3, n);
        } else {
            super.resetThreshold();
        }
        this.minThreshold = Math.round(d);
        this.maxThreshold = Math.round(d2);
    }

    public void convolve(float[] fArray, int n, int n2) {
        ImageProcessor imageProcessor = this.convertToFloat();
        imageProcessor.setRoi(this.getRoi());
        new Convolver().convolve(imageProcessor, fArray, n, n2);
        imageProcessor = imageProcessor.convertToShort(false);
        short[] sArray = (short[])imageProcessor.getPixels();
        System.arraycopy(sArray, 0, this.pixels, 0, this.pixels.length);
    }

    public void noise(double d) {
        Random random = new Random();
        for (int i = this.roiY; i < this.roiY + this.roiHeight; ++i) {
            int n = i * this.width + this.roiX;
            for (int j = this.roiX; j < this.roiX + this.roiWidth; ++j) {
                boolean bl = false;
                do {
                    int n2;
                    int n3;
                    boolean bl2 = bl = (n3 = (this.pixels[n] & 0xFFFF) + (n2 = (int)Math.round(random.nextGaussian() * d))) >= 0 && n3 <= 65535;
                    if (!bl) continue;
                    this.pixels[n] = (short)n3;
                } while (!bl);
                ++n;
            }
        }
        this.resetMinAndMax();
    }

    public void threshold(int n) {
        for (int i = 0; i < this.width * this.height; ++i) {
            this.pixels[i] = (this.pixels[i] & 0xFFFF) <= n ? 0 : 255;
        }
        this.findMinAndMax();
    }

    public FloatProcessor toFloat(int n, FloatProcessor floatProcessor) {
        int n2 = this.width * this.height;
        if (floatProcessor == null || floatProcessor.getWidth() != this.width || floatProcessor.getHeight() != this.height) {
            floatProcessor = new FloatProcessor(this.width, this.height, new float[n2], this.cm);
        }
        float[] fArray = (float[])floatProcessor.getPixels();
        for (int i = 0; i < n2; ++i) {
            fArray[i] = this.pixels[i] & 0xFFFF;
        }
        floatProcessor.setRoi(this.getRoi());
        floatProcessor.setMask(this.mask);
        floatProcessor.setMinAndMax(this.getMin(), this.getMax());
        floatProcessor.setThreshold(this.minThreshold, this.maxThreshold, 2);
        return floatProcessor;
    }

    public void setPixels(int n, FloatProcessor floatProcessor) {
        float[] fArray = (float[])floatProcessor.getPixels();
        int n2 = this.width * this.height;
        for (int i = 0; i < n2; ++i) {
            float f = fArray[i] + 0.5f;
            if (f < 0.0f) {
                f = 0.0f;
            }
            if (f > 65535.0f) {
                f = 65535.0f;
            }
            this.pixels[i] = (short)f;
        }
        this.setMinAndMax(floatProcessor.getMin(), floatProcessor.getMax());
    }

    public double maxValue() {
        return 65535.0;
    }

    public void medianFilter() {
    }

    public void erode() {
    }

    public void dilate() {
    }
}

