/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.measure.Calibration;
import ij.measure.Measurements;
import ij.process.ByteProcessor;
import ij.process.ByteStatistics;
import ij.process.ColorStatistics;
import ij.process.EllipseFitter;
import ij.process.FloatStatistics;
import ij.process.ImageProcessor;
import ij.process.ShortStatistics;
import java.awt.Rectangle;

public class ImageStatistics
implements Measurements {
    public int[] histogram;
    public int pixelCount;
    public long longPixelCount;
    public int mode;
    public double dmode;
    public double area;
    public double min;
    public double max;
    public double mean;
    public double median;
    public double stdDev;
    public double skewness;
    public double kurtosis;
    public double xCentroid;
    public double yCentroid;
    public double xCenterOfMass;
    public double yCenterOfMass;
    public double roiX;
    public double roiY;
    public double roiWidth;
    public double roiHeight;
    public double umean;
    public double major;
    public double minor;
    public double angle;
    public int[] histogram16;
    public double areaFraction;
    public int xstart;
    public int ystart;
    public double histMin;
    public double histMax;
    public int histYMax;
    public int maxCount;
    public int nBins = 256;
    public double binSize = 1.0;
    protected int width;
    protected int height;
    protected int rx;
    protected int ry;
    protected int rw;
    protected int rh;
    protected double pw;
    protected double ph;
    protected Calibration cal;
    EllipseFitter ef;

    public static ImageStatistics getStatistics(ImageProcessor imageProcessor, int n, Calibration calibration) {
        Object object = imageProcessor.getPixels();
        if (object instanceof byte[]) {
            return new ByteStatistics(imageProcessor, n, calibration);
        }
        if (object instanceof short[]) {
            return new ShortStatistics(imageProcessor, n, calibration);
        }
        if (object instanceof int[]) {
            return new ColorStatistics(imageProcessor, n, calibration);
        }
        if (object instanceof float[]) {
            return new FloatStatistics(imageProcessor, n, calibration);
        }
        throw new IllegalArgumentException("Pixels are not byte, short, int or float");
    }

    void getRawMinAndMax(int n, int n2) {
        int n3;
        int n4;
        for (n4 = n; this.histogram[n4] == 0 && n4 < 255; ++n4) {
        }
        this.min = n4;
        for (n3 = n2; this.histogram[n3] == 0 && n3 > 0; --n3) {
        }
        this.max = n3;
    }

    void getRawStatistics(int n, int n2) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = n; i <= n2; ++i) {
            int n3 = this.histogram[i];
            this.longPixelCount += (long)n3;
            d += (double)i * (double)n3;
            double d3 = i;
            d2 += d3 * d3 * (double)n3;
            if (n3 <= this.maxCount) continue;
            this.maxCount = n3;
            this.mode = i;
        }
        this.pixelCount = (int)this.longPixelCount;
        this.area = (double)this.longPixelCount * this.pw * this.ph;
        this.umean = this.mean = d / (double)this.longPixelCount;
        this.dmode = this.mode;
        this.calculateStdDev(this.longPixelCount, d, d2);
        this.histMin = 0.0;
        this.histMax = 255.0;
    }

    void calculateStdDev(double d, double d2, double d3) {
        if (d > 0.0) {
            this.stdDev = (d * d3 - d2 * d2) / d;
            this.stdDev = this.stdDev > 0.0 ? Math.sqrt(this.stdDev / (d - 1.0)) : 0.0;
        } else {
            this.stdDev = 0.0;
        }
    }

    void setup(ImageProcessor imageProcessor, Calibration calibration) {
        this.width = imageProcessor.getWidth();
        this.height = imageProcessor.getHeight();
        this.cal = calibration;
        Rectangle rectangle = imageProcessor.getRoi();
        if (rectangle != null) {
            this.rx = rectangle.x;
            this.ry = rectangle.y;
            this.rw = rectangle.width;
            this.rh = rectangle.height;
        } else {
            this.rx = 0;
            this.ry = 0;
            this.rw = this.width;
            this.rh = this.height;
        }
        if (calibration != null) {
            this.pw = calibration.pixelWidth;
            this.ph = calibration.pixelHeight;
        } else {
            this.pw = 1.0;
            this.ph = 1.0;
        }
        this.roiX = calibration != null ? calibration.getX(this.rx) : (double)this.rx;
        this.roiY = calibration != null ? calibration.getY(this.ry, this.height) : (double)this.ry;
        this.roiWidth = (double)this.rw * this.pw;
        this.roiHeight = (double)this.rh * this.ph;
    }

    void getCentroid(ImageProcessor imageProcessor) {
        byte[] byArray = imageProcessor.getMaskArray();
        int n = 0;
        double d = 0.0;
        double d2 = 0.0;
        int n2 = this.ry;
        int n3 = 0;
        while (n2 < this.ry + this.rh) {
            int n4 = n3 * this.rw;
            for (int i = this.rx; i < this.rx + this.rw; ++i) {
                if (byArray != null && byArray[n4++] == 0) continue;
                ++n;
                d += (double)i;
                d2 += (double)n2;
            }
            ++n2;
            ++n3;
        }
        this.xCentroid = d / (double)n + 0.5;
        this.yCentroid = d2 / (double)n + 0.5;
        if (this.cal != null) {
            this.xCentroid = this.cal.getX(this.xCentroid);
            this.yCentroid = this.cal.getY(this.yCentroid, this.height);
        }
    }

    void fitEllipse(ImageProcessor imageProcessor, int n) {
        boolean bl;
        ImageProcessor imageProcessor2 = null;
        boolean bl2 = bl = (n & 0x100) != 0 && imageProcessor.getMinThreshold() != -808080.0;
        if (bl) {
            ImageProcessor imageProcessor3 = imageProcessor.getMask();
            Rectangle rectangle = imageProcessor.getRoi();
            if (imageProcessor3 == null) {
                imageProcessor3 = new ByteProcessor(rectangle.width, rectangle.height);
                imageProcessor3.invert();
            } else {
                imageProcessor2 = imageProcessor3;
                imageProcessor3 = imageProcessor3.duplicate();
            }
            int n2 = rectangle.width * rectangle.height;
            double d = imageProcessor.getMinThreshold();
            double d2 = imageProcessor.getMaxThreshold();
            for (int i = 0; i < rectangle.height; ++i) {
                for (int j = 0; j < rectangle.width; ++j) {
                    double d3 = imageProcessor.getf(rectangle.x + j, rectangle.y + i);
                    if (!(d3 < d) && !(d3 > d2)) continue;
                    imageProcessor3.setf(j, i, 0.0f);
                }
            }
            imageProcessor.setMask(imageProcessor3);
        }
        if (this.ef == null) {
            this.ef = new EllipseFitter();
        }
        this.ef.fit(imageProcessor, this);
        if (bl) {
            if (imageProcessor2 == null) {
                imageProcessor.setMask(null);
            } else {
                imageProcessor.setMask(imageProcessor2);
            }
        }
        double d = Math.abs(this.pw - this.ph) / this.pw < 0.01 ? this.pw : 0.0;
        this.major = this.ef.major * d;
        this.minor = this.ef.minor * d;
        this.angle = this.ef.angle;
        this.xCentroid = this.ef.xCenter;
        this.yCentroid = this.ef.yCenter;
        if (this.cal != null) {
            this.xCentroid = this.cal.getX(this.xCentroid);
            this.yCentroid = this.cal.getY(this.yCentroid, this.height);
        }
    }

    public void drawEllipse(ImageProcessor imageProcessor) {
        if (this.ef != null) {
            this.ef.drawEllipse(imageProcessor);
        }
    }

    void calculateMedian(int[] nArray, int n, int n2, Calibration calibration) {
        double d = 0.0;
        int n3 = n - 1;
        double d2 = (double)this.pixelCount / 2.0;
        while ((d += (double)nArray[++n3]) <= d2 && n3 < n2) {
        }
        this.median = calibration != null ? calibration.getCValue(n3) : (double)n3;
    }

    void calculateAreaFraction(ImageProcessor imageProcessor, int[] nArray) {
        int n = 0;
        int n2 = 0;
        int n3 = (int)imageProcessor.getMinThreshold();
        int n4 = (int)imageProcessor.getMaxThreshold();
        if ((double)n3 == -808080.0) {
            for (int i = 0; i < nArray.length; ++i) {
                n2 += nArray[i];
            }
            n = n2 - nArray[0];
        } else {
            for (int i = 0; i < nArray.length; ++i) {
                if (i >= n3 && i <= n4) {
                    n += nArray[i];
                }
                n2 += nArray[i];
            }
        }
        this.areaFraction = (double)n * 100.0 / (double)n2;
    }

    public String toString() {
        return "stats[count=" + this.pixelCount + ", mean=" + this.mean + ", min=" + this.min + ", max=" + this.max + "]";
    }
}

