/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.Prefs;
import ij.process.Blitter;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Rectangle;

public class FloatBlitter
implements Blitter {
    public static float divideByZeroValue = (float)Prefs.getDouble("div-by-zero", Double.POSITIVE_INFINITY);
    private FloatProcessor ip;
    private int width;
    private int height;
    private float[] pixels;

    public FloatBlitter(FloatProcessor floatProcessor) {
        this.ip = floatProcessor;
        this.width = floatProcessor.getWidth();
        this.height = floatProcessor.getHeight();
        this.pixels = (float[])floatProcessor.getPixels();
    }

    public void setTransparentColor(Color color) {
    }

    public void copyBits(ImageProcessor imageProcessor, int n, int n2, int n3) {
        if (!(imageProcessor instanceof FloatProcessor)) {
            imageProcessor = imageProcessor.convertToFloat();
        }
        int n4 = imageProcessor.getWidth();
        int n5 = imageProcessor.getHeight();
        Rectangle rectangle = new Rectangle(n4, n5);
        rectangle.setLocation(n, n2);
        Rectangle rectangle2 = new Rectangle(this.width, this.height);
        if (!rectangle.intersects(rectangle2)) {
            return;
        }
        float[] fArray = (float[])imageProcessor.getPixels();
        rectangle = rectangle.intersection(rectangle2);
        int n6 = n < 0 ? -n : 0;
        int n7 = n2 < 0 ? -n2 : 0;
        boolean bl = !Float.isInfinite(divideByZeroValue);
        for (int i = rectangle.y; i < rectangle.y + rectangle.height; ++i) {
            int n8 = (i - n2) * n4 + (rectangle.x - n);
            int n9 = i * this.width + rectangle.x;
            switch (n3) {
                case 0: 
                case 1: 
                case 2: {
                    int n10 = rectangle.width;
                    while (--n10 >= 0) {
                        this.pixels[n9++] = fArray[n8++];
                    }
                    break;
                }
                case 14: {
                    float f;
                    float f2;
                    int n10 = rectangle.width;
                    while (--n10 >= 0) {
                        f = (f2 = fArray[n8++]) == 0.0f ? this.pixels[n9] : f2;
                        this.pixels[n9++] = f;
                    }
                    break;
                }
                case 3: {
                    int n10 = rectangle.width;
                    while (--n10 >= 0) {
                        this.pixels[n9] = fArray[n8] + this.pixels[n9];
                        ++n8;
                        ++n9;
                    }
                    break;
                }
                case 7: {
                    float f;
                    int n10 = rectangle.width;
                    while (--n10 >= 0) {
                        f = (fArray[n8++] + this.pixels[n9]) / 2.0f;
                        this.pixels[n9++] = f;
                    }
                    break;
                }
                case 8: {
                    float f;
                    int n10 = rectangle.width;
                    while (--n10 >= 0) {
                        f = this.pixels[n9] - fArray[n8];
                        this.pixels[n9] = f < 0.0f ? -f : f;
                        ++n8;
                        ++n9;
                    }
                    break;
                }
                case 4: {
                    int n10 = rectangle.width;
                    while (--n10 >= 0) {
                        this.pixels[n9] = this.pixels[n9] - fArray[n8];
                        ++n8;
                        ++n9;
                    }
                    break;
                }
                case 5: {
                    int n10 = rectangle.width;
                    while (--n10 >= 0) {
                        this.pixels[n9] = fArray[n8] * this.pixels[n9];
                        ++n8;
                        ++n9;
                    }
                    break;
                }
                case 6: {
                    float f2;
                    int n10 = rectangle.width;
                    while (--n10 >= 0) {
                        f2 = fArray[n8];
                        this.pixels[n9] = bl && (double)f2 == 0.0 ? divideByZeroValue : this.pixels[n9] / f2;
                        ++n8;
                        ++n9;
                    }
                    break;
                }
                case 9: {
                    float f;
                    int n10 = rectangle.width;
                    while (--n10 >= 0) {
                        f = (int)fArray[n8++] & (int)this.pixels[n9];
                        this.pixels[n9++] = f;
                    }
                    break;
                }
                case 10: {
                    float f;
                    int n10 = rectangle.width;
                    while (--n10 >= 0) {
                        f = (int)fArray[n8++] | (int)this.pixels[n9];
                        this.pixels[n9++] = f;
                    }
                    break;
                }
                case 11: {
                    float f;
                    int n10 = rectangle.width;
                    while (--n10 >= 0) {
                        f = (int)fArray[n8++] ^ (int)this.pixels[n9];
                        this.pixels[n9++] = f;
                    }
                    break;
                }
                case 12: {
                    float f;
                    float f2;
                    int n10 = rectangle.width;
                    while (--n10 >= 0) {
                        int n11 = n8++;
                        f2 = fArray[n11];
                        f = this.pixels[n9];
                        if (f2 < f) {
                            f = f2;
                        }
                        this.pixels[n9++] = f;
                    }
                    break;
                }
                case 13: {
                    float f;
                    float f2;
                    int n10 = rectangle.width;
                    while (--n10 >= 0) {
                        int n12 = n8++;
                        f2 = fArray[n12];
                        f = this.pixels[n9];
                        if (f2 > f) {
                            f = f2;
                        }
                        this.pixels[n9++] = f;
                    }
                    break;
                }
            }
            if (i % 20 != 0) continue;
            imageProcessor.showProgress((double)(i - rectangle.y) / (double)rectangle.height);
        }
        imageProcessor.showProgress(1.0);
    }

    static {
        if (divideByZeroValue == Float.MAX_VALUE) {
            divideByZeroValue = Float.POSITIVE_INFINITY;
        }
    }
}

