/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.IJ;
import ij.ImageStack;
import ij.process.ByteProcessor;
import ij.process.ColorBlitter;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;

public class ColorProcessor
extends ImageProcessor {
    protected int[] pixels;
    protected int[] snapshotPixels = null;
    private int bgColor = -1;
    private int min = 0;
    private int max = 255;
    private WritableRaster rgbRaster;
    private SampleModel rgbSampleModel;
    private static double rWeight = 0.3333333333333333;
    private static double gWeight = 0.3333333333333333;
    private static double bWeight = 0.3333333333333333;
    public static final int RGB_NOISE = 0;
    public static final int RGB_MEDIAN = 1;
    public static final int RGB_FIND_EDGES = 2;
    public static final int RGB_ERODE = 3;
    public static final int RGB_DILATE = 4;
    public static final int RGB_THRESHOLD = 5;
    public static final int RGB_ROTATE = 6;
    public static final int RGB_SCALE = 7;
    public static final int RGB_RESIZE = 8;
    public static final int RGB_TRANSLATE = 9;

    public ColorProcessor(Image image) {
        this.width = image.getWidth(null);
        this.height = image.getHeight(null);
        this.pixels = new int[this.width * this.height];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, this.width, this.height, this.pixels, 0, this.width);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.createColorModel();
        this.fgColor = -16777216;
        this.resetRoi();
    }

    public ColorProcessor(int n, int n2) {
        this(n, n2, new int[n * n2]);
    }

    public ColorProcessor(int n, int n2, int[] nArray) {
        if (nArray != null && n * n2 != nArray.length) {
            throw new IllegalArgumentException("width*height!=pixels.length");
        }
        this.width = n;
        this.height = n2;
        this.createColorModel();
        this.fgColor = -16777216;
        this.resetRoi();
        this.pixels = nArray;
    }

    void createColorModel() {
        this.cm = new DirectColorModel(24, 0xFF0000, 65280, 255);
    }

    public Image createImage() {
        if (IJ.isJava16()) {
            return this.createBufferedImage();
        }
        if (this.source == null) {
            this.source = new MemoryImageSource(this.width, this.height, this.cm, this.pixels, 0, this.width);
            this.source.setAnimated(true);
            this.source.setFullBufferUpdates(true);
            this.img = Toolkit.getDefaultToolkit().createImage(this.source);
        } else if (this.newPixels) {
            this.source.newPixels(this.pixels, this.cm, 0, this.width);
            this.newPixels = false;
        } else {
            this.source.newPixels();
        }
        return this.img;
    }

    Image createBufferedImage() {
        if (this.rgbSampleModel == null) {
            this.rgbSampleModel = this.getRGBSampleModel();
        }
        if (this.rgbRaster == null) {
            DataBufferInt dataBufferInt = new DataBufferInt(this.pixels, this.width * this.height, 0);
            this.rgbRaster = Raster.createWritableRaster(this.rgbSampleModel, dataBufferInt, null);
        }
        if (this.image == null) {
            this.image = new BufferedImage(this.cm, this.rgbRaster, false, null);
        }
        return this.image;
    }

    SampleModel getRGBSampleModel() {
        WritableRaster writableRaster = this.cm.createCompatibleWritableRaster(1, 1);
        SampleModel sampleModel = writableRaster.getSampleModel();
        sampleModel = sampleModel.createCompatibleSampleModel(this.width, this.height);
        return sampleModel;
    }

    public ImageProcessor createProcessor(int n, int n2) {
        ColorProcessor colorProcessor = new ColorProcessor(n, n2);
        colorProcessor.setInterpolationMethod(this.interpolationMethod);
        return colorProcessor;
    }

    public Color getColor(int n, int n2) {
        int n3 = this.pixels[n2 * this.width + n];
        int n4 = (n3 & 0xFF0000) >> 16;
        int n5 = (n3 & 0xFF00) >> 8;
        int n6 = n3 & 0xFF;
        return new Color(n4, n5, n6);
    }

    public void setColor(Color color) {
        this.fgColor = color.getRGB();
        this.drawingColor = color;
    }

    public void setColor(int n) {
        this.fgColor = n;
    }

    public void setValue(double d) {
        this.fgColor = (int)d;
    }

    public void setBackgroundValue(double d) {
        this.bgColor = (int)d;
    }

    public double getBackgroundValue() {
        return this.bgColor;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public void setMinAndMax(double d, double d2) {
        this.setMinAndMax(d, d2, 7);
    }

    public void setMinAndMax(double d, double d2, int n) {
        if (d2 < d) {
            return;
        }
        this.min = (int)d;
        this.max = (int)d2;
        int[] nArray = new int[256];
        for (int i = 0; i < 256; ++i) {
            int n2 = i - this.min;
            if ((n2 = (int)(256.0 * (double)n2 / (d2 - d))) < 0) {
                n2 = 0;
            }
            if (n2 > 255) {
                n2 = 255;
            }
            nArray[i] = n2;
        }
        this.reset();
        if (n == 7) {
            this.applyTable(nArray);
        } else {
            this.applyTable(nArray, n);
        }
    }

    public void snapshot() {
        this.snapshotWidth = this.width;
        this.snapshotHeight = this.height;
        if (this.snapshotPixels == null || this.snapshotPixels != null && this.snapshotPixels.length != this.pixels.length) {
            this.snapshotPixels = new int[this.width * this.height];
        }
        System.arraycopy(this.pixels, 0, this.snapshotPixels, 0, this.width * this.height);
    }

    public void reset() {
        if (this.snapshotPixels == null) {
            return;
        }
        System.arraycopy(this.snapshotPixels, 0, this.pixels, 0, this.width * this.height);
    }

    public void reset(ImageProcessor imageProcessor) {
        if (imageProcessor == null || this.snapshotPixels == null) {
            return;
        }
        if (imageProcessor.getWidth() != this.roiWidth || imageProcessor.getHeight() != this.roiHeight) {
            throw new IllegalArgumentException(this.maskSizeError(imageProcessor));
        }
        byte[] byArray = (byte[])imageProcessor.getPixels();
        int n = this.roiY;
        int n2 = 0;
        while (n < this.roiY + this.roiHeight) {
            int n3 = n * this.width + this.roiX;
            int n4 = n2 * this.roiWidth;
            for (int i = this.roiX; i < this.roiX + this.roiWidth; ++i) {
                if (byArray[n4++] == 0) {
                    this.pixels[n3] = this.snapshotPixels[n3];
                }
                ++n3;
            }
            ++n;
            ++n2;
        }
    }

    public void swapPixelArrays() {
        if (this.snapshotPixels == null) {
            return;
        }
        for (int i = 0; i < this.pixels.length; ++i) {
            int n = this.pixels[i];
            this.pixels[i] = this.snapshotPixels[i];
            this.snapshotPixels[i] = n;
        }
    }

    public void setSnapshotPixels(Object object) {
        this.snapshotPixels = (int[])object;
        this.snapshotWidth = this.width;
        this.snapshotHeight = this.height;
    }

    public Object getSnapshotPixels() {
        return this.snapshotPixels;
    }

    public void fill(ImageProcessor imageProcessor) {
        if (imageProcessor == null) {
            this.fill();
            return;
        }
        int n = this.roiWidth;
        int n2 = this.roiHeight;
        int n3 = this.roiX;
        int n4 = this.roiY;
        if (imageProcessor.getWidth() != n || imageProcessor.getHeight() != n2) {
            return;
        }
        byte[] byArray = (byte[])imageProcessor.getPixels();
        int n5 = n4;
        int n6 = 0;
        while (n5 < n4 + n2) {
            int n7 = n5 * this.width + n3;
            int n8 = n6 * n;
            for (int i = n3; i < n3 + n; ++i) {
                if (byArray[n8++] != 0) {
                    this.pixels[n7] = this.fgColor;
                }
                ++n7;
            }
            ++n5;
            ++n6;
        }
    }

    public Object getPixelsCopy() {
        if (this.snapshotPixels != null && this.snapshotCopyMode) {
            this.snapshotCopyMode = false;
            return this.snapshotPixels;
        }
        int[] nArray = new int[this.width * this.height];
        System.arraycopy(this.pixels, 0, nArray, 0, this.width * this.height);
        return nArray;
    }

    public int getPixel(int n, int n2) {
        if (n >= 0 && n < this.width && n2 >= 0 && n2 < this.height) {
            return this.pixels[n2 * this.width + n];
        }
        return 0;
    }

    public final int get(int n, int n2) {
        return this.pixels[n2 * this.width + n];
    }

    public final void set(int n, int n2, int n3) {
        this.pixels[n2 * this.width + n] = n3;
    }

    public final int get(int n) {
        return this.pixels[n];
    }

    public final void set(int n, int n2) {
        this.pixels[n] = n2;
    }

    public final float getf(int n, int n2) {
        return this.getf(n2 * this.width + n);
    }

    public final void setf(int n, int n2, float f) {
        this.pixels[n2 * this.width + n] = (int)f;
    }

    public final float getf(int n) {
        int n2 = this.pixels[n];
        int n3 = (n2 & 0xFF0000) >> 16;
        int n4 = (n2 & 0xFF00) >> 8;
        int n5 = n2 & 0xFF;
        return (float)((double)n3 * rWeight + (double)n4 * gWeight + (double)n5 * bWeight);
    }

    public final void setf(int n, float f) {
        this.pixels[n] = (int)f;
    }

    public int[] getPixel(int n, int n2, int[] nArray) {
        if (nArray == null) {
            nArray = new int[3];
        }
        int n3 = this.getPixel(n, n2);
        nArray[0] = (n3 & 0xFF0000) >> 16;
        nArray[1] = (n3 & 0xFF00) >> 8;
        nArray[2] = n3 & 0xFF;
        return nArray;
    }

    public final void putPixel(int n, int n2, int[] nArray) {
        int n3 = nArray[0];
        int n4 = nArray[1];
        int n5 = nArray[2];
        this.putPixel(n, n2, (n3 << 16) + (n4 << 8) + n5);
    }

    public double getInterpolatedPixel(double d, double d2) {
        int n = (int)(d + 0.5);
        int n2 = (int)(d2 + 0.5);
        if (n < 0) {
            n = 0;
        }
        if (n >= this.width) {
            n = this.width - 1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 >= this.height) {
            n2 = this.height - 1;
        }
        return this.getPixelValue(n, n2);
    }

    public final int getPixelInterpolated(double d, double d2) {
        if (d < 0.0 || d2 < 0.0 || d >= (double)(this.width - 1) || d2 >= (double)(this.height - 1)) {
            return 0;
        }
        return this.getInterpolatedPixel(d, d2, this.pixels);
    }

    public final void putPixel(int n, int n2, int n3) {
        if (n >= 0 && n < this.width && n2 >= 0 && n2 < this.height) {
            this.pixels[n2 * this.width + n] = n3;
        }
    }

    public void putPixelValue(int n, int n2, double d) {
        if (n >= 0 && n < this.width && n2 >= 0 && n2 < this.height) {
            if (d > 255.0) {
                d = 255.0;
            } else if (d < 0.0) {
                d = 0.0;
            }
            int n3 = (int)(d + 0.5);
            this.pixels[n2 * this.width + n] = -16777216 + (n3 << 16) + (n3 << 8) + n3;
        }
    }

    public float getPixelValue(int n, int n2) {
        if (n >= 0 && n < this.width && n2 >= 0 && n2 < this.height) {
            int n3 = this.pixels[n2 * this.width + n];
            int n4 = (n3 & 0xFF0000) >> 16;
            int n5 = (n3 & 0xFF00) >> 8;
            int n6 = n3 & 0xFF;
            return (float)((double)n4 * rWeight + (double)n5 * gWeight + (double)n6 * bWeight);
        }
        return 0.0f;
    }

    public void drawPixel(int n, int n2) {
        if (n >= this.clipXMin && n <= this.clipXMax && n2 >= this.clipYMin && n2 <= this.clipYMax) {
            this.pixels[n2 * this.width + n] = this.fgColor;
        }
    }

    public Object getPixels() {
        return this.pixels;
    }

    public void setPixels(Object object) {
        this.pixels = (int[])object;
        this.resetPixels(object);
        if (object == null) {
            this.snapshotPixels = null;
        }
        this.rgbRaster = null;
        this.image = null;
    }

    public void getHSB(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        float[] fArray = new float[3];
        for (int i = 0; i < this.width * this.height; ++i) {
            int n = this.pixels[i];
            int n2 = (n & 0xFF0000) >> 16;
            int n3 = (n & 0xFF00) >> 8;
            int n4 = n & 0xFF;
            fArray = Color.RGBtoHSB(n2, n3, n4, fArray);
            byArray[i] = (byte)((double)fArray[0] * 255.0);
            byArray2[i] = (byte)((double)fArray[1] * 255.0);
            byArray3[i] = (byte)((double)fArray[2] * 255.0);
        }
    }

    public ImageStack getHSBStack() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        byte[] byArray = new byte[n * n2];
        byte[] byArray2 = new byte[n * n2];
        byte[] byArray3 = new byte[n * n2];
        this.getHSB(byArray, byArray2, byArray3);
        IndexColorModel indexColorModel = this.getDefaultColorModel();
        ImageStack imageStack = new ImageStack(n, n2, indexColorModel);
        imageStack.addSlice("Hue", byArray);
        imageStack.addSlice("Saturation", byArray2);
        imageStack.addSlice("Brightness", byArray3);
        return imageStack;
    }

    public FloatProcessor getBrightness() {
        int n = this.width * this.height;
        float[] fArray = new float[n];
        float[] fArray2 = new float[3];
        for (int i = 0; i < n; ++i) {
            int n2 = this.pixels[i];
            int n3 = (n2 & 0xFF0000) >> 16;
            int n4 = (n2 & 0xFF00) >> 8;
            int n5 = n2 & 0xFF;
            fArray2 = Color.RGBtoHSB(n3, n4, n5, fArray2);
            fArray[i] = fArray2[2];
        }
        return new FloatProcessor(this.width, this.height, fArray, null);
    }

    public void getRGB(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        for (int i = 0; i < this.width * this.height; ++i) {
            int n = this.pixels[i];
            int n2 = (n & 0xFF0000) >> 16;
            int n3 = (n & 0xFF00) >> 8;
            int n4 = n & 0xFF;
            byArray[i] = (byte)n2;
            byArray2[i] = (byte)n3;
            byArray3[i] = (byte)n4;
        }
    }

    public void setRGB(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        for (int i = 0; i < this.width * this.height; ++i) {
            this.pixels[i] = 0xFF000000 | (byArray[i] & 0xFF) << 16 | (byArray2[i] & 0xFF) << 8 | byArray3[i] & 0xFF;
        }
    }

    public void setHSB(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        for (int i = 0; i < this.width * this.height; ++i) {
            float f = (float)((double)(byArray[i] & 0xFF) / 255.0);
            float f2 = (float)((double)(byArray2[i] & 0xFF) / 255.0);
            float f3 = (float)((double)(byArray3[i] & 0xFF) / 255.0);
            this.pixels[i] = Color.HSBtoRGB(f, f2, f3);
        }
    }

    public void setBrightness(FloatProcessor floatProcessor) {
        int n = this.width * this.height;
        float[] fArray = new float[3];
        float[] fArray2 = (float[])floatProcessor.getPixels();
        if (fArray2.length != n) {
            throw new IllegalArgumentException("fp is wrong size");
        }
        for (int i = 0; i < n; ++i) {
            int n2 = this.pixels[i];
            int n3 = (n2 & 0xFF0000) >> 16;
            int n4 = (n2 & 0xFF00) >> 8;
            int n5 = n2 & 0xFF;
            fArray = Color.RGBtoHSB(n3, n4, n5, fArray);
            float f = fArray2[i];
            if (f < 0.0f) {
                f = 0.0f;
            }
            if (f > 1.0f) {
                f = 1.0f;
            }
            this.pixels[i] = Color.HSBtoRGB(fArray[0], fArray[1], f);
        }
    }

    public void copyBits(ImageProcessor imageProcessor, int n, int n2, int n3) {
        imageProcessor = imageProcessor.convertToRGB();
        new ColorBlitter(this).copyBits(imageProcessor, n, n2, n3);
    }

    public void applyTable(int[] nArray) {
        for (int i = this.roiY; i < this.roiY + this.roiHeight; ++i) {
            int n = i * this.width + this.roiX;
            for (int j = this.roiX; j < this.roiX + this.roiWidth; ++j) {
                int n2 = this.pixels[n];
                int n3 = nArray[(n2 & 0xFF0000) >> 16];
                int n4 = nArray[(n2 & 0xFF00) >> 8];
                int n5 = nArray[n2 & 0xFF];
                this.pixels[n] = -16777216 + (n3 << 16) + (n4 << 8) + n5;
                ++n;
            }
        }
        this.showProgress(1.0);
    }

    public void applyTable(int[] nArray, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (int i = this.roiY; i < this.roiY + this.roiHeight; ++i) {
            int n5 = i * this.width + this.roiX;
            for (int j = this.roiX; j < this.roiX + this.roiWidth; ++j) {
                int n6 = this.pixels[n5];
                if (n == 4) {
                    n2 = nArray[(n6 & 0xFF0000) >> 16];
                    n3 = (n6 & 0xFF00) >> 8;
                    n4 = n6 & 0xFF;
                } else if (n == 2) {
                    n2 = (n6 & 0xFF0000) >> 16;
                    n3 = nArray[(n6 & 0xFF00) >> 8];
                    n4 = n6 & 0xFF;
                } else if (n == 1) {
                    n2 = (n6 & 0xFF0000) >> 16;
                    n3 = (n6 & 0xFF00) >> 8;
                    n4 = nArray[n6 & 0xFF];
                } else if ((n & 6) == 6) {
                    n2 = nArray[(n6 & 0xFF0000) >> 16];
                    n3 = nArray[(n6 & 0xFF00) >> 8];
                    n4 = n6 & 0xFF;
                } else if ((n & 5) == 5) {
                    n2 = nArray[(n6 & 0xFF0000) >> 16];
                    n3 = (n6 & 0xFF00) >> 8;
                    n4 = nArray[n6 & 0xFF];
                } else if ((n & 3) == 3) {
                    n2 = (n6 & 0xFF0000) >> 16;
                    n3 = nArray[(n6 & 0xFF00) >> 8];
                    n4 = nArray[n6 & 0xFF];
                }
                this.pixels[n5] = -16777216 + (n2 << 16) + (n3 << 8) + n4;
                ++n5;
            }
        }
        this.showProgress(1.0);
    }

    public void fill() {
        for (int i = this.roiY; i < this.roiY + this.roiHeight; ++i) {
            int n = i * this.width + this.roiX;
            for (int j = this.roiX; j < this.roiX + this.roiWidth; ++j) {
                this.pixels[n++] = this.fgColor;
            }
            if (i % 20 != 0) continue;
            this.showProgress((double)(i - this.roiY) / (double)this.roiHeight);
        }
        this.showProgress(1.0);
    }

    public void filterRGB(int n, double d) {
        this.filterRGB(n, d, 0.0);
    }

    final ImageProcessor filterRGB(int n, double d, double d2) {
        this.showProgress(0.01);
        byte[] byArray = new byte[this.width * this.height];
        byte[] byArray2 = new byte[this.width * this.height];
        byte[] byArray3 = new byte[this.width * this.height];
        this.getRGB(byArray, byArray2, byArray3);
        Rectangle rectangle = new Rectangle(this.roiX, this.roiY, this.roiWidth, this.roiHeight);
        ByteProcessor byteProcessor = new ByteProcessor(this.width, this.height, byArray, null);
        byteProcessor.setRoi(rectangle);
        ByteProcessor byteProcessor2 = new ByteProcessor(this.width, this.height, byArray2, null);
        byteProcessor2.setRoi(rectangle);
        ByteProcessor byteProcessor3 = new ByteProcessor(this.width, this.height, byArray3, null);
        byteProcessor3.setRoi(rectangle);
        byteProcessor.setBackgroundValue((this.bgColor & 0xFF0000) >> 16);
        byteProcessor2.setBackgroundValue((this.bgColor & 0xFF00) >> 8);
        byteProcessor3.setBackgroundValue(this.bgColor & 0xFF);
        byteProcessor.setInterpolationMethod(this.interpolationMethod);
        byteProcessor2.setInterpolationMethod(this.interpolationMethod);
        byteProcessor3.setInterpolationMethod(this.interpolationMethod);
        this.showProgress(0.15);
        switch (n) {
            case 0: {
                byteProcessor.noise(d);
                this.showProgress(0.4);
                byteProcessor2.noise(d);
                this.showProgress(0.65);
                byteProcessor3.noise(d);
                this.showProgress(0.9);
                break;
            }
            case 1: {
                byteProcessor.medianFilter();
                this.showProgress(0.4);
                byteProcessor2.medianFilter();
                this.showProgress(0.65);
                byteProcessor3.medianFilter();
                this.showProgress(0.9);
                break;
            }
            case 2: {
                byteProcessor.findEdges();
                this.showProgress(0.4);
                byteProcessor2.findEdges();
                this.showProgress(0.65);
                byteProcessor3.findEdges();
                this.showProgress(0.9);
                break;
            }
            case 3: {
                byteProcessor.erode();
                this.showProgress(0.4);
                byteProcessor2.erode();
                this.showProgress(0.65);
                byteProcessor3.erode();
                this.showProgress(0.9);
                break;
            }
            case 4: {
                byteProcessor.dilate();
                this.showProgress(0.4);
                byteProcessor2.dilate();
                this.showProgress(0.65);
                byteProcessor3.dilate();
                this.showProgress(0.9);
                break;
            }
            case 5: {
                byteProcessor.autoThreshold();
                this.showProgress(0.4);
                byteProcessor2.autoThreshold();
                this.showProgress(0.65);
                byteProcessor3.autoThreshold();
                this.showProgress(0.9);
                break;
            }
            case 6: {
                IJ.showStatus("Rotating red");
                byteProcessor.rotate(d);
                this.showProgress(0.4);
                IJ.showStatus("Rotating green");
                byteProcessor2.rotate(d);
                this.showProgress(0.65);
                IJ.showStatus("Rotating blue");
                byteProcessor3.rotate(d);
                this.showProgress(0.9);
                break;
            }
            case 7: {
                IJ.showStatus("Scaling red");
                byteProcessor.scale(d, d2);
                this.showProgress(0.4);
                IJ.showStatus("Scaling green");
                byteProcessor2.scale(d, d2);
                this.showProgress(0.65);
                IJ.showStatus("Scaling blue");
                byteProcessor3.scale(d, d2);
                this.showProgress(0.9);
                break;
            }
            case 8: {
                int n2 = (int)d;
                int n3 = (int)d2;
                IJ.showStatus("Resizing red");
                ImageProcessor imageProcessor = byteProcessor.resize(n2, n3);
                this.showProgress(0.4);
                IJ.showStatus("Resizing green");
                ImageProcessor imageProcessor2 = byteProcessor2.resize(n2, n3);
                this.showProgress(0.65);
                IJ.showStatus("Resizing blue");
                ImageProcessor imageProcessor3 = byteProcessor3.resize(n2, n3);
                this.showProgress(0.9);
                byArray = (byte[])imageProcessor.getPixels();
                byArray2 = (byte[])imageProcessor2.getPixels();
                byArray3 = (byte[])imageProcessor3.getPixels();
                ColorProcessor colorProcessor = new ColorProcessor(n2, n3);
                colorProcessor.setRGB(byArray, byArray2, byArray3);
                this.showProgress(1.0);
                return colorProcessor;
            }
            case 9: {
                IJ.showStatus("Translating red");
                byteProcessor.translate(d, d2);
                this.showProgress(0.4);
                IJ.showStatus("Translating green");
                byteProcessor2.translate(d, d2);
                this.showProgress(0.65);
                IJ.showStatus("Translating blue");
                byteProcessor3.translate(d, d2);
                this.showProgress(0.9);
            }
        }
        byArray = (byte[])byteProcessor.getPixels();
        byArray2 = (byte[])byteProcessor2.getPixels();
        byArray3 = (byte[])byteProcessor3.getPixels();
        this.setRGB(byArray, byArray2, byArray3);
        this.showProgress(1.0);
        return null;
    }

    public void noise(double d) {
        this.filterRGB(0, d);
    }

    public void medianFilter() {
        this.filterRGB(1, 0.0);
    }

    public void findEdges() {
        this.filterRGB(2, 0.0);
    }

    public void erode() {
        this.filterRGB(3, 0.0);
    }

    public void dilate() {
        this.filterRGB(4, 0.0);
    }

    public void autoThreshold() {
        this.filterRGB(5, 0.0);
    }

    public void scale(double d, double d2) {
        int n;
        int n2;
        int n3;
        int n4;
        if (this.interpolationMethod == 2) {
            this.filterRGB(7, d, d2);
            return;
        }
        double d3 = (double)this.roiX + (double)this.roiWidth / 2.0;
        double d4 = (double)this.roiY + (double)this.roiHeight / 2.0;
        if (d > 1.0 && d2 > 1.0) {
            n4 = (int)(d3 - (d3 - (double)this.roiX) * d);
            if (n4 < 0) {
                n4 = 0;
            }
            if ((n3 = n4 + (int)((double)this.roiWidth * d) - 1) >= this.width) {
                n3 = this.width - 1;
            }
            if ((n2 = (int)(d4 - (d4 - (double)this.roiY) * d2)) < 0) {
                n2 = 0;
            }
            if ((n = n2 + (int)((double)this.roiHeight * d2) - 1) >= this.height) {
                n = this.height - 1;
            }
        } else {
            n4 = this.roiX;
            n3 = this.roiX + this.roiWidth - 1;
            n2 = this.roiY;
            n = this.roiY + this.roiHeight - 1;
        }
        int[] nArray = (int[])this.getPixelsCopy();
        boolean bl = d < 1.0 || d2 < 1.0;
        double d5 = (double)this.width - 1.0;
        double d6 = (double)this.width - 1.001;
        double d7 = (double)this.height - 1.0;
        double d8 = (double)this.height - 1.001;
        for (int i = n2; i <= n; ++i) {
            double d9 = ((double)i - d4) / d2 + d4;
            int n5 = (int)d9;
            if (d9 < 0.0) {
                d9 = 0.0;
            }
            if (d9 >= d7) {
                d9 = d8;
            }
            int n6 = i * this.width + n4;
            int n7 = this.width * (int)d9;
            for (int j = n4; j <= n3; ++j) {
                double d10 = ((double)j - d3) / d + d3;
                int n8 = (int)d10;
                if (bl && (n8 < n4 || n8 > n3 || n5 < n2 || n5 > n)) {
                    this.pixels[n6++] = this.bgColor;
                    continue;
                }
                if (this.interpolationMethod == 1) {
                    if (d10 < 0.0) {
                        d10 = 0.0;
                    }
                    if (d10 >= d5) {
                        d10 = d6;
                    }
                    this.pixels[n6++] = this.getInterpolatedPixel(d10, d9, nArray);
                    continue;
                }
                this.pixels[n6++] = nArray[n7 + n8];
            }
            if (i % 20 != 0) continue;
            this.showProgress((double)(i - n2) / (double)this.height);
        }
        this.showProgress(1.0);
    }

    public ImageProcessor crop() {
        int[] nArray = new int[this.roiWidth * this.roiHeight];
        for (int i = this.roiY; i < this.roiY + this.roiHeight; ++i) {
            int n = (i - this.roiY) * this.roiWidth;
            int n2 = i * this.width + this.roiX;
            for (int j = 0; j < this.roiWidth; ++j) {
                nArray[n++] = this.pixels[n2++];
            }
        }
        return new ColorProcessor(this.roiWidth, this.roiHeight, nArray);
    }

    public synchronized ImageProcessor duplicate() {
        int[] nArray = new int[this.width * this.height];
        System.arraycopy(this.pixels, 0, nArray, 0, this.width * this.height);
        return new ColorProcessor(this.width, this.height, nArray);
    }

    public int getInterpolatedRGBPixel(double d, double d2) {
        if (this.width == 1 || this.height == 1) {
            return this.getPixel((int)d, (int)d2);
        }
        if (d < 0.0) {
            d = 0.0;
        }
        if (d >= (double)this.width - 1.0) {
            d = (double)this.width - 1.001;
        }
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        if (d2 >= (double)this.height - 1.0) {
            d2 = (double)this.height - 1.001;
        }
        return this.getInterpolatedPixel(d, d2, this.pixels);
    }

    private final int getInterpolatedPixel(double d, double d2, int[] nArray) {
        int n = (int)d;
        int n2 = (int)d2;
        double d3 = d - (double)n;
        double d4 = d2 - (double)n2;
        int n3 = n2 * this.width + n;
        int n4 = nArray[n3];
        int n5 = (n4 & 0xFF0000) >> 16;
        int n6 = (n4 & 0xFF00) >> 8;
        int n7 = n4 & 0xFF;
        int n8 = nArray[n3 + 1];
        int n9 = (n8 & 0xFF0000) >> 16;
        int n10 = (n8 & 0xFF00) >> 8;
        int n11 = n8 & 0xFF;
        int n12 = nArray[n3 + this.width + 1];
        int n13 = (n12 & 0xFF0000) >> 16;
        int n14 = (n12 & 0xFF00) >> 8;
        int n15 = n12 & 0xFF;
        int n16 = nArray[n3 + this.width];
        int n17 = (n16 & 0xFF0000) >> 16;
        int n18 = (n16 & 0xFF00) >> 8;
        int n19 = n16 & 0xFF;
        double d5 = (double)n17 + d3 * (double)(n13 - n17);
        double d6 = (double)n5 + d3 * (double)(n9 - n5);
        int n20 = (int)(d6 + d4 * (d5 - d6) + 0.5);
        d5 = (double)n18 + d3 * (double)(n14 - n18);
        d6 = (double)n6 + d3 * (double)(n10 - n6);
        int n21 = (int)(d6 + d4 * (d5 - d6) + 0.5);
        d5 = (double)n19 + d3 * (double)(n15 - n19);
        d6 = (double)n7 + d3 * (double)(n11 - n7);
        int n22 = (int)(d6 + d4 * (d5 - d6) + 0.5);
        return 0xFF000000 | (n20 & 0xFF) << 16 | (n21 & 0xFF) << 8 | n22 & 0xFF;
    }

    public ImageProcessor resize(int n, int n2) {
        if (this.interpolationMethod == 2) {
            return this.filterRGB(8, n, n2);
        }
        double d = (double)this.roiX + (double)this.roiWidth / 2.0;
        double d2 = (double)this.roiY + (double)this.roiHeight / 2.0;
        double d3 = (double)n / 2.0;
        double d4 = (double)n2 / 2.0;
        double d5 = (double)n / (double)this.roiWidth;
        double d6 = (double)n2 / (double)this.roiHeight;
        double d7 = (double)this.width - 1.0;
        double d8 = (double)this.width - 1.001;
        double d9 = (double)this.height - 1.0;
        double d10 = (double)this.height - 1.001;
        if (this.interpolationMethod == 1) {
            d3 += d5 / 2.0;
            d4 += d6 / 2.0;
        }
        ImageProcessor imageProcessor = this.createProcessor(n, n2);
        int[] nArray = (int[])imageProcessor.getPixels();
        for (int i = 0; i <= n2 - 1; ++i) {
            double d11 = ((double)i - d4) / d6 + d2;
            if (this.interpolationMethod == 1) {
                if (d11 < 0.0) {
                    d11 = 0.0;
                }
                if (d11 >= d9) {
                    d11 = d10;
                }
            }
            int n3 = this.width * (int)d11;
            int n4 = i * n;
            for (int j = 0; j <= n - 1; ++j) {
                double d12 = ((double)j - d3) / d5 + d;
                if (this.interpolationMethod == 1) {
                    if (d12 < 0.0) {
                        d12 = 0.0;
                    }
                    if (d12 >= d7) {
                        d12 = d8;
                    }
                    nArray[n4++] = this.getInterpolatedPixel(d12, d11, this.pixels);
                    continue;
                }
                nArray[n4++] = this.pixels[n3 + (int)d12];
            }
            if (i % 20 != 0) continue;
            this.showProgress((double)i / (double)n2);
        }
        this.showProgress(1.0);
        return imageProcessor;
    }

    public ImageProcessor makeThumbnail(int n, int n2, double d) {
        return this.resize(n, n2, true);
    }

    public void rotate(double d) {
        if (d % 360.0 == 0.0) {
            return;
        }
        if (this.interpolationMethod == 2) {
            this.filterRGB(6, d);
            return;
        }
        int[] nArray = (int[])this.getPixelsCopy();
        double d2 = (double)this.roiX + (double)(this.roiWidth - 1) / 2.0;
        double d3 = (double)this.roiY + (double)(this.roiHeight - 1) / 2.0;
        int n = this.roiX + this.roiWidth - 1;
        double d4 = -d / 57.29577951308232;
        double d5 = Math.cos(d4);
        double d6 = Math.sin(d4);
        double d7 = d3 * d6 - d2 * d5;
        double d8 = -d2 * d6 - d3 * d5;
        double d9 = this.width;
        double d10 = this.height;
        double d11 = (double)this.width - 1.0;
        double d12 = (double)this.width - 1.001;
        double d13 = (double)this.height - 1.0;
        double d14 = (double)this.height - 1.001;
        for (int i = this.roiY; i < this.roiY + this.roiHeight; ++i) {
            int n2 = i * this.width + this.roiX;
            double d15 = d7 - (double)i * d6 + d2;
            double d16 = d8 + (double)i * d5 + d3;
            for (int j = this.roiX; j <= n; ++j) {
                double d17 = (double)j * d5 + d15;
                double d18 = (double)j * d6 + d16;
                if (d17 >= -0.01 && d17 < d9 && d18 >= -0.01 && d18 < d10) {
                    if (this.interpolationMethod == 1) {
                        if (d17 < 0.0) {
                            d17 = 0.0;
                        }
                        if (d17 >= d11) {
                            d17 = d12;
                        }
                        if (d18 < 0.0) {
                            d18 = 0.0;
                        }
                        if (d18 >= d13) {
                            d18 = d14;
                        }
                        this.pixels[n2++] = this.getInterpolatedPixel(d17, d18, nArray);
                        continue;
                    }
                    int n3 = (int)(d17 + 0.5);
                    int n4 = (int)(d18 + 0.5);
                    if (n3 >= this.width) {
                        n3 = this.width - 1;
                    }
                    if (n4 >= this.height) {
                        n4 = this.height - 1;
                    }
                    this.pixels[n2++] = nArray[this.width * n4 + n3];
                    continue;
                }
                this.pixels[n2++] = this.bgColor;
            }
            if (i % 30 != 0) continue;
            this.showProgress((double)(i - this.roiY) / (double)this.roiHeight);
        }
        this.showProgress(1.0);
    }

    public void flipVertical() {
        for (int i = 0; i < this.roiHeight / 2; ++i) {
            int n = (this.roiY + i) * this.width + this.roiX;
            int n2 = (this.roiY + this.roiHeight - 1 - i) * this.width + this.roiX;
            for (int j = 0; j < this.roiWidth; ++j) {
                int n3 = this.pixels[n];
                this.pixels[n++] = this.pixels[n2];
                this.pixels[n2++] = n3;
            }
        }
    }

    public void convolve3x3(int[] nArray) {
        int n;
        int n2 = nArray[0];
        int n3 = nArray[1];
        int n4 = nArray[2];
        int n5 = nArray[3];
        int n6 = nArray[4];
        int n7 = nArray[5];
        int n8 = nArray[6];
        int n9 = nArray[7];
        int n10 = nArray[8];
        int n11 = 0;
        for (n = 0; n < nArray.length; ++n) {
            n11 += nArray[n];
        }
        if (n11 == 0) {
            n11 = 1;
        }
        if ((n = this.roiHeight / 25) < 1) {
            n = 1;
        }
        int[] nArray2 = (int[])this.getPixelsCopy();
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = this.width;
        for (int i = this.yMin; i <= this.yMax; ++i) {
            int n16 = this.xMin + i * this.width;
            int n17 = 0;
            int n18 = nArray2[n16 - n15 - 1];
            int n19 = nArray2[n16 - n15];
            int n20 = 0;
            int n21 = nArray2[n16 - 1];
            int n22 = nArray2[n16];
            int n23 = 0;
            int n24 = nArray2[n16 + n15 - 1];
            int n25 = nArray2[n16 + n15];
            for (int j = this.xMin; j <= this.xMax; ++j) {
                n17 = n18;
                n18 = n19;
                n19 = nArray2[n16 - n15 + 1];
                n20 = n21;
                n21 = n22;
                n22 = nArray2[n16 + 1];
                n23 = n24;
                n24 = n25;
                n25 = nArray2[n16 + n15 + 1];
                n12 = n2 * ((n17 & 0xFF0000) >> 16) + n3 * ((n18 & 0xFF0000) >> 16) + n4 * ((n19 & 0xFF0000) >> 16) + n5 * ((n20 & 0xFF0000) >> 16) + n6 * ((n21 & 0xFF0000) >> 16) + n7 * ((n22 & 0xFF0000) >> 16) + n8 * ((n23 & 0xFF0000) >> 16) + n9 * ((n24 & 0xFF0000) >> 16) + n10 * ((n25 & 0xFF0000) >> 16);
                if ((n12 /= n11) > 255) {
                    n12 = 255;
                }
                if (n12 < 0) {
                    n12 = 0;
                }
                n13 = n2 * ((n17 & 0xFF00) >> 8) + n3 * ((n18 & 0xFF00) >> 8) + n4 * ((n19 & 0xFF00) >> 8) + n5 * ((n20 & 0xFF00) >> 8) + n6 * ((n21 & 0xFF00) >> 8) + n7 * ((n22 & 0xFF00) >> 8) + n8 * ((n23 & 0xFF00) >> 8) + n9 * ((n24 & 0xFF00) >> 8) + n10 * ((n25 & 0xFF00) >> 8);
                if ((n13 /= n11) > 255) {
                    n13 = 255;
                } else if (n13 < 0) {
                    n13 = 0;
                }
                n14 = n2 * (n17 & 0xFF) + n3 * (n18 & 0xFF) + n4 * (n19 & 0xFF) + n5 * (n20 & 0xFF) + n6 * (n21 & 0xFF) + n7 * (n22 & 0xFF) + n8 * (n23 & 0xFF) + n9 * (n24 & 0xFF) + n10 * (n25 & 0xFF);
                if ((n14 /= n11) > 255) {
                    n14 = 255;
                }
                if (n14 < 0) {
                    n14 = 0;
                }
                this.pixels[n16++] = 0xFF000000 | n12 << 16 & 0xFF0000 | n13 << 8 & 0xFF00 | n14 & 0xFF;
            }
            if (i % n != 0) continue;
            this.showProgress((double)(i - this.roiY) / (double)this.roiHeight);
        }
        this.showProgress(1.0);
    }

    public void filter(int n) {
        int n2 = this.roiHeight / 25;
        if (n2 < 1) {
            n2 = 1;
        }
        int[] nArray = (int[])this.getPixelsCopy();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = this.width;
        for (int i = this.yMin; i <= this.yMax; ++i) {
            int n7 = this.xMin + i * this.width;
            int n8 = 0;
            int n9 = nArray[n7 - n6 - 1];
            int n10 = nArray[n7 - n6];
            int n11 = 0;
            int n12 = nArray[n7 - 1];
            int n13 = nArray[n7];
            int n14 = 0;
            int n15 = nArray[n7 + n6 - 1];
            int n16 = nArray[n7 + n6];
            for (int j = this.xMin; j <= this.xMax; ++j) {
                n8 = n9;
                n9 = n10;
                n10 = nArray[n7 - n6 + 1];
                n11 = n12;
                n12 = n13;
                n13 = nArray[n7 + 1];
                n14 = n15;
                n15 = n16;
                n16 = nArray[n7 + n6 + 1];
                n3 = (n8 & 0xFF0000) + (n9 & 0xFF0000) + (n10 & 0xFF0000) + (n11 & 0xFF0000) + (n12 & 0xFF0000) + (n13 & 0xFF0000) + (n14 & 0xFF0000) + (n15 & 0xFF0000) + (n16 & 0xFF0000);
                n4 = (n8 & 0xFF00) + (n9 & 0xFF00) + (n10 & 0xFF00) + (n11 & 0xFF00) + (n12 & 0xFF00) + (n13 & 0xFF00) + (n14 & 0xFF00) + (n15 & 0xFF00) + (n16 & 0xFF00);
                n5 = (n8 & 0xFF) + (n9 & 0xFF) + (n10 & 0xFF) + (n11 & 0xFF) + (n12 & 0xFF) + (n13 & 0xFF) + (n14 & 0xFF) + (n15 & 0xFF) + (n16 & 0xFF);
                this.pixels[n7++] = 0xFF000000 | n3 / 9 & 0xFF0000 | n4 / 9 & 0xFF00 | n5 / 9;
            }
            if (i % n2 != 0) continue;
            this.showProgress((double)(i - this.roiY) / (double)this.roiHeight);
        }
        this.showProgress(1.0);
    }

    public int[] getHistogram() {
        if (this.mask != null) {
            return this.getHistogram(this.mask);
        }
        int[] nArray = new int[256];
        for (int i = this.roiY; i < this.roiY + this.roiHeight; ++i) {
            int n = i * this.width + this.roiX;
            for (int j = this.roiX; j < this.roiX + this.roiWidth; ++j) {
                int n2;
                int n3 = this.pixels[n++];
                int n4 = (n3 & 0xFF0000) >> 16;
                int n5 = (n3 & 0xFF00) >> 8;
                int n6 = n3 & 0xFF;
                int n7 = n2 = (int)((double)n4 * rWeight + (double)n5 * gWeight + (double)n6 * bWeight + 0.5);
                nArray[n7] = nArray[n7] + 1;
            }
            if (i % 20 != 0) continue;
            this.showProgress((double)(i - this.roiY) / (double)this.roiHeight);
        }
        this.showProgress(1.0);
        return nArray;
    }

    public int[] getHistogram(ImageProcessor imageProcessor) {
        if (imageProcessor.getWidth() != this.roiWidth || imageProcessor.getHeight() != this.roiHeight) {
            throw new IllegalArgumentException(this.maskSizeError(imageProcessor));
        }
        byte[] byArray = (byte[])imageProcessor.getPixels();
        int[] nArray = new int[256];
        int n = this.roiY;
        int n2 = 0;
        while (n < this.roiY + this.roiHeight) {
            int n3 = n * this.width + this.roiX;
            int n4 = n2 * this.roiWidth;
            for (int i = this.roiX; i < this.roiX + this.roiWidth; ++i) {
                if (byArray[n4++] != 0) {
                    int n5;
                    int n6 = this.pixels[n3];
                    int n7 = (n6 & 0xFF0000) >> 16;
                    int n8 = (n6 & 0xFF00) >> 8;
                    int n9 = n6 & 0xFF;
                    int n10 = n5 = (int)((double)n7 * rWeight + (double)n8 * gWeight + (double)n9 * bWeight + 0.5);
                    nArray[n10] = nArray[n10] + 1;
                }
                ++n3;
            }
            if (n % 20 == 0) {
                this.showProgress((double)(n - this.roiY) / (double)this.roiHeight);
            }
            ++n;
            ++n2;
        }
        this.showProgress(1.0);
        return nArray;
    }

    public void convolve(float[] fArray, int n, int n2) {
        int n3 = this.width * this.height;
        byte[] byArray = new byte[n3];
        byte[] byArray2 = new byte[n3];
        byte[] byArray3 = new byte[n3];
        this.getRGB(byArray, byArray2, byArray3);
        ByteProcessor byteProcessor = new ByteProcessor(this.width, this.height, byArray, null);
        ByteProcessor byteProcessor2 = new ByteProcessor(this.width, this.height, byArray2, null);
        ByteProcessor byteProcessor3 = new ByteProcessor(this.width, this.height, byArray3, null);
        ImageProcessor imageProcessor = byteProcessor.convertToFloat();
        Rectangle rectangle = this.getRoi();
        imageProcessor.setRoi(rectangle);
        imageProcessor.convolve(fArray, n, n2);
        ImageProcessor imageProcessor2 = imageProcessor.convertToByte(false);
        imageProcessor = byteProcessor2.convertToFloat();
        imageProcessor.setRoi(rectangle);
        imageProcessor.convolve(fArray, n, n2);
        ImageProcessor imageProcessor3 = imageProcessor.convertToByte(false);
        imageProcessor = byteProcessor3.convertToFloat();
        imageProcessor.setRoi(rectangle);
        imageProcessor.convolve(fArray, n, n2);
        ImageProcessor imageProcessor4 = imageProcessor.convertToByte(false);
        this.setRGB((byte[])imageProcessor2.getPixels(), (byte[])imageProcessor3.getPixels(), (byte[])imageProcessor4.getPixels());
    }

    public static void setWeightingFactors(double d, double d2, double d3) {
        rWeight = d;
        gWeight = d2;
        bWeight = d3;
    }

    public static double[] getWeightingFactors() {
        double[] dArray = new double[]{rWeight, gWeight, bWeight};
        return dArray;
    }

    public boolean isInvertedLut() {
        return false;
    }

    public int getBestIndex(Color color) {
        return 0;
    }

    public void invertLut() {
    }

    public void updateComposite(int[] nArray, int n) {
    }

    public void threshold(int n) {
    }

    public int getNChannels() {
        return 3;
    }

    public FloatProcessor toFloat(int n, FloatProcessor floatProcessor) {
        int n2 = this.width * this.height;
        if (floatProcessor == null || floatProcessor.getWidth() != this.width || floatProcessor.getHeight() != this.height) {
            floatProcessor = new FloatProcessor(this.width, this.height, new float[n2], null);
        }
        float[] fArray = (float[])floatProcessor.getPixels();
        int n3 = 16 - 8 * n;
        int n4 = 255 << n3;
        for (int i = 0; i < n2; ++i) {
            fArray[i] = (this.pixels[i] & n4) >> n3;
        }
        floatProcessor.setRoi(this.getRoi());
        floatProcessor.setMask(this.mask);
        floatProcessor.setMinAndMax(0.0, 255.0);
        return floatProcessor;
    }

    public void setPixels(int n, FloatProcessor floatProcessor) {
        float[] fArray = (float[])floatProcessor.getPixels();
        int n2 = this.width * this.height;
        int n3 = 16 - 8 * n;
        int n4 = 0xFFFFFFFF ^ 255 << n3;
        for (int i = 0; i < n2; ++i) {
            float f = fArray[i] + 0.5f;
            if (f < 0.0f) {
                f = 0.0f;
            }
            if (f > 255.0f) {
                f = 255.0f;
            }
            this.pixels[i] = this.pixels[i] & n4 | (int)f << n3;
        }
    }
}

