/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.process.Blitter;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Rectangle;

public class ByteBlitter
implements Blitter {
    private ByteProcessor ip;
    private int width;
    private int height;
    private byte[] pixels;
    private int transparent = 255;

    public ByteBlitter(ByteProcessor byteProcessor) {
        this.ip = byteProcessor;
        this.width = byteProcessor.getWidth();
        this.height = byteProcessor.getHeight();
        this.pixels = (byte[])byteProcessor.getPixels();
    }

    public void setTransparentColor(Color color) {
        this.transparent = this.ip.getBestIndex(color);
    }

    public void copyBits(ImageProcessor imageProcessor, int n, int n2, int n3) {
        int n4;
        byte[] byArray;
        int n5;
        int n6 = imageProcessor.getWidth();
        int n7 = imageProcessor.getHeight();
        Rectangle rectangle = new Rectangle(n6, n7);
        rectangle.setLocation(n, n2);
        Rectangle rectangle2 = new Rectangle(this.width, this.height);
        if (!rectangle.intersects(rectangle2)) {
            return;
        }
        if (imageProcessor instanceof ColorProcessor) {
            int[] nArray = (int[])imageProcessor.getPixels();
            n5 = imageProcessor.getWidth() * imageProcessor.getHeight();
            byArray = new byte[n5];
            if (this.ip.isInvertedLut()) {
                for (n4 = 0; n4 < n5; ++n4) {
                    byArray[n4] = (byte)(255 - nArray[n4] & 0xFF);
                }
            } else {
                for (n4 = 0; n4 < n5; ++n4) {
                    byArray[n4] = (byte)(nArray[n4] & 0xFF);
                }
            }
        } else {
            imageProcessor = imageProcessor.convertToByte(true);
            byArray = (byte[])imageProcessor.getPixels();
        }
        rectangle = rectangle.intersection(rectangle2);
        int n8 = n < 0 ? -n : 0;
        int n9 = n2 < 0 ? -n2 : 0;
        for (n4 = rectangle.y; n4 < rectangle.y + rectangle.height; ++n4) {
            int n10 = (n4 - n2) * n6 + (rectangle.x - n);
            int n11 = n4 * this.width + rectangle.x;
            switch (n3) {
                case 0: {
                    int n12 = rectangle.width;
                    while (--n12 >= 0) {
                        this.pixels[n11++] = byArray[n10++];
                    }
                    break;
                }
                case 1: {
                    int n12 = rectangle.width;
                    while (--n12 >= 0) {
                        this.pixels[n11++] = (byte)(255 - byArray[n10++] & 0xFF);
                    }
                    break;
                }
                case 2: {
                    int n12 = rectangle.width;
                    while (--n12 >= 0) {
                        int n13;
                        n5 = (n13 = byArray[n10++] & 0xFF) == this.transparent ? this.pixels[n11] : n13;
                        this.pixels[n11++] = (byte)n5;
                    }
                    break;
                }
                case 14: {
                    int n12 = rectangle.width;
                    while (--n12 >= 0) {
                        int n14;
                        n5 = (n14 = byArray[n10++] & 0xFF) == 0 ? this.pixels[n11] : n14;
                        this.pixels[n11++] = (byte)n5;
                    }
                    break;
                }
                case 3: {
                    int n12 = rectangle.width;
                    while (--n12 >= 0) {
                        if ((n5 = (byArray[n10++] & 0xFF) + (this.pixels[n11] & 0xFF)) > 255) {
                            n5 = 255;
                        }
                        this.pixels[n11++] = (byte)n5;
                    }
                    break;
                }
                case 7: {
                    int n12 = rectangle.width;
                    while (--n12 >= 0) {
                        n5 = ((byArray[n10++] & 0xFF) + (this.pixels[n11] & 0xFF)) / 2;
                        this.pixels[n11++] = (byte)n5;
                    }
                    break;
                }
                case 4: {
                    int n12 = rectangle.width;
                    while (--n12 >= 0) {
                        if ((n5 = (this.pixels[n11] & 0xFF) - (byArray[n10++] & 0xFF)) < 0) {
                            n5 = 0;
                        }
                        this.pixels[n11++] = (byte)n5;
                    }
                    break;
                }
                case 8: {
                    int n12 = rectangle.width;
                    while (--n12 >= 0) {
                        if ((n5 = (this.pixels[n11] & 0xFF) - (byArray[n10++] & 0xFF)) < 0) {
                            n5 = -n5;
                        }
                        this.pixels[n11++] = (byte)n5;
                    }
                    break;
                }
                case 5: {
                    int n12 = rectangle.width;
                    while (--n12 >= 0) {
                        if ((n5 = (byArray[n10++] & 0xFF) * (this.pixels[n11] & 0xFF)) > 255) {
                            n5 = 255;
                        }
                        this.pixels[n11++] = (byte)n5;
                    }
                    break;
                }
                case 6: {
                    int n12 = rectangle.width;
                    while (--n12 >= 0) {
                        int n15;
                        n5 = (n15 = byArray[n10++] & 0xFF) == 0 ? 255 : (this.pixels[n11] & 0xFF) / n15;
                        this.pixels[n11++] = (byte)n5;
                    }
                    break;
                }
                case 9: {
                    int n12 = rectangle.width;
                    while (--n12 >= 0) {
                        n5 = byArray[n10++] & this.pixels[n11];
                        this.pixels[n11++] = (byte)n5;
                    }
                    break;
                }
                case 10: {
                    int n12 = rectangle.width;
                    while (--n12 >= 0) {
                        n5 = byArray[n10++] | this.pixels[n11];
                        this.pixels[n11++] = (byte)n5;
                    }
                    break;
                }
                case 11: {
                    int n12 = rectangle.width;
                    while (--n12 >= 0) {
                        n5 = byArray[n10++] ^ this.pixels[n11];
                        this.pixels[n11++] = (byte)n5;
                    }
                    break;
                }
                case 12: {
                    int n12 = rectangle.width;
                    while (--n12 >= 0) {
                        int n16;
                        n5 = this.pixels[n11] & 0xFF;
                        if ((n16 = byArray[n10++] & 0xFF) < n5) {
                            n5 = n16;
                        }
                        this.pixels[n11++] = (byte)n5;
                    }
                    break;
                }
                case 13: {
                    int n12 = rectangle.width;
                    while (--n12 >= 0) {
                        int n17;
                        n5 = this.pixels[n11] & 0xFF;
                        if ((n17 = byArray[n10++] & 0xFF) > n5) {
                            n5 = n17;
                        }
                        this.pixels[n11++] = (byte)n5;
                    }
                    break;
                }
            }
            if (n4 % 20 != 0) continue;
            imageProcessor.showProgress((double)(n4 - rectangle.y) / (double)rectangle.height);
        }
        imageProcessor.hideProgress();
    }
}

