/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.process.ByteProcessor;
import java.awt.Color;

public class BinaryProcessor
extends ByteProcessor {
    static int[] table = new int[]{0, 0, 0, 1, 0, 0, 1, 3, 0, 0, 3, 1, 1, 0, 1, 3, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 2, 0, 3, 0, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 3, 0, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 2, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 3, 0, 2, 0, 0, 0, 3, 1, 0, 0, 1, 3, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 3, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 3, 1, 3, 0, 0, 1, 3, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 3, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 0, 1, 0, 0, 0, 0, 2, 2, 0, 0, 2, 0, 0, 0};
    private ByteProcessor parent;
    static final int OUTLINE = 0;

    public BinaryProcessor(ByteProcessor byteProcessor) {
        super(byteProcessor.getWidth(), byteProcessor.getHeight(), (byte[])byteProcessor.getPixels(), byteProcessor.getColorModel());
        this.setRoi(byteProcessor.getRoi());
        this.parent = byteProcessor;
    }

    void process(int n, int n2) {
        int n3 = this.roiHeight / 25;
        if (n3 < 1) {
            n3 = 1;
        }
        int n4 = 255;
        if (this.parent.isInvertedLut()) {
            n4 = 0;
        }
        byte[] byArray = (byte[])this.parent.getPixelsCopy();
        int n5 = 0;
        int n6 = this.width;
        for (int i = this.yMin; i <= this.yMax; ++i) {
            int n7 = this.xMin + i * this.width;
            int n8 = byArray[n7 - n6 - 1] & 0xFF;
            int n9 = byArray[n7 - n6] & 0xFF;
            int n10 = byArray[n7 - 1] & 0xFF;
            int n11 = byArray[n7] & 0xFF;
            int n12 = byArray[n7 + n6 - 1] & 0xFF;
            int n13 = byArray[n7 + n6] & 0xFF;
            for (int j = this.xMin; j <= this.xMax; ++j) {
                int n14 = n8;
                n8 = n9;
                n9 = byArray[n7 - n6 + 1] & 0xFF;
                int n15 = n10;
                n10 = n11;
                n11 = byArray[n7 + 1] & 0xFF;
                int n16 = n12;
                n12 = n13;
                n13 = byArray[n7 + n6 + 1] & 0xFF;
                switch (n) {
                    case 0: {
                        n5 = n10;
                        if (n5 == n4 || n14 == n4 || n8 == n4 || n9 == n4 || n15 == n4 || n11 == n4 || n16 == n4 || n12 == n4 || n13 == n4) break;
                        n5 = n4;
                    }
                }
                this.pixels[n7++] = (byte)n5;
            }
            if (i % n3 != 0) continue;
            this.parent.showProgress((double)(i - this.roiY) / (double)this.roiHeight);
        }
        this.parent.hideProgress();
    }

    public void skeletonize() {
        int n;
        int n2 = 0;
        this.resetRoi();
        this.setColor(Color.white);
        this.moveTo(0, 0);
        this.lineTo(0, this.height - 1);
        this.moveTo(0, 0);
        this.lineTo(this.width - 1, 0);
        this.moveTo(this.width - 1, 0);
        this.lineTo(this.width - 1, this.height - 1);
        this.moveTo(0, this.height - 1);
        this.lineTo(this.width, this.height - 1);
        ImageStack imageStack = null;
        boolean bl = IJ.debugMode;
        if (bl) {
            imageStack = new ImageStack(this.width, this.height);
        }
        do {
            this.snapshot();
            if (bl) {
                imageStack.addSlice("" + n2, this.duplicate());
            }
            n = this.thin(n2++, table);
            this.snapshot();
            if (!bl) continue;
            imageStack.addSlice("" + n2, this.duplicate());
        } while ((n = this.thin(n2++, table)) > 0);
        if (bl) {
            new ImagePlus("Skel Movie", imageStack).show();
        }
    }

    int thin(int n, int[] nArray) {
        int n2 = this.roiHeight / 25;
        if (n2 < 1) {
            n2 = 1;
        }
        int n3 = 255;
        if (this.parent.isInvertedLut()) {
            n3 = 0;
        }
        byte[] byArray = (byte[])this.getPixelsCopy();
        int n4 = this.width;
        int n5 = 0;
        int n6 = 100;
        for (int i = this.yMin; i <= this.yMax; ++i) {
            int n7 = this.xMin + i * this.width;
            for (int j = this.xMin; j <= this.xMax; ++j) {
                int n8 = byArray[n7] & 0xFF;
                int n9 = n8;
                if (n9 != n3) {
                    int n10 = byArray[n7 - n4 - 1] & 0xFF;
                    int n11 = byArray[n7 - n4] & 0xFF;
                    int n12 = byArray[n7 - n4 + 1] & 0xFF;
                    int n13 = byArray[n7 - 1] & 0xFF;
                    int n14 = byArray[n7 + 1] & 0xFF;
                    int n15 = byArray[n7 + n4 - 1] & 0xFF;
                    int n16 = byArray[n7 + n4] & 0xFF;
                    int n17 = byArray[n7 + n4 + 1] & 0xFF;
                    int n18 = 0;
                    if (n10 != n3) {
                        n18 |= 1;
                    }
                    if (n11 != n3) {
                        n18 |= 2;
                    }
                    if (n12 != n3) {
                        n18 |= 4;
                    }
                    if (n14 != n3) {
                        n18 |= 8;
                    }
                    if (n17 != n3) {
                        n18 |= 0x10;
                    }
                    if (n16 != n3) {
                        n18 |= 0x20;
                    }
                    if (n15 != n3) {
                        n18 |= 0x40;
                    }
                    if (n13 != n3) {
                        n18 |= 0x80;
                    }
                    int n19 = nArray[n18];
                    if ((n & 1) == 1) {
                        if (n19 == 2 || n19 == 3) {
                            n9 = n3;
                            ++n5;
                        }
                    } else if (n19 == 1 || n19 == 3) {
                        n9 = n3;
                        ++n5;
                    }
                }
                this.pixels[n7++] = (byte)n9;
            }
            if (i % n2 != 0) continue;
            this.showProgress((double)(i - this.roiY) / (double)this.roiHeight);
        }
        this.hideProgress();
        return n5;
    }

    public void outline() {
        this.process(0, 0);
    }
}

