/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.IJ;
import ij.ImageListener;
import ij.ImagePlus;
import ij.Macro;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.Roi;
import ij.gui.TextRoi;
import ij.measure.CurveFitter;
import ij.plugin.NewPlugin;
import ij.plugin.PlugIn;
import ij.plugin.frame.Editor;
import ij.plugin.frame.PlugInFrame;
import ij.util.Tools;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Polygon;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.StringTokenizer;

public class Recorder
extends PlugInFrame
implements PlugIn,
ActionListener,
ImageListener,
ItemListener {
    public static boolean record;
    public static boolean recordInMacros;
    private static final int MACRO = 0;
    private static final int JAVASCRIPT = 1;
    private static final int PLUGIN = 2;
    private static final String[] modes;
    private Choice mode;
    private Button makeMacro;
    private Button help;
    private TextField fileName;
    private String fitTypeStr = CurveFitter.fitList[0];
    private static TextArea textArea;
    private static Recorder instance;
    private static String commandName;
    private static String commandOptions;
    private static String defaultName;
    private static boolean recordPath;
    private static boolean scriptMode;
    private static boolean imageUpdated;
    private static int imageID;

    public Recorder() {
        super("Recorder");
        if (instance != null) {
            WindowManager.toFront(instance);
            return;
        }
        WindowManager.addWindow(this);
        instance = this;
        record = true;
        scriptMode = false;
        recordInMacros = false;
        Panel panel = new Panel(new FlowLayout(0, 0, 0));
        panel.add(new Label("  Record:"));
        this.mode = new Choice();
        for (int i = 0; i < modes.length; ++i) {
            this.mode.addItem(modes[i]);
        }
        this.mode.addItemListener(this);
        this.mode.select(Prefs.get("recorder.mode", modes[0]));
        panel.add(this.mode);
        panel.add(new Label("    Name:"));
        this.fileName = new TextField(defaultName, 15);
        this.setFileName();
        panel.add(this.fileName);
        panel.add(new Label("   "));
        this.makeMacro = new Button("Create");
        this.makeMacro.addActionListener(this);
        panel.add(this.makeMacro);
        panel.add(new Label("   "));
        this.help = new Button("?");
        this.help.addActionListener(this);
        panel.add(this.help);
        this.add("North", panel);
        textArea = new TextArea("", 15, 80, 1);
        textArea.setFont(new Font("Monospaced", 0, 12));
        if (IJ.isLinux()) {
            textArea.setBackground(Color.white);
        }
        this.add("Center", textArea);
        this.pack();
        GUI.center(this);
        this.show();
        IJ.register(Recorder.class);
    }

    public static void record(String string) {
        if (textArea == null) {
            return;
        }
        textArea.append(string + "();\n");
    }

    public static void setCommand(String string) {
        boolean bl = Thread.currentThread().getName().startsWith("Run$_");
        if (textArea == null || bl && !recordInMacros) {
            return;
        }
        commandName = string;
        commandOptions = null;
        recordPath = true;
        imageUpdated = false;
        imageID = 0;
        if (scriptMode) {
            ImagePlus imagePlus = WindowManager.getCurrentImage();
            int n = imageID = imagePlus != null ? imagePlus.getID() : 0;
            if (imageID != 0) {
                ImagePlus.addImageListener(instance);
            }
        }
    }

    public static String getCommand() {
        return commandName;
    }

    static String fixPath(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            stringBuffer.append(c);
            if (c != '\\') continue;
            stringBuffer.append("\\");
        }
        return new String(stringBuffer);
    }

    public static void record(String string, String string2) {
        if (IJ.debugMode) {
            IJ.log("record: " + string + "  " + string2);
        }
        boolean bl = string.equals("selectWindow");
        if (!(textArea == null || scriptMode && bl || commandName != null && bl)) {
            if (scriptMode && string.equals("roiManager")) {
                textArea.append("rm.runCommand(\"" + string2 + "\");\n");
            } else {
                if (string.equals("setTool")) {
                    string = "//" + (scriptMode ? "IJ." : "") + string;
                }
                textArea.append(string + "(\"" + string2 + "\");\n");
            }
        }
    }

    public static void record(String string, String string2, String string3) {
        if (textArea == null) {
            return;
        }
        if (string2.equals("Open") || string2.equals("Save") || string.equals("saveAs")) {
            string3 = Recorder.fixPath(string3);
        }
        if (scriptMode && string.equals("roiManager")) {
            textArea.append("rm.runCommand(\"" + string2 + "\", \"" + string3 + "\");\n");
        } else {
            if (scriptMode && string.equals("saveAs")) {
                string = "IJ." + string;
            }
            textArea.append(string + "(\"" + string2 + "\", \"" + string3 + "\");\n");
        }
    }

    public static void record(String string, String string2, String string3, String string4) {
        if (textArea == null) {
            return;
        }
        textArea.append(string + "(\"" + string2 + "\", \"" + string3 + "\",\"" + string4 + "\");\n");
    }

    public static void record(String string, int n) {
        if (textArea == null) {
            return;
        }
        textArea.append(string + "(" + n + ");\n");
    }

    public static void record(String string, int n, int n2) {
        if (textArea == null) {
            return;
        }
        textArea.append(string + "(" + n + ", " + n2 + ");\n");
    }

    public static void record(String string, double d, double d2) {
        if (textArea == null) {
            return;
        }
        int n = Math.abs(d) < 1.0E-4 || Math.abs(d2) < 1.0E-4 ? 9 : 4;
        textArea.append(string + "(" + IJ.d2s(d, n) + ", " + IJ.d2s(d2, n) + ");\n");
    }

    public static void record(String string, int n, int n2, int n3) {
        if (textArea == null) {
            return;
        }
        if (scriptMode && string.endsWith("groundColor")) {
            string = "IJ." + string;
        }
        textArea.append(string + "(" + n + ", " + n2 + ", " + n3 + ");\n");
    }

    public static void record(String string, String string2, int n) {
        textArea.append(string + "(\"" + string2 + "\", " + n + ");\n");
    }

    public static void record(String string, String string2, int n, int n2) {
        if (textArea == null) {
            return;
        }
        string = "//" + string;
        textArea.append(string + "(\"" + string2 + "\", " + n + ", " + n2 + ");\n");
    }

    public static void record(String string, int n, int n2, int n3, int n4) {
        if (textArea == null) {
            return;
        }
        if (scriptMode && string.startsWith("make")) {
            if (string.equals("makeRectangle")) {
                Recorder.recordString("imp.setRoi(" + n + ", " + n2 + ", " + n3 + ", " + n4 + ");\n");
            } else if (string.equals("makeOval")) {
                Recorder.recordString("imp.setRoi(new OvalRoi(" + n + ", " + n2 + ", " + n3 + ", " + n4 + "));\n");
            } else if (string.equals("makeLine")) {
                Recorder.recordString("imp.setRoi(new Line(" + n + ", " + n2 + ", " + n3 + ", " + n4 + "));\n");
            }
        } else {
            textArea.append(string + "(" + n + ", " + n2 + ", " + n3 + ", " + n4 + ");\n");
        }
    }

    public static void record(String string, int n, int n2, int n3, int n4, int n5) {
        textArea.append(string + "(" + n + ", " + n2 + ", " + n3 + ", " + n4 + ", " + n5 + ");\n");
    }

    public static void record(String string, int n, int n2, int n3, int n4, double d) {
        textArea.append(string + "(" + n + ", " + n2 + ", " + n3 + ", " + n4 + ", " + IJ.d2s(d, 2) + ");\n");
    }

    public static void record(String string, String string2, String string3, int n, int n2, int n3, int n4, int n5) {
        if (textArea == null) {
            return;
        }
        string2 = Recorder.fixPath(string2);
        string = "//" + string;
        textArea.append(string + "(\"" + string2 + "\", " + "\"" + string3 + "\", " + n + ", " + n2 + ", " + n3 + ", " + n4 + ", " + n5 + ");\n");
    }

    public static void recordString(String string) {
        if (textArea != null) {
            textArea.append(string);
        }
    }

    public static void recordCall(String string) {
        if (IJ.debugMode) {
            IJ.log("recordCall: " + string + "  " + commandName);
        }
        if (textArea != null && scriptMode && !IJ.macroRunning()) {
            textArea.append(string + "\n");
            commandName = null;
        }
    }

    public static void recordRoi(Polygon polygon, int n) {
        if (textArea == null) {
            return;
        }
        if (scriptMode) {
            Recorder.recordScriptRoi(polygon, n);
            return;
        }
        if (n == 8 || n == 10) {
            String string = "newArray(";
            String string2 = "newArray(";
            string = string + polygon.xpoints[0] + ",";
            string2 = string2 + polygon.ypoints[0] + ",";
            string = string + polygon.xpoints[1] + ",";
            string2 = string2 + polygon.ypoints[1] + ",";
            string = string + polygon.xpoints[2] + ")";
            string2 = string2 + polygon.ypoints[2] + ")";
            String string3 = n == 8 ? "angle" : "point";
            textArea.append("makeSelection(\"" + string3 + "\"," + string + "," + string2 + ");\n");
        } else {
            String string = n == 2 ? "makePolygon" : "makeLine";
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < polygon.npoints; ++i) {
                stringBuffer.append(polygon.xpoints[i] + ",");
                stringBuffer.append("" + polygon.ypoints[i]);
                if (i == polygon.npoints - 1) continue;
                stringBuffer.append(",");
            }
            textArea.append(string + "(" + stringBuffer.toString() + ");\n");
        }
    }

    public static void recordScriptRoi(Polygon polygon, int n) {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < polygon.npoints; ++i) {
            stringBuffer.append(polygon.xpoints[i]);
            if (i == polygon.npoints - 1) continue;
            stringBuffer.append(",");
        }
        String string = stringBuffer.toString();
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i = 0; i < polygon.npoints; ++i) {
            stringBuffer2.append(polygon.ypoints[i]);
            if (i == polygon.npoints - 1) continue;
            stringBuffer2.append(",");
        }
        String string2 = stringBuffer2.toString();
        boolean bl2 = bl = instance != null && Recorder.instance.mode.getSelectedItem().equals(modes[2]);
        if (bl) {
            textArea.append("int[] xpoints = {" + string + "};\n");
            textArea.append("int[] ypoints = {" + string2 + "};\n");
        } else {
            textArea.append("xpoints = [" + string + "];\n");
            textArea.append("ypoints = [" + string2 + "];\n");
        }
        String string3 = "POLYGON";
        switch (n) {
            case 6: {
                string3 = "POLYLINE";
                break;
            }
            case 8: {
                string3 = "ANGLE";
            }
        }
        string3 = "Roi." + string3;
        if (n == 10) {
            textArea.append("imp.setRoi(new PointRoi(xpoints,ypoints," + polygon.npoints + "));\n");
        } else {
            textArea.append("imp.setRoi(new PolygonRoi(xpoints,ypoints," + polygon.npoints + "," + string3 + "));\n");
        }
    }

    public static void recordOption(String string, String string2) {
        if (string == null) {
            return;
        }
        string = Recorder.trimKey(string);
        string2 = Recorder.addQuotes(string2);
        Recorder.checkForDuplicate(string + "=", string2);
        commandOptions = commandOptions == null ? string + "=" + string2 : commandOptions + " " + string + "=" + string2;
    }

    public static void recordPath(String string, String string2) {
        if (string == null || !recordPath) {
            recordPath = true;
            return;
        }
        string = Recorder.trimKey(string);
        string2 = Recorder.fixPath(string2);
        string2 = Recorder.addQuotes(string2);
        Recorder.checkForDuplicate(string + "=", string2);
        commandOptions = commandOptions == null ? string + "=" + string2 : commandOptions + " " + string + "=" + string2;
    }

    public static void recordOption(String string) {
        if (string == null) {
            return;
        }
        if (commandOptions == null && string.equals(" ")) {
            commandOptions = " ";
        } else {
            string = Recorder.trimKey(string);
            Recorder.checkForDuplicate(" " + string, "");
            commandOptions = commandOptions == null ? string : commandOptions + " " + string;
        }
    }

    static void checkForDuplicate(String string, String string2) {
        if (commandOptions != null && commandName != null && commandOptions.indexOf(string) != -1 && (string2.equals("") || commandOptions.indexOf(string2) == -1)) {
            if (string.endsWith("=")) {
                string = string.substring(0, string.length() - 1);
            }
            IJ.showMessage("Recorder", "Duplicate keyword:\n \n    Command: \"" + commandName + "\"\n" + "    Keyword: " + "\"" + string + "\"\n" + "    Value: " + string2 + "\n \n" + "Add an underscore to the corresponding label\n" + "in the dialog to make the first word unique.");
        }
    }

    static String trimKey(String string) {
        return Macro.trimKey(string);
    }

    public static void saveCommand() {
        String string = commandName;
        if (string != null) {
            if (commandOptions == null && (string.equals("Fill") || string.equals("Clear"))) {
                commandOptions = "slice";
            }
            if (commandOptions != null) {
                if (string.equals("Open...")) {
                    String string2;
                    String string3 = string2 = scriptMode ? "imp = IJ.openImage" : "open";
                    if (scriptMode && Recorder.isTextOrTable(commandOptions)) {
                        string2 = "IJ.open";
                    }
                    textArea.append(string2 + "(\"" + Recorder.strip(commandOptions) + "\");\n");
                } else if (Recorder.isSaveAs()) {
                    if (string.endsWith("...")) {
                        string = string.substring(0, string.length() - 3);
                    }
                    String string4 = Recorder.strip(commandOptions);
                    String string5 = scriptMode ? "IJ.saveAs(imp, " : "saveAs(";
                    textArea.append(string5 + "\"" + string + "\", \"" + string4 + "\");\n");
                } else if (string.equals("Image...")) {
                    Recorder.appendNewImage();
                } else if (string.equals("Set Slice...")) {
                    textArea.append((scriptMode ? "imp." : "") + "setSlice(" + Recorder.strip(commandOptions) + ");\n");
                } else if (string.equals("Rename...")) {
                    textArea.append((scriptMode ? "imp.setTitle" : "rename") + "(\"" + Recorder.strip(commandOptions) + "\");\n");
                } else if (string.equals("Wand Tool...")) {
                    textArea.append("//run(\"" + string + "\", \"" + commandOptions + "\");\n");
                } else if (string.equals("Results... ") && commandOptions.indexOf(".txt") == -1) {
                    textArea.append((scriptMode ? "IJ." : "") + "open(\"" + Recorder.strip(commandOptions) + "\");\n");
                } else if (!string.equals("Results...") && !string.equals("Run...")) {
                    String string6 = "run(";
                    if (scriptMode) {
                        string6 = imageUpdated ? "IJ.run(imp, " : "IJ.run(";
                    }
                    textArea.append(string6 + "\"" + string + "\", \"" + commandOptions + "\");\n");
                }
            } else if (string.equals("Threshold...") || string.equals("Fonts...") || string.equals("Brightness/Contrast...")) {
                textArea.append("//run(\"" + string + "\");\n");
            } else if (string.equals("Start Animation [\\]")) {
                textArea.append("doCommand(\"Start Animation [\\\\]\");\n");
            } else if (!string.equals("Add to Manager ")) {
                if (string.equals("Draw") && !scriptMode) {
                    ImagePlus imagePlus = WindowManager.getCurrentImage();
                    Roi roi = imagePlus.getRoi();
                    if (roi != null && roi instanceof TextRoi) {
                        textArea.append(((TextRoi)roi).getMacroCode(imagePlus.getProcessor()));
                    } else {
                        textArea.append("run(\"" + string + "\");\n");
                    }
                } else {
                    if (IJ.altKeyDown() && (string.equals("Open Next") || string.equals("Plot Profile"))) {
                        textArea.append("setKeyDown(\"alt\"); ");
                    }
                    if (scriptMode) {
                        String string7 = imageUpdated || string.equals("Select None") ? "IJ.run(imp, " : "IJ.run(";
                        textArea.append(string7 + "\"" + string + "\", \"\");\n");
                    } else {
                        textArea.append("run(\"" + string + "\");\n");
                    }
                }
            }
        }
        commandName = null;
        commandOptions = null;
        if (imageID != 0) {
            ImagePlus.removeImageListener(instance);
            imageID = 0;
        }
    }

    static boolean isTextOrTable(String string) {
        return string.endsWith(".txt") || string.endsWith(".csv") || string.endsWith(".xls");
    }

    static boolean isSaveAs() {
        return commandName.equals("Tiff...") || commandName.equals("Gif...") || commandName.equals("Jpeg...") || commandName.equals("Text Image...") || commandName.equals("ZIP...") || commandName.equals("Raw Data...") || commandName.equals("BMP...") || commandName.equals("PNG...") || commandName.equals("PGM...") || commandName.equals("FITS...") || commandName.equals("LUT...") || commandName.equals("Selection...") || commandName.equals("XY Coordinates...") || commandName.equals("Text... ");
    }

    static void appendNewImage() {
        String string = Recorder.getCommandOptions() + " ";
        String string2 = Macro.getValue(string, "name", "Untitled");
        String string3 = Macro.getValue(string, "type", "8-bit");
        String string4 = Macro.getValue(string, "fill", "");
        if (!string4.equals("")) {
            string3 = string3 + " " + string4;
        }
        int n = (int)Tools.parseDouble(Macro.getValue(string, "width", "512"));
        int n2 = (int)Tools.parseDouble(Macro.getValue(string, "height", "512"));
        int n3 = (int)Tools.parseDouble(Macro.getValue(string, "slices", "1"));
        textArea.append((scriptMode ? "imp = IJ.createImage" : "newImage") + "(\"" + string2 + "\", " + "\"" + string3 + "\", " + n + ", " + n2 + ", " + n3 + ");\n");
    }

    static String strip(String string) {
        int n = string.indexOf(61);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        if (string.startsWith("[")) {
            int n2 = string.indexOf(93);
            if (n2 == -1) {
                n2 = string.length();
            }
            string = string.substring(1, n2);
        } else {
            n = string.indexOf(32);
            if (n != -1) {
                string = string.substring(0, n);
            }
        }
        return string;
    }

    static String addQuotes(String string) {
        int n = string.indexOf(32);
        if (n > -1) {
            string = "[" + string + "]";
        }
        return string;
    }

    public static String getCommandOptions() {
        return commandOptions;
    }

    void createMacro() {
        String string = textArea.getText();
        if (string == null || string.equals("")) {
            IJ.showMessage("Recorder", "A macro cannot be created until at least\none command has been recorded.");
            return;
        }
        boolean bl = this.mode.getSelectedItem().equals(modes[2]);
        String string2 = this.fileName.getText();
        int n = string2.lastIndexOf(".");
        if (scriptMode) {
            if (n >= 0) {
                string2 = string2.substring(0, n);
            }
            if (string.indexOf("rm.") != -1) {
                string = (bl ? "RoiManager " : "") + "rm = RoiManager.getInstance();\n" + "if (rm==null) rm = new RoiManager();\n" + "rm.runCommand(\"reset\");\n" + string;
            }
            if (string.indexOf("imp =") == -1 && string.indexOf("IJ.openImage") == -1 && string.indexOf("IJ.createImage") == -1) {
                string = (bl ? "ImagePlus " : "") + "imp = IJ.getImage();\n" + string;
            }
            if (string.indexOf("imp =") != -1 && string.indexOf("IJ.getImage") == -1 && string.indexOf("IJ.saveAs") == -1 && string.indexOf("imp.close") == -1) {
                string = string + "imp.show();\n";
            }
            if (bl) {
                string2 = string2 + ".java";
                this.createPlugin(string, string2);
                return;
            }
            string2 = string2 + ".js";
        } else if (!string2.endsWith(".txt")) {
            if (n >= 0) {
                string2 = string2.substring(0, n);
            }
            string2 = string2 + ".ijm";
        }
        if (IJ.runFijiEditor(string2, string)) {
            return;
        }
        Editor editor = (Editor)IJ.runPlugIn("ij.plugin.frame.Editor", "");
        if (editor == null) {
            return;
        }
        editor.createMacro(string2, string);
    }

    void createPlugin(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        int n = stringTokenizer.countTokens();
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            String string3 = stringTokenizer.nextToken();
            if (string3 == null || string3.length() <= 3) continue;
            stringBuffer.append("\t\t");
            if (string3.startsWith("imp =") && !bl) {
                stringBuffer.append("ImagePlus ");
                bl = true;
            }
            stringBuffer.append(string3);
            stringBuffer.append('\n');
        }
        String string4 = new String(stringBuffer);
        string4 = string4.replaceAll("print", "IJ.log");
        NewPlugin newPlugin = (NewPlugin)IJ.runPlugIn("ij.plugin.NewPlugin", "name:" + string2 + "\n" + string4);
    }

    public static void disablePathRecording() {
        recordPath = false;
    }

    public static boolean scriptMode() {
        return scriptMode;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.makeMacro) {
            this.createMacro();
        } else if (actionEvent.getSource() == this.help) {
            this.showHelp();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.setFileName();
    }

    void setFileName() {
        String string = this.mode.getSelectedItem();
        boolean bl = scriptMode = string.equals(modes[1]) || string.equals(modes[2]);
        if (string.equals(modes[0])) {
            this.fileName.setText("Macro.ijm");
        } else if (string.equals(modes[1])) {
            this.fileName.setText("script.js");
        } else {
            this.fileName.setText("My_Plugin.java");
        }
    }

    public void imageUpdated(ImagePlus imagePlus) {
        if (imagePlus.getID() == imageID) {
            imageUpdated = true;
        }
    }

    public void imageOpened(ImagePlus imagePlus) {
    }

    public void imageClosed(ImagePlus imagePlus) {
    }

    void showHelp() {
        IJ.showMessage("Recorder", "Click \"Create\" to open recorded commands\nas a macro in an editor window.\n \nIn the editor:\n \n    Type ctrl+R (Macros>Run Macro) to\n    run the macro.\n \n    Use File>Save As to save it and\n    ImageJ's Open command to open it.\n \n    To create a command, save in the plugins\n    folder and run Help>Refresh Menus.\n");
    }

    public void close() {
        super.close();
        record = false;
        textArea = null;
        commandName = null;
        instance = null;
        Prefs.set("recorder.mode", this.mode.getSelectedItem());
    }

    public String getText() {
        if (textArea == null) {
            return "";
        }
        return textArea.getText();
    }

    public static Recorder getInstance() {
        return instance;
    }

    static {
        modes = new String[]{"Macro", "JavaScript", "Plugin"};
        defaultName = "Macro.ijm";
        recordPath = true;
    }
}

