/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.plugin.frame.PlugInFrame;
import ij.plugin.frame.Recorder;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class Channels
extends PlugInFrame
implements PlugIn,
ItemListener,
ActionListener {
    private static String[] modes = new String[]{"Composite", "Color", "Grayscale"};
    private static String[] menuItems = new String[]{"Make Composite", "Convert to RGB", "Split Channels", "Merge Channels...", "Edit LUT...", "-", "Red", "Green", "Blue", "Cyan", "Magenta", "Yellow", "Grays"};
    private static String moreLabel = "More \u00bb";
    private Choice choice;
    private Checkbox[] checkbox;
    private Button moreButton;
    private static Frame instance;
    private int id;
    private static Point location;
    private PopupMenu pm;

    public Channels() {
        super("Channels");
        int n;
        int n2;
        if (instance != null) {
            WindowManager.toFront(instance);
            return;
        }
        WindowManager.addWindow(this);
        instance = this;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        int n3 = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n3++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        int n4 = 32;
        if (IJ.isVista()) {
            n4 = 40;
        } else if (IJ.isMacOSX()) {
            n4 = 18;
        }
        gridBagConstraints.insets = new Insets(10, n4, 10, n4);
        this.choice = new Choice();
        for (int i = 0; i < modes.length; ++i) {
            this.choice.addItem(modes[i]);
        }
        this.choice.select(0);
        this.choice.addItemListener(this);
        this.add((Component)this.choice, gridBagConstraints);
        CompositeImage compositeImage = this.getImage();
        int n5 = n2 = compositeImage != null ? compositeImage.getNChannels() : 3;
        if (n2 > 7) {
            n2 = 7;
        }
        this.checkbox = new Checkbox[n2];
        for (n = 0; n < n2; ++n) {
            this.checkbox[n] = new Checkbox("Channel " + (n + 1), true);
            gridBagConstraints.insets = new Insets(0, 25, n < n2 - 1 ? 0 : 10, 5);
            gridBagConstraints.gridy = n3++;
            this.add((Component)this.checkbox[n], gridBagConstraints);
            this.checkbox[n].addItemListener(this);
        }
        gridBagConstraints.insets = new Insets(0, 15, 10, 15);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridy = n3++;
        this.moreButton = new Button(moreLabel);
        this.moreButton.addActionListener(this);
        this.add((Component)this.moreButton, gridBagConstraints);
        this.update();
        this.pm = new PopupMenu();
        for (n = 0; n < menuItems.length; ++n) {
            this.addPopupItem(menuItems[n]);
        }
        this.add(this.pm);
        this.addKeyListener(IJ.getInstance());
        this.setResizable(false);
        this.pack();
        if (location == null) {
            GUI.center(this);
            location = this.getLocation();
        } else {
            this.setLocation(location);
        }
        this.show();
    }

    public void update() {
        int n;
        CompositeImage compositeImage = this.getImage();
        if (compositeImage == null) {
            return;
        }
        int n2 = this.checkbox.length;
        int n3 = compositeImage.getNChannels();
        if (n3 != n2 && n3 <= 7) {
            instance = null;
            location = this.getLocation();
            this.close();
            new Channels();
            return;
        }
        boolean[] blArray = compositeImage.getActiveChannels();
        for (n = 0; n < this.checkbox.length; ++n) {
            this.checkbox[n].setState(blArray[n]);
        }
        n = 0;
        switch (compositeImage.getMode()) {
            case 1: {
                n = 0;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            case 3: {
                n = 2;
            }
        }
        this.choice.select(n);
    }

    void addPopupItem(String string) {
        MenuItem menuItem = new MenuItem(string);
        menuItem.addActionListener(this);
        this.pm.add(menuItem);
    }

    CompositeImage getImage() {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null || !imagePlus.isComposite()) {
            return null;
        }
        return (CompositeImage)imagePlus;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object;
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null) {
            return;
        }
        if (!imagePlus.isComposite()) {
            int n = imagePlus.getNChannels();
            if (n == 1 && imagePlus.getStackSize() <= 4) {
                n = imagePlus.getStackSize();
            }
            if (imagePlus.getBitDepth() == 24 || n > 1 && n < 7) {
                object = new GenericDialog(imagePlus.getTitle(), this);
                ((GenericDialog)object).addMessage("Convert to multi-channel composite image?");
                ((GenericDialog)object).showDialog();
                if (((GenericDialog)object).wasCanceled()) {
                    return;
                }
                IJ.doCommand("Make Composite");
            } else {
                IJ.error("Channels", "A composite image is required (e.g., " + moreLabel + " Open HeLa Cells),\nor create one using " + moreLabel + " Make Composite.");
                return;
            }
        }
        if (!imagePlus.isComposite()) {
            return;
        }
        CompositeImage compositeImage = (CompositeImage)imagePlus;
        object = itemEvent.getSource();
        if (object == this.choice) {
            int n = ((Choice)object).getSelectedIndex();
            switch (n) {
                case 0: {
                    compositeImage.setMode(1);
                    break;
                }
                case 1: {
                    compositeImage.setMode(2);
                    break;
                }
                case 2: {
                    compositeImage.setMode(3);
                }
            }
            compositeImage.updateAndDraw();
            if (Recorder.record) {
                String string = null;
                switch (n) {
                    case 0: {
                        string = "composite";
                        break;
                    }
                    case 1: {
                        string = "color";
                        break;
                    }
                    case 2: {
                        string = "grayscale";
                    }
                }
                Recorder.record("Stack.setDisplayMode", string);
            }
        } else if (object instanceof Checkbox) {
            for (int i = 0; i < this.checkbox.length; ++i) {
                Checkbox checkbox = (Checkbox)object;
                if (checkbox != this.checkbox[i]) continue;
                if (compositeImage.getMode() == 1) {
                    boolean[] blArray = compositeImage.getActiveChannels();
                    blArray[i] = checkbox.getState();
                    if (Recorder.record) {
                        String string = "";
                        for (int j = 0; j < compositeImage.getNChannels(); ++j) {
                            string = string + (blArray[j] ? "1" : "0");
                        }
                        Recorder.record("Stack.setActiveChannels", string);
                    }
                } else {
                    imagePlus.setPosition(i + 1, imagePlus.getSlice(), imagePlus.getFrame());
                    if (Recorder.record) {
                        Recorder.record("Stack.setChannel", i + 1);
                    }
                }
                compositeImage.updateAndDraw();
                return;
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == null) {
            return;
        }
        if (string.equals(moreLabel)) {
            Point point = this.moreButton.getLocation();
            this.pm.show(this, point.x, point.y);
        } else if (string.equals("Convert to RGB")) {
            IJ.doCommand("Stack to RGB");
        } else {
            IJ.doCommand(string);
        }
    }

    public static Frame getInstance() {
        return instance;
    }

    public void close() {
        super.close();
        instance = null;
        location = this.getLocation();
    }
}

