/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.plugin.filter.ExtendedPlugInFilter;
import ij.plugin.filter.GaussianBlur;
import ij.plugin.filter.PlugInFilterRunner;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.AWTEvent;
import java.awt.Rectangle;

public class UnsharpMask
implements ExtendedPlugInFilter,
DialogListener {
    private static double sigma = 1.0;
    private static double weight = 0.6;
    private final int flags = 16801887;
    private GaussianBlur gb;

    public int setup(String string, ImagePlus imagePlus) {
        return 16801887;
    }

    public void run(ImageProcessor imageProcessor) {
        this.sharpenFloat((FloatProcessor)imageProcessor, sigma, (float)weight);
    }

    public void sharpenFloat(FloatProcessor floatProcessor, double d, float f) {
        if (this.gb == null) {
            this.gb = new GaussianBlur();
        }
        this.gb.blurGaussian(floatProcessor, d, d, 0.01);
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        float[] fArray = (float[])floatProcessor.getPixels();
        float[] fArray2 = (float[])floatProcessor.getSnapshotPixels();
        int n = floatProcessor.getWidth();
        Rectangle rectangle = floatProcessor.getRoi();
        for (int i = rectangle.y; i < rectangle.y + rectangle.height; ++i) {
            int n2 = rectangle.x;
            int n3 = n * i + n2;
            while (n2 < rectangle.x + rectangle.width) {
                fArray[n3] = (fArray2[n3] - f * fArray[n3]) / (1.0f - f);
                ++n2;
                ++n3;
            }
        }
    }

    public int showDialog(ImagePlus imagePlus, String string, PlugInFilterRunner plugInFilterRunner) {
        String string2 = Macro.getOptions();
        boolean bl = false;
        if (string2 != null && string2.indexOf("gaussian=") >= 0) {
            bl = true;
            Macro.setOptions(string2.replaceAll("gaussian=", "radius="));
        }
        GenericDialog genericDialog = new GenericDialog(string);
        sigma = Math.abs(sigma);
        if (weight < 0.0) {
            weight = 0.0;
        }
        if (weight > 0.99) {
            weight = 0.99;
        }
        genericDialog.addNumericField("Radius (Sigma)", sigma, 1, 6, "pixels");
        genericDialog.addNumericField("Mask Weight (0.1-0.9)", weight, 2);
        genericDialog.addPreviewCheckbox(plugInFilterRunner);
        genericDialog.addDialogListener(this);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return 4096;
        }
        if (bl) {
            sigma /= 2.5;
        }
        IJ.register(this.getClass());
        return IJ.setupDialog(imagePlus, 16801887);
    }

    public boolean dialogItemChanged(GenericDialog genericDialog, AWTEvent aWTEvent) {
        sigma = genericDialog.getNextNumber();
        weight = genericDialog.getNextNumber();
        return !(sigma < 0.0 || weight < 0.0 || weight > 0.99) && !genericDialog.invalidNumber();
    }

    public void setNPasses(int n) {
        if (this.gb == null) {
            this.gb = new GaussianBlur();
        }
        this.gb.setNPasses(n);
    }
}

