/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.Prefs;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.gui.Overlay;
import ij.gui.Roi;
import ij.gui.TextRoi;
import ij.gui.Toolbar;
import ij.plugin.filter.ExtendedPlugInFilter;
import ij.plugin.filter.PlugInFilterRunner;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.util.Tools;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;

public class StackLabeler
implements ExtendedPlugInFilter,
DialogListener {
    private static final String[] formats = new String[]{"0", "0000", "00:00", "00:00:00", "Text"};
    private static final int NUMBER = 0;
    private static final int ZERO_PADDED_NUMBER = 1;
    private static final int MIN_SEC = 2;
    private static final int HOUR_MIN_SEC = 3;
    private static final int TEXT = 4;
    private static int format = (int)Prefs.get("label.format", 0.0);
    private int flags = 31;
    private ImagePlus imp;
    private static int x = 5;
    private static int y = 20;
    private static int fontSize = 18;
    private int maxWidth;
    private Font font;
    private static double start = 0.0;
    private static double interval = 1.0;
    private static String text = "";
    private static int decimalPlaces = 0;
    private static boolean useOverlay;
    private static boolean useTextToolFont;
    private int fieldWidth;
    private Color color;
    private int firstFrame;
    private int lastFrame;
    private int defaultLastFrame;
    private Overlay overlay;
    private boolean previewing;
    private boolean virtualStack;
    private int yoffset;

    public int setup(String string, ImagePlus imagePlus) {
        if (imagePlus != null) {
            this.virtualStack = imagePlus.getStack().isVirtual();
            if (this.virtualStack) {
                useOverlay = true;
            }
            this.flags += this.virtualStack ? 0 : 32;
            this.firstFrame = 1;
            this.lastFrame = this.defaultLastFrame = imagePlus.getStackSize();
        }
        this.imp = imagePlus;
        return this.flags;
    }

    public int showDialog(ImagePlus imagePlus, String string, PlugInFilterRunner plugInFilterRunner) {
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        Rectangle rectangle = imageProcessor.getRoi();
        if (rectangle.width < imageProcessor.getWidth() || rectangle.height < imageProcessor.getHeight()) {
            x = rectangle.x;
            y = rectangle.y + rectangle.height;
            fontSize = (int)(((double)rectangle.height - 1.10526) / 0.934211);
            if (fontSize < 7) {
                fontSize = 7;
            }
            if (fontSize > 80) {
                fontSize = 80;
            }
        }
        if (IJ.macroRunning()) {
            format = 0;
            decimalPlaces = 0;
            interval = 1.0;
            text = "";
            start = 0.0;
            useOverlay = false;
            useTextToolFont = false;
            String string2 = Macro.getOptions();
            if (string2 != null) {
                if (string2.indexOf("interval=0") != -1 && string2.indexOf("format=") == -1) {
                    format = 4;
                }
                if (string2.indexOf(" slice=") != -1) {
                    string2 = string2.replaceAll(" slice=", " range=");
                    Macro.setOptions(string2);
                }
            }
        }
        if (format < 0 || format > 4) {
            format = 0;
        }
        int n = imagePlus.getStackSize();
        if (imagePlus.isHyperStack()) {
            if (imagePlus.getNFrames() > 1) {
                n = imagePlus.getNFrames();
            } else if (imagePlus.getNSlices() > 1) {
                n = imagePlus.getNSlices();
            }
        }
        GenericDialog genericDialog = new GenericDialog("StackLabeler");
        genericDialog.setInsets(2, 5, 0);
        genericDialog.addChoice("Format:", formats, formats[format]);
        genericDialog.addStringField("Starting value:", IJ.d2s(start, decimalPlaces));
        genericDialog.addStringField("Interval:", "" + IJ.d2s(interval, decimalPlaces));
        genericDialog.addNumericField("X location:", x, 0);
        genericDialog.addNumericField("Y location:", y, 0);
        genericDialog.addNumericField("Font size:", fontSize, 0);
        genericDialog.addStringField("Text:", text, 10);
        this.addRange(genericDialog, "Range:", 1, n);
        genericDialog.setInsets(10, 20, 0);
        genericDialog.addCheckbox(" Use overlay", useOverlay);
        genericDialog.addCheckbox(" Use text tool font", useTextToolFont);
        genericDialog.addPreviewCheckbox(plugInFilterRunner);
        genericDialog.addHelp("http://imagej.nih.gov/ij/docs/menus/image.html#label");
        genericDialog.addDialogListener(this);
        this.previewing = true;
        genericDialog.showDialog();
        this.previewing = false;
        if (genericDialog.wasCanceled()) {
            return 4096;
        }
        return this.flags;
    }

    void addRange(GenericDialog genericDialog, String string, int n, int n2) {
        genericDialog.addStringField(string, n + "-" + n2);
    }

    double[] getRange(GenericDialog genericDialog, int n, int n2) {
        String[] stringArray = Tools.split(genericDialog.getNextString(), " -");
        double d = Tools.parseDouble(stringArray[0]);
        double d2 = stringArray.length == 2 ? Tools.parseDouble(stringArray[1]) : Double.NaN;
        double[] dArray = new double[2];
        dArray[0] = Double.isNaN(d) ? 1.0 : (double)((int)d);
        double d3 = dArray[1] = Double.isNaN(d2) ? (double)n2 : (double)((int)d2);
        if (dArray[0] < (double)n) {
            dArray[0] = n;
        }
        if (dArray[1] > (double)n2) {
            dArray[1] = n2;
        }
        if (dArray[0] > dArray[1]) {
            dArray[0] = n;
            dArray[1] = n2;
        }
        return dArray;
    }

    public boolean dialogItemChanged(GenericDialog genericDialog, AWTEvent aWTEvent) {
        format = genericDialog.getNextChoiceIndex();
        start = Tools.parseDouble(genericDialog.getNextString());
        String string = genericDialog.getNextString();
        interval = Tools.parseDouble(string);
        x = (int)genericDialog.getNextNumber();
        y = (int)genericDialog.getNextNumber();
        fontSize = (int)genericDialog.getNextNumber();
        text = genericDialog.getNextString();
        double[] dArray = this.getRange(genericDialog, 1, this.defaultLastFrame);
        useOverlay = genericDialog.getNextBoolean();
        useTextToolFont = genericDialog.getNextBoolean();
        if (this.virtualStack) {
            useOverlay = true;
        }
        this.firstFrame = (int)dArray[0];
        this.lastFrame = (int)dArray[1];
        int n = string.indexOf(".");
        decimalPlaces = n != -1 ? string.length() - n - 1 : 0;
        if (genericDialog.invalidNumber()) {
            return false;
        }
        this.font = useTextToolFont ? new Font(TextRoi.getFont(), TextRoi.getStyle(), fontSize) : new Font("SansSerif", 0, fontSize);
        if (y < fontSize) {
            y = fontSize + 5;
        }
        ImageProcessor imageProcessor = this.imp.getProcessor();
        imageProcessor.setFont(this.font);
        int n2 = this.defaultLastFrame;
        this.maxWidth = imageProcessor.getStringWidth(this.getString(n2, interval, format));
        this.fieldWidth = 1;
        if (n2 >= 10) {
            this.fieldWidth = 2;
        }
        if (n2 >= 100) {
            this.fieldWidth = 3;
        }
        if (n2 >= 1000) {
            this.fieldWidth = 4;
        }
        if (n2 >= 10000) {
            this.fieldWidth = 5;
        }
        Prefs.set("label.format", format);
        return true;
    }

    public void run(ImageProcessor imageProcessor) {
        int n = imageProcessor.getSliceNumber();
        int n2 = n - 1;
        if (this.imp.isHyperStack()) {
            n2 = this.updateIndex(n2);
        }
        if (this.virtualStack) {
            int n3 = this.imp.getStackSize();
            if (this.previewing) {
                n3 = 1;
            }
            for (int i = 1; i <= n3; ++i) {
                n = i;
                n2 = i - 1;
                if (this.imp.isHyperStack()) {
                    n2 = this.updateIndex(n2);
                }
                this.drawLabel(imageProcessor, n, n2);
            }
        } else {
            if (this.previewing && this.overlay != null) {
                this.imp.setOverlay(null);
                this.overlay = null;
            }
            this.drawLabel(imageProcessor, n, n2);
        }
    }

    int updateIndex(int n) {
        if (this.imp.getNFrames() > 1) {
            return (int)((double)n * ((double)this.imp.getNFrames() / (double)this.imp.getStackSize()));
        }
        if (this.imp.getNSlices() > 1) {
            return (int)((double)n * ((double)this.imp.getNSlices() / (double)this.imp.getStackSize()));
        }
        return n;
    }

    void drawLabel(ImageProcessor imageProcessor, int n, int n2) {
        Object object;
        String string = this.getString(n2, interval, format);
        imageProcessor.setFont(this.font);
        int n3 = imageProcessor.getStringWidth(string);
        if (this.color == null) {
            this.color = Toolbar.getForegroundColor();
            if ((this.color.getRGB() & 0xFFFFFF) == 0) {
                imageProcessor.setRoi(x, y - fontSize, this.maxWidth + n3, fontSize);
                double d = ImageStatistics.getStatistics((ImageProcessor)imageProcessor, (int)2, null).mean;
                if (d < 50.0 && !imageProcessor.isInvertedLut()) {
                    this.color = Color.white;
                }
                imageProcessor.resetRoi();
            }
        }
        int n4 = n;
        if (this.imp.isHyperStack()) {
            object = this.imp.convertIndexToPosition(n);
            if (this.imp.getNFrames() > 1) {
                n4 = object[2];
            } else if (this.imp.getNSlices() > 1) {
                n4 = object[1];
            }
        }
        if (useOverlay) {
            if (n == 1) {
                this.overlay = new Overlay();
                object = this.imp.getRoi();
                Rectangle rectangle = object != null ? ((Roi)object).getBounds() : null;
                int n5 = this.yoffset = rectangle != null ? rectangle.height : fontSize;
            }
            if (n4 >= this.firstFrame && n4 <= this.lastFrame) {
                object = new TextRoi(x + this.maxWidth - n3, y - this.yoffset, string, this.font);
                ((Roi)object).setStrokeColor(this.color);
                ((Roi)object).setNonScalable(true);
                ((Roi)object).setPosition(n);
                this.overlay.add((Roi)object);
            }
            if (n == this.imp.getStackSize() || this.previewing) {
                this.imp.setOverlay(this.overlay);
            }
        } else if (n4 >= this.firstFrame && n4 <= this.lastFrame) {
            imageProcessor.setColor(this.color);
            imageProcessor.setAntialiasedText(fontSize >= 18);
            imageProcessor.moveTo(x + this.maxWidth - n3, y);
            imageProcessor.drawString(string);
        }
    }

    String getString(int n, double d, int n2) {
        double d2 = start + (double)(n + 1 - this.firstFrame) * d;
        int n3 = (int)Math.floor(d2);
        int n4 = 1;
        if (n3 < 0) {
            n4 = -1;
        }
        n3 *= n4;
        String string = "";
        switch (n2) {
            case 0: {
                string = IJ.d2s(d2, decimalPlaces) + " " + text;
                break;
            }
            case 1: {
                string = decimalPlaces == 0 ? this.zeroFill((int)d2) : IJ.d2s(d2, decimalPlaces);
                string = text + " " + string;
                break;
            }
            case 2: {
                string = this.pad((int)Math.floor(n3 / 60 % 60)) + ":" + this.pad(n3 % 60) + " " + text;
                if (n4 != -1) break;
                string = "-" + string;
                break;
            }
            case 3: {
                string = this.pad((int)Math.floor(n3 / 3600)) + ":" + this.pad((int)Math.floor(n3 / 60 % 60)) + ":" + this.pad(n3 % 60) + " " + text;
                if (n4 != -1) break;
                string = "-" + string;
                break;
            }
            case 4: {
                string = text;
            }
        }
        return string;
    }

    String pad(int n) {
        String string = "" + n;
        if (string.length() == 1) {
            string = "0" + string;
        }
        return string;
    }

    String zeroFill(int n) {
        String string = "" + n;
        while (string.length() < this.fieldWidth) {
            string = "0" + string;
        }
        return string;
    }

    public void setNPasses(int n) {
    }
}

