/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.Prefs;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.plugin.ContrastEnhancer;
import ij.plugin.filter.ExtendedPlugInFilter;
import ij.plugin.filter.PlugInFilterRunner;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.AWTEvent;
import java.awt.Rectangle;
import java.util.Arrays;

public class RankFilters
implements ExtendedPlugInFilter,
DialogListener {
    public static final int MEAN = 0;
    public static final int MIN = 1;
    public static final int MAX = 2;
    public static final int VARIANCE = 3;
    public static final int MEDIAN = 4;
    public static final int OUTLIERS = 5;
    public static final int DESPECKLE = 6;
    public static final int REMOVE_NAN = 7;
    public static final int OPEN = 8;
    public static final int CLOSE = 9;
    private static int HIGHEST_FILTER = 9;
    private static final int BRIGHT_OUTLIERS = 0;
    private static final int DARK_OUTLIERS = 1;
    private static final String[] outlierStrings = new String[]{"Bright", "Dark"};
    private double radius;
    private double threshold;
    private int whichOutliers;
    private int filterType;
    private static double[] lastRadius = new double[HIGHEST_FILTER + 1];
    private static double lastThreshold = 50.0;
    private static int lastWhichOutliers = 0;
    int flags = 16777311;
    private ImagePlus imp;
    private int nPasses = 1;
    private PlugInFilterRunner pfr;
    private int pass;
    private int numThreads = Prefs.getThreads();
    private int highestYinCache;
    private boolean threadWaiting;
    private boolean copyingToCache;

    private boolean isMultiStepFilter(int n) {
        return n >= 8;
    }

    public int setup(String string, ImagePlus imagePlus) {
        Roi roi;
        this.imp = imagePlus;
        if (string.equals("mean")) {
            this.filterType = 0;
        } else if (string.equals("min")) {
            this.filterType = 1;
        } else if (string.equals("max")) {
            this.filterType = 2;
        } else if (string.equals("variance")) {
            this.filterType = 3;
            this.flags |= 0x10000;
        } else if (string.equals("median")) {
            this.filterType = 4;
        } else if (string.equals("outliers")) {
            this.filterType = 5;
        } else if (string.equals("despeckle")) {
            this.filterType = 6;
        } else if (string.equals("close")) {
            this.filterType = 9;
        } else if (string.equals("open")) {
            this.filterType = 8;
        } else if (string.equals("nan")) {
            this.filterType = 7;
            if (imagePlus != null && imagePlus.getBitDepth() != 32) {
                IJ.error("RankFilters", "\"Remove NaNs\" requires a 32-bit image");
                return 4096;
            }
        } else if (string.equals("final")) {
            if (imagePlus != null && imagePlus.getBitDepth() != 8 && imagePlus.getBitDepth() != 24 && imagePlus.getRoi() == null) {
                new ContrastEnhancer().stretchHistogram(imagePlus.getProcessor(), 0.5);
            }
        } else {
            if (string.equals("masks")) {
                this.showMasks();
                return 4096;
            }
            IJ.error("RankFilters", "Argument missing or undefined: " + string);
            return 4096;
        }
        if (this.isMultiStepFilter(this.filterType) && imagePlus != null && (roi = imagePlus.getRoi()) != null && !roi.getBounds().contains(new Rectangle(imagePlus.getWidth(), imagePlus.getHeight()))) {
            this.flags |= 0x4000;
        }
        return this.flags;
    }

    public int showDialog(ImagePlus imagePlus, String string, PlugInFilterRunner plugInFilterRunner) {
        if (this.filterType == 6) {
            this.filterType = 4;
            this.radius = 1.0;
        } else {
            int n;
            GenericDialog genericDialog = new GenericDialog(string + "...");
            this.radius = lastRadius[this.filterType] <= 0.0 ? 2.0 : lastRadius[this.filterType];
            genericDialog.addNumericField("Radius", this.radius, 1, 6, "pixels");
            int n2 = n = imagePlus.getType() == 2 ? 2 : 0;
            if (this.filterType == 5) {
                genericDialog.addNumericField("Threshold", lastThreshold, n);
                genericDialog.addChoice("Which outliers", outlierStrings, outlierStrings[lastWhichOutliers]);
                genericDialog.addHelp("http://imagej.nih.gov/ij/docs/menus/process.html#outliers");
            } else if (this.filterType == 7) {
                genericDialog.addHelp("http://imagej.nih.gov/ij/docs/menus/process.html#nans");
            }
            genericDialog.addPreviewCheckbox(plugInFilterRunner);
            genericDialog.addDialogListener(this);
            genericDialog.showDialog();
            if (genericDialog.wasCanceled()) {
                return 4096;
            }
            IJ.register(this.getClass());
            if (Macro.getOptions() == null) {
                RankFilters.lastRadius[this.filterType] = this.radius;
                if (this.filterType == 5) {
                    lastThreshold = this.threshold;
                    lastWhichOutliers = this.whichOutliers;
                }
            }
        }
        this.pfr = plugInFilterRunner;
        this.flags = IJ.setupDialog(imagePlus, this.flags);
        if ((this.flags & 0x20) != 0) {
            int n = imagePlus.getWidth() * imagePlus.getHeight();
            Roi roi = imagePlus.getRoi();
            if (roi != null) {
                Rectangle rectangle = roi.getBounds();
                n = rectangle.width * rectangle.height;
            }
            double d = (double)n * this.radius;
            if (this.filterType == 0 || this.filterType == 3) {
                d *= 0.5;
            } else if (this.filterType == 4) {
                d *= this.radius * 0.5;
            }
            if (d < 1000000.0 && imagePlus.getImageStackSize() >= this.numThreads) {
                this.numThreads = 1;
                this.flags |= 0x8000;
            }
        }
        return this.flags;
    }

    public boolean dialogItemChanged(GenericDialog genericDialog, AWTEvent aWTEvent) {
        int n;
        this.radius = genericDialog.getNextNumber();
        if (this.filterType == 5) {
            this.threshold = genericDialog.getNextNumber();
            this.whichOutliers = genericDialog.getNextChoiceIndex();
        }
        int n2 = n = this.filterType == 4 || this.filterType == 5 || this.filterType == 7 ? 100 : 1000;
        return !genericDialog.invalidNumber() && !(this.radius < 0.0) && !(this.radius > (double)n) && (this.filterType != 5 || !(this.threshold < 0.0));
    }

    public void run(ImageProcessor imageProcessor) {
        this.rank(imageProcessor, this.radius, this.filterType, this.whichOutliers, (float)this.threshold);
        if (IJ.escapePressed()) {
            imageProcessor.reset();
        }
    }

    public void rank(ImageProcessor imageProcessor, double d, int n) {
        this.rank(imageProcessor, d, n, 0, 50.0f);
    }

    public void rank(ImageProcessor imageProcessor, double d, int n, int n2, float f) {
        Rectangle rectangle = imageProcessor.getRoi();
        ImageProcessor imageProcessor2 = imageProcessor.getMask();
        Rectangle rectangle2 = null;
        int[] nArray = this.makeLineRadii(d);
        boolean bl = rectangle.width < imageProcessor.getWidth() || rectangle.height < imageProcessor.getHeight();
        boolean[] blArray = new boolean[1];
        for (int i = 0; i < imageProcessor.getNChannels(); ++i) {
            int n3;
            int n4 = n;
            if (this.isMultiStepFilter(n)) {
                int n5 = n4 = n == 8 ? 1 : 2;
                if (bl) {
                    n3 = this.kRadius(nArray);
                    int n6 = this.kHeight(nArray);
                    Rectangle rectangle3 = (Rectangle)rectangle.clone();
                    rectangle3.grow(n3, n6 / 2);
                    rectangle2 = rectangle3.intersection(new Rectangle(imageProcessor.getWidth(), imageProcessor.getHeight()));
                    imageProcessor.setRoi(rectangle2);
                }
            }
            this.doFiltering(imageProcessor, nArray, n4, n2, f, i, blArray);
            if (blArray[0]) break;
            if (!this.isMultiStepFilter(n)) continue;
            imageProcessor.setRoi(rectangle);
            imageProcessor.setMask(imageProcessor2);
            n3 = n == 8 ? 2 : 1;
            this.doFiltering(imageProcessor, nArray, n3, n2, f, i, blArray);
            if (blArray[0]) break;
            if (!bl) continue;
            this.resetRoiBoundary(imageProcessor, rectangle, rectangle2);
        }
    }

    private void doFiltering(final ImageProcessor imageProcessor, final int[] nArray, final int n, final int n2, final float f, final int n3, final boolean[] blArray) {
        Rectangle rectangle = imageProcessor.getRoi();
        int n4 = imageProcessor.getWidth();
        Object object = imageProcessor.getPixels();
        int n5 = Math.min(rectangle.height, this.numThreads);
        int n6 = this.kHeight(nArray);
        int n7 = this.kRadius(nArray);
        final int n8 = rectangle.width + 2 * n7;
        final int n9 = n6 + (n5 > 1 ? 2 * n5 : 0);
        final float[] fArray = new float[n8 * n9];
        this.highestYinCache = Math.max(rectangle.y - n6 / 2, 0) - 1;
        final int[] nArray2 = new int[n5];
        Arrays.fill(nArray2, -1);
        nArray2[n5 - 1] = rectangle.y - 1;
        Thread[] threadArray = new Thread[n5];
        for (int i = n5 - 1; i > 0; --i) {
            final int n10 = i;
            Thread thread = new Thread(new Runnable(){

                public final void run() {
                    RankFilters.this.doFiltering(imageProcessor, nArray, fArray, n8, n9, n, n2, f, n3, nArray2, n10, blArray);
                }
            }, "RankFilters-" + i);
            thread.setPriority(Thread.currentThread().getPriority());
            thread.start();
            threadArray[n10] = thread;
        }
        this.doFiltering(imageProcessor, nArray, fArray, n8, n9, n, n2, f, n3, nArray2, 0, blArray);
        try {
            for (Thread thread : threadArray) {
                if (thread == null) continue;
                thread.join();
            }
        }
        catch (InterruptedException interruptedException) {
            blArray[0] = true;
        }
        this.showProgress(1.0, imageProcessor instanceof ColorProcessor);
        ++this.pass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void doFiltering(ImageProcessor imageProcessor, int[] nArray, float[] fArray, int n, int n2, int n3, int n4, float f, int n5, int[] nArray2, int n6, boolean[] blArray) {
        float f2;
        if (blArray[0]) return;
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        int n7 = imageProcessor.getWidth();
        int n8 = imageProcessor.getHeight();
        Rectangle rectangle = imageProcessor.getRoi();
        int n9 = this.kHeight(nArray);
        int n10 = this.kRadius(nArray);
        int n11 = this.kNPoints(nArray);
        int n12 = rectangle.x - n10;
        int n13 = rectangle.x + rectangle.width + n10;
        int[] nArray3 = this.makeCachePointers(nArray, n);
        int n14 = n12 < 0 ? -n12 : 0;
        int n15 = n13 > n7 ? n13 - n7 : 0;
        int n16 = n12 > 0 ? n12 : 0;
        int n17 = n13 < n7 ? n13 : n7;
        int n18 = n17 - n16;
        boolean bl = n3 == 1 || n3 == 2;
        boolean bl2 = bl || n3 == 5;
        boolean bl3 = n3 == 0 || n3 == 3;
        boolean bl4 = n3 == 4 || n3 == 5;
        double[] dArray = bl3 ? new double[2] : null;
        float[] fArray2 = (float[])(bl4 || n3 == 7 ? new float[n11] : null);
        float[] fArray3 = (float[])(bl4 || n3 == 7 ? new float[n11] : null);
        float f3 = f2 = n3 == 1 ? -1.0f : 1.0f;
        if (n3 == 5) {
            f2 = imageProcessor.isInvertedLut() == (n4 == 1) ? -1.0f : 1.0f;
        }
        boolean bl5 = n10 < 2;
        Object object = imageProcessor.getPixels();
        boolean bl6 = object instanceof float[];
        float f4 = bl6 ? Float.NaN : (float)imageProcessor.maxValue();
        float[] fArray4 = bl6 ? (float[])object : new float[rectangle.width];
        int n19 = nArray2.length;
        long l = System.currentTimeMillis();
        int n20 = n9 / 2 - n2;
        boolean bl7 = imageProcessor instanceof ColorProcessor;
        while (!blArray[0]) {
            int n21;
            long l2;
            boolean bl8;
            int n22;
            nArray2[n6] = n22 = this.arrayMax(nArray2) + 1;
            boolean bl9 = bl8 = n22 >= rectangle.y + rectangle.height;
            if (n19 > 1 && (this.threadWaiting || bl8)) {
                RankFilters rankFilters = this;
                // MONITORENTER : rankFilters
                this.notifyAll();
                // MONITOREXIT : rankFilters
            }
            if (bl8) {
                return;
            }
            if (n6 == 0 && (l2 = System.currentTimeMillis()) - l > 100L) {
                l = l2;
                this.showProgress((double)(n22 - rectangle.y) / (double)rectangle.height, bl7);
                if (Thread.currentThread().isInterrupted() || this.imp != null && IJ.escapePressed()) {
                    blArray[0] = true;
                    RankFilters rankFilters = this;
                    // MONITORENTER : rankFilters
                    this.notifyAll();
                    // MONITOREXIT : rankFilters
                    return;
                }
            }
            for (n21 = 0; n21 < nArray3.length; ++n21) {
                nArray3[n21] = (nArray3[n21] + n * (n22 - n20)) % fArray.length;
            }
            n20 = n22;
            if (n19 > 1 && n22 - (n21 = this.arrayMinNonNegative(nArray2)) + n9 > n2) {
                RankFilters rankFilters = this;
                // MONITORENTER : rankFilters
                do {
                    this.notifyAll();
                    this.threadWaiting = true;
                    try {
                        this.wait();
                        if (blArray[0]) {
                            // MONITOREXIT : rankFilters
                            return;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        blArray[0] = true;
                        this.notifyAll();
                        // MONITOREXIT : rankFilters
                        return;
                    }
                } while (n22 - (n21 = this.arrayMinNonNegative(nArray2)) + n9 > n2);
                this.threadWaiting = false;
                // MONITOREXIT : rankFilters
            }
            if (n19 == 1) {
                for (int i = n21 = n22 == rectangle.y ? Math.max(rectangle.y - n9 / 2, 0) : n22 + n9 / 2; i <= n22 + n9 / 2; ++i) {
                    RankFilters.readLineToCacheOrPad(object, n7, n8, rectangle.y, n16, n18, fArray, n, n2, n14, n15, n5, n9, i);
                }
            } else if (!this.copyingToCache || this.highestYinCache < n22 + n9 / 2) {
                float[] fArray5 = fArray;
                // MONITORENTER : fArray
                this.copyingToCache = true;
                while (this.highestYinCache < this.arrayMinNonNegative(nArray2) - n9 / 2 + n2 - 1) {
                    int n23 = this.highestYinCache + 1;
                    RankFilters.readLineToCacheOrPad(object, n7, n8, rectangle.y, n16, n18, fArray, n, n2, n14, n15, n5, n9, n23);
                    this.highestYinCache = n23;
                }
                this.copyingToCache = false;
                // MONITOREXIT : fArray5
            }
            int n24 = n * (n22 % n2) + n10;
            this.filterLine(fArray4, n7, fArray, nArray3, n11, n24, rectangle, n22, dArray, fArray2, fArray3, f2, f4, bl6, n3, bl5, bl3, bl, bl2);
            if (bl6) continue;
            RankFilters.writeLineToPixels(fArray4, object, rectangle.x + n22 * n7, rectangle.width, n5);
        }
    }

    private int arrayMax(int[] nArray) {
        int n = Integer.MIN_VALUE;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= n) continue;
            n = nArray[i];
        }
        return n;
    }

    private int arrayMinNonNegative(int[] nArray) {
        int n = Integer.MAX_VALUE;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] < 0 || nArray[i] >= n) continue;
            n = nArray[i];
        }
        return n;
    }

    private void filterLine(float[] fArray, int n, float[] fArray2, int[] nArray, int n2, int n3, Rectangle rectangle, int n4, double[] dArray, float[] fArray3, float[] fArray4, float f, float f2, boolean bl, int n5, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        int n6 = bl ? rectangle.x + n4 * n : 0;
        float f3 = 0.0f;
        float f4 = Float.isNaN(fArray2[n3]) ? 0.0f : fArray2[n3];
        boolean bl6 = true;
        int n7 = 0;
        while (n7 < rectangle.width) {
            block23: {
                float f5;
                block24: {
                    block25: {
                        block21: {
                            block22: {
                                if (!bl6) break block21;
                                bl6 = bl2;
                                if (bl5) {
                                    f3 = RankFilters.getAreaMax(fArray2, n7, nArray, 0, -3.4028235E38f, f);
                                }
                                if (!bl4) break block22;
                                fArray[n6] = f3 * f;
                                break block23;
                            }
                            if (bl3) {
                                RankFilters.getAreaSums(fArray2, n7, nArray, dArray);
                            }
                            break block24;
                        }
                        if (!bl5) break block25;
                        f5 = RankFilters.getSideMax(fArray2, n7, nArray, true, f);
                        if (f5 >= f3) {
                            f3 = f5;
                        } else {
                            float f6 = RankFilters.getSideMax(fArray2, n7, nArray, false, f);
                            if (f6 >= f3) {
                                f3 = RankFilters.getAreaMax(fArray2, n7, nArray, 1, f5, f);
                            }
                        }
                        if (!bl4) break block24;
                        fArray[n6] = f3 * f;
                        break block23;
                    }
                    if (bl3) {
                        RankFilters.addSideSums(fArray2, n7, nArray, dArray);
                        if (Double.isNaN(dArray[0])) {
                            bl6 = true;
                        }
                    }
                }
                if (bl3) {
                    if (n5 == 0) {
                        fArray[n6] = (float)(dArray[0] / (double)n2);
                    } else {
                        f5 = (float)((dArray[1] - dArray[0] * dArray[0] / (double)n2) / (double)n2);
                        if (f5 > f2) {
                            f5 = f2;
                        }
                        fArray[n6] = f5;
                    }
                } else if (n5 == 4) {
                    fArray[n6] = f4 = RankFilters.getMedian(fArray2, n7, nArray, fArray3, fArray4, n2, f4);
                } else if (n5 == 5) {
                    f5 = fArray2[n3 + n7];
                    if ((double)(f5 * f) + this.threshold < (double)f3 && (double)(f5 * f) + this.threshold < (double)((f4 = RankFilters.getMedian(fArray2, n7, nArray, fArray3, fArray4, n2, f4)) * f)) {
                        f5 = f4;
                    }
                    fArray[n6] = f5;
                } else if (n5 == 7) {
                    if (Float.isNaN(fArray[n6])) {
                        fArray[n6] = RankFilters.getNaNAwareMedian(fArray2, n7, nArray, fArray3, fArray4, n2, f4);
                    } else {
                        f4 = fArray[n6];
                    }
                }
            }
            ++n7;
            ++n6;
        }
    }

    private static void readLineToCacheOrPad(Object object, int n, int n2, int n3, int n4, int n5, float[] fArray, int n6, int n7, int n8, int n9, int n10, int n11, int n12) {
        int n13 = n12 % n7;
        if (n12 < n2) {
            RankFilters.readLineToCache(object, n12 * n, n4, n5, fArray, n13 * n6, n8, n9, n10);
            if (n12 == 0) {
                for (int i = n3 - n11 / 2; i < 0; ++i) {
                    int n14 = n7 + i;
                    System.arraycopy(fArray, 0, fArray, n14 * n6, n6);
                }
            }
        } else {
            System.arraycopy(fArray, n6 * ((n2 - 1) % n7), fArray, n13 * n6, n6);
        }
    }

    private static void readLineToCache(Object object, int n, int n2, int n3, float[] fArray, int n4, int n5, int n6, int n7) {
        int n8;
        int n9;
        int n10;
        Object[] objectArray;
        if (object instanceof byte[]) {
            objectArray = (byte[])object;
            n10 = n + n2;
            n9 = n4 + n5;
            while (n10 < n + n2 + n3) {
                fArray[n9] = objectArray[n10] & 0xFF;
                ++n10;
                ++n9;
            }
        } else if (object instanceof short[]) {
            objectArray = (short[])object;
            n10 = n + n2;
            n9 = n4 + n5;
            while (n10 < n + n2 + n3) {
                fArray[n9] = objectArray[n10] & 0xFFFF;
                ++n10;
                ++n9;
            }
        } else if (object instanceof float[]) {
            System.arraycopy(object, n + n2, fArray, n4 + n5, n3);
        } else {
            objectArray = (int[])object;
            n10 = 16 - 8 * n7;
            n9 = 255 << n10;
            int n11 = n + n2;
            int n12 = n4 + n5;
            while (n11 < n + n2 + n3) {
                fArray[n12] = (objectArray[n11] & n9) >> n10;
                ++n11;
                ++n12;
            }
        }
        for (n8 = n4; n8 < n4 + n5; ++n8) {
            fArray[n8] = fArray[n4 + n5];
        }
        for (n8 = n4 + n5 + n3; n8 < n4 + n5 + n3 + n6; ++n8) {
            fArray[n8] = fArray[n4 + n5 + n3 - 1];
        }
    }

    private static void writeLineToPixels(float[] fArray, Object object, int n, int n2, int n3) {
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            int n4 = 0;
            int n5 = n;
            while (n4 < n2) {
                byArray[n5] = (byte)((int)(fArray[n4] + 0.5f) & 0xFF);
                ++n4;
                ++n5;
            }
        } else if (object instanceof short[]) {
            short[] sArray = (short[])object;
            int n6 = 0;
            int n7 = n;
            while (n6 < n2) {
                sArray[n7] = (short)((int)(fArray[n6] + 0.5f) & 0xFFFF);
                ++n6;
                ++n7;
            }
        } else {
            int[] nArray = (int[])object;
            int n8 = 16 - 8 * n3;
            int n9 = 0xFFFFFFFF ^ 255 << n8;
            int n10 = 0;
            int n11 = n;
            while (n10 < n2) {
                nArray[n11] = nArray[n11] & n9 | (int)(fArray[n10] + 0.5f) << n8;
                ++n10;
                ++n11;
            }
        }
    }

    private static float getAreaMax(float[] fArray, int n, int[] nArray, int n2, float f, float f2) {
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = nArray[i++] + n; j <= nArray[i] + n - n2; ++j) {
                float f3 = fArray[j] * f2;
                if (!(f < f3)) continue;
                f = f3;
            }
        }
        return f;
    }

    private static float getSideMax(float[] fArray, int n, int[] nArray, boolean bl, float f) {
        int n2;
        float f2 = -3.4028235E38f;
        if (!bl) {
            --n;
        }
        int n3 = n2 = bl ? 1 : 0;
        while (n2 < nArray.length) {
            float f3 = fArray[n + nArray[n2]] * f;
            if (f2 < f3) {
                f2 = f3;
            }
            n2 += 2;
        }
        return f2;
    }

    private static void getAreaSums(float[] fArray, int n, int[] nArray, double[] dArray) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = nArray[i++] + n; j <= nArray[i] + n; ++j) {
                float f = fArray[j];
                d += (double)f;
                d2 += (double)(f * f);
            }
        }
        dArray[0] = d;
        dArray[1] = d2;
    }

    private static void addSideSums(float[] fArray, int n, int[] nArray, double[] dArray) {
        double d = 0.0;
        double d2 = 0.0;
        int n2 = 0;
        while (n2 < nArray.length) {
            float f = fArray[nArray[n2++] + (n - 1)];
            d -= (double)f;
            d2 -= (double)(f * f);
            f = fArray[nArray[n2++] + n];
            d += (double)f;
            d2 += (double)(f * f);
        }
        dArray[0] = dArray[0] + d;
        dArray[1] = dArray[1] + d2;
    }

    private static float getMedian(float[] fArray, int n, int[] nArray, float[] fArray2, float[] fArray3, int n2, float f) {
        int n3;
        int n4 = 0;
        int n5 = 0;
        for (n3 = 0; n3 < nArray.length; ++n3) {
            for (int i = nArray[n3++] + n; i <= nArray[n3] + n; ++i) {
                float f2 = fArray[i];
                if (f2 > f) {
                    fArray2[n4] = f2;
                    ++n4;
                    continue;
                }
                if (!(f2 < f)) continue;
                fArray3[n5] = f2;
                ++n5;
            }
        }
        n3 = n2 / 2;
        if (n4 > n3) {
            return RankFilters.findNthLowestNumber(fArray2, n4, n4 - n3 - 1);
        }
        if (n5 > n3) {
            return RankFilters.findNthLowestNumber(fArray3, n5, n3);
        }
        return f;
    }

    private static float getNaNAwareMedian(float[] fArray, int n, int[] nArray, float[] fArray2, float[] fArray3, int n2, float f) {
        int n3;
        int n4 = 0;
        int n5 = 0;
        for (n3 = 0; n3 < nArray.length; ++n3) {
            for (int i = nArray[n3++] + n; i <= nArray[n3] + n; ++i) {
                float f2 = fArray[i];
                if (Float.isNaN(f2)) {
                    --n2;
                    continue;
                }
                if (f2 > f) {
                    fArray2[n4] = f2;
                    ++n4;
                    continue;
                }
                if (!(f2 < f)) continue;
                fArray3[n5] = f2;
                ++n5;
            }
        }
        if (n2 == 0) {
            return Float.NaN;
        }
        n3 = n2 / 2;
        if (n4 > n3) {
            return RankFilters.findNthLowestNumber(fArray2, n4, n4 - n3 - 1);
        }
        if (n5 > n3) {
            return RankFilters.findNthLowestNumber(fArray3, n5, n3);
        }
        return f;
    }

    public static final float findNthLowestNumber(float[] fArray, int n, int n2) {
        int n3 = 0;
        int n4 = n - 1;
        float f = fArray[n2];
        while (n3 < n4) {
            int n5 = n3;
            int n6 = n4;
            while (true) {
                if (fArray[n5] < f) {
                    ++n5;
                    continue;
                }
                while (f < fArray[n6]) {
                    --n6;
                }
                float f2 = fArray[n6];
                fArray[n6] = fArray[n5];
                fArray[n5] = f2;
                if (--n6 < n2 || ++n5 > n2) break;
            }
            if (n6 < n2) {
                n3 = n5;
            }
            if (n2 < n5) {
                n4 = n6;
            }
            f = fArray[n2];
        }
        return f;
    }

    private void resetRoiBoundary(ImageProcessor imageProcessor, Rectangle rectangle, Rectangle rectangle2) {
        int n = imageProcessor.getWidth();
        Object object = imageProcessor.getPixels();
        Object object2 = imageProcessor.getSnapshotPixels();
        int n2 = rectangle2.y;
        int n3 = rectangle2.x + n2 * n;
        while (n2 < rectangle.y) {
            System.arraycopy(object2, n3, object, n3, rectangle2.width);
            ++n2;
            n3 += n;
        }
        n2 = rectangle.x - rectangle2.x;
        n3 = rectangle2.x + rectangle2.width - (rectangle.x + rectangle.width);
        int n4 = rectangle.y;
        int n5 = rectangle2.x + n4 * n;
        int n6 = rectangle.x + rectangle.width + n4 * n;
        while (n4 < rectangle.y + rectangle.height) {
            if (n2 > 0) {
                System.arraycopy(object2, n5, object, n5, n2);
            }
            if (n3 > 0) {
                System.arraycopy(object2, n6, object, n6, n3);
            }
            ++n4;
            n5 += n;
            n6 += n;
        }
        n4 = rectangle.y + rectangle.height;
        n5 = rectangle2.x + n4 * n;
        while (n4 < rectangle2.y + rectangle2.height) {
            System.arraycopy(object2, n5, object, n5, rectangle2.width);
            ++n4;
            n5 += n;
        }
    }

    public void makeKernel(double d) {
        this.radius = d;
    }

    protected int[] makeLineRadii(double d) {
        if (d >= 1.5 && d < 1.75) {
            d = 1.75;
        } else if (d >= 2.5 && d < 2.85) {
            d = 2.85;
        }
        int n = (int)(d * d) + 1;
        int n2 = (int)Math.sqrt((double)n + 1.0E-10);
        int n3 = 2 * n2 + 1;
        int[] nArray = new int[2 * n3 + 2];
        nArray[2 * n2] = -n2;
        nArray[2 * n2 + 1] = n2;
        int n4 = 2 * n2 + 1;
        for (int i = 1; i <= n2; ++i) {
            int n5 = (int)Math.sqrt((double)(n - i * i) + 1.0E-10);
            nArray[2 * (n2 - i)] = -n5;
            nArray[2 * (n2 - i) + 1] = n5;
            nArray[2 * (n2 + i)] = -n5;
            nArray[2 * (n2 + i) + 1] = n5;
            n4 += 4 * n5 + 2;
        }
        nArray[nArray.length - 2] = n4;
        nArray[nArray.length - 1] = n2;
        return nArray;
    }

    private int kHeight(int[] nArray) {
        return (nArray.length - 2) / 2;
    }

    private int kRadius(int[] nArray) {
        return nArray[nArray.length - 1];
    }

    private int kNPoints(int[] nArray) {
        return nArray[nArray.length - 2];
    }

    private int[] makeCachePointers(int[] nArray, int n) {
        int n2 = this.kRadius(nArray);
        int n3 = this.kHeight(nArray);
        int[] nArray2 = new int[2 * n3];
        for (int i = 0; i < n3; ++i) {
            nArray2[2 * i] = i * n + n2 + nArray[2 * i];
            nArray2[2 * i + 1] = i * n + n2 + nArray[2 * i + 1];
        }
        return nArray2;
    }

    void showMasks() {
        int n = 150;
        int n2 = 150;
        ImageStack imageStack = new ImageStack(n, n2);
        for (double d = 0.5; d < 50.0; d += 0.5) {
            FloatProcessor floatProcessor = new FloatProcessor(n, n2, new int[n * n2]);
            float[] fArray = (float[])((ImageProcessor)floatProcessor).getPixels();
            int[] nArray = this.makeLineRadii(d);
            int n3 = this.kHeight(nArray);
            int n4 = this.kRadius(nArray);
            int n5 = n2 / 2 - n3 / 2;
            int n6 = 0;
            int n7 = n5;
            while (n6 < n3) {
                int n8 = n / 2 + nArray[2 * n6];
                int n9 = n8 + n7 * n;
                while (n8 <= n / 2 + nArray[2 * n6 + 1]) {
                    fArray[n9] = 1.0f;
                    ++n8;
                    ++n9;
                }
                ++n6;
                ++n7;
            }
            imageStack.addSlice("radius=" + d + ", size=" + (2 * n4 + 1), floatProcessor);
        }
        new ImagePlus("Masks", imageStack).show();
    }

    public void setNPasses(int n) {
        this.nPasses = n;
        this.pass = 0;
    }

    private void showProgress(double d, boolean bl) {
        int n = bl ? this.nPasses * 3 : this.nPasses;
        d = (double)this.pass / (double)n + d / (double)n;
        IJ.showProgress(d);
    }
}

