/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.Undo;
import ij.WindowManager;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.Line;
import ij.gui.Roi;
import ij.plugin.filter.ExtendedPlugInFilter;
import ij.plugin.filter.PlugInFilter;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.AWTEvent;
import java.awt.Checkbox;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Hashtable;

public class PlugInFilterRunner
implements Runnable,
DialogListener {
    private String command;
    private Object theFilter;
    private ImagePlus imp;
    private int flags;
    private boolean snapshotDone;
    private boolean previewCheckboxOn;
    private boolean bgPreviewOn;
    private boolean bgKeepPreview;
    private Thread previewThread;
    private GenericDialog gd;
    private Checkbox previewCheckbox;
    private long previewTime;
    private boolean ipChanged;
    private int processedAsPreview;
    private Hashtable slicesForThread;
    private Hashtable roisForThread;
    Hashtable sliceForThread = new Hashtable();
    private int nPasses;
    private int pass;
    private boolean doStack;

    public PlugInFilterRunner(Object object, String string, String string2) {
        Object object2;
        int n;
        this.theFilter = object;
        this.command = string;
        this.imp = WindowManager.getCurrentImage();
        this.flags = ((PlugInFilter)object).setup(string2, this.imp);
        if ((this.flags & 0x1000) != 0) {
            return;
        }
        if (!this.checkImagePlus(this.imp, this.flags, string)) {
            return;
        }
        if ((this.flags & 0x200) != 0) {
            this.imp = null;
        }
        Roi roi = null;
        if (this.imp != null) {
            roi = this.imp.getRoi();
            if (roi != null) {
                roi.endPaste();
            }
            if (!this.imp.lock()) {
                return;
            }
            int n2 = this.nPasses = (this.flags & 0x2000) != 0 ? this.imp.getProcessor().getNChannels() : 1;
        }
        if (object instanceof ExtendedPlugInFilter) {
            this.flags = ((ExtendedPlugInFilter)object).showDialog(this.imp, string, this);
            if (this.snapshotDone) {
                Undo.setup(1, this.imp);
            }
            int n3 = n = (this.flags & 0x1000000) != 0 ? 1 : 0;
            if (n != 0 && this.imp != null && this.previewThread != null && this.ipChanged && this.previewCheckbox != null && this.previewCheckboxOn) {
                this.bgKeepPreview = true;
                this.waitForPreviewDone();
                this.processedAsPreview = this.imp.getCurrentSlice();
            } else {
                this.killPreview();
                this.previewTime = 0L;
            }
        }
        if ((this.flags & 0x1000) != 0) {
            if (this.imp != null) {
                this.imp.unlock();
            }
            return;
        }
        if (this.imp == null) {
            ((PlugInFilter)object).run(null);
            return;
        }
        n = this.imp.getStackSize();
        if ((this.flags & 0x40000) != 0) {
            this.flags &= 0xFFFF7FFF;
        }
        this.doStack = n > 1 && (this.flags & 0x20) != 0;
        this.imp.startTiming();
        if (this.doStack || this.processedAsPreview == 0) {
            IJ.showStatus(string + (this.doStack ? " (Stack)..." : "..."));
            object2 = this.imp.getProcessor();
            this.pass = 0;
            if (!this.doStack) {
                FloatProcessor floatProcessor = null;
                this.prepareProcessor((ImageProcessor)object2, this.imp);
                this.announceSliceNumber(this.imp.getCurrentSlice());
                if (object instanceof ExtendedPlugInFilter) {
                    ((ExtendedPlugInFilter)object).setNPasses(this.nPasses);
                }
                if ((this.flags & 0x80) == 0) {
                    boolean bl;
                    boolean bl2 = bl = Prefs.disableUndo || (this.flags & 0x100) != 0;
                    if (!bl) {
                        ((ImageProcessor)object2).snapshot();
                        this.snapshotDone = true;
                    }
                }
                this.processOneImage((ImageProcessor)object2, floatProcessor, this.snapshotDone);
                if ((this.flags & 0x80) == 0) {
                    if (this.snapshotDone) {
                        Undo.setup(1, this.imp);
                    } else {
                        Undo.reset();
                    }
                }
                if ((this.flags & 0x80) == 0 && (this.flags & 0x20000) == 0) {
                    ((ImageProcessor)object2).resetBinaryThreshold();
                }
            } else {
                Undo.reset();
                IJ.resetEscape();
                int n4 = this.processedAsPreview != 0 ? n - 1 : n;
                this.nPasses *= n4;
                if (object instanceof ExtendedPlugInFilter) {
                    ((ExtendedPlugInFilter)object).setNPasses(this.nPasses);
                }
                int n5 = 1;
                if ((this.flags & 0x8000) != 0) {
                    n5 = Prefs.getThreads();
                    if (n5 > n4) {
                        n5 = n4;
                    }
                    if (n5 > 1) {
                        this.slicesForThread = new Hashtable(n5 - 1);
                    }
                }
                int n6 = 1;
                for (int i = 1; i < n5; ++i) {
                    int n7 = n4 * i / n5;
                    if (this.processedAsPreview != 0 && this.processedAsPreview <= n7) {
                        ++n7;
                    }
                    Thread thread = new Thread((Runnable)this, string + " " + n6 + "-" + n7);
                    this.slicesForThread.put(thread, new int[]{n6, n7});
                    thread.start();
                    n6 = n7 + 1;
                }
                this.processStack(n6, n);
                if (this.slicesForThread != null) {
                    while (this.slicesForThread.size() > 0) {
                        Thread thread = (Thread)this.slicesForThread.keys().nextElement();
                        try {
                            thread.join();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        this.slicesForThread.remove(thread);
                    }
                }
            }
        }
        if ((this.flags & 0x10000) != 0 && !IJ.escapePressed()) {
            ((PlugInFilter)object).setup("final", this.imp);
        }
        if (IJ.escapePressed()) {
            IJ.showStatus(string + " INTERRUPTED");
            IJ.showProgress(1, 1);
        } else {
            IJ.showTime(this.imp, this.imp.getStartTime() - this.previewTime, string + ": ", this.doStack ? n : 1);
        }
        IJ.showProgress(1.0);
        if (this.ipChanged) {
            this.imp.changes = true;
            this.imp.updateAndDraw();
        }
        if ((object2 = this.imp.getWindow()) != null) {
            ((ImageWindow)object2).running = false;
            ((ImageWindow)object2).running2 = false;
        }
        this.imp.unlock();
    }

    private void processStack(int n, int n2) {
        ImageStack imageStack = this.imp.getStack();
        ImageProcessor imageProcessor = imageStack.getProcessor(n);
        this.prepareProcessor(imageProcessor, this.imp);
        imageProcessor.setLineWidth(Line.getWidth());
        FloatProcessor floatProcessor = null;
        int n3 = this.imp.getNSlices();
        for (int i = n; i <= n2; ++i) {
            if (i == this.processedAsPreview) continue;
            this.announceSliceNumber(i);
            imageProcessor.setPixels(imageStack.getPixels(i));
            imageProcessor.setSliceNumber(i);
            this.processOneImage(imageProcessor, floatProcessor, false);
            if (!IJ.escapePressed()) continue;
            IJ.beep();
            break;
        }
    }

    private void prepareProcessor(ImageProcessor imageProcessor, ImagePlus imagePlus) {
        ImageProcessor imageProcessor2 = imagePlus.getMask();
        Roi roi = imagePlus.getRoi();
        if (roi != null && roi.isArea()) {
            imageProcessor.setRoi(roi);
        } else {
            imageProcessor.setRoi((Roi)null);
        }
        if (imagePlus.getStackSize() > 1) {
            ImageProcessor imageProcessor3 = imagePlus.getProcessor();
            double d = imageProcessor3.getMinThreshold();
            double d2 = imageProcessor3.getMaxThreshold();
            double d3 = imageProcessor.getMinThreshold();
            double d4 = imageProcessor.getMaxThreshold();
            if (d != -808080.0 && (d != d3 || d2 != d4)) {
                imageProcessor.setThreshold(d, d2, 2);
            }
        }
    }

    private void processOneImage(ImageProcessor imageProcessor, FloatProcessor floatProcessor, boolean bl) {
        boolean bl2;
        if ((this.flags & 0x40000) != 0) {
            this.processImageUsingThreads(imageProcessor, floatProcessor, bl);
            return;
        }
        Thread thread = Thread.currentThread();
        boolean bl3 = (this.flags & 0x2000) != 0 && !(imageProcessor instanceof FloatProcessor);
        boolean bl4 = bl2 = (this.flags & 0x40) != 0 && imageProcessor.getMask() != null;
        if (!bl && (bl2 || (this.flags & 0x4000) != 0 && !bl3)) {
            imageProcessor.snapshot();
            this.snapshotDone = true;
        }
        if (bl3) {
            for (int i = 0; i < imageProcessor.getNChannels(); ++i) {
                floatProcessor = imageProcessor.toFloat(i, floatProcessor);
                floatProcessor.setSliceNumber(imageProcessor.getSliceNumber());
                if (thread.isInterrupted()) {
                    return;
                }
                if ((this.flags & 0x4000) != 0) {
                    floatProcessor.snapshot();
                }
                if (this.doStack) {
                    IJ.showProgress((double)this.pass / (double)this.nPasses);
                }
                ((PlugInFilter)this.theFilter).run(floatProcessor);
                if (thread.isInterrupted()) {
                    return;
                }
                ++this.pass;
                if ((this.flags & 0x80) != 0) continue;
                this.ipChanged = true;
                imageProcessor.setPixels(i, floatProcessor);
            }
        } else {
            if ((this.flags & 0x80) == 0) {
                this.ipChanged = true;
            }
            if (this.doStack) {
                IJ.showProgress((double)this.pass / (double)this.nPasses);
            }
            ((PlugInFilter)this.theFilter).run(imageProcessor);
            ++this.pass;
        }
        if (thread.isInterrupted()) {
            return;
        }
        if (bl2) {
            imageProcessor.reset(imageProcessor.getMask());
        }
    }

    private void processImageUsingThreads(ImageProcessor imageProcessor, FloatProcessor floatProcessor, boolean bl) {
        boolean bl2;
        Thread thread = Thread.currentThread();
        boolean bl3 = (this.flags & 0x2000) != 0 && !(imageProcessor instanceof FloatProcessor);
        boolean bl4 = bl2 = (this.flags & 0x40) != 0 && imageProcessor.getMask() != null;
        if (!bl && (bl2 || (this.flags & 0x4000) != 0 && !bl3)) {
            imageProcessor.snapshot();
            this.snapshotDone = true;
        }
        if (bl3) {
            for (int i = 0; i < imageProcessor.getNChannels(); ++i) {
                floatProcessor = imageProcessor.toFloat(i, floatProcessor);
                floatProcessor.setSliceNumber(imageProcessor.getSliceNumber());
                if (thread.isInterrupted()) {
                    return;
                }
                if ((this.flags & 0x4000) != 0) {
                    floatProcessor.snapshot();
                }
                if (this.doStack) {
                    IJ.showProgress((double)this.pass / (double)this.nPasses);
                }
                this.processChannelUsingThreads(floatProcessor);
                if (thread.isInterrupted()) {
                    return;
                }
                if ((this.flags & 0x80) != 0) continue;
                this.ipChanged = true;
                imageProcessor.setPixels(i, floatProcessor);
            }
        } else {
            if ((this.flags & 0x80) == 0) {
                this.ipChanged = true;
            }
            if (this.doStack) {
                IJ.showProgress((double)this.pass / (double)this.nPasses);
            }
            this.processChannelUsingThreads(imageProcessor);
        }
        if (thread.isInterrupted()) {
            return;
        }
        if (bl2) {
            imageProcessor.reset(imageProcessor.getMask());
        }
    }

    private void processChannelUsingThreads(ImageProcessor imageProcessor) {
        ImageProcessor imageProcessor2 = imageProcessor.getMask();
        Rectangle rectangle = imageProcessor.getRoi();
        int n = Prefs.getThreads();
        if (n > rectangle.height) {
            n = rectangle.height;
        }
        if (n > 1) {
            this.roisForThread = new Hashtable(n - 1);
        }
        int n2 = rectangle.y;
        for (int i = 1; i < n; ++i) {
            int n3 = rectangle.y + rectangle.height * i / n - 1;
            Thread thread = new Thread((Runnable)this, this.command + " " + n2 + "-" + n3);
            Rectangle rectangle2 = new Rectangle(rectangle.x, n2, rectangle.width, n3 - n2 + 1);
            this.roisForThread.put(thread, this.duplicateProcessor(imageProcessor, rectangle2));
            thread.start();
            n2 = n3 + 1;
        }
        imageProcessor.setRoi(new Rectangle(rectangle.x, n2, rectangle.width, rectangle.y + rectangle.height - n2));
        ((PlugInFilter)this.theFilter).run(imageProcessor);
        ++this.pass;
        if (this.roisForThread != null) {
            while (this.roisForThread.size() > 0) {
                Thread thread = (Thread)this.roisForThread.keys().nextElement();
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.roisForThread.remove(thread);
            }
        }
        this.roisForThread = null;
        imageProcessor.setMask(imageProcessor2);
        imageProcessor.setRoi(rectangle);
    }

    ImageProcessor duplicateProcessor(ImageProcessor imageProcessor, Rectangle rectangle) {
        ImageProcessor imageProcessor2 = (ImageProcessor)imageProcessor.clone();
        imageProcessor2.setRoi(rectangle);
        return imageProcessor2;
    }

    private boolean checkImagePlus(ImagePlus imagePlus, int n, String string) {
        boolean bl;
        boolean bl2 = bl = (n & 0x200) == 0;
        if (bl && imagePlus == null) {
            IJ.noImage();
            return false;
        }
        if (bl) {
            if (imagePlus.getProcessor() == null) {
                PlugInFilterRunner.wrongType(n, string);
                return false;
            }
            int n2 = imagePlus.getType();
            switch (n2) {
                case 0: {
                    if ((n & 1) != 0) break;
                    PlugInFilterRunner.wrongType(n, string);
                    return false;
                }
                case 3: {
                    if ((n & 2) != 0) break;
                    PlugInFilterRunner.wrongType(n, string);
                    return false;
                }
                case 1: {
                    if ((n & 4) != 0) break;
                    PlugInFilterRunner.wrongType(n, string);
                    return false;
                }
                case 2: {
                    if ((n & 8) != 0) break;
                    PlugInFilterRunner.wrongType(n, string);
                    return false;
                }
                case 4: {
                    if ((n & 0x10) != 0) break;
                    PlugInFilterRunner.wrongType(n, string);
                    return false;
                }
            }
            if ((n & 0x400) != 0 && imagePlus.getRoi() == null) {
                IJ.error(string, "This command requires a selection");
                return false;
            }
            if ((n & 0x800) != 0 && imagePlus.getStackSize() == 1) {
                IJ.error(string, "This command requires a stack");
                return false;
            }
        }
        return true;
    }

    static void wrongType(int n, String string) {
        String string2 = "\"" + string + "\" requires an image of type:\n \n";
        if ((n & 1) != 0) {
            string2 = string2 + "\t8-bit grayscale\n";
        }
        if ((n & 2) != 0) {
            string2 = string2 + "\t8-bit color\n";
        }
        if ((n & 4) != 0) {
            string2 = string2 + "\t16-bit grayscale\n";
        }
        if ((n & 8) != 0) {
            string2 = string2 + "\t32-bit (float) grayscale\n";
        }
        if ((n & 0x10) != 0) {
            string2 = string2 + "\tRGB color\n";
        }
        IJ.error(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void announceSliceNumber(int n) {
        Hashtable hashtable = this.sliceForThread;
        synchronized (hashtable) {
            Integer n2 = new Integer(n);
            this.sliceForThread.put(Thread.currentThread(), n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSliceNumber() {
        Hashtable hashtable = this.sliceForThread;
        synchronized (hashtable) {
            Integer n = (Integer)this.sliceForThread.get(Thread.currentThread());
            return n == null ? -1 : n;
        }
    }

    public void run() {
        block9: {
            Thread thread = Thread.currentThread();
            try {
                if (thread == this.previewThread) {
                    this.runPreview();
                } else if (this.roisForThread != null && this.roisForThread.containsKey(thread)) {
                    ImageProcessor imageProcessor = (ImageProcessor)this.roisForThread.get(thread);
                    ((PlugInFilter)this.theFilter).run(imageProcessor);
                    imageProcessor.setPixels(null);
                    imageProcessor.setSnapshotPixels(null);
                } else if (this.slicesForThread != null && this.slicesForThread.containsKey(thread)) {
                    int[] nArray = (int[])this.slicesForThread.get(thread);
                    this.processStack(nArray[0], nArray[1]);
                } else {
                    IJ.error("PlugInFilterRunner internal error:\nunsolicited background thread");
                }
            }
            catch (Exception exception) {
                String string;
                if (thread == this.previewThread) {
                    this.gd.previewRunning(false);
                    IJ.wait(100);
                    this.previewCheckbox.setState(false);
                    this.bgPreviewOn = false;
                    this.previewThread = null;
                }
                if ((string = "" + exception).indexOf("Macro canceled") != -1) break block9;
                IJ.beep();
                IJ.log("ERROR: " + string + "\nin " + thread.getName() + "\nat " + exception.getStackTrace()[0] + "\nfrom " + exception.getStackTrace()[1]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runPreview() {
        if (IJ.debugMode) {
            IJ.log("preview thread started; imp=" + this.imp.getTitle());
        }
        Thread thread = Thread.currentThread();
        ImageProcessor imageProcessor = this.imp.getProcessor();
        Roi roi = this.imp.getRoi();
        FloatProcessor floatProcessor = null;
        this.prepareProcessor(imageProcessor, this.imp);
        this.announceSliceNumber(this.imp.getCurrentSlice());
        if (!this.snapshotDone && (this.flags & 0x80) == 0) {
            imageProcessor.snapshot();
            this.snapshotDone = true;
        }
        boolean bl = false;
        while (this.bgPreviewOn) {
            if (this.previewCheckboxOn) {
                this.gd.previewRunning(true);
            }
            if (this.imp.getRoi() != roi) {
                this.imp.setRoi(roi);
                if (roi != null && roi.isArea()) {
                    imageProcessor.setRoi(roi);
                } else {
                    imageProcessor.setRoi((Roi)null);
                }
            }
            if (this.ipChanged) {
                imageProcessor.reset();
            }
            this.ipChanged = false;
            bl = false;
            long l = System.currentTimeMillis();
            this.pass = 0;
            if (this.theFilter instanceof ExtendedPlugInFilter) {
                ((ExtendedPlugInFilter)this.theFilter).setNPasses(this.nPasses);
            }
            if (!thread.isInterrupted()) {
                this.processOneImage(imageProcessor, floatProcessor, true);
                IJ.showProgress(1.0);
                if (!thread.isInterrupted()) {
                    bl = true;
                    this.previewTime = System.currentTimeMillis() - l;
                    this.imp.updateAndDraw();
                    if (IJ.debugMode) {
                        IJ.log("preview processing done");
                    }
                }
            }
            this.gd.previewRunning(false);
            IJ.showStatus("");
            PlugInFilterRunner plugInFilterRunner = this;
            synchronized (plugInFilterRunner) {
                if (!this.bgPreviewOn) {
                    break;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    bl = false;
                }
            }
        }
        if (thread.isInterrupted()) {
            bl = false;
        }
        if (!bl || !this.bgKeepPreview) {
            this.imp.setRoi(roi);
            if (this.ipChanged) {
                imageProcessor.reset();
                this.ipChanged = false;
            }
        }
        this.imp.updateAndDraw();
        this.sliceForThread.remove(thread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killPreview() {
        if (this.previewThread == null) {
            return;
        }
        PlugInFilterRunner plugInFilterRunner = this;
        synchronized (plugInFilterRunner) {
            this.previewThread.interrupt();
            this.bgPreviewOn = false;
            if (this.roisForThread != null) {
                Enumeration enumeration = this.roisForThread.keys();
                while (enumeration.hasMoreElements()) {
                    Thread thread = (Thread)enumeration.nextElement();
                    thread.interrupt();
                }
            }
        }
        this.waitForPreviewDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForPreviewDone() {
        if (this.previewThread.isAlive()) {
            try {
                this.previewThread.setPriority(Thread.currentThread().getPriority());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        PlugInFilterRunner plugInFilterRunner = this;
        synchronized (plugInFilterRunner) {
            this.bgPreviewOn = false;
            this.notify();
        }
        try {
            this.previewThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.previewThread = null;
    }

    public void setDialog(GenericDialog genericDialog) {
        if (genericDialog != null && this.imp != null) {
            this.previewCheckbox = genericDialog.getPreviewCheckbox();
            if (this.previewCheckbox != null) {
                genericDialog.addDialogListener(this);
                this.gd = genericDialog;
            }
        }
    }

    public boolean dialogItemChanged(GenericDialog genericDialog, AWTEvent aWTEvent) {
        if (this.previewCheckbox == null || this.imp == null) {
            return true;
        }
        this.previewCheckboxOn = this.previewCheckbox.getState();
        if (this.previewCheckboxOn && this.previewThread == null) {
            this.bgPreviewOn = true;
            this.previewThread = new Thread((Runnable)this, this.command + " Preview");
            int n = Thread.currentThread().getPriority() - 2;
            if (n < 1) {
                n = 1;
            }
            this.previewThread.setPriority(n);
            this.previewThread.start();
            if (IJ.debugMode) {
                IJ.log(this.command + " Preview thread was started");
            }
            return true;
        }
        if (this.previewThread != null) {
            if (!this.previewCheckboxOn) {
                this.killPreview();
                return true;
            }
            this.previewThread.interrupt();
        }
        return true;
    }
}

