/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.LookUpTable;
import ij.Macro;
import ij.Prefs;
import ij.Undo;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.Overlay;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.Wand;
import ij.macro.Interpreter;
import ij.measure.Calibration;
import ij.measure.Measurements;
import ij.measure.ResultsTable;
import ij.plugin.filter.Analyzer;
import ij.plugin.filter.PlugInFilter;
import ij.plugin.frame.RoiManager;
import ij.process.ByteProcessor;
import ij.process.ByteStatistics;
import ij.process.ColorProcessor;
import ij.process.ColorStatistics;
import ij.process.FloatProcessor;
import ij.process.FloatStatistics;
import ij.process.FloodFiller;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.PolygonFiller;
import ij.process.ShortProcessor;
import ij.process.ShortStatistics;
import ij.text.TextPanel;
import ij.text.TextWindow;
import ij.util.Tools;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.image.IndexColorModel;
import java.util.Properties;

public class ParticleAnalyzer
implements PlugInFilter,
Measurements {
    public static final int SHOW_RESULTS = 1;
    public static final int SHOW_SUMMARY = 2;
    public static final int SHOW_OUTLINES = 4;
    public static final int EXCLUDE_EDGE_PARTICLES = 8;
    public static final int SHOW_ROI_MASKS = 16;
    public static final int SHOW_PROGRESS = 32;
    public static final int CLEAR_WORKSHEET = 64;
    public static final int RECORD_STARTS = 128;
    public static final int DISPLAY_SUMMARY = 256;
    public static final int SHOW_NONE = 512;
    public static final int INCLUDE_HOLES = 1024;
    public static final int ADD_TO_MANAGER = 2048;
    public static final int SHOW_MASKS = 4096;
    public static final int FOUR_CONNECTED = 8192;
    public static final int IN_SITU_SHOW = 16384;
    public static final int SHOW_OVERLAY_OUTLINES = 32768;
    public static final int SHOW_OVERLAY_MASKS = 65536;
    static final String OPTIONS = "ap.options";
    static final int BYTE = 0;
    static final int SHORT = 1;
    static final int FLOAT = 2;
    static final int RGB = 3;
    static final double DEFAULT_MIN_SIZE = 0.0;
    static final double DEFAULT_MAX_SIZE = Double.POSITIVE_INFINITY;
    private static double staticMinSize = 0.0;
    private static double staticMaxSize = Double.POSITIVE_INFINITY;
    private static boolean pixelUnits;
    private static int staticOptions;
    private static String[] showStrings;
    private static double staticMinCircularity;
    private static double staticMaxCircularity;
    private static String prevHdr;
    protected static final int NOTHING = 0;
    protected static final int OUTLINES = 1;
    protected static final int BARE_OUTLINES = 2;
    protected static final int ELLIPSES = 3;
    protected static final int MASKS = 4;
    protected static final int ROI_MASKS = 5;
    protected static final int OVERLAY_OUTLINES = 6;
    protected static final int OVERLAY_MASKS = 7;
    protected static int staticShowChoice;
    protected ImagePlus imp;
    protected ResultsTable rt;
    protected Analyzer analyzer;
    protected int slice;
    protected boolean processStack;
    protected boolean showResults;
    protected boolean excludeEdgeParticles;
    protected boolean showSizeDistribution;
    protected boolean resetCounter;
    protected boolean showProgress;
    protected boolean recordStarts;
    protected boolean displaySummary;
    protected boolean floodFill;
    protected boolean addToManager;
    protected boolean inSituShow;
    private String summaryHdr = "Slice\tCount\tTotal Area\tAverage Size\tArea Fraction";
    private double level1;
    private double level2;
    private double minSize;
    private double maxSize;
    private double minCircularity;
    private double maxCircularity;
    private int showChoice;
    private int options;
    private int measurements;
    private Calibration calibration;
    private String arg;
    private double fillColor;
    private boolean thresholdingLUT;
    private ImageProcessor drawIP;
    private int width;
    private int height;
    private boolean canceled;
    private ImageStack outlines;
    private IndexColorModel customLut;
    private int particleCount;
    private int maxParticleCount = 0;
    private int totalCount;
    private TextWindow tw;
    private Wand wand;
    private int imageType;
    private int imageType2;
    private boolean roiNeedsImage;
    private int minX;
    private int maxX;
    private int minY;
    private int maxY;
    private ImagePlus redirectImp;
    private ImageProcessor redirectIP;
    private PolygonFiller pf;
    private Roi saveRoi;
    private int beginningCount;
    private Rectangle r;
    private ImageProcessor mask;
    private double totalArea;
    private FloodFiller ff;
    private Polygon polygon;
    private RoiManager roiManager;
    private ImagePlus outputImage;
    private boolean hideOutputImage;
    private int roiType;
    private int wandMode = 1;
    private Overlay overlay;
    boolean blackBackground;
    private static int defaultFontSize;
    private static int nextFontSize;
    private static int nextLineWidth;
    private int fontSize = nextFontSize;
    private int lineWidth = nextLineWidth;
    int counter = 0;

    public ParticleAnalyzer(int n, int n2, ResultsTable resultsTable, double d, double d2, double d3, double d4) {
        this.options = n;
        this.measurements = n2;
        this.rt = resultsTable;
        if (this.rt == null) {
            this.rt = new ResultsTable();
        }
        this.minSize = d;
        this.maxSize = d2;
        this.minCircularity = d3;
        this.maxCircularity = d4;
        this.slice = 1;
        if ((n & 0x10) != 0) {
            this.showChoice = 5;
        }
        if ((n & 0x8000) != 0) {
            this.showChoice = 6;
        }
        if ((n & 0x10000) != 0) {
            this.showChoice = 7;
        }
        if ((n & 4) != 0) {
            this.showChoice = 1;
        }
        if ((n & 0x1000) != 0) {
            this.showChoice = 4;
        }
        if ((n & 0x200) != 0) {
            this.showChoice = 0;
        }
        if ((n & 0x2000) != 0) {
            this.wandMode = 4;
            n |= 0x400;
        }
        nextFontSize = defaultFontSize;
        nextLineWidth = 1;
    }

    public ParticleAnalyzer(int n, int n2, ResultsTable resultsTable, double d, double d2) {
        this(n, n2, resultsTable, d, d2, 0.0, 1.0);
    }

    public ParticleAnalyzer() {
        this.slice = 1;
    }

    public int setup(String string, ImagePlus imagePlus) {
        this.arg = string;
        this.imp = imagePlus;
        IJ.register(ParticleAnalyzer.class);
        if (imagePlus == null) {
            IJ.noImage();
            return 4096;
        }
        if (imagePlus.getBitDepth() == 24 && !this.isThresholdedRGB(imagePlus)) {
            IJ.error("Particle Analyzer", "RGB images must be thresholded using\nImage>Adjust>Color Threshold.");
            return 4096;
        }
        if (!this.showDialog()) {
            return 4096;
        }
        int n = 415;
        int n2 = IJ.setupDialog(imagePlus, n);
        this.processStack = (n2 & 0x20) != 0;
        this.slice = 0;
        this.saveRoi = imagePlus.getRoi();
        if (this.saveRoi != null && this.saveRoi.getType() != 0 && this.saveRoi.isArea()) {
            this.polygon = this.saveRoi.getPolygon();
        }
        imagePlus.startTiming();
        nextFontSize = defaultFontSize;
        nextLineWidth = 1;
        return n2;
    }

    public void run(ImageProcessor imageProcessor) {
        if (this.canceled) {
            return;
        }
        ++this.slice;
        if (this.imp.getStackSize() > 1 && this.processStack) {
            this.imp.setSlice(this.slice);
        }
        if (this.imp.getType() == 4) {
            imageProcessor = (ImageProcessor)this.imp.getProperty("Mask");
            imageProcessor.setThreshold(255.0, 255.0, 2);
        }
        if (!this.analyze(this.imp, imageProcessor)) {
            this.canceled = true;
        }
        if (this.slice == this.imp.getStackSize()) {
            this.imp.updateAndDraw();
            if (this.saveRoi != null) {
                this.imp.setRoi(this.saveRoi);
            }
        }
    }

    public boolean showDialog() {
        String string;
        String string2;
        double d;
        Calibration calibration = this.imp != null ? this.imp.getCalibration() : new Calibration();
        double d2 = calibration.pixelWidth * calibration.pixelHeight;
        if (pixelUnits) {
            d2 = 1.0;
        }
        if (Macro.getOptions() != null) {
            boolean bl = this.updateMacroOptions();
            if (bl) {
                d2 = 1.0;
            }
            staticMinSize = 0.0;
            staticMaxSize = Double.POSITIVE_INFINITY;
            staticMinCircularity = 0.0;
            staticMaxCircularity = 1.0;
            staticShowChoice = 0;
        }
        GenericDialog genericDialog = new GenericDialog("Analyze Particles");
        this.minSize = staticMinSize;
        this.maxSize = staticMaxSize;
        this.minCircularity = staticMinCircularity;
        this.maxCircularity = staticMaxCircularity;
        this.showChoice = staticShowChoice;
        if (this.maxSize == 999999.0) {
            this.maxSize = Double.POSITIVE_INFINITY;
        }
        this.options = staticOptions;
        String string3 = calibration.getUnit();
        boolean bl = calibration.scaled();
        if (string3.equals("inch")) {
            string3 = "pixel";
            d2 = 1.0;
            bl = false;
            pixelUnits = true;
        }
        String string4 = string3 + "^2";
        int n = 0;
        double d3 = this.minSize * d2;
        if ((double)((int)d3) != d3) {
            n = 2;
        }
        if ((double)((int)(d = this.maxSize * d2)) != d && d != Double.POSITIVE_INFINITY) {
            n = 2;
        }
        if ((string2 = ResultsTable.d2s(d3, n)).indexOf("-") != -1) {
            for (int i = n; i <= 6 && (string2 = ResultsTable.d2s(d3, i)).indexOf("-") != -1; ++i) {
            }
        }
        if ((string = ResultsTable.d2s(d, n)).indexOf("-") != -1) {
            for (int i = n; i <= 6 && (string = ResultsTable.d2s(d, i)).indexOf("-") != -1; ++i) {
            }
        }
        if (bl) {
            genericDialog.setInsets(5, 0, 0);
        }
        genericDialog.addStringField("Size (" + string4 + "):", string2 + "-" + string, 12);
        if (bl) {
            genericDialog.setInsets(0, 40, 5);
            genericDialog.addCheckbox("Pixel units", pixelUnits);
        }
        genericDialog.addStringField("Circularity:", IJ.d2s(this.minCircularity) + "-" + IJ.d2s(this.maxCircularity), 12);
        genericDialog.addChoice("Show:", showStrings, showStrings[this.showChoice]);
        String[] stringArray = new String[8];
        boolean[] blArray = new boolean[8];
        stringArray[0] = "Display results";
        blArray[0] = (this.options & 1) != 0;
        stringArray[1] = "Exclude on edges";
        blArray[1] = (this.options & 8) != 0;
        stringArray[2] = "Clear results";
        blArray[2] = (this.options & 0x40) != 0;
        stringArray[3] = "Include holes";
        blArray[3] = (this.options & 0x400) != 0;
        stringArray[4] = "Summarize";
        blArray[4] = (this.options & 0x100) != 0;
        stringArray[5] = "Record starts";
        blArray[5] = (this.options & 0x80) != 0;
        stringArray[6] = "Add to Manager";
        blArray[6] = (this.options & 0x800) != 0;
        stringArray[7] = "In_situ Show";
        blArray[7] = (this.options & 0x4000) != 0;
        genericDialog.addCheckboxGroup(4, 2, stringArray, blArray);
        genericDialog.addHelp("http://imagej.nih.gov/ij/docs/menus/analyze.html#ap");
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return false;
        }
        String string5 = genericDialog.getNextString();
        if (bl) {
            pixelUnits = genericDialog.getNextBoolean();
        }
        d2 = pixelUnits ? 1.0 : calibration.pixelWidth * calibration.pixelHeight;
        String[] stringArray2 = Tools.split(string5, " -");
        double d4 = genericDialog.parseDouble(stringArray2[0]);
        double d5 = stringArray2.length == 2 ? genericDialog.parseDouble(stringArray2[1]) : Double.NaN;
        this.minSize = Double.isNaN(d4) ? 0.0 : d4 / d2;
        double d6 = this.maxSize = Double.isNaN(d5) ? Double.POSITIVE_INFINITY : d5 / d2;
        if (this.minSize < 0.0) {
            this.minSize = 0.0;
        }
        if (this.maxSize < this.minSize) {
            this.maxSize = Double.POSITIVE_INFINITY;
        }
        staticMinSize = this.minSize;
        staticMaxSize = this.maxSize;
        stringArray2 = Tools.split(genericDialog.getNextString(), " -");
        double d7 = genericDialog.parseDouble(stringArray2[0]);
        double d8 = stringArray2.length == 2 ? genericDialog.parseDouble(stringArray2[1]) : Double.NaN;
        this.minCircularity = Double.isNaN(d7) ? 0.0 : d7;
        double d9 = this.maxCircularity = Double.isNaN(d8) ? 1.0 : d8;
        if (this.minCircularity < 0.0 || this.minCircularity > 1.0) {
            this.minCircularity = 0.0;
        }
        if (this.maxCircularity < this.minCircularity || this.maxCircularity > 1.0) {
            this.maxCircularity = 1.0;
        }
        if (this.minCircularity == 1.0 && this.maxCircularity == 1.0) {
            this.minCircularity = 0.0;
        }
        staticMinCircularity = this.minCircularity;
        staticMaxCircularity = this.maxCircularity;
        if (genericDialog.invalidNumber()) {
            IJ.error("Bins invalid.");
            this.canceled = true;
            return false;
        }
        staticShowChoice = this.showChoice = genericDialog.getNextChoiceIndex();
        this.options = genericDialog.getNextBoolean() ? (this.options |= 1) : (this.options &= 0xFFFFFFFE);
        this.options = genericDialog.getNextBoolean() ? (this.options |= 8) : (this.options &= 0xFFFFFFF7);
        this.options = genericDialog.getNextBoolean() ? (this.options |= 0x40) : (this.options &= 0xFFFFFFBF);
        this.options = genericDialog.getNextBoolean() ? (this.options |= 0x400) : (this.options &= 0xFFFFFBFF);
        this.options = genericDialog.getNextBoolean() ? (this.options |= 0x100) : (this.options &= 0xFFFFFEFF);
        this.options = genericDialog.getNextBoolean() ? (this.options |= 0x80) : (this.options &= 0xFFFFFF7F);
        this.options = genericDialog.getNextBoolean() ? (this.options |= 0x800) : (this.options &= 0xFFFFF7FF);
        this.options = genericDialog.getNextBoolean() ? (this.options |= 0x4000) : (this.options &= 0xFFFFBFFF);
        staticOptions = this.options;
        this.options |= 0x20;
        if ((this.options & 0x100) != 0) {
            Analyzer.setMeasurements(Analyzer.getMeasurements() | 1);
        }
        return true;
    }

    private boolean isThresholdedRGB(ImagePlus imagePlus) {
        Object object = imagePlus.getProperty("Mask");
        if (object == null || !(object instanceof ImageProcessor)) {
            return false;
        }
        ImageProcessor imageProcessor = (ImageProcessor)object;
        return imageProcessor.getWidth() == imagePlus.getWidth() && imageProcessor.getHeight() == imagePlus.getHeight();
    }

    boolean updateMacroOptions() {
        String string = Macro.getOptions();
        int n = string.indexOf("maximum=");
        if (n == -1) {
            return false;
        }
        n += 8;
        int n2 = string.length();
        while (n < n2 - 1 && string.charAt(n) != ' ') {
            ++n;
        }
        if (n == n2 - 1) {
            return false;
        }
        int n3 = (int)Tools.parseDouble(Macro.getValue(string, "minimum", "1"));
        int n4 = (int)Tools.parseDouble(Macro.getValue(string, "maximum", "999999"));
        string = "size=" + n3 + "-" + n4 + string.substring(n, n2);
        Macro.setOptions(string);
        return true;
    }

    public boolean analyze(ImagePlus imagePlus) {
        return this.analyze(imagePlus, imagePlus.getProcessor());
    }

    public boolean analyze(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        ImagePlus imagePlus2;
        if (this.imp == null) {
            this.imp = imagePlus;
        }
        this.showResults = (this.options & 1) != 0;
        this.excludeEdgeParticles = (this.options & 8) != 0;
        this.resetCounter = (this.options & 0x40) != 0;
        this.showProgress = (this.options & 0x20) != 0;
        this.floodFill = (this.options & 0x400) == 0;
        this.recordStarts = (this.options & 0x80) != 0;
        this.addToManager = (this.options & 0x800) != 0;
        this.displaySummary = (this.options & 0x100) != 0;
        this.inSituShow = (this.options & 0x4000) != 0;
        this.outputImage = null;
        imageProcessor.snapshot();
        imageProcessor.setProgressBar(null);
        if (Analyzer.isRedirectImage()) {
            this.redirectImp = Analyzer.getRedirectImage(imagePlus);
            if (this.redirectImp == null) {
                return false;
            }
            int n = this.redirectImp.getStackSize();
            if (n > 1 && n == imagePlus.getStackSize()) {
                ImageStack imageStack = this.redirectImp.getStack();
                this.redirectIP = imageStack.getProcessor(imagePlus.getCurrentSlice());
            } else {
                this.redirectIP = this.redirectImp.getProcessor();
            }
        } else if (imagePlus.getType() == 4 && (imagePlus2 = (ImagePlus)imagePlus.getProperty("OriginalImage")) != null && imagePlus2.getWidth() == imagePlus.getWidth() && imagePlus2.getHeight() == imagePlus.getHeight()) {
            this.redirectImp = imagePlus2;
            this.redirectIP = imagePlus2.getProcessor();
        }
        if (!this.setThresholdLevels(imagePlus, imageProcessor)) {
            return false;
        }
        this.width = imageProcessor.getWidth();
        this.height = imageProcessor.getHeight();
        if (this.showChoice != 0 && this.showChoice != 6 && this.showChoice != 7) {
            boolean bl = this.blackBackground = Prefs.blackBackground && this.inSituShow;
            if (this.slice == 1) {
                this.outlines = new ImageStack(this.width, this.height);
            }
            this.drawIP = this.showChoice == 5 ? new ShortProcessor(this.width, this.height) : new ByteProcessor(this.width, this.height);
            this.drawIP.setLineWidth(this.lineWidth);
            if (this.showChoice != 5) {
                if (this.showChoice == 4 && !this.blackBackground) {
                    this.drawIP.invertLut();
                } else if (this.showChoice == 1) {
                    if (!this.inSituShow) {
                        if (this.customLut == null) {
                            this.makeCustomLut();
                        }
                        this.drawIP.setColorModel(this.customLut);
                    }
                    this.drawIP.setFont(new Font("SansSerif", 0, this.fontSize));
                    if (this.fontSize > 12 && this.inSituShow) {
                        this.drawIP.setAntialiasedText(true);
                    }
                }
            }
            this.outlines.addSlice(null, this.drawIP);
            if (this.showChoice == 5 || this.blackBackground) {
                this.drawIP.setColor(Color.black);
                this.drawIP.fill();
                this.drawIP.setColor(Color.white);
            } else {
                this.drawIP.setColor(Color.white);
                this.drawIP.fill();
                this.drawIP.setColor(Color.black);
            }
        }
        Calibration calibration = this.calibration = this.redirectImp != null ? this.redirectImp.getCalibration() : imagePlus.getCalibration();
        if (this.rt == null) {
            this.rt = Analyzer.getResultsTable();
            this.analyzer = new Analyzer(imagePlus);
        } else {
            this.analyzer = new Analyzer(imagePlus, this.measurements, this.rt);
        }
        if (this.resetCounter && this.slice == 1 && !Analyzer.resetCounter()) {
            return false;
        }
        this.beginningCount = Analyzer.getCounter();
        byte[] byArray = null;
        if (imageProcessor instanceof ByteProcessor) {
            byArray = (byte[])imageProcessor.getPixels();
        }
        if (this.r == null) {
            this.r = imageProcessor.getRoi();
            this.mask = imageProcessor.getMask();
            if (this.displaySummary) {
                this.totalArea = this.mask != null ? ImageStatistics.getStatistics((ImageProcessor)imageProcessor, (int)1, (Calibration)this.calibration).area : (double)this.r.width * this.calibration.pixelWidth * (double)this.r.height * this.calibration.pixelHeight;
            }
        }
        this.minX = this.r.x;
        this.maxX = this.r.x + this.r.width;
        this.minY = this.r.y;
        this.maxY = this.r.y + this.r.height;
        if (!(this.r.width >= this.width && this.r.height >= this.height && this.mask == null || this.eraseOutsideRoi(imageProcessor, this.r, this.mask))) {
            return false;
        }
        int n = Math.max(this.r.height / 25, 1);
        boolean bl = false;
        ImageWindow imageWindow = imagePlus.getWindow();
        if (imageWindow != null) {
            imageWindow.running = true;
        }
        if (this.measurements == 0) {
            this.measurements = Analyzer.getMeasurements();
        }
        if (this.showChoice == 3) {
            this.measurements |= 0x800;
        }
        this.measurements &= 0xFFFFFEFF;
        this.roiNeedsImage = (this.measurements & 0x80) != 0 || (this.measurements & 0x2000) != 0 || (this.measurements & 0x4000) != 0;
        this.particleCount = 0;
        this.wand = new Wand(imageProcessor);
        this.pf = new PolygonFiller();
        if (this.floodFill) {
            ImageProcessor imageProcessor2 = imageProcessor.duplicate();
            imageProcessor2.setValue(this.fillColor);
            this.ff = new FloodFiller(imageProcessor2);
        }
        this.roiType = Wand.allPoints() ? 3 : 4;
        for (int i = this.r.y; i < this.r.y + this.r.height; ++i) {
            int n2 = i * this.width;
            for (int j = this.r.x; j < this.r.x + this.r.width; ++j) {
                double d = byArray != null ? (double)(byArray[n2 + j] & 0xFF) : (this.imageType == 1 ? (double)imageProcessor.getPixel(j, i) : (double)imageProcessor.getPixelValue(j, i));
                if (!(d >= this.level1) || !(d <= this.level2)) continue;
                this.analyzeParticle(j, i, imagePlus, imageProcessor);
            }
            if (this.showProgress && i % n == 0) {
                IJ.showProgress((double)(i - this.r.y) / (double)this.r.height);
            }
            if (imageWindow != null) {
                boolean bl2 = this.canceled = !imageWindow.running;
            }
            if (!this.canceled) continue;
            Macro.abort();
            break;
        }
        if (this.showProgress) {
            IJ.showProgress(1.0);
        }
        if (this.showResults) {
            this.rt.updateResults();
        }
        imagePlus.killRoi();
        imageProcessor.resetRoi();
        imageProcessor.reset();
        if (this.displaySummary && IJ.getInstance() != null) {
            this.updateSliceSummary();
        }
        if (this.addToManager && this.roiManager != null) {
            this.roiManager.setEditMode(imagePlus, true);
        }
        this.maxParticleCount = this.particleCount > this.maxParticleCount ? this.particleCount : this.maxParticleCount;
        this.totalCount += this.particleCount;
        if (!this.canceled) {
            this.showResults();
        }
        return true;
    }

    void updateSliceSummary() {
        Object object;
        int n;
        int n2 = this.imp.getStackSize();
        float[] fArray = this.rt.getColumn(0);
        if (fArray == null) {
            fArray = new float[]{};
        }
        String string = this.imp.getTitle();
        if (n2 > 1) {
            string = this.imp.getStack().getShortSliceLabel(this.slice);
            string = string != null && !string.equals("") ? string : "" + this.slice;
        }
        String string2 = null;
        double d = 0.0;
        int n3 = fArray.length - this.particleCount;
        if (n3 < 0) {
            return;
        }
        for (n = n3; n < fArray.length; ++n) {
            d += (double)fArray[n];
        }
        n = Analyzer.getPrecision();
        Calibration calibration = this.imp.getCalibration();
        String string3 = "\t" + ResultsTable.d2s(d, n);
        String string4 = "\t" + ResultsTable.d2s(d / (double)this.particleCount, n);
        String string5 = "\t" + ResultsTable.d2s(d * 100.0 / this.totalArea, 1);
        string2 = string + "\t" + this.particleCount + string3 + string4 + string5;
        string2 = this.addMeans(string2, fArray.length > 0 ? n3 : -1);
        if (n2 == 1 && (object = WindowManager.getFrame("Summary")) != null && object instanceof TextWindow && this.summaryHdr.equals(prevHdr)) {
            this.tw = (TextWindow)object;
        }
        if (this.tw == null) {
            object = n2 == 1 ? "Summary" : "Summary of " + this.imp.getTitle();
            this.tw = new TextWindow((String)object, this.summaryHdr, string2, 450, 300);
            prevHdr = this.summaryHdr;
        } else {
            this.tw.append(string2);
        }
    }

    String addMeans(String string, int n) {
        if ((this.measurements & 2) != 0) {
            string = this.addMean(1, string, n);
        }
        if ((this.measurements & 8) != 0) {
            string = this.addMean(3, string, n);
        }
        if ((this.measurements & 0x80) != 0) {
            string = this.addMean(10, string, n);
        }
        if ((this.measurements & 0x800) != 0) {
            string = this.addMean(15, string, n);
            string = this.addMean(16, string, n);
            string = this.addMean(17, string, n);
        }
        if ((this.measurements & 0x2000) != 0) {
            string = this.addMean(18, string, n);
            string = this.addMean(35, string, n);
        }
        if ((this.measurements & 0x4000) != 0) {
            string = this.addMean(19, string, n);
            string = this.addMean(29, string, n);
            string = this.addMean(30, string, n);
            string = this.addMean(31, string, n);
            string = this.addMean(32, string, n);
        }
        if ((this.measurements & 0x8000) != 0) {
            string = this.addMean(20, string, n);
        }
        if ((this.measurements & 0x10000) != 0) {
            string = this.addMean(21, string, n);
        }
        if ((this.measurements & 0x20000) != 0) {
            string = this.addMean(22, string, n);
        }
        if ((this.measurements & 0x40000) != 0) {
            string = this.addMean(23, string, n);
        }
        return string;
    }

    private String addMean(int n, String string, int n2) {
        if (n2 == -1) {
            string = string + "\tNaN";
            this.summaryHdr = this.summaryHdr + "\t" + ResultsTable.getDefaultHeading(n);
        } else {
            float[] fArray;
            float[] fArray2 = fArray = n >= 0 ? this.rt.getColumn(n) : null;
            if (fArray != null) {
                ImageProcessor imageProcessor = new FloatProcessor(fArray.length, 1, fArray, null);
                if (imageProcessor == null) {
                    return string;
                }
                imageProcessor.setRoi(n2, 0, imageProcessor.getWidth() - n2, 1);
                imageProcessor = ((ImageProcessor)imageProcessor).crop();
                FloatStatistics floatStatistics = new FloatStatistics(imageProcessor);
                if (floatStatistics == null) {
                    return string;
                }
                string = string + this.n(floatStatistics.mean);
            } else {
                string = string + "\tNaN";
            }
            this.summaryHdr = this.summaryHdr + "\t" + this.rt.getColumnHeading(n);
        }
        return string;
    }

    String n(double d) {
        String string = (double)Math.round(d) == d ? ResultsTable.d2s(d, 0) : ResultsTable.d2s(d, Analyzer.getPrecision());
        return "\t" + string;
    }

    boolean eraseOutsideRoi(ImageProcessor imageProcessor, Rectangle rectangle, ImageProcessor imageProcessor2) {
        int n = imageProcessor.getWidth();
        int n2 = imageProcessor.getHeight();
        imageProcessor.setRoi(rectangle);
        if (this.excludeEdgeParticles && this.polygon != null) {
            ImageStatistics imageStatistics = ImageStatistics.getStatistics(imageProcessor, 16, null);
            if (this.fillColor >= imageStatistics.min && this.fillColor <= imageStatistics.max) {
                int n3;
                double d = this.level1 - 1.0;
                if (d < 0.0 || d == this.fillColor) {
                    d = this.level2 + 1.0;
                    int n4 = n3 = this.imageType == 0 ? 255 : 65535;
                    if (d > (double)n3 || d == this.fillColor) {
                        IJ.error("Particle Analyzer", "Unable to remove edge particles");
                        return false;
                    }
                }
                for (n3 = this.minY; n3 < this.maxY; ++n3) {
                    for (int i = this.minX; i < this.maxX; ++i) {
                        int n5 = imageProcessor.getPixel(i, n3);
                        if ((double)n5 != this.fillColor) continue;
                        imageProcessor.putPixel(i, n3, (int)d);
                    }
                }
            }
        }
        imageProcessor.setValue(this.fillColor);
        if (imageProcessor2 != null) {
            imageProcessor2 = imageProcessor2.duplicate();
            imageProcessor2.invert();
            imageProcessor.fill(imageProcessor2);
        }
        imageProcessor.setRoi(0, 0, rectangle.x, n2);
        imageProcessor.fill();
        imageProcessor.setRoi(rectangle.x, 0, rectangle.width, rectangle.y);
        imageProcessor.fill();
        imageProcessor.setRoi(rectangle.x, rectangle.y + rectangle.height, rectangle.width, n2 - (rectangle.y + rectangle.height));
        imageProcessor.fill();
        imageProcessor.setRoi(rectangle.x + rectangle.width, 0, n - (rectangle.x + rectangle.width), n2);
        imageProcessor.fill();
        imageProcessor.resetRoi();
        return true;
    }

    boolean setThresholdLevels(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        double d = imageProcessor.getMinThreshold();
        double d2 = imageProcessor.getMaxThreshold();
        boolean bl = imagePlus.isInvertedLut();
        boolean bl2 = imageProcessor instanceof ByteProcessor;
        this.imageType = imageProcessor instanceof ShortProcessor ? 1 : (imageProcessor instanceof FloatProcessor ? 2 : 0);
        if (d == -808080.0) {
            ImageStatistics imageStatistics = imagePlus.getStatistics();
            if (this.imageType != 0 || imageStatistics.histogram[0] + imageStatistics.histogram[255] != imageStatistics.pixelCount) {
                IJ.error("Particle Analyzer", "A thresholded image or 8-bit binary image is\nrequired. Threshold levels can be set using\nthe Image->Adjust->Threshold tool.");
                this.canceled = true;
                return false;
            }
            boolean bl3 = bl;
            if (Prefs.blackBackground) {
                boolean bl4 = bl3 = !bl3;
            }
            if (bl3) {
                this.level1 = 255.0;
                this.level2 = 255.0;
                this.fillColor = 64.0;
            } else {
                this.level1 = 0.0;
                this.level2 = 0.0;
                this.fillColor = 192.0;
            }
        } else {
            this.level1 = d;
            this.level2 = d2;
            if (this.imageType == 0) {
                if (this.level1 > 0.0) {
                    this.fillColor = 0.0;
                } else if (this.level2 < 255.0) {
                    this.fillColor = 255.0;
                }
            } else if (this.imageType == 1) {
                if (this.level1 > 0.0) {
                    this.fillColor = 0.0;
                } else if (this.level2 < 65535.0) {
                    this.fillColor = 65535.0;
                }
            } else if (this.imageType == 2) {
                this.fillColor = -3.4028234663852886E38;
            } else {
                return false;
            }
        }
        this.imageType2 = this.imageType;
        if (this.redirectIP != null) {
            this.imageType2 = this.redirectIP instanceof ShortProcessor ? 1 : (this.redirectIP instanceof FloatProcessor ? 2 : (this.redirectIP instanceof ColorProcessor ? 3 : 0));
        }
        return true;
    }

    void analyzeParticle(int n, int n2, ImagePlus imagePlus, ImageProcessor imageProcessor) {
        Cloneable cloneable;
        Object object;
        ImageProcessor imageProcessor2 = this.redirectIP != null ? this.redirectIP : imageProcessor;
        this.wand.autoOutline(n, n2, this.level1, this.level2, this.wandMode);
        if (this.wand.npoints == 0) {
            IJ.log("wand error: " + n + " " + n2);
            return;
        }
        PolygonRoi polygonRoi = new PolygonRoi(this.wand.xpoints, this.wand.ypoints, this.wand.npoints, this.roiType);
        Rectangle rectangle = polygonRoi.getBounds();
        if (rectangle.width > 1 && rectangle.height > 1) {
            object = polygonRoi;
            this.pf.setPolygon(((PolygonRoi)object).getXCoordinates(), ((PolygonRoi)object).getYCoordinates(), ((PolygonRoi)object).getNCoordinates());
            imageProcessor2.setMask(this.pf.getMask(rectangle.width, rectangle.height));
            if (this.floodFill) {
                this.ff.particleAnalyzerFill(n, n2, this.level1, this.level2, imageProcessor2.getMask(), rectangle);
            }
        }
        imageProcessor2.setRoi(rectangle);
        imageProcessor.setValue(this.fillColor);
        object = this.getStatistics(imageProcessor2, this.measurements, this.calibration);
        boolean bl = true;
        if (this.excludeEdgeParticles) {
            if (rectangle.x == this.minX || rectangle.y == this.minY || rectangle.x + rectangle.width == this.maxX || rectangle.y + rectangle.height == this.maxY) {
                bl = false;
            }
            if (this.polygon != null) {
                cloneable = polygonRoi.getBounds();
                int n3 = ((Rectangle)cloneable).x + this.wand.xpoints[this.wand.npoints - 1];
                int n4 = ((Rectangle)cloneable).y + this.wand.ypoints[this.wand.npoints - 1];
                for (int i = 0; i < this.wand.npoints; ++i) {
                    int n5 = ((Rectangle)cloneable).x + this.wand.xpoints[i];
                    int n6 = ((Rectangle)cloneable).y + this.wand.ypoints[i];
                    if (!this.polygon.contains(n5, n6)) {
                        bl = false;
                        break;
                    }
                    if (n3 == n5 && (double)imageProcessor.getPixel(n3, n4 - 1) == this.fillColor || n4 == n6 && (double)imageProcessor.getPixel(n3 - 1, n4) == this.fillColor) {
                        bl = false;
                        break;
                    }
                    n3 = n5;
                    n4 = n6;
                }
            }
        }
        cloneable = imageProcessor2.getMask();
        if (this.minCircularity > 0.0 || this.maxCircularity < 1.0) {
            double d;
            double d2 = ((Roi)polygonRoi).getLength();
            double d3 = d = d2 == 0.0 ? 0.0 : Math.PI * 4 * ((double)((ImageStatistics)object).pixelCount / (d2 * d2));
            if (d > 1.0) {
                d = 1.0;
            }
            if (d < this.minCircularity || d > this.maxCircularity) {
                bl = false;
            }
        }
        if ((double)((ImageStatistics)object).pixelCount >= this.minSize && (double)((ImageStatistics)object).pixelCount <= this.maxSize && bl) {
            ++this.particleCount;
            if (this.roiNeedsImage) {
                polygonRoi.setImage(imagePlus);
            }
            ((ImageStatistics)object).xstart = n;
            ((ImageStatistics)object).ystart = n2;
            this.saveResults((ImageStatistics)object, polygonRoi);
            if (this.showChoice != 0) {
                this.drawParticle(this.drawIP, polygonRoi, (ImageStatistics)object, (ImageProcessor)cloneable);
            }
        }
        if (this.redirectIP != null) {
            imageProcessor.setRoi(rectangle);
        }
        imageProcessor.fill((ImageProcessor)cloneable);
    }

    ImageStatistics getStatistics(ImageProcessor imageProcessor, int n, Calibration calibration) {
        switch (this.imageType2) {
            case 0: {
                return new ByteStatistics(imageProcessor, n, calibration);
            }
            case 1: {
                return new ShortStatistics(imageProcessor, n, calibration);
            }
            case 2: {
                return new FloatStatistics(imageProcessor, n, calibration);
            }
            case 3: {
                return new ColorStatistics(imageProcessor, n, calibration);
            }
        }
        return null;
    }

    protected void saveResults(ImageStatistics imageStatistics, Roi roi) {
        this.analyzer.saveResults(imageStatistics, roi);
        if (this.recordStarts) {
            this.rt.addValue("XStart", (double)imageStatistics.xstart);
            this.rt.addValue("YStart", (double)imageStatistics.ystart);
        }
        if (this.addToManager) {
            if (this.roiManager == null) {
                if (Macro.getOptions() != null && Interpreter.isBatchMode()) {
                    this.roiManager = Interpreter.getBatchModeRoiManager();
                }
                if (this.roiManager == null) {
                    Frame frame = WindowManager.getFrame("ROI Manager");
                    if (frame == null) {
                        IJ.run("ROI Manager...");
                    }
                    if ((frame = WindowManager.getFrame("ROI Manager")) == null || !(frame instanceof RoiManager)) {
                        this.addToManager = false;
                        return;
                    }
                    this.roiManager = (RoiManager)frame;
                }
                if (this.resetCounter) {
                    this.roiManager.runCommand("reset");
                }
            }
            if (this.imp.getStackSize() > 1) {
                roi.setPosition(this.imp.getCurrentSlice());
            }
            if (this.lineWidth != 1) {
                roi.setStrokeWidth(this.lineWidth);
            }
            this.roiManager.add(this.imp, roi, this.rt.getCounter());
        }
        if (this.showResults) {
            this.rt.addResults();
        }
    }

    protected void drawParticle(ImageProcessor imageProcessor, Roi roi, ImageStatistics imageStatistics, ImageProcessor imageProcessor2) {
        switch (this.showChoice) {
            case 4: {
                this.drawFilledParticle(imageProcessor, roi, imageProcessor2);
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: {
                this.drawOutline(imageProcessor, roi, this.rt.getCounter());
                break;
            }
            case 3: {
                this.drawEllipse(imageProcessor, imageStatistics, this.rt.getCounter());
                break;
            }
            case 5: {
                this.drawRoiFilledParticle(imageProcessor, roi, imageProcessor2, this.rt.getCounter());
                break;
            }
        }
    }

    void drawFilledParticle(ImageProcessor imageProcessor, Roi roi, ImageProcessor imageProcessor2) {
        imageProcessor.setRoi(roi.getBounds());
        imageProcessor.fill(imageProcessor2);
    }

    void drawOutline(ImageProcessor imageProcessor, Roi roi, int n) {
        if (this.showChoice == 6 || this.showChoice == 7) {
            if (this.overlay == null) {
                this.overlay = new Overlay();
                this.overlay.drawLabels(true);
                this.overlay.setLabelFont(new Font("SansSerif", 0, this.fontSize));
            }
            Roi roi2 = (Roi)roi.clone();
            roi2.setStrokeColor(Color.cyan);
            if (this.lineWidth != 1) {
                roi2.setStrokeWidth(this.lineWidth);
            }
            if (this.showChoice == 7) {
                roi2.setFillColor(Color.cyan);
            }
            this.overlay.add(roi2);
        } else {
            Rectangle rectangle = roi.getBounds();
            int n2 = ((PolygonRoi)roi).getNCoordinates();
            int[] nArray = ((PolygonRoi)roi).getXCoordinates();
            int[] nArray2 = ((PolygonRoi)roi).getYCoordinates();
            int n3 = rectangle.x;
            int n4 = rectangle.y;
            if (!this.inSituShow) {
                imageProcessor.setValue(0.0);
            }
            imageProcessor.moveTo(n3 + nArray[0], n4 + nArray2[0]);
            for (int i = 1; i < n2; ++i) {
                imageProcessor.lineTo(n3 + nArray[i], n4 + nArray2[i]);
            }
            imageProcessor.lineTo(n3 + nArray[0], n4 + nArray2[0]);
            if (this.showChoice != 2) {
                String string = ResultsTable.d2s(n, 0);
                imageProcessor.moveTo(rectangle.x + rectangle.width / 2 - imageProcessor.getStringWidth(string) / 2, rectangle.y + rectangle.height / 2 + this.fontSize / 2);
                if (!this.inSituShow) {
                    imageProcessor.setValue(1.0);
                }
                imageProcessor.drawString(string);
            }
        }
    }

    void drawEllipse(ImageProcessor imageProcessor, ImageStatistics imageStatistics, int n) {
        imageStatistics.drawEllipse(imageProcessor);
    }

    void drawRoiFilledParticle(ImageProcessor imageProcessor, Roi roi, ImageProcessor imageProcessor2, int n) {
        int n2 = n < 65535 ? n : 65535;
        imageProcessor.setValue(n2);
        imageProcessor.setRoi(roi.getBounds());
        imageProcessor.fill(imageProcessor2);
    }

    void showResults() {
        Object object;
        boolean bl;
        int n = this.rt.getCounter();
        boolean bl2 = bl = !this.processStack || this.slice == this.imp.getStackSize();
        if ((this.showChoice == 6 || this.showChoice == 7) && this.slice == 1 && n > 0) {
            this.imp.setOverlay(this.overlay);
        } else if (this.outlines != null && bl) {
            Object object2 = object = this.imp != null ? this.imp.getTitle() : "Outlines";
            String string = this.showChoice == 4 ? "Mask of " : (this.showChoice == 5 ? "Count Masks of " : "Drawing of ");
            this.outlines.update(this.drawIP);
            this.outputImage = new ImagePlus(string + (String)object, this.outlines);
            if (this.inSituShow) {
                if (this.imp.getStackSize() == 1) {
                    Undo.setup(6, this.imp);
                }
                this.imp.setStack(null, this.outputImage.getStack());
            } else if (!this.hideOutputImage) {
                this.outputImage.show();
            }
        }
        if (this.showResults && !this.processStack) {
            object = IJ.getTextPanel();
            if (this.beginningCount > 0 && object != null && ((TextPanel)object).getLineCount() != n) {
                this.rt.show("Results");
            }
            Analyzer.firstParticle = this.beginningCount;
            Analyzer.lastParticle = Analyzer.getCounter() - 1;
        } else {
            Analyzer.lastParticle = 0;
            Analyzer.firstParticle = 0;
        }
    }

    public ImagePlus getOutputImage() {
        return this.outputImage;
    }

    public void setHideOutputImage(boolean bl) {
        this.hideOutputImage = bl;
    }

    public static void setFontSize(int n) {
        nextFontSize = n;
    }

    public static void setLineWidth(int n) {
        nextLineWidth = n;
    }

    int getColumnID(String string) {
        int n = this.rt.getFreeColumn(string);
        if (n == -2) {
            n = this.rt.getColumnIndex(string);
        }
        return n;
    }

    void makeCustomLut() {
        IndexColorModel indexColorModel = (IndexColorModel)LookUpTable.createGrayscaleColorModel(false);
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[256];
        byte[] byArray3 = new byte[256];
        indexColorModel.getReds(byArray);
        indexColorModel.getGreens(byArray2);
        indexColorModel.getBlues(byArray3);
        byArray[1] = -1;
        byArray2[1] = 0;
        byArray3[1] = 0;
        this.customLut = new IndexColorModel(8, 256, byArray, byArray2, byArray3);
    }

    public static void savePreferences(Properties properties) {
        properties.put(OPTIONS, Integer.toString(staticOptions));
    }

    static {
        staticOptions = Prefs.getInt(OPTIONS, 64);
        showStrings = new String[]{"Nothing", "Outlines", "Bare Outlines", "Ellipses", "Masks", "Count Masks", "Overlay Outlines", "Overlay Masks"};
        staticMinCircularity = 0.0;
        staticMaxCircularity = 1.0;
        nextFontSize = defaultFontSize = 9;
        nextLineWidth = 1;
    }
}

