/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.macro.Interpreter;
import ij.macro.Program;
import ij.macro.Tokenizer;
import ij.plugin.filter.Analyzer;
import ij.plugin.filter.ExtendedPlugInFilter;
import ij.plugin.filter.PlugInFilterRunner;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.AWTEvent;
import java.awt.Rectangle;

public class ImageMath
implements ExtendedPlugInFilter,
DialogListener {
    public static final String MACRO_KEY = "math.macro";
    private int flags = 16777311;
    private String arg;
    private ImagePlus imp;
    private boolean canceled;
    private double lower = -1.0;
    private double upper = -1.0;
    private static double addValue = 25.0;
    private static double mulValue = 1.25;
    private static double minValue = 0.0;
    private static double maxValue = 255.0;
    private static final String defaultAndValue = "11110000";
    private static String andValue = "11110000";
    private static final double defaultGammaValue = 0.5;
    private static double gammaValue = 0.5;
    private static String macro = Prefs.get("math.macro", "v=v+50*sin(d/10)");
    private int w;
    private int h;
    private int w2;
    private int h2;
    private boolean hasX;
    private boolean hasA;
    private boolean hasD;
    private boolean hasGetPixel;
    private String macro2;
    private PlugInFilterRunner pfr;
    private GenericDialog gd;

    public int setup(String string, ImagePlus imagePlus) {
        this.arg = string;
        this.imp = imagePlus;
        IJ.register(ImageMath.class);
        this.flags = imagePlus != null && imagePlus.getStackSize() == 1 && string.equals("macro") ? (this.flags |= 0x40000) : (this.flags |= 0x8000);
        return this.flags;
    }

    public void run(ImageProcessor imageProcessor) {
        if (this.canceled) {
            return;
        }
        if (this.arg.equals("add")) {
            imageProcessor.add(addValue);
            return;
        }
        if (this.arg.equals("sub")) {
            imageProcessor.subtract(addValue);
            return;
        }
        if (this.arg.equals("mul")) {
            imageProcessor.multiply(mulValue);
            return;
        }
        if (this.arg.equals("div")) {
            if (mulValue == 0.0 && this.imp.getBitDepth() != 32) {
                return;
            }
            imageProcessor.multiply(1.0 / mulValue);
            return;
        }
        if (this.arg.equals("and")) {
            try {
                imageProcessor.and(Integer.parseInt(andValue, 2));
            }
            catch (NumberFormatException numberFormatException) {
                andValue = defaultAndValue;
                IJ.error("Binary number required");
            }
            return;
        }
        if (this.arg.equals("or")) {
            try {
                imageProcessor.or(Integer.parseInt(andValue, 2));
            }
            catch (NumberFormatException numberFormatException) {
                andValue = defaultAndValue;
                IJ.error("Binary number required");
            }
            return;
        }
        if (this.arg.equals("xor")) {
            try {
                imageProcessor.xor(Integer.parseInt(andValue, 2));
            }
            catch (NumberFormatException numberFormatException) {
                andValue = defaultAndValue;
                IJ.error("Binary number required");
            }
            return;
        }
        if (this.arg.equals("min")) {
            imageProcessor.min(minValue);
            if (!(imageProcessor instanceof ByteProcessor)) {
                imageProcessor.resetMinAndMax();
            }
            return;
        }
        if (this.arg.equals("max")) {
            imageProcessor.max(maxValue);
            if (!(imageProcessor instanceof ByteProcessor)) {
                imageProcessor.resetMinAndMax();
            }
            return;
        }
        if (this.arg.equals("gamma")) {
            if ((gammaValue < 0.1 || gammaValue > 5.0) && !this.previewing()) {
                IJ.error("Gamma must be between 0.1 and 5.0");
                gammaValue = 0.5;
                return;
            }
            imageProcessor.gamma(gammaValue);
            return;
        }
        if (this.arg.equals("set")) {
            boolean bl = imageProcessor instanceof ColorProcessor;
            if (bl) {
                if (addValue > 255.0) {
                    addValue = 255.0;
                }
                if (addValue < 0.0) {
                    addValue = 0.0;
                }
                int n = (int)addValue;
                imageProcessor.setValue(n + (n << 8) + (n << 16));
            } else {
                imageProcessor.setValue(addValue);
            }
            imageProcessor.fill();
            return;
        }
        if (this.arg.equals("log")) {
            imageProcessor.log();
            return;
        }
        if (this.arg.equals("exp")) {
            imageProcessor.exp();
            return;
        }
        if (this.arg.equals("sqr")) {
            imageProcessor.sqr();
            return;
        }
        if (this.arg.equals("sqrt")) {
            imageProcessor.sqrt();
            return;
        }
        if (this.arg.equals("reciprocal")) {
            if (!this.isFloat(imageProcessor)) {
                return;
            }
            float[] fArray = (float[])imageProcessor.getPixels();
            for (int i = 0; i < imageProcessor.getWidth() * imageProcessor.getHeight(); ++i) {
                fArray[i] = fArray[i] == 0.0f ? Float.NaN : 1.0f / fArray[i];
            }
            imageProcessor.resetMinAndMax();
            return;
        }
        if (this.arg.equals("nan")) {
            this.setBackgroundToNaN(imageProcessor);
            return;
        }
        if (this.arg.equals("abs")) {
            if (!(imageProcessor instanceof FloatProcessor) && !this.imp.getCalibration().isSigned16Bit()) {
                IJ.error("32-bit or signed 16-bit image required");
                this.canceled = true;
            } else {
                imageProcessor.abs();
                imageProcessor.resetMinAndMax();
            }
            return;
        }
        if (this.arg.equals("macro")) {
            this.applyMacro(imageProcessor);
            return;
        }
    }

    boolean previewing() {
        return this.gd != null && this.gd.getPreviewCheckbox().getState();
    }

    boolean isFloat(ImageProcessor imageProcessor) {
        if (!(imageProcessor instanceof FloatProcessor)) {
            IJ.error("32-bit float image required");
            this.canceled = true;
            return false;
        }
        return true;
    }

    void getValue(String string, String string2, double d, int n) {
        int n2 = Analyzer.getPrecision();
        if (n > 0 || (double)((int)d) != d) {
            n = Math.max(n2, 1);
        }
        this.gd = new GenericDialog(string);
        this.gd.addNumericField(string2, d, n, 8, null);
        this.gd.addPreviewCheckbox(this.pfr);
        this.gd.addDialogListener(this);
        this.gd.showDialog();
    }

    void getBinaryValue(String string, String string2, String string3) {
        this.gd = new GenericDialog(string);
        this.gd.addStringField(string2, string3);
        this.gd.addPreviewCheckbox(this.pfr);
        this.gd.addDialogListener(this);
        this.gd.showDialog();
    }

    void getGammaValue(double d) {
        this.gd = new GenericDialog("Gamma");
        this.gd.addSlider("Value:", 0.05, 5.0, d);
        this.gd.addPreviewCheckbox(this.pfr);
        this.gd.addDialogListener(this);
        this.gd.showDialog();
    }

    void setBackgroundToNaN(ImageProcessor imageProcessor) {
        if (this.lower == -1.0 && this.upper == -1.0) {
            this.lower = imageProcessor.getMinThreshold();
            this.upper = imageProcessor.getMaxThreshold();
            if (this.lower == -808080.0 || !(imageProcessor instanceof FloatProcessor)) {
                IJ.error("Thresholded 32-bit float image required");
                this.canceled = true;
                return;
            }
        }
        float[] fArray = (float[])imageProcessor.getPixels();
        int n = imageProcessor.getWidth();
        int n2 = imageProcessor.getHeight();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                double d = fArray[i * n + j];
                if (!(d < this.lower) && !(d > this.upper)) continue;
                fArray[i * n + j] = Float.NaN;
            }
        }
        imageProcessor.resetMinAndMax();
    }

    void applyMacro(ImageProcessor imageProcessor) {
        int n = 23;
        if (this.macro2 == null) {
            return;
        }
        if (this.macro2.indexOf("=") == -1) {
            IJ.error("The variable 'v' must be assigned a value (e.g., \"v=255-v\")");
            this.canceled = true;
            return;
        }
        macro = this.macro2;
        Program program = new Tokenizer().tokenize(macro);
        this.hasX = program.hasWord("x");
        this.hasA = program.hasWord("a");
        this.hasD = program.hasWord("d");
        this.hasGetPixel = program.hasWord("getPixel");
        this.w = this.imp.getWidth();
        this.h = this.imp.getHeight();
        this.w2 = this.w / 2;
        this.h2 = this.h / 2;
        String string = "var v,x,y,z,w,h,d,a;\nfunction dummy() {}\n" + this.macro2 + ";\n";
        Interpreter interpreter = new Interpreter();
        interpreter.run(string, null);
        if (interpreter.wasError()) {
            return;
        }
        Prefs.set(MACRO_KEY, macro);
        interpreter.setVariable("w", this.w);
        interpreter.setVariable("h", this.h);
        boolean bl = this.pfr.getSliceNumber() == 1 && !Interpreter.isBatchMode();
        interpreter.setVariable("z", this.pfr.getSliceNumber() - 1);
        int n2 = this.imp.getBitDepth();
        Rectangle rectangle = imageProcessor.getRoi();
        int n3 = rectangle.height / 50;
        if (n3 < 1) {
            n3 = 1;
        }
        if (n2 == 8) {
            byte[] byArray;
            byte[] byArray2 = byArray = (byte[])imageProcessor.getPixels();
            if (this.hasGetPixel) {
                byArray2 = new byte[this.w * this.h];
            }
            for (int i = rectangle.y; i < rectangle.y + rectangle.height; ++i) {
                if (bl && i % n3 == 0) {
                    IJ.showProgress(i - rectangle.y, rectangle.height);
                }
                interpreter.setVariable("y", i);
                for (int j = rectangle.x; j < rectangle.x + rectangle.width; ++j) {
                    int n4 = i * this.w + j;
                    double d = byArray[n4] & 0xFF;
                    interpreter.setVariable("v", d);
                    if (this.hasX) {
                        interpreter.setVariable("x", j);
                    }
                    if (this.hasA) {
                        interpreter.setVariable("a", this.getA(j, i));
                    }
                    if (this.hasD) {
                        interpreter.setVariable("d", this.getD(j, i));
                    }
                    interpreter.run(n);
                    int n5 = (int)interpreter.getVariable("v");
                    if (n5 < 0) {
                        n5 = 0;
                    }
                    if (n5 > 255) {
                        n5 = 255;
                    }
                    byArray2[n4] = (byte)n5;
                }
            }
            if (this.hasGetPixel) {
                System.arraycopy(byArray2, 0, byArray, 0, this.w * this.h);
            }
        } else if (n2 == 24) {
            int[] nArray;
            int[] nArray2 = nArray = (int[])imageProcessor.getPixels();
            if (this.hasGetPixel) {
                nArray2 = new int[this.w * this.h];
            }
            for (int i = rectangle.y; i < rectangle.y + rectangle.height; ++i) {
                if (bl && i % n3 == 0) {
                    IJ.showProgress(i - rectangle.y, rectangle.height);
                }
                interpreter.setVariable("y", i);
                for (int j = rectangle.x; j < rectangle.x + rectangle.width; ++j) {
                    if (this.hasX) {
                        interpreter.setVariable("x", j);
                    }
                    if (this.hasA) {
                        interpreter.setVariable("a", this.getA(j, i));
                    }
                    if (this.hasD) {
                        interpreter.setVariable("d", this.getD(j, i));
                    }
                    int n6 = i * this.w + j;
                    int n7 = nArray[n6];
                    if (this.hasGetPixel) {
                        interpreter.setVariable("v", n7);
                        interpreter.run(n);
                        n7 = (int)interpreter.getVariable("v");
                    } else {
                        int n8 = (n7 & 0xFF0000) >> 16;
                        int n9 = (n7 & 0xFF00) >> 8;
                        int n10 = n7 & 0xFF;
                        interpreter.setVariable("v", n8);
                        interpreter.run(n);
                        n8 = (int)interpreter.getVariable("v");
                        if (n8 < 0) {
                            n8 = 0;
                        }
                        if (n8 > 255) {
                            n8 = 255;
                        }
                        interpreter.setVariable("v", n9);
                        interpreter.run(n);
                        n9 = (int)interpreter.getVariable("v");
                        if (n9 < 0) {
                            n9 = 0;
                        }
                        if (n9 > 255) {
                            n9 = 255;
                        }
                        interpreter.setVariable("v", n10);
                        interpreter.run(n);
                        n10 = (int)interpreter.getVariable("v");
                        if (n10 < 0) {
                            n10 = 0;
                        }
                        if (n10 > 255) {
                            n10 = 255;
                        }
                        n7 = 0xFF000000 | (n8 & 0xFF) << 16 | (n9 & 0xFF) << 8 | n10 & 0xFF;
                    }
                    nArray2[n6] = n7;
                }
            }
            if (this.hasGetPixel) {
                System.arraycopy(nArray2, 0, nArray, 0, this.w * this.h);
            }
        } else {
            for (int i = rectangle.y; i < rectangle.y + rectangle.height; ++i) {
                if (bl && i % n3 == 0) {
                    IJ.showProgress(i - rectangle.y, rectangle.height);
                }
                interpreter.setVariable("y", i);
                for (int j = rectangle.x; j < rectangle.x + rectangle.width; ++j) {
                    double d = imageProcessor.getPixelValue(j, i);
                    interpreter.setVariable("v", d);
                    if (this.hasX) {
                        interpreter.setVariable("x", j);
                    }
                    if (this.hasA) {
                        interpreter.setVariable("a", this.getA(j, i));
                    }
                    if (this.hasD) {
                        interpreter.setVariable("d", this.getD(j, i));
                    }
                    interpreter.run(n);
                    imageProcessor.putPixelValue(j, i, interpreter.getVariable("v"));
                }
            }
        }
        if (bl) {
            IJ.showProgress(1.0);
        }
        if (this.pfr.getSliceNumber() == 1) {
            imageProcessor.resetMinAndMax();
        }
    }

    final double getD(int n, int n2) {
        double d = n - this.w2;
        double d2 = n2 - this.h2;
        return Math.sqrt(d * d + d2 * d2);
    }

    final double getA(int n, int n2) {
        double d = Math.atan2(this.h - n2 - 1 - this.h2, n - this.w2);
        if (d < 0.0) {
            d += Math.PI * 2;
        }
        return d;
    }

    void getMacro(String string) {
        this.gd = new GenericDialog("Expression Evaluator");
        this.gd.addStringField("Code:", string, 42);
        this.gd.setInsets(0, 40, 0);
        this.gd.addMessage("v=pixel value, x,y&z=pixel coordinates, w=image width,\nh=image height, a=angle, d=distance from center\n");
        this.gd.setInsets(5, 40, 0);
        this.gd.addPreviewCheckbox(this.pfr);
        this.gd.addDialogListener(this);
        this.gd.addHelp("http://imagej.nih.gov/ij/docs/menus/process.html#math-macro");
        this.gd.showDialog();
    }

    public int showDialog(ImagePlus imagePlus, String string, PlugInFilterRunner plugInFilterRunner) {
        this.pfr = plugInFilterRunner;
        if (this.arg.equals("macro")) {
            this.getMacro(macro);
        } else if (this.arg.equals("add")) {
            this.getValue("Add", "Value: ", addValue, 0);
        } else if (this.arg.equals("sub")) {
            this.getValue("Subtract", "Value: ", addValue, 0);
        } else if (this.arg.equals("mul")) {
            this.getValue("Multiply", "Value: ", mulValue, 2);
        } else if (this.arg.equals("div")) {
            this.getValue("Divide", "Value: ", mulValue, 2);
        } else if (this.arg.equals("and")) {
            this.getBinaryValue("AND", "Value (binary): ", andValue);
        } else if (this.arg.equals("or")) {
            this.getBinaryValue("OR", "Value (binary): ", andValue);
        } else if (this.arg.equals("xor")) {
            this.getBinaryValue("XOR", "Value (binary): ", andValue);
        } else if (this.arg.equals("min")) {
            this.getValue("Min", "Value: ", minValue, 0);
        } else if (this.arg.equals("max")) {
            this.getValue("Max", "Value: ", maxValue, 0);
        } else if (this.arg.equals("gamma")) {
            this.getGammaValue(gammaValue);
        } else if (this.arg.equals("set")) {
            boolean bl = imagePlus.getBitDepth() == 24;
            String string2 = bl ? "Value (0-255): " : "Value: ";
            this.getValue("Set", string2, addValue, 0);
        }
        if (this.gd != null && this.gd.wasCanceled()) {
            return 4096;
        }
        return IJ.setupDialog(imagePlus, this.flags);
    }

    public boolean dialogItemChanged(GenericDialog genericDialog, AWTEvent aWTEvent) {
        if (this.arg.equals("macro")) {
            String string = genericDialog.getNextString();
            if (this.previewing() && this.macro2 != null && !string.equals(this.macro2)) {
                genericDialog.getPreviewCheckbox().setState(false);
            }
            this.macro2 = string;
        } else if (this.arg.equals("add") || this.arg.equals("sub") || this.arg.equals("set")) {
            addValue = genericDialog.getNextNumber();
        } else if (this.arg.equals("mul") || this.arg.equals("div")) {
            mulValue = genericDialog.getNextNumber();
        } else if (this.arg.equals("and") || this.arg.equals("or") || this.arg.equals("xor")) {
            andValue = genericDialog.getNextString();
        } else if (this.arg.equals("min")) {
            minValue = genericDialog.getNextNumber();
        } else if (this.arg.equals("max")) {
            maxValue = genericDialog.getNextNumber();
        } else if (this.arg.equals("gamma")) {
            gammaValue = genericDialog.getNextNumber();
        }
        this.canceled = genericDialog.invalidNumber();
        if (genericDialog.wasOKed() && this.canceled) {
            IJ.error("Value is invalid.");
            return false;
        }
        return true;
    }

    public void setNPasses(int n) {
    }
}

