/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.plugin.filter.EDM;
import ij.plugin.filter.ExtendedPlugInFilter;
import ij.plugin.filter.PlugInFilterRunner;
import ij.plugin.frame.ThresholdAdjuster;
import ij.process.ByteProcessor;
import ij.process.FloodFiller;
import ij.process.ImageProcessor;
import java.awt.AWTEvent;

public class Binary
implements ExtendedPlugInFilter,
DialogListener {
    static final int MAX_ITERATIONS = 100;
    static final String NO_OPERATION = "Nothing";
    static final String[] outputTypes = new String[]{"Overwrite", "8-bit", "16-bit", "32-bit"};
    static final String[] operations = new String[]{"Nothing", "Erode", "Dilate", "Open", "Close", "Outline", "Fill Holes", "Skeletonize"};
    static int iterations = 1;
    static int count = 1;
    String operation = "Nothing";
    String arg;
    ImagePlus imp;
    PlugInFilterRunner pfr;
    boolean doOptions;
    boolean previewing;
    boolean escapePressed;
    int foreground;
    int background;
    int flags = 16941123;
    int nPasses;

    public int setup(String string, ImagePlus imagePlus) {
        this.arg = string;
        IJ.register(Binary.class);
        this.doOptions = string.equals("options");
        if (this.doOptions) {
            if (imagePlus == null) {
                return 512;
            }
            ImageProcessor imageProcessor = imagePlus.getProcessor();
            if (!(imageProcessor instanceof ByteProcessor)) {
                return 512;
            }
            if (!((ByteProcessor)imageProcessor).isBinary()) {
                return 512;
            }
        }
        return this.flags;
    }

    public int showDialog(ImagePlus imagePlus, String string, PlugInFilterRunner plugInFilterRunner) {
        if (this.doOptions) {
            this.imp = imagePlus;
            this.pfr = plugInFilterRunner;
            GenericDialog genericDialog = new GenericDialog("Binary Options");
            genericDialog.addNumericField("Iterations (1-100):", iterations, 0, 3, "");
            genericDialog.addNumericField("Count (1-8):", count, 0, 3, "");
            genericDialog.addCheckbox("Black background", Prefs.blackBackground);
            genericDialog.addCheckbox("Pad edges when eroding", Prefs.padEdges);
            genericDialog.addChoice("EDM output:", outputTypes, outputTypes[EDM.getOutputType()]);
            if (imagePlus != null) {
                genericDialog.addChoice("Do:", operations, this.operation);
                genericDialog.addPreviewCheckbox(plugInFilterRunner);
                genericDialog.addDialogListener(this);
                this.previewing = true;
            }
            genericDialog.addHelp("http://imagej.nih.gov/ij/docs/menus/process.html#options");
            genericDialog.showDialog();
            this.previewing = false;
            if (genericDialog.wasCanceled()) {
                return 4096;
            }
            if (imagePlus == null) {
                this.dialogItemChanged(genericDialog, null);
                return 4096;
            }
            return this.operation.equals(NO_OPERATION) ? 4096 : IJ.setupDialog(imagePlus, this.flags);
        }
        if (!((ByteProcessor)imagePlus.getProcessor()).isBinary()) {
            IJ.error("8-bit binary (black and white only) image required.");
            return 4096;
        }
        return IJ.setupDialog(imagePlus, this.flags);
    }

    public boolean dialogItemChanged(GenericDialog genericDialog, AWTEvent aWTEvent) {
        iterations = (int)genericDialog.getNextNumber();
        count = (int)genericDialog.getNextNumber();
        boolean bl = Prefs.blackBackground;
        Prefs.blackBackground = genericDialog.getNextBoolean();
        if (Prefs.blackBackground != bl) {
            ThresholdAdjuster.update();
        }
        Prefs.padEdges = genericDialog.getNextBoolean();
        EDM.setOutputType(genericDialog.getNextChoiceIndex());
        boolean bl2 = genericDialog.invalidNumber();
        if (iterations < 1) {
            iterations = 1;
            bl2 = true;
        }
        if (iterations > 100) {
            iterations = 100;
            bl2 = true;
        }
        if (count < 1) {
            count = 1;
            bl2 = true;
        }
        if (count > 8) {
            count = 8;
            bl2 = true;
        }
        if (bl2) {
            return false;
        }
        if (this.imp != null) {
            this.operation = genericDialog.getNextChoice();
            this.arg = this.operation.toLowerCase();
        }
        return true;
    }

    public void setNPasses(int n) {
        this.nPasses = n;
    }

    public void run(ImageProcessor imageProcessor) {
        int n = this.foreground = Prefs.blackBackground ? 255 : 0;
        if (imageProcessor.isInvertedLut()) {
            this.foreground = 255 - this.foreground;
        }
        this.background = 255 - this.foreground;
        imageProcessor.setSnapshotCopyMode(true);
        if (this.arg.equals("outline")) {
            this.outline(imageProcessor);
        } else if (this.arg.startsWith("fill")) {
            this.fill(imageProcessor, this.foreground, this.background);
        } else if (this.arg.startsWith("skel")) {
            imageProcessor.resetRoi();
            this.skeletonize(imageProcessor);
        } else if (this.arg.equals("erode") || this.arg.equals("dilate")) {
            this.doIterations((ByteProcessor)imageProcessor, this.arg);
        } else if (this.arg.equals("open")) {
            this.doIterations(imageProcessor, "erode");
            this.doIterations(imageProcessor, "dilate");
        } else if (this.arg.equals("close")) {
            this.doIterations(imageProcessor, "dilate");
            this.doIterations(imageProcessor, "erode");
        }
        imageProcessor.setSnapshotCopyMode(false);
        imageProcessor.setBinaryThreshold();
    }

    void doIterations(ImageProcessor imageProcessor, String string) {
        if (this.escapePressed) {
            return;
        }
        if (!this.previewing && iterations > 1) {
            IJ.showStatus(this.arg + "... press ESC to cancel");
        }
        for (int i = 0; i < iterations; ++i) {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            if (IJ.escapePressed()) {
                this.escapePressed = true;
                imageProcessor.reset();
                return;
            }
            if (this.nPasses <= 1) {
                IJ.showProgress(i + 1, iterations);
            }
            if (string.equals("erode")) {
                ((ByteProcessor)imageProcessor).erode(count, this.background);
                continue;
            }
            ((ByteProcessor)imageProcessor).dilate(count, this.background);
        }
    }

    void outline(ImageProcessor imageProcessor) {
        if (Prefs.blackBackground) {
            imageProcessor.invert();
        }
        ((ByteProcessor)imageProcessor).outline();
        if (Prefs.blackBackground) {
            imageProcessor.invert();
        }
    }

    void skeletonize(ImageProcessor imageProcessor) {
        if (Prefs.blackBackground) {
            imageProcessor.invert();
        }
        boolean bl = this.hasEdgePixels(imageProcessor);
        ImageProcessor imageProcessor2 = this.expand(imageProcessor, bl);
        ((ByteProcessor)imageProcessor2).skeletonize();
        imageProcessor = this.shrink(imageProcessor, imageProcessor2, bl);
        if (Prefs.blackBackground) {
            imageProcessor.invert();
        }
    }

    boolean hasEdgePixels(ImageProcessor imageProcessor) {
        int n;
        int n2 = imageProcessor.getWidth();
        int n3 = imageProcessor.getHeight();
        boolean bl = false;
        for (n = 0; n < n2; ++n) {
            if (imageProcessor.getPixel(n, 0) != this.foreground) continue;
            bl = true;
        }
        for (n = 0; n < n2; ++n) {
            if (imageProcessor.getPixel(n, n3 - 1) != this.foreground) continue;
            bl = true;
        }
        for (n = 0; n < n3; ++n) {
            if (imageProcessor.getPixel(0, n) != this.foreground) continue;
            bl = true;
        }
        for (n = 0; n < n3; ++n) {
            if (imageProcessor.getPixel(n2 - 1, n) != this.foreground) continue;
            bl = true;
        }
        return bl;
    }

    ImageProcessor expand(ImageProcessor imageProcessor, boolean bl) {
        if (bl) {
            ImageProcessor imageProcessor2 = imageProcessor.createProcessor(imageProcessor.getWidth() + 2, imageProcessor.getHeight() + 2);
            if (this.foreground == 0) {
                imageProcessor2.setColor(255);
                imageProcessor2.fill();
            }
            imageProcessor2.insert(imageProcessor, 1, 1);
            return imageProcessor2;
        }
        return imageProcessor;
    }

    ImageProcessor shrink(ImageProcessor imageProcessor, ImageProcessor imageProcessor2, boolean bl) {
        if (bl) {
            int n = imageProcessor.getWidth();
            int n2 = imageProcessor.getHeight();
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    imageProcessor.putPixel(j, i, imageProcessor2.getPixel(j + 1, i + 1));
                }
            }
        }
        return imageProcessor;
    }

    void fill(ImageProcessor imageProcessor, int n, int n2) {
        int n3;
        int n4 = imageProcessor.getWidth();
        int n5 = imageProcessor.getHeight();
        FloodFiller floodFiller = new FloodFiller(imageProcessor);
        imageProcessor.setColor(127);
        for (n3 = 0; n3 < n5; ++n3) {
            if (imageProcessor.getPixel(0, n3) == n2) {
                floodFiller.fill(0, n3);
            }
            if (imageProcessor.getPixel(n4 - 1, n3) != n2) continue;
            floodFiller.fill(n4 - 1, n3);
        }
        for (n3 = 0; n3 < n4; ++n3) {
            if (imageProcessor.getPixel(n3, 0) == n2) {
                floodFiller.fill(n3, 0);
            }
            if (imageProcessor.getPixel(n3, n5 - 1) != n2) continue;
            floodFiller.fill(n3, n5 - 1);
        }
        byte[] byArray = (byte[])imageProcessor.getPixels();
        int n6 = n4 * n5;
        for (int i = 0; i < n6; ++i) {
            byArray[i] = byArray[i] == 127 ? (byte)n2 : (byte)n;
        }
    }
}

