/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.Prefs;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.plugin.filter.ExtendedPlugInFilter;
import ij.plugin.filter.PlugInFilterRunner;
import ij.plugin.filter.RollingBall;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import ij.util.Tools;
import java.awt.AWTEvent;

public class BackgroundSubtracter
implements ExtendedPlugInFilter,
DialogListener {
    private static double radius = 50.0;
    private static boolean lightBackground = Prefs.get("bs.background", true);
    private static boolean separateColors;
    private static boolean createBackground;
    private static boolean useParaboloid;
    private static boolean doPresmooth;
    private boolean isRGB;
    private boolean previewing;
    private static final int MAXIMUM = 0;
    private static final int MEAN = 1;
    private static final int X_DIRECTION = 0;
    private static final int Y_DIRECTION = 1;
    private static final int DIAGONAL_1A = 2;
    private static final int DIAGONAL_1B = 3;
    private static final int DIAGONAL_2A = 4;
    private static final int DIAGONAL_2B = 5;
    private static final int DIRECTION_PASSES = 9;
    private int nPasses = 9;
    private int pass;
    private int flags = 16875551;

    public int setup(String string, ImagePlus imagePlus) {
        if (string.equals("final")) {
            imagePlus.getProcessor().resetMinAndMax();
            return 4096;
        }
        return this.flags;
    }

    public int showDialog(ImagePlus imagePlus, String string, PlugInFilterRunner plugInFilterRunner) {
        this.isRGB = imagePlus.getProcessor() instanceof ColorProcessor;
        String string2 = Macro.getOptions();
        if (string2 != null) {
            Macro.setOptions(string2.replaceAll("white", "light"));
        }
        GenericDialog genericDialog = new GenericDialog(string);
        genericDialog.addNumericField("Rolling ball radius:", radius, 1, 6, "pixels");
        genericDialog.addCheckbox("Light background", lightBackground);
        if (this.isRGB) {
            genericDialog.addCheckbox("Separate colors", separateColors);
        }
        genericDialog.addCheckbox("Create background (don't subtract)", createBackground);
        genericDialog.addCheckbox("Sliding paraboloid", useParaboloid);
        genericDialog.addCheckbox("Disable smoothing", !doPresmooth);
        genericDialog.addPreviewCheckbox(plugInFilterRunner);
        genericDialog.addDialogListener(this);
        this.previewing = true;
        genericDialog.addHelp("http://imagej.nih.gov/ij/docs/menus/process.html#background");
        genericDialog.showDialog();
        this.previewing = false;
        if (genericDialog.wasCanceled()) {
            return 4096;
        }
        IJ.register(this.getClass());
        Prefs.set("bs.background", lightBackground);
        if (imagePlus.getProcessor() instanceof FloatProcessor && !createBackground) {
            this.flags |= 0x4000;
        }
        return IJ.setupDialog(imagePlus, this.flags);
    }

    public boolean dialogItemChanged(GenericDialog genericDialog, AWTEvent aWTEvent) {
        radius = genericDialog.getNextNumber();
        if (radius <= 1.0E-4 || genericDialog.invalidNumber()) {
            return false;
        }
        lightBackground = genericDialog.getNextBoolean();
        if (this.isRGB) {
            separateColors = genericDialog.getNextBoolean();
        }
        createBackground = genericDialog.getNextBoolean();
        useParaboloid = genericDialog.getNextBoolean();
        doPresmooth = !genericDialog.getNextBoolean();
        return true;
    }

    public void run(ImageProcessor imageProcessor) {
        if (this.isRGB && !separateColors) {
            this.rollingBallBrightnessBackground((ColorProcessor)imageProcessor, radius, createBackground, lightBackground, useParaboloid, doPresmooth, true);
        } else {
            this.rollingBallBackground(imageProcessor, radius, createBackground, lightBackground, useParaboloid, doPresmooth, true);
        }
        if (this.previewing && (imageProcessor instanceof FloatProcessor || imageProcessor instanceof ShortProcessor)) {
            imageProcessor.resetMinAndMax();
        }
    }

    public void subtractRGBBackround(ColorProcessor colorProcessor, int n) {
        this.rollingBallBrightnessBackground(colorProcessor, n, false, lightBackground, false, true, true);
    }

    public void subtractBackround(ImageProcessor imageProcessor, int n) {
        this.rollingBallBackground(imageProcessor, n, false, lightBackground, false, true, true);
    }

    public void rollingBallBrightnessBackground(ColorProcessor colorProcessor, double d, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        int n = colorProcessor.getWidth();
        int n2 = colorProcessor.getHeight();
        byte[] byArray = new byte[n * n2];
        byte[] byArray2 = new byte[n * n2];
        byte[] byArray3 = new byte[n * n2];
        colorProcessor.getHSB(byArray, byArray2, byArray3);
        ByteProcessor byteProcessor = new ByteProcessor(n, n2, byArray3, null);
        this.rollingBallBackground(byteProcessor, d, bl, bl2, bl3, bl4, bl5);
        colorProcessor.setHSB(byArray, byArray2, (byte[])byteProcessor.getPixels());
    }

    public void rollingBallBackground(ImageProcessor imageProcessor, double d, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        boolean bl6 = imageProcessor.isInvertedLut();
        boolean bl7 = bl6 && !bl2 || !bl6 && bl2;
        RollingBall rollingBall = null;
        if (!bl3) {
            rollingBall = new RollingBall(d);
        }
        FloatProcessor floatProcessor = null;
        for (int i = 0; i < imageProcessor.getNChannels(); ++i) {
            int n;
            floatProcessor = imageProcessor.toFloat(i, floatProcessor);
            if (bl3) {
                this.slidingParaboloidFloatBackground(floatProcessor, (float)d, bl7, bl4, bl5);
            } else {
                this.rollingBallFloatBackground(floatProcessor, (float)d, bl7, bl4, rollingBall);
            }
            if (bl) {
                imageProcessor.setPixels(i, floatProcessor);
                continue;
            }
            float[] fArray = (float[])floatProcessor.getPixels();
            if (imageProcessor instanceof FloatProcessor) {
                float[] fArray2 = (float[])floatProcessor.getSnapshotPixels();
                for (int j = 0; j < fArray.length; ++j) {
                    fArray[j] = fArray2[j] - fArray[j];
                }
                continue;
            }
            if (imageProcessor instanceof ShortProcessor) {
                float f = bl7 ? 65535.5f : 0.5f;
                short[] sArray = (short[])imageProcessor.getPixels();
                for (n = 0; n < fArray.length; ++n) {
                    float f2 = (float)(sArray[n] & 0xFFFF) - fArray[n] + f;
                    if (f2 < 0.0f) {
                        f2 = 0.0f;
                    }
                    if (f2 > 65535.0f) {
                        f2 = 65535.0f;
                    }
                    sArray[n] = (short)f2;
                }
                continue;
            }
            if (imageProcessor instanceof ByteProcessor) {
                float f = bl7 ? 255.5f : 0.5f;
                byte[] byArray = (byte[])imageProcessor.getPixels();
                for (n = 0; n < fArray.length; ++n) {
                    float f3 = (float)(byArray[n] & 0xFF) - fArray[n] + f;
                    if (f3 < 0.0f) {
                        f3 = 0.0f;
                    }
                    if (f3 > 255.0f) {
                        f3 = 255.0f;
                    }
                    byArray[n] = (byte)f3;
                }
                continue;
            }
            if (!(imageProcessor instanceof ColorProcessor)) continue;
            float f = bl7 ? 255.5f : 0.5f;
            int[] nArray = (int[])imageProcessor.getPixels();
            n = 16 - 8 * i;
            int n2 = 255 << n;
            int n3 = 0xFFFFFFFF ^ 255 << n;
            for (int j = 0; j < fArray.length; ++j) {
                int n4 = nArray[j];
                float f4 = (float)((n4 & n2) >> n) - fArray[j] + f;
                if (f4 < 0.0f) {
                    f4 = 0.0f;
                }
                if (f4 > 255.0f) {
                    f4 = 255.0f;
                }
                nArray[j] = n4 & n3 | (int)f4 << n;
            }
        }
    }

    void slidingParaboloidFloatBackground(FloatProcessor floatProcessor, float f, boolean bl, boolean bl2, boolean bl3) {
        block7: {
            float f2;
            float[] fArray;
            block6: {
                fArray = (float[])floatProcessor.getPixels();
                int n = floatProcessor.getWidth();
                int n2 = floatProcessor.getHeight();
                float[] fArray2 = new float[Math.max(n, n2)];
                int[] nArray = new int[Math.max(n, n2)];
                float f3 = 0.5f / f;
                float f4 = 1.0f / f;
                this.showProgress(1.0E-6);
                if (bl) {
                    for (int i = 0; i < fArray.length; ++i) {
                        fArray[i] = -fArray[i];
                    }
                }
                f2 = 0.0f;
                if (bl2) {
                    f2 = (float)this.filter3x3(floatProcessor, 0);
                    this.showProgress(0.5);
                    this.filter3x3(floatProcessor, 1);
                    ++this.pass;
                }
                if (bl3) {
                    this.correctCorners(floatProcessor, f3, fArray2, nArray);
                }
                this.filter1D(floatProcessor, 0, f3, fArray2, nArray);
                this.filter1D(floatProcessor, 1, f3, fArray2, nArray);
                this.filter1D(floatProcessor, 0, f3, fArray2, nArray);
                this.filter1D(floatProcessor, 2, f4, fArray2, nArray);
                this.filter1D(floatProcessor, 3, f4, fArray2, nArray);
                this.filter1D(floatProcessor, 4, f4, fArray2, nArray);
                this.filter1D(floatProcessor, 5, f4, fArray2, nArray);
                this.filter1D(floatProcessor, 2, f4, fArray2, nArray);
                this.filter1D(floatProcessor, 3, f4, fArray2, nArray);
                if (!bl) break block6;
                for (int i = 0; i < fArray.length; ++i) {
                    fArray[i] = -(fArray[i] - f2);
                }
                break block7;
            }
            if (!bl2) break block7;
            int n = 0;
            while (n < fArray.length) {
                int n3 = n++;
                fArray[n3] = fArray[n3] - f2;
            }
        }
    }

    void filter1D(FloatProcessor floatProcessor, int n, float f, float[] fArray, int[] nArray) {
        float[] fArray2 = (float[])floatProcessor.getPixels();
        int n2 = floatProcessor.getWidth();
        int n3 = floatProcessor.getHeight();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        switch (n) {
            case 0: {
                n5 = n3;
                n6 = n2;
                n7 = 1;
                n8 = n2;
                break;
            }
            case 1: {
                n5 = n2;
                n6 = 1;
                n7 = n2;
                n8 = n3;
                break;
            }
            case 2: {
                n5 = n2 - 2;
                n6 = 1;
                n7 = n2 + 1;
                break;
            }
            case 3: {
                n4 = 1;
                n5 = n3 - 2;
                n6 = n2;
                n7 = n2 + 1;
                break;
            }
            case 4: {
                n4 = 2;
                n5 = n2;
                n6 = 1;
                n7 = n2 - 1;
                break;
            }
            case 5: {
                n4 = 0;
                n5 = n3 - 2;
                n6 = n2;
                n7 = n2 - 1;
            }
        }
        for (int i = n4; i < n5; ++i) {
            if (i % 50 == 0) {
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                this.showProgress((double)i / (double)n5);
            }
            int n9 = i * n6;
            if (n == 5) {
                n9 += n2 - 1;
            }
            switch (n) {
                case 2: {
                    n8 = Math.min(n3, n2 - i);
                    break;
                }
                case 3: {
                    n8 = Math.min(n2, n3 - i);
                    break;
                }
                case 4: {
                    n8 = Math.min(n3, i + 1);
                    break;
                }
                case 5: {
                    n8 = Math.min(n2, n3 - i);
                }
            }
            BackgroundSubtracter.lineSlideParabola(fArray2, n9, n7, n8, f, fArray, nArray, null);
        }
        ++this.pass;
    }

    static float[] lineSlideParabola(float[] fArray, int n, int n2, int n3, float f, float[] fArray2, int[] nArray, float[] fArray3) {
        int n4;
        float f2;
        float f3;
        float f4 = Float.MAX_VALUE;
        int n5 = 0;
        int n6 = n3 - 1;
        int n7 = 0;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 1.999f * f;
        int n8 = 0;
        int n9 = n;
        while (n8 < n3) {
            fArray2[n8] = f3 = fArray[n9];
            if (f3 < f4) {
                f4 = f3;
            }
            if (n8 >= 2 && f5 + f5 - f6 - f3 < f7) {
                nArray[n5] = n8 - 1;
                n5 = n8 - 1;
            }
            f6 = f5;
            f5 = f3;
            ++n8;
            n9 += n2;
        }
        nArray[n5] = n3 - 1;
        nArray[n3 - 1] = Integer.MAX_VALUE;
        n8 = 0;
        while (n8 < n3 - 1) {
            float f8 = fArray2[n8];
            f3 = Float.MAX_VALUE;
            int n10 = 0;
            int n11 = n3;
            int n12 = 0;
            int n13 = nArray[n8];
            while (n13 < n11) {
                double d;
                int n14;
                float f9 = fArray2[n13];
                f2 = (f9 - f8) / (float)(n13 - n8) + f * (float)(n13 - n8);
                if (f2 < f3) {
                    f3 = f2;
                    n10 = n13;
                    n12 = -3;
                }
                if (n12 == 0 && (n14 = n8 + (int)((d = (double)(0.5f * f3 / f)) + Math.sqrt(d * d + (double)((f8 - f4) / f)) + 1.0)) < n11 && n14 > 0) {
                    n11 = n14;
                }
                n13 = nArray[n13];
                ++n12;
            }
            if (n8 == 0) {
                n6 = n10;
            }
            if (n10 == n3 - 1) {
                n7 = n8;
            }
            n13 = n8 + 1;
            n4 = n + n13 * n2;
            while (n13 < n10) {
                fArray[n4] = f8 + (float)(n13 - n8) * (f3 - (float)(n13 - n8) * f);
                ++n13;
                n4 += n2;
            }
            n8 = n10;
        }
        if (fArray3 != null) {
            if (4 * n6 >= n3) {
                n6 = 0;
            }
            if (4 * (n3 - 1 - n7) >= n3) {
                n7 = n3 - 1;
            }
            float f10 = fArray2[n6];
            f3 = fArray2[n7];
            float f11 = (f3 - f10) / (float)(n7 - n6);
            float f12 = f10 - f11 * (float)n6;
            float f13 = 0.0f;
            float f14 = 0.5f * (float)(n7 + n6);
            for (n4 = (n3 + 2) / 3; n4 <= 2 * n3 / 3; ++n4) {
                f2 = ((float)n4 - f14) * 2.0f / (float)(n7 - n6);
                float f15 = f2 * f2 * f2 * f2 * f2 * f2 - 1.0f;
                if (!(fArray2[n4] < f12 + f11 * (float)n4 + f13 * f15)) continue;
                f13 = -(f12 + f11 * (float)n4 - fArray2[n4]) / f15;
            }
            float f16 = ((float)n6 - f14) * 2.0f / (float)(n7 - n6);
            fArray3[0] = f12 + f13 * (f16 * f16 * f16 * f16 * f16 * f16 - 1.0f) + f * (float)n6 * (float)n6;
            f16 = ((float)n7 - f14) * 2.0f / (float)(n7 - n6);
            fArray3[1] = f12 + (float)(n3 - 1) * f11 + f13 * (f16 * f16 * f16 * f16 * f16 * f16 - 1.0f) + f * (float)(n3 - 1 - n7) * (float)(n3 - 1 - n7);
        }
        return fArray3;
    }

    void correctCorners(FloatProcessor floatProcessor, float f, float[] fArray, int[] nArray) {
        int n = floatProcessor.getWidth();
        int n2 = floatProcessor.getHeight();
        float[] fArray2 = (float[])floatProcessor.getPixels();
        float[] fArray3 = new float[4];
        float[] fArray4 = new float[2];
        fArray4 = BackgroundSubtracter.lineSlideParabola(fArray2, 0, 1, n, f, fArray, nArray, fArray4);
        fArray3[0] = fArray4[0];
        fArray3[1] = fArray4[1];
        fArray4 = BackgroundSubtracter.lineSlideParabola(fArray2, (n2 - 1) * n, 1, n, f, fArray, nArray, fArray4);
        fArray3[2] = fArray4[0];
        fArray3[3] = fArray4[1];
        fArray4 = BackgroundSubtracter.lineSlideParabola(fArray2, 0, n, n2, f, fArray, nArray, fArray4);
        fArray3[0] = fArray3[0] + fArray4[0];
        fArray3[2] = fArray3[2] + fArray4[1];
        fArray4 = BackgroundSubtracter.lineSlideParabola(fArray2, n - 1, n, n2, f, fArray, nArray, fArray4);
        fArray3[1] = fArray3[1] + fArray4[0];
        fArray3[3] = fArray3[3] + fArray4[1];
        int n3 = Math.min(n, n2);
        float f2 = 2.0f * f;
        fArray4 = BackgroundSubtracter.lineSlideParabola(fArray2, 0, 1 + n, n3, f2, fArray, nArray, fArray4);
        fArray3[0] = fArray3[0] + fArray4[0];
        fArray4 = BackgroundSubtracter.lineSlideParabola(fArray2, n - 1, -1 + n, n3, f2, fArray, nArray, fArray4);
        fArray3[1] = fArray3[1] + fArray4[0];
        fArray4 = BackgroundSubtracter.lineSlideParabola(fArray2, (n2 - 1) * n, 1 - n, n3, f2, fArray, nArray, fArray4);
        fArray3[2] = fArray3[2] + fArray4[0];
        fArray4 = BackgroundSubtracter.lineSlideParabola(fArray2, n * n2 - 1, -1 - n, n3, f2, fArray, nArray, fArray4);
        fArray3[3] = fArray3[3] + fArray4[0];
        if (fArray2[0] > fArray3[0] / 3.0f) {
            fArray2[0] = fArray3[0] / 3.0f;
        }
        if (fArray2[n - 1] > fArray3[1] / 3.0f) {
            fArray2[n - 1] = fArray3[1] / 3.0f;
        }
        if (fArray2[(n2 - 1) * n] > fArray3[2] / 3.0f) {
            fArray2[(n2 - 1) * n] = fArray3[2] / 3.0f;
        }
        if (fArray2[n * n2 - 1] > fArray3[3] / 3.0f) {
            fArray2[n * n2 - 1] = fArray3[3] / 3.0f;
        }
    }

    void rollingBallFloatBackground(FloatProcessor floatProcessor, float f, boolean bl, boolean bl2, RollingBall rollingBall) {
        FloatProcessor floatProcessor2;
        float[] fArray = (float[])floatProcessor.getPixels();
        boolean bl3 = rollingBall.shrinkFactor > 1;
        this.showProgress(0.0);
        if (bl) {
            for (int i = 0; i < fArray.length; ++i) {
                fArray[i] = -fArray[i];
            }
        }
        if (bl2) {
            this.filter3x3(floatProcessor, 1);
        }
        double[] dArray = Tools.getMinMax(fArray);
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        FloatProcessor floatProcessor3 = floatProcessor2 = bl3 ? this.shrinkImage(floatProcessor, rollingBall.shrinkFactor) : floatProcessor;
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        this.rollBall(rollingBall, floatProcessor2);
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        this.showProgress(0.9);
        if (bl3) {
            this.enlargeImage(floatProcessor2, floatProcessor, rollingBall.shrinkFactor);
        }
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        if (bl) {
            for (int i = 0; i < fArray.length; ++i) {
                fArray[i] = -fArray[i];
            }
        }
        ++this.pass;
    }

    FloatProcessor shrinkImage(FloatProcessor floatProcessor, int n) {
        int n2 = floatProcessor.getWidth();
        int n3 = floatProcessor.getHeight();
        float[] fArray = (float[])floatProcessor.getPixels();
        int n4 = (n2 + n - 1) / n;
        int n5 = (n3 + n - 1) / n;
        this.showProgress(0.1);
        FloatProcessor floatProcessor2 = new FloatProcessor(n4, n5);
        float[] fArray2 = (float[])floatProcessor2.getPixels();
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < n4; ++j) {
                float f = Float.MAX_VALUE;
                int n6 = 0;
                for (int k = n * i; n6 < n && k < n3; ++n6, ++k) {
                    int n7 = 0;
                    for (int i2 = n * j; n7 < n && i2 < n2; ++n7, ++i2) {
                        float f2 = fArray[i2 + k * n2];
                        if (!(f2 < f)) continue;
                        f = f2;
                    }
                }
                fArray2[j + i * n4] = f;
            }
        }
        return floatProcessor2;
    }

    void rollBall(RollingBall rollingBall, FloatProcessor floatProcessor) {
        float[] fArray = (float[])floatProcessor.getPixels();
        int n = floatProcessor.getWidth();
        int n2 = floatProcessor.getHeight();
        float[] fArray2 = rollingBall.data;
        int n3 = rollingBall.width;
        int n4 = n3 / 2;
        float[] fArray3 = new float[n * n3];
        Thread thread = Thread.currentThread();
        long l = System.currentTimeMillis();
        for (int i = -n4; i < n2 + n4; ++i) {
            int n5;
            int n6;
            long l2 = System.currentTimeMillis();
            if (l2 - l > 100L) {
                l = l2;
                if (thread.isInterrupted()) {
                    return;
                }
                this.showProgress(0.1 + 0.8 * (double)i / (double)(n2 + n3));
            }
            int n7 = (i + n4) % n3;
            int n8 = i + n4;
            if (n8 < n2) {
                System.arraycopy(fArray, n8 * n, fArray3, n7 * n, n);
                n6 = 0;
                n5 = n8 * n;
                while (n6 < n) {
                    fArray[n5] = -3.4028235E38f;
                    ++n6;
                    ++n5;
                }
            }
            if ((n6 = i - n4) < 0) {
                n6 = 0;
            }
            n5 = n6 - i + n4;
            int n9 = i + n4;
            if (n9 >= n2) {
                n9 = n2 - 1;
            }
            for (int j = -n4; j < n + n4; ++j) {
                float f;
                int n10;
                int n11;
                int n12;
                float f2 = Float.MAX_VALUE;
                int n13 = j - n4;
                if (n13 < 0) {
                    n13 = 0;
                }
                int n14 = n13 - j + n4;
                int n15 = j + n4;
                if (n15 >= n) {
                    n15 = n - 1;
                }
                int n16 = n6;
                int n17 = n5;
                while (n16 <= n9) {
                    n12 = n16 % n3 * n + n13;
                    n11 = n13;
                    n10 = n14 + n17 * n3;
                    while (n11 <= n15) {
                        f = fArray3[n12] - fArray2[n10];
                        if (f2 > f) {
                            f2 = f;
                        }
                        ++n11;
                        ++n12;
                        ++n10;
                    }
                    ++n16;
                    ++n17;
                }
                n16 = n6;
                n17 = n5;
                while (n16 <= n9) {
                    n12 = n13;
                    n11 = n12 + n16 * n;
                    n10 = n14 + n17 * n3;
                    while (n12 <= n15) {
                        f = f2 + fArray2[n10];
                        if (fArray[n11] < f) {
                            fArray[n11] = f;
                        }
                        ++n12;
                        ++n11;
                        ++n10;
                    }
                    ++n16;
                    ++n17;
                }
            }
        }
    }

    void enlargeImage(FloatProcessor floatProcessor, FloatProcessor floatProcessor2, int n) {
        int n2;
        int n3 = floatProcessor2.getWidth();
        int n4 = floatProcessor2.getHeight();
        int n5 = floatProcessor.getWidth();
        int n6 = floatProcessor.getHeight();
        float[] fArray = (float[])floatProcessor2.getPixels();
        float[] fArray2 = (float[])floatProcessor.getPixels();
        int[] nArray = new int[n3];
        float[] fArray3 = new float[n3];
        this.makeInterpolationArrays(nArray, fArray3, n3, n5, n);
        int[] nArray2 = new int[n4];
        float[] fArray4 = new float[n4];
        this.makeInterpolationArrays(nArray2, fArray4, n4, n6, n);
        float[] fArray5 = new float[n3];
        float[] fArray6 = new float[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            fArray6[n2] = fArray2[nArray[n2]] * fArray3[n2] + fArray2[nArray[n2] + 1] * (1.0f - fArray3[n2]);
        }
        n2 = -1;
        for (int i = 0; i < n4; ++i) {
            int n7;
            int n8;
            if (n2 < nArray2[i]) {
                float[] fArray7 = fArray5;
                fArray5 = fArray6;
                fArray6 = fArray7;
                ++n2;
                n8 = (nArray2[i] + 1) * n5;
                for (n7 = 0; n7 < n3; ++n7) {
                    fArray6[n7] = fArray2[n8 + nArray[n7]] * fArray3[n7] + fArray2[n8 + nArray[n7] + 1] * (1.0f - fArray3[n7]);
                }
            }
            float f = fArray4[i];
            n8 = 0;
            n7 = i * n3;
            while (n8 < n3) {
                fArray[n7] = fArray5[n8] * f + fArray6[n8] * (1.0f - f);
                ++n8;
                ++n7;
            }
        }
    }

    void makeInterpolationArrays(int[] nArray, float[] fArray, int n, int n2, int n3) {
        for (int i = 0; i < n; ++i) {
            int n4 = (i - n3 / 2) / n3;
            if (n4 >= n2 - 1) {
                n4 = n2 - 2;
            }
            nArray[i] = n4;
            float f = ((float)i + 0.5f) / (float)n3 - ((float)n4 + 0.5f);
            fArray[i] = 1.0f - f;
        }
    }

    double filter3x3(FloatProcessor floatProcessor, int n) {
        int n2;
        int n3 = floatProcessor.getWidth();
        int n4 = floatProcessor.getHeight();
        double d = 0.0;
        float[] fArray = (float[])floatProcessor.getPixels();
        for (n2 = 0; n2 < n4; ++n2) {
            d += this.filter3(fArray, n3, n2 * n3, 1, n);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            d += this.filter3(fArray, n4, n2, n3, n);
        }
        return d / (double)n3 / (double)n4;
    }

    double filter3(float[] fArray, int n, int n2, int n3, int n4) {
        float f;
        double d = 0.0;
        float f2 = f = fArray[n2];
        int n5 = 0;
        int n6 = n2;
        while (n5 < n) {
            float f3 = f2;
            f2 = f;
            if (n5 < n - 1) {
                f = fArray[n6 + n3];
            }
            if (n4 == 0) {
                float f4;
                float f5 = f4 = f3 > f ? f3 : f;
                if (f2 > f4) {
                    f4 = f2;
                }
                d += (double)(f4 - f2);
                fArray[n6] = f4;
            } else {
                fArray[n6] = (f3 + f2 + f) * 0.33333334f;
            }
            ++n5;
            n6 += n3;
        }
        return d;
    }

    public void setNPasses(int n) {
        if (this.isRGB && separateColors) {
            n *= 3;
        }
        this.nPasses = n;
        if (useParaboloid) {
            n *= doPresmooth ? 11 : 9;
        }
        this.pass = 0;
    }

    private void showProgress(double d) {
        if (this.nPasses <= 0) {
            return;
        }
        d = (double)this.pass / (double)this.nPasses + d / (double)this.nPasses;
        IJ.showProgress(d);
    }

    static {
        doPresmooth = true;
    }
}

