/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.macro.Interpreter;
import ij.plugin.ChannelSplitter;
import ij.plugin.PlugIn;
import ij.plugin.RGBStackMerge;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;

public class ZProjector
implements PlugIn {
    public static final int AVG_METHOD = 0;
    public static final int MAX_METHOD = 1;
    public static final int MIN_METHOD = 2;
    public static final int SUM_METHOD = 3;
    public static final int SD_METHOD = 4;
    public static final int MEDIAN_METHOD = 5;
    public static final String[] METHODS = new String[]{"Average Intensity", "Max Intensity", "Min Intensity", "Sum Slices", "Standard Deviation", "Median"};
    private static final String METHOD_KEY = "zproject.method";
    private int method = (int)Prefs.get("zproject.method", 0.0);
    private static final int BYTE_TYPE = 0;
    private static final int SHORT_TYPE = 1;
    private static final int FLOAT_TYPE = 2;
    public static final String lutMessage = "Stacks with inverter LUTs may not project correctly.\nTo create a standard LUT, invert the stack (Edit/Invert)\nand invert the LUT (Image/Lookup Tables/Invert LUT).";
    private ImagePlus projImage = null;
    private ImagePlus imp = null;
    private int startSlice = 1;
    private int stopSlice = 1;
    private boolean allTimeFrames = true;
    private String color = "";
    private boolean isHyperstack;
    private int increment = 1;
    private int sliceCount;

    public ZProjector() {
    }

    public ZProjector(ImagePlus imagePlus) {
        this.setImage(imagePlus);
    }

    public void setImage(ImagePlus imagePlus) {
        this.imp = imagePlus;
        this.startSlice = 1;
        this.stopSlice = imagePlus.getStackSize();
    }

    public void setStartSlice(int n) {
        if (this.imp == null || n < 1 || n > this.imp.getStackSize()) {
            return;
        }
        this.startSlice = n;
    }

    public void setStopSlice(int n) {
        if (this.imp == null || n < 1 || n > this.imp.getStackSize()) {
            return;
        }
        this.stopSlice = n;
    }

    public void setMethod(int n) {
        this.method = n;
    }

    public ImagePlus getProjection() {
        return this.projImage;
    }

    public void run(String string) {
        int n;
        this.imp = WindowManager.getCurrentImage();
        int n2 = this.imp.getStackSize();
        if (this.imp == null) {
            IJ.noImage();
            return;
        }
        if (n2 == 1) {
            IJ.error("ZProjection", "Stack required");
            return;
        }
        if (this.imp.getProcessor().isInvertedLut() && !IJ.showMessageWithCancel("ZProjection", lutMessage)) {
            return;
        }
        int n3 = this.imp.getNFrames();
        int n4 = this.imp.getNSlices();
        this.isHyperstack = this.imp.isHyperStack() || Interpreter.isBatchMode() && (n3 > 1 && n3 < n2 || n4 > 1 && n4 < n2);
        this.startSlice = 1;
        this.stopSlice = this.isHyperstack ? ((n = this.imp.getNSlices()) > 1 ? n : this.imp.getNFrames()) : n2;
        GenericDialog genericDialog = this.buildControlDialog(this.startSlice, this.stopSlice);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        if (!this.imp.lock()) {
            return;
        }
        long l = System.currentTimeMillis();
        this.setStartSlice((int)genericDialog.getNextNumber());
        this.setStopSlice((int)genericDialog.getNextNumber());
        this.method = genericDialog.getNextChoiceIndex();
        Prefs.set(METHOD_KEY, this.method);
        if (this.isHyperstack) {
            this.allTimeFrames = this.imp.getNFrames() > 1 && this.imp.getNSlices() > 1 ? genericDialog.getNextBoolean() : false;
            this.doHyperStackProjection(this.allTimeFrames);
        } else if (this.imp.getType() == 4) {
            this.doRGBProjection();
        } else {
            this.doProjection();
        }
        if (string.equals("") && this.projImage != null) {
            long l2 = System.currentTimeMillis();
            this.projImage.setCalibration(this.imp.getCalibration());
            this.projImage.show("ZProjector: " + IJ.d2s((double)(l2 - l) / 1000.0, 2) + " seconds");
        }
        this.imp.unlock();
        IJ.register(ZProjector.class);
    }

    public void doRGBProjection() {
        this.doRGBProjection(this.imp.getStack());
    }

    private void doRGBProjection(ImageStack imageStack) {
        ImageStack[] imageStackArray = ChannelSplitter.splitRGB(imageStack, true);
        ImagePlus imagePlus = new ImagePlus("Red", imageStackArray[0]);
        ImagePlus imagePlus2 = new ImagePlus("Green", imageStackArray[1]);
        ImagePlus imagePlus3 = new ImagePlus("Blue", imageStackArray[2]);
        this.imp.unlock();
        ImagePlus imagePlus4 = this.imp;
        this.imp = imagePlus;
        this.color = "(red)";
        this.doProjection();
        ImagePlus imagePlus5 = this.projImage;
        this.imp = imagePlus2;
        this.color = "(green)";
        this.doProjection();
        ImagePlus imagePlus6 = this.projImage;
        this.imp = imagePlus3;
        this.color = "(blue)";
        this.doProjection();
        ImagePlus imagePlus7 = this.projImage;
        int n = imagePlus5.getWidth();
        int n2 = imagePlus5.getHeight();
        int n3 = imagePlus5.getStackSize();
        RGBStackMerge rGBStackMerge = new RGBStackMerge();
        ImageStack imageStack2 = rGBStackMerge.mergeStacks(n, n2, n3, imagePlus5.getStack(), imagePlus6.getStack(), imagePlus7.getStack(), true);
        this.imp = imagePlus4;
        this.projImage = new ImagePlus(this.makeTitle(), imageStack2);
    }

    protected GenericDialog buildControlDialog(int n, int n2) {
        GenericDialog genericDialog = new GenericDialog("ZProjection", IJ.getInstance());
        genericDialog.addNumericField("Start slice:", this.startSlice, 0);
        genericDialog.addNumericField("Stop slice:", this.stopSlice, 0);
        genericDialog.addChoice("Projection Type", METHODS, METHODS[this.method]);
        if (this.isHyperstack && this.imp.getNFrames() > 1 && this.imp.getNSlices() > 1) {
            genericDialog.addCheckbox("All Time Frames", this.allTimeFrames);
        }
        return genericDialog;
    }

    public void doProjection() {
        int n;
        if (this.imp == null) {
            return;
        }
        this.sliceCount = 0;
        if (this.method < 0 || this.method > 5) {
            this.method = 0;
        }
        for (int i = this.startSlice; i <= this.stopSlice; i += this.increment) {
            ++this.sliceCount;
        }
        if (this.method == 5) {
            this.projImage = this.doMedianProjection();
            return;
        }
        FloatProcessor floatProcessor = new FloatProcessor(this.imp.getWidth(), this.imp.getHeight());
        ImageStack imageStack = this.imp.getStack();
        RayFunction rayFunction = this.getRayFunction(this.method, floatProcessor);
        if (IJ.debugMode) {
            IJ.log("\nProjecting stack from: " + this.startSlice + " to: " + this.stopSlice);
        }
        if (imageStack.getProcessor(1) instanceof ByteProcessor) {
            n = 0;
        } else if (imageStack.getProcessor(1) instanceof ShortProcessor) {
            n = 1;
        } else if (imageStack.getProcessor(1) instanceof FloatProcessor) {
            n = 2;
        } else {
            IJ.error("ZProjector: Non-RGB stack required");
            return;
        }
        for (int i = this.startSlice; i <= this.stopSlice; i += this.increment) {
            IJ.showStatus("ZProjection " + this.color + ": " + i + "/" + this.stopSlice);
            IJ.showProgress(i - this.startSlice, this.stopSlice - this.startSlice);
            this.projectSlice(imageStack.getPixels(i), rayFunction, n);
        }
        if (this.method == 3) {
            floatProcessor.resetMinAndMax();
            this.projImage = new ImagePlus(this.makeTitle(), floatProcessor);
        } else if (this.method == 4) {
            rayFunction.postProcess();
            floatProcessor.resetMinAndMax();
            this.projImage = new ImagePlus(this.makeTitle(), floatProcessor);
        } else {
            rayFunction.postProcess();
            this.projImage = this.makeOutputImage(this.imp, floatProcessor, n);
        }
        if (this.projImage == null) {
            IJ.error("ZProjection - error computing projection.");
        }
    }

    public void doHyperStackProjection(boolean bl) {
        int n = this.startSlice;
        int n2 = this.stopSlice;
        int n3 = 1;
        int n4 = this.imp.getNFrames();
        if (!bl) {
            n3 = n4 = this.imp.getFrame();
        }
        ImageStack imageStack = new ImageStack(this.imp.getWidth(), this.imp.getHeight());
        int n5 = this.imp.getNChannels();
        int n6 = this.imp.getNSlices();
        if (n6 == 1) {
            n6 = this.imp.getNFrames();
            n4 = 1;
            n3 = 1;
        }
        int n7 = n4 - n3 + 1;
        this.increment = n5;
        boolean bl2 = this.imp.getBitDepth() == 24;
        for (int i = n3; i <= n4; ++i) {
            for (int j = 1; j <= n5; ++j) {
                this.startSlice = (i - 1) * n5 * n6 + (n - 1) * n5 + j;
                this.stopSlice = (i - 1) * n5 * n6 + (n2 - 1) * n5 + j;
                if (bl2) {
                    this.doHSRGBProjection(this.imp);
                } else {
                    this.doProjection();
                }
                imageStack.addSlice(null, this.projImage.getProcessor());
            }
        }
        this.projImage = new ImagePlus(this.makeTitle(), imageStack);
        this.projImage.setDimensions(n5, 1, n7);
        if (n5 > 1) {
            this.projImage = new CompositeImage(this.projImage, 0);
            ((CompositeImage)this.projImage).copyLuts(this.imp);
            if (this.method == 3 || this.method == 4) {
                ((CompositeImage)this.projImage).resetDisplayRanges();
            }
        }
        if (n7 > 1) {
            this.projImage.setOpenAsHyperStack(true);
        }
        IJ.showProgress(1, 1);
    }

    private void doHSRGBProjection(ImagePlus imagePlus) {
        ImageStack imageStack = imagePlus.getStack();
        ImageStack imageStack2 = new ImageStack(imageStack.getWidth(), imageStack.getHeight());
        for (int i = this.startSlice; i <= this.stopSlice; ++i) {
            imageStack2.addSlice(null, imageStack.getProcessor(i));
        }
        this.startSlice = 1;
        this.stopSlice = imageStack2.getSize();
        this.doRGBProjection(imageStack2);
    }

    private RayFunction getRayFunction(int n, FloatProcessor floatProcessor) {
        switch (n) {
            case 0: 
            case 3: {
                return new AverageIntensity(floatProcessor, this.sliceCount);
            }
            case 1: {
                return new MaxIntensity(floatProcessor);
            }
            case 2: {
                return new MinIntensity(floatProcessor);
            }
            case 4: {
                return new StandardDeviation(floatProcessor, this.sliceCount);
            }
        }
        IJ.error("ZProjection - unknown method.");
        return null;
    }

    private ImagePlus makeOutputImage(ImagePlus imagePlus, FloatProcessor floatProcessor, int n) {
        int n2 = imagePlus.getWidth();
        int n3 = imagePlus.getHeight();
        float[] fArray = (float[])floatProcessor.getPixels();
        ImageProcessor imageProcessor = null;
        int n4 = fArray.length;
        switch (n) {
            case 0: {
                imageProcessor = imagePlus.getProcessor().createProcessor(n2, n3);
                byte[] byArray = (byte[])imageProcessor.getPixels();
                for (int i = 0; i < n4; ++i) {
                    byArray[i] = (byte)fArray[i];
                }
                break;
            }
            case 1: {
                imageProcessor = imagePlus.getProcessor().createProcessor(n2, n3);
                short[] sArray = (short[])imageProcessor.getPixels();
                for (int i = 0; i < n4; ++i) {
                    sArray[i] = (short)fArray[i];
                }
                break;
            }
            case 2: {
                imageProcessor = new FloatProcessor(n2, n3, fArray, null);
            }
        }
        imageProcessor.resetMinAndMax();
        return new ImagePlus(this.makeTitle(), imageProcessor);
    }

    private void projectSlice(Object object, RayFunction rayFunction, int n) {
        switch (n) {
            case 0: {
                rayFunction.projectSlice((byte[])object);
                break;
            }
            case 1: {
                rayFunction.projectSlice((short[])object);
                break;
            }
            case 2: {
                rayFunction.projectSlice((float[])object);
            }
        }
    }

    String makeTitle() {
        String string = "AVG_";
        switch (this.method) {
            case 3: {
                string = "SUM_";
                break;
            }
            case 1: {
                string = "MAX_";
                break;
            }
            case 2: {
                string = "MIN_";
                break;
            }
            case 4: {
                string = "STD_";
                break;
            }
            case 5: {
                string = "MED_";
            }
        }
        return WindowManager.makeUniqueName(string + this.imp.getTitle());
    }

    ImagePlus doMedianProjection() {
        IJ.showStatus("Calculating median...");
        ImageStack imageStack = this.imp.getStack();
        ImageProcessor[] imageProcessorArray = new ImageProcessor[this.sliceCount];
        int n = 0;
        for (int i = this.startSlice; i <= this.stopSlice; i += this.increment) {
            imageProcessorArray[n++] = imageStack.getProcessor(i);
        }
        ImageProcessor imageProcessor = imageProcessorArray[0].duplicate();
        imageProcessor = imageProcessor.convertToFloat();
        float[] fArray = new float[this.sliceCount];
        int n2 = imageProcessor.getWidth();
        int n3 = imageProcessor.getHeight();
        int n4 = Math.max(n3 / 30, 1);
        for (int i = 0; i < n3; ++i) {
            if (i % n4 == 0) {
                IJ.showProgress(i, n3 - 1);
            }
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < this.sliceCount; ++k) {
                    fArray[k] = imageProcessorArray[k].getPixelValue(j, i);
                }
                imageProcessor.putPixelValue(j, i, this.median(fArray));
            }
        }
        return new ImagePlus(this.makeTitle(), imageProcessor);
    }

    float median(float[] fArray) {
        this.sort(fArray);
        int n = fArray.length;
        if ((n & 1) == 0) {
            return (fArray[n / 2 - 1] + fArray[n / 2]) / 2.0f;
        }
        return fArray[n / 2];
    }

    void sort(float[] fArray) {
        if (!this.alreadySorted(fArray)) {
            this.sort(fArray, 0, fArray.length - 1);
        }
    }

    void sort(float[] fArray, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        float f = fArray[(n + n2) / 2];
        while (true) {
            if (n3 < n2 && f > fArray[n3]) {
                ++n3;
                continue;
            }
            while (n4 > n && f < fArray[n4]) {
                --n4;
            }
            if (n3 < n4) {
                float f2 = fArray[n3];
                fArray[n3] = fArray[n4];
                fArray[n4] = f2;
            }
            if (n3 <= n4) {
                ++n3;
                --n4;
            }
            if (n3 > n4) break;
        }
        if (n < n4) {
            this.sort(fArray, n, n4);
        }
        if (n3 < n2) {
            this.sort(fArray, n3, n2);
        }
    }

    boolean alreadySorted(float[] fArray) {
        for (int i = 1; i < fArray.length; ++i) {
            if (!(fArray[i] < fArray[i - 1])) continue;
            return false;
        }
        return true;
    }

    class StandardDeviation
    extends RayFunction {
        private float[] result;
        private double[] sum;
        private double[] sum2;
        private int num;
        private int len;

        public StandardDeviation(FloatProcessor floatProcessor, int n) {
            this.result = (float[])floatProcessor.getPixels();
            this.len = this.result.length;
            this.num = n;
            this.sum = new double[this.len];
            this.sum2 = new double[this.len];
        }

        public void projectSlice(byte[] byArray) {
            int n = 0;
            while (n < this.len) {
                int n2 = byArray[n] & 0xFF;
                int n3 = n;
                this.sum[n3] = this.sum[n3] + (double)n2;
                int n4 = n++;
                this.sum2[n4] = this.sum2[n4] + (double)(n2 * n2);
            }
        }

        public void projectSlice(short[] sArray) {
            int n = 0;
            while (n < this.len) {
                double d = sArray[n] & 0xFFFF;
                int n2 = n;
                this.sum[n2] = this.sum[n2] + d;
                int n3 = n++;
                this.sum2[n3] = this.sum2[n3] + d * d;
            }
        }

        public void projectSlice(float[] fArray) {
            int n = 0;
            while (n < this.len) {
                double d = fArray[n];
                int n2 = n;
                this.sum[n2] = this.sum[n2] + d;
                int n3 = n++;
                this.sum2[n3] = this.sum2[n3] + d * d;
            }
        }

        public void postProcess() {
            double d = this.num;
            for (int i = 0; i < this.len; ++i) {
                if (this.num > 1) {
                    double d2 = (d * this.sum2[i] - this.sum[i] * this.sum[i]) / d;
                    if (d2 > 0.0) {
                        this.result[i] = (float)Math.sqrt(d2 / (d - 1.0));
                        continue;
                    }
                    this.result[i] = 0.0f;
                    continue;
                }
                this.result[i] = 0.0f;
            }
        }
    }

    class MinIntensity
    extends RayFunction {
        private float[] fpixels;
        private int len;

        public MinIntensity(FloatProcessor floatProcessor) {
            this.fpixels = (float[])floatProcessor.getPixels();
            this.len = this.fpixels.length;
            for (int i = 0; i < this.len; ++i) {
                this.fpixels[i] = Float.MAX_VALUE;
            }
        }

        public void projectSlice(byte[] byArray) {
            for (int i = 0; i < this.len; ++i) {
                if (!((float)(byArray[i] & 0xFF) < this.fpixels[i])) continue;
                this.fpixels[i] = byArray[i] & 0xFF;
            }
        }

        public void projectSlice(short[] sArray) {
            for (int i = 0; i < this.len; ++i) {
                if (!((float)(sArray[i] & 0xFFFF) < this.fpixels[i])) continue;
                this.fpixels[i] = sArray[i] & 0xFFFF;
            }
        }

        public void projectSlice(float[] fArray) {
            for (int i = 0; i < this.len; ++i) {
                if (!(fArray[i] < this.fpixels[i])) continue;
                this.fpixels[i] = fArray[i];
            }
        }
    }

    class MaxIntensity
    extends RayFunction {
        private float[] fpixels;
        private int len;

        public MaxIntensity(FloatProcessor floatProcessor) {
            this.fpixels = (float[])floatProcessor.getPixels();
            this.len = this.fpixels.length;
            for (int i = 0; i < this.len; ++i) {
                this.fpixels[i] = -3.4028235E38f;
            }
        }

        public void projectSlice(byte[] byArray) {
            for (int i = 0; i < this.len; ++i) {
                if (!((float)(byArray[i] & 0xFF) > this.fpixels[i])) continue;
                this.fpixels[i] = byArray[i] & 0xFF;
            }
        }

        public void projectSlice(short[] sArray) {
            for (int i = 0; i < this.len; ++i) {
                if (!((float)(sArray[i] & 0xFFFF) > this.fpixels[i])) continue;
                this.fpixels[i] = sArray[i] & 0xFFFF;
            }
        }

        public void projectSlice(float[] fArray) {
            for (int i = 0; i < this.len; ++i) {
                if (!(fArray[i] > this.fpixels[i])) continue;
                this.fpixels[i] = fArray[i];
            }
        }
    }

    class AverageIntensity
    extends RayFunction {
        private float[] fpixels;
        private int num;
        private int len;

        public AverageIntensity(FloatProcessor floatProcessor, int n) {
            this.fpixels = (float[])floatProcessor.getPixels();
            this.len = this.fpixels.length;
            this.num = n;
        }

        public void projectSlice(byte[] byArray) {
            for (int i = 0; i < this.len; ++i) {
                int n = i;
                this.fpixels[n] = this.fpixels[n] + (float)(byArray[i] & 0xFF);
            }
        }

        public void projectSlice(short[] sArray) {
            for (int i = 0; i < this.len; ++i) {
                int n = i;
                this.fpixels[n] = this.fpixels[n] + (float)(sArray[i] & 0xFFFF);
            }
        }

        public void projectSlice(float[] fArray) {
            for (int i = 0; i < this.len; ++i) {
                int n = i;
                this.fpixels[n] = this.fpixels[n] + fArray[i];
            }
        }

        public void postProcess() {
            float f = this.num;
            int n = 0;
            while (n < this.len) {
                int n2 = n++;
                this.fpixels[n2] = this.fpixels[n2] / f;
            }
        }
    }

    abstract class RayFunction {
        RayFunction() {
        }

        public abstract void projectSlice(byte[] var1);

        public abstract void projectSlice(short[] var1);

        public abstract void projectSlice(float[] var1);

        public void postProcess() {
        }
    }
}

