/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.io.FileSaver;
import ij.io.SaveDialog;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.plugin.frame.Recorder;
import ij.process.ImageProcessor;
import ij.process.LUT;
import java.io.File;
import java.util.Locale;
import java.util.Properties;

public class StackWriter
implements PlugIn {
    private static String[] choices = new String[]{"BMP", "FITS", "GIF", "JPEG", "PGM", "PNG", "Raw", "Text", "TIFF", "ZIP"};
    private static String fileType = "TIFF";
    private static int ndigits = 4;
    private static boolean useLabels;
    private static boolean firstTime;
    private int startAt;
    private boolean hyperstack;
    private int[] dim;

    public void run(String string) {
        boolean bl;
        Object object;
        Object object2;
        Object object3;
        int n;
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null || imagePlus != null && imagePlus.getStackSize() < 2) {
            IJ.error("Stack Writer", "This command requires a stack.");
            return;
        }
        int n2 = imagePlus.getStackSize();
        String string2 = imagePlus.getTitle();
        int n3 = string2.lastIndexOf(".");
        if (n3 >= 0) {
            string2 = string2.substring(0, n3);
        }
        this.hyperstack = imagePlus.isHyperStack();
        LUT[] lUTArray = null;
        int n4 = 0;
        int n5 = imagePlus.getNChannels();
        if (this.hyperstack) {
            this.dim = imagePlus.getDimensions();
            if (imagePlus.isComposite()) {
                lUTArray = ((CompositeImage)imagePlus).getLuts();
            }
            if (firstTime && ndigits == 4) {
                ndigits = 3;
                firstTime = false;
            }
        }
        GenericDialog genericDialog = new GenericDialog("Save Image Sequence");
        genericDialog.addChoice("Format:", choices, fileType);
        genericDialog.addStringField("Name:", string2, 12);
        if (!this.hyperstack) {
            genericDialog.addNumericField("Start At:", this.startAt, 0);
        }
        genericDialog.addNumericField("Digits (1-8):", ndigits, 0);
        if (!this.hyperstack) {
            genericDialog.addCheckbox("Use slice labels as file names", useLabels);
        }
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        fileType = genericDialog.getNextChoice();
        string2 = genericDialog.getNextString();
        if (!this.hyperstack) {
            this.startAt = (int)genericDialog.getNextNumber();
        }
        if (this.startAt < 0) {
            this.startAt = 0;
        }
        ndigits = (int)genericDialog.getNextNumber();
        useLabels = !this.hyperstack ? genericDialog.getNextBoolean() : false;
        int n6 = 0;
        if (ndigits < 1) {
            ndigits = 1;
        }
        if (ndigits > 8) {
            ndigits = 8;
        }
        if (n2 > (n = (int)Math.pow(10.0, ndigits)) && !useLabels && !this.hyperstack) {
            IJ.error("Stack Writer", "More than " + ndigits + " digits are required to generate \nunique file names for " + n2 + " images.");
            return;
        }
        String string3 = fileType.toLowerCase(Locale.US);
        if (string3.equals("gif") && !FileSaver.okForGif(imagePlus)) {
            return;
        }
        if (string3.equals("fits") && !FileSaver.okForFits(imagePlus)) {
            return;
        }
        if (string3.equals("text")) {
            string3 = "text image";
        }
        String string4 = "." + string3;
        if (string3.equals("tiff")) {
            string4 = ".tif";
        } else if (string3.equals("text image")) {
            string4 = ".txt";
        }
        String string5 = "Save Image Sequence";
        String string6 = Macro.getOptions();
        String string7 = null;
        if (string6 != null && (string7 = Macro.getValue(string6, string5, null)) != null) {
            object3 = new File(string7);
            if (!((File)object3).isDirectory() && (((File)object3).exists() || string7.lastIndexOf(".") > string7.length() - 5)) {
                string7 = ((File)object3).getParent();
            }
            if (!string7.endsWith(File.separator)) {
                string7 = string7 + File.separator;
            }
        }
        if (string7 == null) {
            if (Prefs.useFileChooser && !IJ.isMacOSX()) {
                object3 = this.getDigits(n6);
                object2 = new SaveDialog(string5, string2 + (String)object3 + string4, string4);
                object = ((SaveDialog)object2).getFileName();
                if (object == null) {
                    return;
                }
                string7 = ((SaveDialog)object2).getDirectory();
            } else {
                string7 = IJ.getDirectory(string5);
            }
        }
        if (string7 == null) {
            return;
        }
        boolean bl2 = bl = imagePlus.getOverlay() != null && !imagePlus.getHideOverlay();
        if (!string3.equals("jpeg") && !string3.equals("png")) {
            bl = false;
        }
        object2 = imagePlus.getStack();
        object = new ImagePlus();
        ((ImagePlus)object).setTitle(imagePlus.getTitle());
        Calibration calibration = imagePlus.getCalibration();
        int n7 = ((ImageStack)object2).getSize();
        String string8 = null;
        imagePlus.lock();
        for (int i = 1; i <= n7; ++i) {
            Object object4;
            IJ.showStatus("writing: " + i + "/" + n7);
            IJ.showProgress(i, n7);
            ImageProcessor imageProcessor = ((ImageStack)object2).getProcessor(i);
            if (bl) {
                imagePlus.setSliceWithoutUpdate(i);
                imageProcessor = imagePlus.flatten().getProcessor();
            } else if (lUTArray != null && n5 > 1 && this.hyperstack) {
                imageProcessor.setColorModel(lUTArray[n4++]);
                if (n4 >= lUTArray.length) {
                    n4 = 0;
                }
            }
            ((ImagePlus)object).setProcessor(null, imageProcessor);
            String string9 = ((ImageStack)object2).getSliceLabel(i);
            if (string9 != null && string9.indexOf("\n") != -1) {
                ((ImagePlus)object).setProperty("Info", string9);
            } else {
                object4 = ((ImagePlus)object).getProperties();
                if (object4 != null) {
                    ((Properties)object4).remove("Info");
                }
            }
            ((ImagePlus)object).setCalibration(calibration);
            object4 = this.getDigits(n6++);
            if (useLabels) {
                string8 = ((ImageStack)object2).getShortSliceLabel(i);
                if (string8 != null && string8.equals("")) {
                    string8 = null;
                }
                if (string8 != null) {
                    string8 = string8.replaceAll("/", "-");
                }
            }
            String string10 = string8 == null ? string7 + string2 + (String)object4 + string4 : string7 + string8 + string4;
            if (Recorder.record) {
                Recorder.disablePathRecording();
            }
            IJ.saveAs((ImagePlus)object, string3, string10);
        }
        imagePlus.unlock();
        if (bl) {
            imagePlus.setSlice(1);
        }
        IJ.showStatus("");
    }

    String getDigits(int n) {
        if (this.hyperstack) {
            int n2 = n % this.dim[2] + 1;
            int n3 = n / this.dim[2] % this.dim[3] + 1;
            int n4 = n / (this.dim[2] * this.dim[3]) % this.dim[4] + 1;
            String string = "";
            String string2 = "";
            String string3 = "";
            if (this.dim[2] > 1) {
                string = "00000000" + n2;
                string = "_c" + string.substring(string.length() - ndigits);
            }
            if (this.dim[3] > 1) {
                string2 = "00000000" + n3;
                string2 = "_z" + string2.substring(string2.length() - ndigits);
            }
            if (this.dim[4] > 1) {
                string3 = "00000000" + n4;
                string3 = "_t" + string3.substring(string3.length() - ndigits);
            }
            return string3 + string2 + string;
        }
        String string = "00000000" + (this.startAt + n);
        return string.substring(string.length() - ndigits);
    }

    static {
        firstTime = true;
    }
}

