/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import ij.process.StackProcessor;

public class StackMaker
implements PlugIn {
    private static int w = 2;
    private static int h = 2;
    private static int b = 0;

    public void run(String string) {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null) {
            IJ.noImage();
            return;
        }
        if (imagePlus.getStackSize() > 1) {
            IJ.error("This command requires a montage");
            return;
        }
        GenericDialog genericDialog = new GenericDialog("Stack Maker");
        genericDialog.addNumericField("Images_per_row: ", w, 0);
        genericDialog.addNumericField("Images_per_column: ", h, 0);
        genericDialog.addNumericField("Border width: ", b, 0);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        w = (int)genericDialog.getNextNumber();
        h = (int)genericDialog.getNextNumber();
        b = (int)genericDialog.getNextNumber();
        ImageStack imageStack = this.makeStack(imagePlus.getProcessor(), w, h, b);
        new ImagePlus("Stack", imageStack).show();
    }

    public ImageStack makeStack(ImageProcessor imageProcessor, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6 = n * n2;
        int n7 = imageProcessor.getWidth() / n;
        int n8 = imageProcessor.getHeight() / n2;
        ImageStack imageStack = new ImageStack(n7, n8);
        for (n5 = 0; n5 < n2; ++n5) {
            for (n4 = 0; n4 < n; ++n4) {
                imageProcessor.setRoi(n4 * n7, n5 * n8, n7, n8);
                imageStack.addSlice(null, imageProcessor.crop());
            }
        }
        if (n3 > 0) {
            n5 = n7 - n3 - n3 / 2;
            n4 = n8 - n3 - n3 / 2;
            StackProcessor stackProcessor = new StackProcessor(imageStack, imageProcessor);
            imageStack = stackProcessor.crop(n3, n3, n5, n4);
        }
        return imageStack;
    }
}

