/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;

public class StackInserter
implements PlugIn {
    private static int index1;
    private static int index2;
    private static int x;
    private static int y;

    public void run(String string) {
        Object object;
        int[] nArray = WindowManager.getIDList();
        if (nArray == null) {
            IJ.showMessage("Stack Inserter", "No windows are open.");
            return;
        }
        if (nArray.length == 1) {
            IJ.showMessage("Stack Inserter", "At least two windows must be open, \nincluding at least one stack.");
            return;
        }
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            object = WindowManager.getImage(nArray[i]);
            stringArray[i] = object != null ? ((ImagePlus)object).getTitle() : "";
        }
        if (index1 >= stringArray.length) {
            index1 = 0;
        }
        if (index2 >= stringArray.length) {
            index2 = 0;
        }
        GenericDialog genericDialog = new GenericDialog("Stack Inserter");
        genericDialog.addChoice("Source Image or Stack: ", stringArray, stringArray[index1]);
        genericDialog.addChoice("Destination Stack: ", stringArray, stringArray[index2]);
        genericDialog.addNumericField("X Location: ", 0.0, 0);
        genericDialog.addNumericField("Y Location: ", 0.0, 0);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        index1 = genericDialog.getNextChoiceIndex();
        index2 = genericDialog.getNextChoiceIndex();
        x = (int)genericDialog.getNextNumber();
        y = (int)genericDialog.getNextNumber();
        object = stringArray[index1];
        String string2 = stringArray[index2];
        ImagePlus imagePlus = WindowManager.getImage(nArray[index1]);
        ImagePlus imagePlus2 = WindowManager.getImage(nArray[index2]);
        if (imagePlus.getType() != imagePlus2.getType()) {
            IJ.showMessage("Stack Inserter", "The source and destination must be the same type.");
            return;
        }
        if (imagePlus2.getStackSize() == 1) {
            IJ.showMessage("Stack Inserter", "The destination must be a stack.");
            return;
        }
        if (imagePlus == imagePlus2) {
            IJ.showMessage("Stack Inserter", "The source and destination must be different.");
            return;
        }
        this.insert(imagePlus, imagePlus2, x, y);
    }

    public void insert(ImagePlus imagePlus, ImagePlus imagePlus2, int n, int n2) {
        ImageStack imageStack = imagePlus.getStack();
        ImageStack imageStack2 = imagePlus2.getStack();
        int n3 = imageStack.getSize();
        int n4 = imageStack2.getSize();
        for (int i = 1; i <= n4; ++i) {
            ImageProcessor imageProcessor = imageStack.getProcessor(i <= n3 ? i : n3);
            ImageProcessor imageProcessor2 = imageStack2.getProcessor(i);
            imageProcessor2.insert(imageProcessor, n, n2);
            imageStack2.setPixels(imageProcessor2.getPixels(), i);
        }
        imagePlus2.setStack(null, imageStack2);
    }
}

