/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.EllipseRoi;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.RoiProperties;
import ij.gui.ShapeRoi;
import ij.macro.Interpreter;
import ij.measure.Calibration;
import ij.measure.Measurements;
import ij.plugin.PlugIn;
import ij.plugin.filter.GaussianBlur;
import ij.plugin.filter.ThresholdToSelection;
import ij.plugin.frame.LineWidthAdjuster;
import ij.plugin.frame.RoiManager;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.util.Tools;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Polygon;
import java.awt.Rectangle;

public class Selection
implements PlugIn,
Measurements {
    private ImagePlus imp;
    private float[] kernel = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    private float[] kernel3 = new float[]{1.0f, 1.0f, 1.0f};
    private static String angle = "15";
    private static String enlarge = "15";
    private static int bandSize = 15;
    private static boolean nonScalable;
    private static Color linec;
    private static Color fillc;
    private static int lineWidth;

    public void run(String string) {
        this.imp = WindowManager.getCurrentImage();
        if (string.equals("add")) {
            this.addToRoiManager(this.imp);
            return;
        }
        if (this.imp == null) {
            IJ.noImage();
            return;
        }
        if (string.equals("all")) {
            this.imp.setRoi(0, 0, this.imp.getWidth(), this.imp.getHeight());
        } else if (string.equals("none")) {
            this.imp.killRoi();
        } else if (string.equals("restore")) {
            this.imp.restoreRoi();
        } else if (string.equals("spline")) {
            this.fitSpline();
        } else if (string.equals("circle")) {
            this.fitCircle(this.imp);
        } else if (string.equals("ellipse")) {
            this.createEllipse(this.imp);
        } else if (string.equals("hull")) {
            this.convexHull(this.imp);
        } else if (string.equals("mask")) {
            this.createMask(this.imp);
        } else if (string.equals("from")) {
            this.createSelectionFromMask(this.imp);
        } else if (string.equals("inverse")) {
            this.invert(this.imp);
        } else if (string.equals("tobox")) {
            this.toBoundingBox(this.imp);
        } else if (string.equals("toarea")) {
            this.lineToArea(this.imp);
        } else if (string.equals("toline")) {
            this.areaToLine(this.imp);
        } else if (string.equals("properties")) {
            this.setProperties("Properties", this.imp.getRoi());
            this.imp.draw();
        } else if (string.equals("band")) {
            this.makeBand(this.imp);
        } else {
            this.runMacro(string);
        }
    }

    void runMacro(String string) {
        String string2;
        Roi roi = this.imp.getRoi();
        if (IJ.macroRunning() && (string2 = Macro.getOptions()) != null && (string2.indexOf("grid=") != -1 || string2.indexOf("interpolat") != -1)) {
            IJ.run("Rotate... ", string2);
            return;
        }
        if (roi == null) {
            IJ.error("Rotate>Selection", "This command requires a selection");
            return;
        }
        roi = (Roi)roi.clone();
        if (string.equals("rotate")) {
            String string3;
            double d = Tools.parseDouble(angle);
            if (Double.isNaN(d)) {
                angle = "15";
            }
            if ((string3 = IJ.runMacroFile("ij.jar:RotateSelection", angle)) != null) {
                angle = string3;
            }
        } else if (string.equals("enlarge")) {
            string2 = IJ.runMacroFile("ij.jar:EnlargeSelection", enlarge);
            if (string2 != null) {
                enlarge = string2;
            }
            Roi.previousRoi = roi;
        }
    }

    void fitCircle(ImagePlus imagePlus) {
        double d;
        double d2;
        double d3;
        double d4;
        Roi roi = imagePlus.getRoi();
        if (roi == null) {
            IJ.error("Fit Circle", "Selection required");
            return;
        }
        if (roi.isArea()) {
            ImageProcessor imageProcessor = imagePlus.getProcessor();
            imageProcessor.setRoi(roi);
            ImageStatistics imageStatistics = ImageStatistics.getStatistics(imageProcessor, 33, null);
            double d5 = Math.sqrt((double)imageStatistics.pixelCount / Math.PI);
            imagePlus.killRoi();
            int n = (int)Math.round(2.0 * d5);
            IJ.makeOval((int)Math.round(imageStatistics.xCentroid - d5), (int)Math.round(imageStatistics.yCentroid - d5), n, n);
            return;
        }
        Polygon polygon = roi.getPolygon();
        int n = polygon.npoints;
        int[] nArray = polygon.xpoints;
        int[] nArray2 = polygon.ypoints;
        if (n < 3) {
            IJ.error("Fit Circle", "At least 3 points are required to fit a circle.");
            return;
        }
        double d6 = 0.0;
        double d7 = 0.0;
        for (int i = 0; i < n; ++i) {
            d6 += (double)polygon.xpoints[i];
            d7 += (double)polygon.ypoints[i];
        }
        double d8 = d6 / (double)n;
        double d9 = d7 / (double)n;
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = 0.0;
        double d14 = 0.0;
        double d15 = 0.0;
        for (int i = 0; i < n; ++i) {
            dArray[i] = (double)nArray[i] - d8;
            dArray2[i] = (double)nArray2[i] - d9;
            double d16 = dArray[i] * dArray[i] + dArray2[i] * dArray2[i];
            d12 += dArray[i] * dArray2[i];
            d10 += dArray[i] * dArray[i];
            d11 += dArray2[i] * dArray2[i];
            d13 += dArray[i] * d16;
            d14 += dArray2[i] * d16;
            d15 += d16 * d16;
        }
        double d17 = (d10 /= (double)n) + (d11 /= (double)n);
        double d18 = d10 * d11 - (d12 /= (double)n) * d12;
        double d19 = (d13 /= (double)n) * d13;
        double d20 = (d14 /= (double)n) * d14;
        double d21 = 4.0 * d18 - 3.0 * d17 * d17 - (d15 /= (double)n);
        double d22 = d15 * d17 + 4.0 * d18 * d17 - d19 - d20 - d17 * d17 * d17;
        double d23 = d19 * d11 + d20 * d10 - d15 * d18 - 2.0 * d13 * d14 * d12 + d17 * d17 * d18;
        double d24 = d21 + d21;
        double d25 = 1.0E-12;
        double d26 = 1.0E20;
        int n2 = 20;
        double d27 = 0.0;
        int n3 = 0;
        for (int i = 1; i <= n2; ++i) {
            n3 = i;
            double d28 = d26;
            d26 = d23 + d27 * (d22 + d27 * (d21 + 4.0 * d27 * d27));
            if (Math.abs(d26) > Math.abs(d28)) {
                if (IJ.debugMode) {
                    IJ.log("Fit Circle: wrong direction: |ynew| > |yold|");
                }
                d27 = 0.0;
                break;
            }
            double d29 = d27;
            double d30 = d22 + d27 * (d24 + 16.0 * d27 * d27);
            if (Math.abs(((d27 = d29 - d26 / d30) - d29) / d27) < d25) break;
            if (i >= n2) {
                if (IJ.debugMode) {
                    IJ.log("Fit Circle: will not converge");
                }
                d27 = 0.0;
            }
            if (!(d27 < 0.0)) continue;
            if (IJ.debugMode) {
                IJ.log("Fit Circle: negative root:  x = " + d27);
            }
            d27 = 0.0;
        }
        if (IJ.debugMode) {
            IJ.log("Fit Circle: n=" + n + ", xnew=" + IJ.d2s(d27, 2) + ", iterations=" + n3);
        }
        if (Double.isNaN(d4 = Math.sqrt((d3 = (d13 * (d11 - d27) - d14 * d12) / (2.0 * (d2 = d27 * d27 - d27 * d17 + d18))) * d3 + (d = (d14 * (d10 - d27) - d13 * d12) / (2.0 * d2)) * d + d17 + 2.0 * d27))) {
            IJ.error("Fit Circle", "Points are collinear.");
            return;
        }
        imagePlus.killRoi();
        IJ.makeOval((int)Math.round((d3 += d8) - d4), (int)Math.round((d += d9) - d4), (int)Math.round(2.0 * d4), (int)Math.round(2.0 * d4));
    }

    void fitSpline() {
        String string;
        boolean bl;
        Roi roi = this.imp.getRoi();
        if (roi == null) {
            IJ.error("Spline", "Selection required");
            return;
        }
        int n = roi.getType();
        boolean bl2 = bl = n == 2 || n == 6;
        if (!bl && n != 3 && n != 4 && n != 7) {
            IJ.error("Spline", "Polygon or polyline selection required");
            return;
        }
        if (roi instanceof EllipseRoi) {
            return;
        }
        PolygonRoi polygonRoi = (PolygonRoi)roi;
        if (!bl) {
            polygonRoi = this.trimPolygon(polygonRoi, polygonRoi.getUncalibratedLength());
        }
        if ((string = Macro.getOptions()) != null && string.indexOf("straighten") != -1) {
            polygonRoi.fitSplineForStraightening();
        } else if (string != null && string.indexOf("remove") != -1) {
            polygonRoi.removeSplineFit();
        } else {
            polygonRoi.fitSpline();
        }
        this.imp.draw();
        LineWidthAdjuster.update();
    }

    PolygonRoi trimPolygon(PolygonRoi polygonRoi, double d) {
        int n;
        int[] nArray = polygonRoi.getXCoordinates();
        int[] nArray2 = polygonRoi.getYCoordinates();
        int n2 = polygonRoi.getNCoordinates();
        nArray = this.smooth(nArray, n2);
        nArray2 = this.smooth(nArray2, n2);
        float[] fArray = this.getCurvature(nArray, nArray2, n2);
        Rectangle rectangle = polygonRoi.getBounds();
        double d2 = this.rodbard(d);
        double d3 = Math.sqrt((nArray[1] - nArray[0]) * (nArray[1] - nArray[0]) + (nArray2[1] - nArray2[0]) * (nArray2[1] - nArray2[0]));
        nArray[0] = nArray[0] + rectangle.x;
        nArray2[0] = nArray2[0] + rectangle.y;
        int n3 = 1;
        int n4 = 0;
        int n5 = 0;
        for (n = 1; n < n2 - 1; ++n) {
            int n6 = nArray[n];
            int n7 = nArray2[n];
            n4 = nArray[n + 1];
            n5 = nArray2[n + 1];
            d3 += Math.sqrt((n4 - n6) * (n4 - n6) + (n5 - n7) * (n5 - n7)) + 1.0;
            if (!((d3 += (double)(fArray[n] * 2.0f)) >= d2)) continue;
            nArray[n3] = n4 + rectangle.x;
            nArray2[n3] = n5 + rectangle.y;
            ++n3;
            d3 = 0.0;
        }
        int n8 = n = polygonRoi.getType() == 7 ? 6 : 2;
        if (n == 6 && d3 > 0.0) {
            nArray[n3] = n4 + rectangle.x;
            nArray2[n3] = n5 + rectangle.y;
            ++n3;
        }
        PolygonRoi polygonRoi2 = new PolygonRoi(nArray, nArray2, n3, n);
        this.imp.setRoi(polygonRoi2);
        return polygonRoi2;
    }

    double rodbard(double d) {
        double d2 = d == 0.0 ? 5.0 : Math.exp(Math.log(d / 700.0) * 0.88);
        double d3 = -40.1;
        return (d3 /= 1.0 + d2) + 44.0;
    }

    int[] smooth(int[] nArray, int n) {
        FloatProcessor floatProcessor = new FloatProcessor(n, 1);
        for (int i = 0; i < n; ++i) {
            floatProcessor.putPixelValue(i, 0, nArray[i]);
        }
        GaussianBlur gaussianBlur = new GaussianBlur();
        gaussianBlur.blur1Direction(floatProcessor, 2.0, 0.01, true, 0);
        for (int i = 0; i < n; ++i) {
            nArray[i] = Math.round(floatProcessor.getPixelValue(i, 0));
        }
        return nArray;
    }

    float[] getCurvature(int[] nArray, int[] nArray2, int n) {
        float[] fArray = new float[n];
        float[] fArray2 = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = nArray[i];
            fArray2[i] = nArray2[i];
        }
        FloatProcessor floatProcessor = new FloatProcessor(n, 1, fArray, null);
        FloatProcessor floatProcessor2 = new FloatProcessor(n, 1, fArray2, null);
        ((ImageProcessor)floatProcessor).convolve(this.kernel, this.kernel.length, 1);
        ((ImageProcessor)floatProcessor2).convolve(this.kernel, this.kernel.length, 1);
        float[] fArray3 = new float[n];
        float[] fArray4 = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray3[i] = i;
            fArray4[i] = (float)Math.sqrt((fArray[i] - (float)nArray[i]) * (fArray[i] - (float)nArray[i]) + (fArray2[i] - (float)nArray2[i]) * (fArray2[i] - (float)nArray2[i]));
        }
        return fArray4;
    }

    void createEllipse(ImagePlus imagePlus) {
        IJ.showStatus("Fitting ellipse");
        Roi roi = imagePlus.getRoi();
        if (roi == null) {
            IJ.error("Fit Ellipse", "Selection required");
            return;
        }
        if (roi.isLine()) {
            IJ.error("Fit Ellipse", "\"Fit Ellipse\" does not work with line selections");
            return;
        }
        ImageStatistics imageStatistics = imagePlus.getStatistics(2080);
        double d = imageStatistics.major * Math.cos(imageStatistics.angle / 180.0 * Math.PI) / 2.0;
        double d2 = -imageStatistics.major * Math.sin(imageStatistics.angle / 180.0 * Math.PI) / 2.0;
        double d3 = imageStatistics.xCentroid - d;
        double d4 = imageStatistics.xCentroid + d;
        double d5 = imageStatistics.yCentroid - d2;
        double d6 = imageStatistics.yCentroid + d2;
        double d7 = imageStatistics.minor / imageStatistics.major;
        imagePlus.killRoi();
        imagePlus.setRoi(new EllipseRoi(d3, d5, d4, d6, d7));
    }

    void convexHull(ImagePlus imagePlus) {
        int n;
        Roi roi = imagePlus.getRoi();
        int n2 = n = roi != null ? roi.getType() : -1;
        if (n != 3 && n != 4 && n != 2 && n != 10) {
            IJ.error("Convex Hull", "Polygonal or point selection required");
            return;
        }
        if (roi instanceof EllipseRoi) {
            return;
        }
        Polygon polygon = roi.getConvexHull();
        if (polygon != null) {
            imagePlus.setRoi(new PolygonRoi(polygon.xpoints, polygon.ypoints, polygon.npoints, 2));
        }
    }

    int findFirstPoint(int[] nArray, int[] nArray2, int n, ImagePlus imagePlus) {
        int n2;
        int n3;
        int n4 = imagePlus.getHeight();
        for (n3 = 0; n3 < n; ++n3) {
            n2 = nArray2[n3];
            if (n2 >= n4) continue;
            n4 = n2;
        }
        n3 = imagePlus.getWidth();
        int n5 = 0;
        for (int i = 0; i < n; ++i) {
            int n6 = nArray[i];
            n2 = nArray2[i];
            if (n2 != n4 || n6 >= n3) continue;
            n3 = n6;
            n5 = i;
        }
        return n5;
    }

    void createMask(ImagePlus imagePlus) {
        ImageProcessor imageProcessor;
        Roi roi = imagePlus.getRoi();
        boolean bl = Prefs.useInvertingLut;
        Prefs.useInvertingLut = false;
        if (roi == null || !roi.isArea() && roi.getType() != 10) {
            this.createMaskFromThreshold(imagePlus);
            Prefs.useInvertingLut = bl;
            return;
        }
        ImagePlus imagePlus2 = null;
        Frame frame = WindowManager.getFrame("Mask");
        if (frame != null && frame instanceof ImageWindow) {
            imagePlus2 = ((ImageWindow)frame).getImagePlus();
        }
        if (imagePlus2 == null) {
            imageProcessor = new ByteProcessor(imagePlus.getWidth(), imagePlus.getHeight());
            if (!Prefs.blackBackground) {
                imageProcessor.invertLut();
            }
            imagePlus2 = new ImagePlus("Mask", imageProcessor);
            imagePlus2.show();
        }
        imageProcessor = imagePlus2.getProcessor();
        imageProcessor.setRoi(roi);
        imageProcessor.setValue(255.0);
        imageProcessor.fill(imageProcessor.getMask());
        imagePlus2.updateAndDraw();
        Prefs.useInvertingLut = bl;
    }

    void createMaskFromThreshold(ImagePlus imagePlus) {
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        if (imageProcessor.getMinThreshold() == -808080.0) {
            IJ.error("Create Mask", "Area selection or thresholded image required");
            return;
        }
        double d = imageProcessor.getMinThreshold();
        double d2 = imageProcessor.getMaxThreshold();
        IJ.run("Duplicate...", "title=mask");
        ImagePlus imagePlus2 = WindowManager.getCurrentImage();
        ImageProcessor imageProcessor2 = imagePlus2.getProcessor();
        imageProcessor2.setThreshold(d, d2, 2);
        IJ.run("Convert to Mask");
    }

    void createSelectionFromMask(ImagePlus imagePlus) {
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        if (imageProcessor.getMinThreshold() != -808080.0) {
            IJ.runPlugIn("ij.plugin.filter.ThresholdToSelection", "");
            return;
        }
        if (!imageProcessor.isBinary()) {
            IJ.error("Create Selection", "This command creates a composite selection from\na mask (8-bit binary image with white background)\nor from an image that has been thresholded using\nthe Image>Adjust>Threshold tool. The current\nimage is not a mask and has not been thresholded.");
            return;
        }
        int n = imageProcessor.isInvertedLut() ? 255 : 0;
        imageProcessor.setThreshold(n, n, 2);
        IJ.runPlugIn("ij.plugin.filter.ThresholdToSelection", "");
    }

    void invert(ImagePlus imagePlus) {
        Roi roi = imagePlus.getRoi();
        if (roi == null || !roi.isArea()) {
            IJ.error("Inverse", "Area selection required");
            return;
        }
        ShapeRoi shapeRoi = roi instanceof ShapeRoi ? (ShapeRoi)roi : new ShapeRoi(roi);
        ShapeRoi shapeRoi2 = new ShapeRoi(new Roi(0, 0, imagePlus.getWidth(), imagePlus.getHeight()));
        imagePlus.setRoi(shapeRoi.xor(shapeRoi2));
    }

    void lineToArea(ImagePlus imagePlus) {
        Roi roi = imagePlus.getRoi();
        if (roi == null || !roi.isLine()) {
            IJ.error("Line to Area", "Line selection required");
            return;
        }
        if (roi.getType() == 5 && roi.getStrokeWidth() == 1.0f) {
            IJ.error("Line to Area", "Straight line width must be > 1");
            return;
        }
        ByteProcessor byteProcessor = new ByteProcessor(imagePlus.getWidth(), imagePlus.getHeight());
        byteProcessor.setColor(255);
        if (roi.getType() == 5) {
            byteProcessor.fillPolygon(roi.getPolygon());
        } else {
            roi.drawPixels(byteProcessor);
        }
        ((ImageProcessor)byteProcessor).setThreshold(255.0, 255.0, 2);
        ThresholdToSelection thresholdToSelection = new ThresholdToSelection();
        Roi roi2 = thresholdToSelection.convert(byteProcessor);
        imagePlus.setRoi(roi2);
        Roi.previousRoi = (Roi)roi.clone();
    }

    void areaToLine(ImagePlus imagePlus) {
        Roi roi = imagePlus.getRoi();
        if (roi == null || !roi.isArea()) {
            IJ.error("Area to Line", "Area selection required");
            return;
        }
        Polygon polygon = roi.getPolygon();
        if (polygon == null) {
            return;
        }
        int n = roi.getType();
        if (n == 9) {
            IJ.error("Area to Line", "Composite selections cannot be converted to lines.");
            return;
        }
        int n2 = 6;
        if (n == 1 || n == 3 || n == 4 || roi instanceof PolygonRoi && ((PolygonRoi)roi).isSplineFit()) {
            n2 = 7;
        }
        PolygonRoi polygonRoi = new PolygonRoi(polygon.xpoints, polygon.ypoints, polygon.npoints, n2);
        imagePlus.setRoi(polygonRoi);
    }

    void toBoundingBox(ImagePlus imagePlus) {
        Roi roi = imagePlus.getRoi();
        Rectangle rectangle = roi.getBounds();
        imagePlus.killRoi();
        imagePlus.setRoi(new Roi(rectangle.x, rectangle.y, rectangle.width, rectangle.height));
    }

    void addToRoiManager(ImagePlus imagePlus) {
        Frame frame;
        if (IJ.macroRunning() && Interpreter.isBatchModeRoiManager()) {
            IJ.error("run(\"Add to Manager\") may not work in batch mode macros");
        }
        if ((frame = WindowManager.getFrame("ROI Manager")) == null) {
            IJ.run("ROI Manager...");
        }
        if (imagePlus == null) {
            return;
        }
        Roi roi = imagePlus.getRoi();
        if (roi == null) {
            return;
        }
        frame = WindowManager.getFrame("ROI Manager");
        if (frame == null || !(frame instanceof RoiManager)) {
            IJ.error("ROI Manager not found");
        }
        RoiManager roiManager = (RoiManager)frame;
        boolean bl = IJ.altKeyDown();
        IJ.setKeyUp(-1);
        if (bl && !IJ.macroRunning()) {
            IJ.setKeyDown(16);
        }
        roiManager.runCommand("add");
        IJ.setKeyUp(-1);
    }

    boolean setProperties(String string, Roi roi) {
        Frame frame = WindowManager.getFrontWindow();
        if (frame != null && frame.getTitle().indexOf("3D Viewer") != -1) {
            return false;
        }
        if (roi == null) {
            IJ.error("This command requires a selection.");
            return false;
        }
        RoiProperties roiProperties = new RoiProperties(string, roi);
        return roiProperties.showDialog();
    }

    private void makeBand(ImagePlus imagePlus) {
        int n;
        Roi roi = imagePlus.getRoi();
        if (roi == null) {
            IJ.error("Make Band", "Selection required");
            return;
        }
        if (!roi.isArea()) {
            IJ.error("Make Band", "Area selection required");
            return;
        }
        Calibration calibration = imagePlus.getCalibration();
        double d = bandSize;
        double d2 = d * calibration.pixelWidth;
        int n2 = 0;
        if ((double)((int)d2) != d2) {
            n2 = 2;
        }
        GenericDialog genericDialog = new GenericDialog("Make Band");
        genericDialog.addNumericField("Band Size:", d2, n2, 4, calibration.getUnits());
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        d2 = genericDialog.getNextNumber();
        if (Double.isNaN(d2)) {
            IJ.error("Make Band", "invalid number");
            return;
        }
        int n3 = (int)Math.round(d2 / calibration.pixelWidth);
        if (n3 > 255) {
            IJ.error("Make Band", "Cannot make bands wider that 255 pixels");
            return;
        }
        int n4 = imagePlus.getWidth();
        int n5 = imagePlus.getHeight();
        Rectangle rectangle = roi.getBounds();
        ImageProcessor imageProcessor = roi.getMask();
        if (imageProcessor == null) {
            imageProcessor = new ByteProcessor(rectangle.width, rectangle.height);
            imageProcessor.invert();
        }
        ByteProcessor byteProcessor = new ByteProcessor(n4, n5);
        byteProcessor.insert(imageProcessor, rectangle.x, rectangle.y);
        ImagePlus imagePlus2 = new ImagePlus("mask", byteProcessor);
        boolean bl = Prefs.blackBackground;
        Prefs.blackBackground = false;
        IJ.run(imagePlus2, "Distance Map", "");
        Prefs.blackBackground = bl;
        imageProcessor = imagePlus2.getProcessor();
        imageProcessor.setThreshold(0.0, n3, 2);
        int n6 = -1;
        int n7 = -1;
        for (n = rectangle.x; n < rectangle.x + rectangle.width; ++n) {
            for (int i = rectangle.y; i < rectangle.y + rectangle.height; ++i) {
                if (imageProcessor.getPixel(n, i) >= n3) continue;
                n6 = n;
                n7 = i;
                break;
            }
            if (n6 >= 0 || n7 >= 0) break;
        }
        if ((n = IJ.doWand(imagePlus2, n6, n7, 0.0, null)) <= 0) {
            IJ.error("Make Band", "Unable to make band");
            return;
        }
        ShapeRoi shapeRoi = new ShapeRoi(imagePlus2.getRoi());
        if (!(roi instanceof ShapeRoi)) {
            roi = new ShapeRoi(roi);
        }
        ShapeRoi shapeRoi2 = (ShapeRoi)roi;
        shapeRoi = shapeRoi.not(shapeRoi2);
        imagePlus.setRoi(shapeRoi);
        bandSize = n3;
    }

    static {
        lineWidth = 1;
    }
}

