/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.gui.NonBlockingGenericDialog;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.plugin.Colors;
import ij.plugin.PlugIn;
import java.awt.AWTEvent;
import java.awt.Color;

public class RectToolOptions
implements PlugIn,
DialogListener {
    private String strokeColorName;
    private String fillColorName;
    private static GenericDialog gd;
    private static double defaultStrokeWidth;

    public void run(String string) {
        if (gd != null && gd.isVisible()) {
            gd.toFront();
        } else {
            this.rectToolOptions();
        }
    }

    void rectToolOptions() {
        Roi roi;
        Color color = Toolbar.getForegroundColor();
        Color color2 = null;
        double d = defaultStrokeWidth;
        int n = (int)Prefs.get("toolbar.arc.size", 20.0);
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        Roi roi2 = roi = imagePlus != null ? imagePlus.getRoi() : null;
        if (roi != null && roi.getType() == 0) {
            color = roi.getStrokeColor();
            if (color == null) {
                color = Roi.getColor();
            }
            color2 = roi.getFillColor();
            d = roi.getStrokeWidth();
            n = roi.getCornerDiameter();
        }
        String string = Colors.colorToString(color);
        String string2 = Colors.colorToString(color2);
        gd = new NonBlockingGenericDialog("Rounded Rectangle Tool");
        gd.addSlider("Stroke width:", 1.0, 25.0, (int)d);
        gd.addSlider("Corner diameter:", 0.0, 200.0, n);
        gd.addStringField("Stroke color: ", string);
        gd.addStringField("Fill color: ", string2);
        gd.addDialogListener(this);
        gd.showDialog();
    }

    public boolean dialogItemChanged(GenericDialog genericDialog, AWTEvent aWTEvent) {
        double d = genericDialog.getNextNumber();
        int n = (int)genericDialog.getNextNumber();
        String string = genericDialog.getNextString();
        String string2 = genericDialog.getNextString();
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        Roi roi = imagePlus != null ? imagePlus.getRoi() : null;
        Color color = null;
        if (roi != null && roi.getType() == 0) {
            roi.setStrokeWidth((int)d);
            roi.setCornerDiameter(n);
            color = Colors.decode(string, roi.getStrokeColor());
            Color color2 = Colors.decode(string2, roi.getFillColor());
            roi.setStrokeColor(color);
            roi.setFillColor(color2);
        }
        defaultStrokeWidth = d;
        if (color != null) {
            Toolbar.setForegroundColor(color);
        }
        Toolbar.setRoundRectArcSize(n);
        if (n > 0 && !Toolbar.getToolName().equals("roundrect")) {
            IJ.setTool("roundrect");
        }
        return true;
    }

    public static float getDefaultStrokeWidth() {
        return (float)defaultStrokeWidth;
    }

    static {
        defaultStrokeWidth = 2.0;
    }
}

