/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.process.LUT;
import java.awt.Color;
import java.awt.image.IndexColorModel;

public class RGBStackMerge
implements PlugIn {
    private static boolean staticCreateComposite = true;
    private static boolean staticKeep;
    private static boolean staticIgnoreLuts;
    private ImagePlus imp;
    private byte[] blank;
    private boolean ignoreLuts;

    public void run(String string) {
        this.imp = WindowManager.getCurrentImage();
        this.mergeStacks();
    }

    public static ImagePlus mergeChannels(ImagePlus[] imagePlusArray, boolean bl) {
        RGBStackMerge rGBStackMerge = new RGBStackMerge();
        return rGBStackMerge.mergeHyperstacks(imagePlusArray, bl);
    }

    public void mergeStacks() {
        int n;
        boolean bl;
        ImagePlus imagePlus;
        Object object;
        int n2;
        String string;
        int[] nArray = WindowManager.getIDList();
        if (nArray == null) {
            this.error("No images are open.");
            return;
        }
        String[] stringArray = new String[nArray.length + 1];
        for (int i = 0; i < nArray.length; ++i) {
            ImagePlus imagePlus2 = WindowManager.getImage(nArray[i]);
            stringArray[i] = imagePlus2 != null ? imagePlus2.getTitle() : "";
        }
        stringArray[nArray.length] = string = "*None*";
        boolean bl2 = staticCreateComposite;
        boolean bl3 = staticKeep;
        this.ignoreLuts = staticIgnoreLuts;
        if (IJ.isMacro()) {
            this.ignoreLuts = false;
            bl3 = false;
            bl2 = false;
        }
        GenericDialog genericDialog = new GenericDialog("Color Merge");
        genericDialog.addChoice("Red:", stringArray, stringArray[0]);
        genericDialog.addChoice("Green:", stringArray, stringArray[1]);
        String string2 = stringArray.length > 2 && !IJ.macroRunning() ? stringArray[2] : string;
        genericDialog.addChoice("Blue:", stringArray, string2);
        String string3 = stringArray.length > 3 && !IJ.macroRunning() ? stringArray[3] : string;
        genericDialog.addChoice("Gray:", stringArray, string3);
        genericDialog.addCheckbox("Create composite", bl2);
        genericDialog.addCheckbox("Keep source images", bl3);
        genericDialog.addCheckbox("Ignore source LUTs", this.ignoreLuts);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        int[] nArray2 = new int[]{genericDialog.getNextChoiceIndex(), genericDialog.getNextChoiceIndex(), genericDialog.getNextChoiceIndex(), genericDialog.getNextChoiceIndex()};
        bl2 = genericDialog.getNextBoolean();
        bl3 = genericDialog.getNextBoolean();
        this.ignoreLuts = genericDialog.getNextBoolean();
        if (!IJ.isMacro()) {
            staticCreateComposite = bl2;
            staticKeep = bl3;
            staticIgnoreLuts = this.ignoreLuts;
        }
        ImagePlus[] imagePlusArray = new ImagePlus[4];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        for (n2 = 0; n2 < 4; ++n2) {
            if (nArray2[n2] >= nArray.length) continue;
            imagePlusArray[n2] = WindowManager.getImage(nArray[nArray2[n2]]);
            if (n4 != 0) continue;
            n4 = imagePlusArray[n2].getWidth();
            n5 = imagePlusArray[n2].getHeight();
            n3 = imagePlusArray[n2].getStackSize();
            n6 = imagePlusArray[n2].getBitDepth();
            n7 = imagePlusArray[n2].getNSlices();
            n8 = imagePlusArray[n2].getNFrames();
        }
        if (n4 == 0) {
            this.error("There must be at least one source image or stack.");
            return;
        }
        n2 = 0;
        for (int i = 0; i < 4; ++i) {
            object = imagePlusArray[i];
            if (object == null) continue;
            if (((ImagePlus)object).getStackSize() != n3) {
                this.error("The source stacks must have the same number of images.");
                return;
            }
            if (((ImagePlus)object).isHyperStack()) {
                if (((ImagePlus)object).isComposite() && ((CompositeImage)(imagePlus = (CompositeImage)object)).getMode() != 1) {
                    ((CompositeImage)imagePlus).setMode(1);
                    ((ImagePlus)object).updateAndDraw();
                    if (!IJ.isMacro()) {
                        IJ.run("Channels Tool...");
                    }
                    return;
                }
                if (n6 == 24) {
                    this.error("Source hyperstacks cannot be RGB.");
                    return;
                }
                if (((ImagePlus)object).getNChannels() > 1) {
                    this.error("Source hyperstacks cannot have more than 1 channel.");
                    return;
                }
                if (((ImagePlus)object).getNSlices() != n7 || ((ImagePlus)object).getNFrames() != n8) {
                    this.error("Source hyperstacks must have the same dimensions.");
                    return;
                }
                n2 = 1;
            }
            if (((ImagePlus)object).getWidth() != n4 || imagePlusArray[i].getHeight() != n5) {
                this.error("The source images or stacks must have the same width and height.");
                return;
            }
            if (bl2) {
                for (int j = 0; j < 4; ++j) {
                    if (j == i || imagePlusArray[j] == null || object != imagePlusArray[j]) continue;
                    bl2 = false;
                }
            }
            if (!bl2 || ((ImagePlus)object).getBitDepth() == n6) continue;
            this.error("The source images must have the same bit depth.");
            return;
        }
        ImageStack[] imageStackArray = new ImageStack[]{imagePlusArray[0] != null ? imagePlusArray[0].getStack() : null, imagePlusArray[1] != null ? imagePlusArray[1].getStack() : null, imagePlusArray[2] != null ? imagePlusArray[2].getStack() : null, imagePlusArray[3] != null ? imagePlusArray[3].getStack() : null};
        object = Macro.getOptions();
        if (object != null && ((String)object).indexOf("gray=") == -1) {
            imageStackArray[3] = null;
        }
        boolean bl4 = bl = !bl2 && imageStackArray[3] != null;
        if (bl) {
            bl2 = true;
        }
        if (imageStackArray[3] != null) {
            bl2 = true;
        }
        for (n = 0; n < 4; ++n) {
            if (imagePlusArray[n] == null || imagePlusArray[n].getBitDepth() != 24) continue;
            bl2 = false;
        }
        if (bl2 || n2 != 0) {
            imagePlus = this.mergeHyperstacks(imagePlusArray, bl3);
            if (imagePlus == null) {
                return;
            }
        } else {
            ImageStack imageStack = this.mergeStacks(n4, n5, n3, imageStackArray[0], imageStackArray[1], imageStackArray[2], bl3);
            imagePlus = new ImagePlus("RGB", imageStack);
        }
        if (imagePlusArray[0] != null) {
            imagePlus.setCalibration(imagePlusArray[0].getCalibration());
        }
        if (!bl3) {
            for (n = 0; n < 4; ++n) {
                if (imagePlusArray[n] == null) continue;
                imagePlusArray[n].changes = false;
                imagePlusArray[n].close();
            }
        }
        if (bl) {
            if (n3 == 1) {
                imagePlus = imagePlus.flatten();
                imagePlus.setTitle("RGB");
            } else {
                imagePlus.setTitle("RGB");
                IJ.run(imagePlus, "RGB Color", "slices");
                return;
            }
        }
        imagePlus.show();
    }

    public ImagePlus mergeHyperstacks(ImagePlus[] imagePlusArray, boolean bl) {
        ImageProcessor imageProcessor;
        int n;
        if (this.duplicateImage(imagePlusArray)) {
            bl = true;
        }
        int n2 = imagePlusArray.length;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            if (imagePlusArray[i] == null) continue;
            ++n3;
        }
        if (n3 < 2) {
            return null;
        }
        ImagePlus[] imagePlusArray2 = new ImagePlus[n3];
        Color[] colorArray = new Color[]{Color.red, Color.green, Color.blue, Color.white};
        Color[] colorArray2 = new Color[n3];
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            if (imagePlusArray[i] == null) continue;
            imagePlusArray2[n4] = imagePlusArray[i];
            if (i < colorArray.length) {
                colorArray2[n4] = colorArray[i];
            }
            ++n4;
        }
        imagePlusArray = imagePlusArray2;
        ImageStack[] imageStackArray = new ImageStack[n3];
        for (int i = 0; i < n3; ++i) {
            imageStackArray[i] = imagePlusArray[i].getStack();
        }
        ImagePlus imagePlus = imagePlusArray[0];
        int n5 = imagePlus.getWidth();
        int n6 = imagePlus.getHeight();
        int n7 = imagePlus.getNSlices();
        int n8 = imagePlus.getNFrames();
        ImageStack imageStack = new ImageStack(n5, n6);
        int[] nArray = new int[n3];
        for (int i = 0; i < n8; ++i) {
            for (int j = 0; j < n7; ++j) {
                for (n = 0; n < n3; ++n) {
                    imageProcessor = imageStackArray[n].getProcessor(nArray[n] + 1);
                    if (bl) {
                        imageProcessor = imageProcessor.duplicate();
                    }
                    imageStack.addSlice(null, imageProcessor);
                    if (bl) {
                        int n9 = n;
                        nArray[n9] = nArray[n9] + 1;
                        continue;
                    }
                    imageStackArray[n].deleteSlice(1);
                }
            }
        }
        String string = imagePlus.getTitle();
        string = string.startsWith("C1-") ? string.substring(3) : (n8 > 1 ? "Merged" : "Composite");
        ImagePlus imagePlus2 = new ImagePlus(string, imageStack);
        imagePlus2.setDimensions(n3, n7, n8);
        imagePlus2 = new CompositeImage(imagePlus2, 1);
        for (n = 0; n < n3; ++n) {
            imageProcessor = imagePlusArray[n].getProcessor();
            IndexColorModel indexColorModel = (IndexColorModel)imageProcessor.getColorModel();
            LUT lUT = null;
            if (n < colorArray2.length && colorArray2[n] != null && (this.ignoreLuts || !imageProcessor.isColorLut())) {
                lUT = LUT.createLutFromColor(colorArray2[n]);
                lUT.min = imageProcessor.getMin();
                lUT.max = imageProcessor.getMax();
            } else {
                lUT = new LUT(indexColorModel, imageProcessor.getMin(), imageProcessor.getMax());
            }
            ((CompositeImage)imagePlus2).setChannelLut(lUT, n + 1);
        }
        imagePlus2.setOpenAsHyperStack(true);
        return imagePlus2;
    }

    private boolean duplicateImage(ImagePlus[] imagePlusArray) {
        for (int i = 0; i < imagePlusArray.length; ++i) {
            for (int j = 0; j < imagePlusArray.length; ++j) {
                if (imagePlusArray[i] == null || imagePlusArray[j] == null || i == j || imagePlusArray[i] != imagePlusArray[j]) continue;
                return true;
            }
        }
        return false;
    }

    public ImagePlus createComposite(int n, int n2, int n3, ImageStack[] imageStackArray, boolean bl) {
        ImagePlus[] imagePlusArray = new ImagePlus[imageStackArray.length];
        for (int i = 0; i < imageStackArray.length; ++i) {
            imagePlusArray[i] = new ImagePlus("" + i, imageStackArray[i]);
        }
        return this.mergeHyperstacks(imagePlusArray, bl);
    }

    public ImageStack mergeStacks(int n, int n2, int n3, ImageStack imageStack, ImageStack imageStack2, ImageStack imageStack3, boolean bl) {
        ImageStack imageStack4 = new ImageStack(n, n2);
        int n4 = n3 / 10;
        if (n4 < 1) {
            n4 = 1;
        }
        int n5 = 1;
        this.blank = new byte[n * n2];
        boolean bl2 = imageStack != null ? imageStack.getProcessor(1).isInvertedLut() : false;
        boolean bl3 = imageStack2 != null ? imageStack2.getProcessor(1).isInvertedLut() : false;
        boolean bl4 = imageStack3 != null ? imageStack3.getProcessor(1).isInvertedLut() : false;
        try {
            for (int i = 1; i <= n3; ++i) {
                ColorProcessor colorProcessor = new ColorProcessor(n, n2);
                byte[] byArray = this.getPixels(imageStack, n5, 0);
                byte[] byArray2 = this.getPixels(imageStack2, n5, 1);
                byte[] byArray3 = this.getPixels(imageStack3, n5, 2);
                if (bl2) {
                    byArray = this.invert(byArray);
                }
                if (bl3) {
                    byArray2 = this.invert(byArray2);
                }
                if (bl4) {
                    byArray3 = this.invert(byArray3);
                }
                colorProcessor.setRGB(byArray, byArray2, byArray3);
                if (bl) {
                    ++n5;
                } else {
                    if (imageStack != null) {
                        imageStack.deleteSlice(1);
                    }
                    if (imageStack2 != null && imageStack2 != imageStack) {
                        imageStack2.deleteSlice(1);
                    }
                    if (imageStack3 != null && imageStack3 != imageStack && imageStack3 != imageStack2) {
                        imageStack3.deleteSlice(1);
                    }
                }
                imageStack4.addSlice(null, colorProcessor);
                if (i % n4 != 0) continue;
                IJ.showProgress((double)i / (double)n3);
            }
            IJ.showProgress(1.0);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            IJ.outOfMemory("Merge Stacks");
            IJ.showProgress(1.0);
        }
        return imageStack4;
    }

    byte[] getPixels(ImageStack imageStack, int n, int n2) {
        if (imageStack == null) {
            return this.blank;
        }
        Object object = imageStack.getPixels(n);
        if (!(object instanceof int[])) {
            if (object instanceof byte[]) {
                return (byte[])object;
            }
            ImageProcessor imageProcessor = imageStack.getProcessor(n);
            imageProcessor = imageProcessor.convertToByte(true);
            return (byte[])imageProcessor.getPixels();
        }
        int n3 = imageStack.getWidth() * imageStack.getHeight();
        byte[] byArray = new byte[n3];
        byte[] byArray2 = new byte[n3];
        byte[] byArray3 = new byte[n3];
        ColorProcessor colorProcessor = (ColorProcessor)imageStack.getProcessor(n);
        colorProcessor.getRGB(byArray, byArray2, byArray3);
        switch (n2) {
            case 0: {
                return byArray;
            }
            case 1: {
                return byArray2;
            }
            case 2: {
                return byArray3;
            }
        }
        return null;
    }

    byte[] invert(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        for (int i = 0; i < byArray2.length; ++i) {
            byArray2[i] = (byte)(255 - byArray2[i] & 0xFF);
        }
        return byArray2;
    }

    void error(String string) {
        IJ.error("Merge Channels", string);
    }
}

