/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.util.Tools;
import java.util.Properties;

public class ProxySettings
implements PlugIn {
    private Properties props = System.getProperties();
    private String proxyhost = Prefs.get("proxy.server", "");
    private int proxyport = (int)Prefs.get("proxy.port", 8080.0);

    public void run(String string) {
        double d;
        String string2;
        if (IJ.getApplet() != null) {
            return;
        }
        String string3 = System.getProperty("http.proxyHost");
        if (string3 != null) {
            this.proxyhost = string3;
        }
        if ((string2 = System.getProperty("http.proxyPort")) != null && !Double.isNaN(d = Tools.parseDouble(string2))) {
            this.proxyport = (int)d;
        }
        if (!this.showDialog()) {
            return;
        }
        if (!this.proxyhost.equals("")) {
            this.props.put("proxySet", "true");
        } else {
            this.props.put("proxySet", "false");
        }
        this.props.put("http.proxyHost", this.proxyhost);
        this.props.put("http.proxyPort", "" + this.proxyport);
        Prefs.set("proxy.server", this.proxyhost);
        Prefs.set("proxy.port", this.proxyport);
        try {
            System.setProperty("java.net.useSystemProxies", Prefs.useSystemProxies ? "true" : "false");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (IJ.debugMode) {
            this.logProperties();
        }
    }

    public void logProperties() {
        IJ.log("proxy set: " + System.getProperty("proxySet"));
        IJ.log("proxy host: " + System.getProperty("http.proxyHost"));
        IJ.log("proxy port: " + System.getProperty("http.proxyPort"));
        IJ.log("java.net.useSystemProxies: " + System.getProperty("java.net.useSystemProxies"));
    }

    boolean showDialog() {
        GenericDialog genericDialog = new GenericDialog("Proxy Settings");
        genericDialog.addStringField("Proxy server:", this.proxyhost, 15);
        genericDialog.addNumericField("Port:", this.proxyport, 0);
        genericDialog.addCheckbox("Or, use system proxy settings", Prefs.useSystemProxies);
        genericDialog.addHelp("http://imagej.nih.gov/ij/docs/menus/edit.html#proxy");
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return false;
        }
        this.proxyhost = genericDialog.getNextString();
        this.proxyport = (int)genericDialog.getNextNumber();
        Prefs.useSystemProxies = genericDialog.getNextBoolean();
        return true;
    }
}

