/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.util.Tools;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class Memory
implements PlugIn {
    String s;
    int index1;
    int index2;
    File f;
    boolean fileMissing;
    boolean sixtyFourBit;

    public void run(String string) {
        this.changeMemoryAllocation();
    }

    void changeMemoryAllocation() {
        String string;
        boolean bl;
        IJ.maxMemory();
        int n = (int)(this.getMemorySetting() / 0x100000L);
        boolean bl2 = bl = n == 0;
        if (n == 0) {
            n = (int)(this.maxMemory() / 0x100000L);
        }
        String string2 = "Memory " + (IJ.is64Bit() ? "(64-bit)" : "(32-bit)");
        GenericDialog genericDialog = new GenericDialog(string2);
        genericDialog.addNumericField("Maximum memory:", n, 0, 5, "MB");
        genericDialog.addNumericField("Parallel threads for stacks:", Prefs.getThreads(), 0, 5, "");
        genericDialog.setInsets(12, 0, 0);
        genericDialog.addCheckbox("Keep multiple undo buffers", Prefs.keepUndoBuffers);
        genericDialog.setInsets(12, 0, 0);
        genericDialog.addCheckbox("Run garbage collector on status bar click", !Prefs.noClickToGC);
        genericDialog.addHelp("http://imagej.nih.gov/ij/docs/menus/edit.html#memory");
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        int n2 = (int)genericDialog.getNextNumber();
        Prefs.setThreads((int)genericDialog.getNextNumber());
        Prefs.keepUndoBuffers = genericDialog.getNextBoolean();
        boolean bl3 = Prefs.noClickToGC = !genericDialog.getNextBoolean();
        if (genericDialog.invalidNumber()) {
            IJ.showMessage("Memory", "The number entered was invalid.");
            return;
        }
        if (bl && n2 != n) {
            this.showError();
            return;
        }
        if (n2 < 256 && IJ.isMacOSX()) {
            n2 = 256;
        }
        if (n2 < 32 && IJ.isWindows()) {
            n2 = 32;
        }
        if (n2 == n) {
            return;
        }
        int n3 = IJ.isWindows() ? 1600 : 1700;
        String string3 = "";
        if (IJ.isMacOSX()) {
            string3 = "\n \nOn Max OS X, use\n/Applications/Utilities/Java/Java Preferences\nto switch to a 64-bit version of Java. You may\nalso need to run \"ImageJ64\" instead of \"ImageJ\".";
        }
        if (n2 >= n3 && !IJ.is64Bit()) {
            if (!IJ.showMessageWithCancel(string2, "Note: setting the memory limit to a value\ngreater than " + n3 + "MB on a 32-bit system\n" + "may cause ImageJ to fail to start. The title of\n" + "the Edit>Options>Memory & Threads dialog\n" + "box changes to \"Memory (64-bit)\" when ImageJ\n" + "is running on a 64-bit version of Java." + string3)) {
                // empty if block
            }
            return;
        }
        try {
            string = this.s.substring(this.index2);
            if (string.startsWith("g")) {
                string = "m" + string.substring(1);
            }
            String string4 = this.s.substring(0, this.index1) + n2 + string;
            FileOutputStream fileOutputStream = new FileOutputStream(this.f);
            PrintWriter printWriter = new PrintWriter(fileOutputStream);
            printWriter.print(string4);
            printWriter.close();
        }
        catch (IOException iOException) {
            String string5 = iOException.getMessage();
            if (string5 == null || string5.equals("")) {
                string5 = "" + iOException;
            }
            String string6 = IJ.isMacOSX() ? "Info.plist" : "ImageJ.cfg";
            String string7 = "Unable to update the file \"" + string6 + "\".\n" + " \n" + "\"" + string5 + "\"";
            if (IJ.isVista()) {
                string7 = string7 + "\n \nOn Windows Vista, ImageJ must be installed in a directory that\nthe user can write to, such as \"Desktop\" or \"Documents\"";
            }
            IJ.showMessage("Memory", string7);
            return;
        }
        string = "";
        if (IJ.isWindows() && n2 > 640 && n2 > n) {
            string = "\nDelete the \"ImageJ.cfg\" file, located in the ImageJ folder,\nif ImageJ fails to start.";
        }
        IJ.showMessage("Memory", "The new " + n2 + "MB limit will take effect after ImageJ is restarted." + string);
    }

    public long getMemorySetting() {
        if (IJ.getApplet() != null) {
            return 0L;
        }
        long l = 0L;
        if (IJ.isMacOSX()) {
            if (IJ.is64Bit()) {
                l = this.getMemorySetting("ImageJ64.app/Contents/Info.plist");
            }
            if (l == 0L) {
                l = this.getMemorySetting("ImageJ.app/Contents/Info.plist");
            }
        } else {
            l = this.getMemorySetting("ImageJ.cfg");
        }
        return l;
    }

    void showError() {
        int n = (int)(this.maxMemory() / 0x100000L);
        String string = "ImageJ is unable to change the memory limit. For \nmore information, refer to the installation notes at\n \n    http://imagej.nih.gov/ij/docs/install/\n \n";
        if (this.fileMissing) {
            if (IJ.isMacOSX()) {
                string = string + "The ImageJ application (ImageJ.app) was not found.\n \n";
            } else if (IJ.isWindows()) {
                string = string + "ImageJ.cfg not found.\n \n";
            }
            this.fileMissing = false;
        }
        if (n > 0) {
            string = string + "Current limit: " + n + "MB";
        }
        if (IJ.isVista()) {
            string = string + "\n \nOn Windows Vista, ImageJ must be installed in a directory that\nthe user can write to, such as \"Desktop\" or \"Documents\"";
        }
        IJ.showMessage("Memory", string);
    }

    long getMemorySetting(String string) {
        String string2 = Prefs.getHomeDir() + File.separator + string;
        this.f = new File(string2);
        if (!this.f.exists()) {
            this.fileMissing = true;
            return 0L;
        }
        long l = 0L;
        try {
            int n = (int)this.f.length();
            byte[] byArray = new byte[n];
            FileInputStream fileInputStream = new FileInputStream(this.f);
            fileInputStream.read(byArray, 0, n);
            this.s = new String(byArray, 0, n, "ISO8859_1");
            fileInputStream.close();
            this.index1 = this.s.indexOf("-mx");
            if (this.index1 == -1) {
                this.index1 = this.s.indexOf("-Xmx");
            }
            if (this.index1 == -1) {
                return 0L;
            }
            this.index1 = this.s.charAt(this.index1 + 1) == 'X' ? (this.index1 += 4) : (this.index1 += 3);
            this.index2 = this.index1;
            while (this.index2 < this.s.length() - 1 && Character.isDigit(this.s.charAt(++this.index2))) {
            }
            String string3 = this.s.substring(this.index1, this.index2);
            l = (long)Tools.parseDouble(string3, 0.0) * 1024L * 1024L;
            if (this.index2 < this.s.length() && this.s.charAt(this.index2) == 'g') {
                l *= 1024L;
            }
        }
        catch (Exception exception) {
            IJ.log("" + exception);
            return 0L;
        }
        return l;
    }

    public long maxMemory() {
        return Runtime.getRuntime().maxMemory();
    }
}

