/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.Prefs;
import ij.WindowManager;
import ij.io.SaveDialog;
import ij.measure.ResultsTable;
import ij.plugin.PlugIn;
import ij.text.TextPanel;
import ij.text.TextWindow;
import java.awt.Frame;
import java.io.IOException;

public class MeasurementsWriter
implements PlugIn {
    public void run(String string) {
        this.save(string);
    }

    public boolean save(String string) {
        Frame frame = WindowManager.getFrontWindow();
        if (frame != null && frame instanceof TextWindow) {
            TextWindow textWindow = (TextWindow)frame;
            if (textWindow.getTextPanel().getResultsTable() == null) {
                IJ.error("Save As>Results", "\"" + textWindow.getTitle() + "\" is not a results table");
                return false;
            }
            return textWindow.getTextPanel().saveAs(string);
        }
        if (IJ.isResultsWindow()) {
            TextPanel textPanel = IJ.getTextPanel();
            if (textPanel != null && !textPanel.saveAs(string)) {
                return false;
            }
        } else {
            ResultsTable resultsTable = ResultsTable.getResultsTable();
            if (resultsTable == null || resultsTable.getCounter() == 0) {
                return false;
            }
            if (string.equals("")) {
                SaveDialog saveDialog = new SaveDialog("Save as Text", "Results", Prefs.get("options.ext", ".xls"));
                String string2 = saveDialog.getFileName();
                if (string2 == null) {
                    return false;
                }
                string = saveDialog.getDirectory() + string2;
            }
            try {
                resultsTable.saveAs(string);
            }
            catch (IOException iOException) {
                IJ.error("" + iOException);
            }
        }
        return true;
    }
}

