/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Undo;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.plugin.frame.Recorder;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij.process.StackProcessor;

public class ImageCalculator
implements PlugIn {
    private static String[] operators = new String[]{"Add", "Subtract", "Multiply", "Divide", "AND", "OR", "XOR", "Min", "Max", "Average", "Difference", "Copy", "Transparent-zero"};
    private static String[] lcOperators = new String[]{"add", "sub", "mul", "div", "and", "or", "xor", "min", "max", "ave", "diff", "copy", "zero"};
    private static int operator;
    private static String title1;
    private static String title2;
    private static boolean createWindow;
    private static boolean floatResult;
    private boolean processStack;

    public void run(String string) {
        ImagePlus imagePlus;
        Object object;
        int[] nArray = WindowManager.getIDList();
        if (nArray == null) {
            IJ.noImage();
            return;
        }
        IJ.register(ImageCalculator.class);
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            object = WindowManager.getImage(nArray[i]);
            stringArray[i] = object != null ? ((ImagePlus)object).getTitle() : "";
        }
        GenericDialog genericDialog = new GenericDialog("Image Calculator", IJ.getInstance());
        object = title1.equals("") ? stringArray[0] : title1;
        genericDialog.addChoice("Image1:", stringArray, (String)object);
        genericDialog.addChoice("Operation:", operators, operators[operator]);
        object = title2.equals("") ? stringArray[0] : title2;
        genericDialog.addChoice("Image2:", stringArray, (String)object);
        genericDialog.addCheckbox("Create new window", createWindow);
        genericDialog.addCheckbox("32-bit (float) result", floatResult);
        genericDialog.addHelp("http://imagej.nih.gov/ij/docs/menus/process.html#calculator");
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        int n = genericDialog.getNextChoiceIndex();
        title1 = stringArray[n];
        operator = genericDialog.getNextChoiceIndex();
        int n2 = genericDialog.getNextChoiceIndex();
        createWindow = genericDialog.getNextBoolean();
        floatResult = genericDialog.getNextBoolean();
        title2 = stringArray[n2];
        ImagePlus imagePlus2 = WindowManager.getImage(nArray[n]);
        ImagePlus imagePlus3 = this.calculate(imagePlus2, imagePlus = WindowManager.getImage(nArray[n2]), false);
        if (imagePlus3 != null) {
            imagePlus3.show();
        }
    }

    public ImagePlus run(String string, ImagePlus imagePlus, ImagePlus imagePlus2) {
        if (imagePlus == null || imagePlus2 == null || string == null) {
            return null;
        }
        operator = this.getOperator(string);
        if (operator == -1) {
            throw new IllegalArgumentException("No valid operator");
        }
        createWindow = string.indexOf("create") != -1;
        floatResult = string.indexOf("32") != -1 || string.indexOf("float") != -1;
        this.processStack = string.indexOf("stack") != -1;
        return this.calculate(imagePlus, imagePlus2, true);
    }

    public void calculate(String string, ImagePlus imagePlus, ImagePlus imagePlus2) {
        if (imagePlus == null || imagePlus2 == null || string == null) {
            return;
        }
        operator = this.getOperator(string);
        if (operator == -1) {
            IJ.error("Image Calculator", "No valid operator");
            return;
        }
        createWindow = string.indexOf("create") != -1;
        floatResult = string.indexOf("32") != -1 || string.indexOf("float") != -1;
        this.processStack = string.indexOf("stack") != -1;
        ImagePlus imagePlus3 = this.calculate(imagePlus, imagePlus2, true);
        if (imagePlus3 != null) {
            imagePlus3.show();
        }
    }

    int getOperator(String string) {
        string = string.toLowerCase();
        int n = -1;
        if (string.indexOf("xor") != -1) {
            n = 6;
        }
        if (n == -1) {
            for (int i = 0; i < lcOperators.length; ++i) {
                if (string.indexOf(lcOperators[i]) == -1) continue;
                n = i;
                break;
            }
        }
        return n;
    }

    ImagePlus calculate(ImagePlus imagePlus, ImagePlus imagePlus2, boolean bl) {
        ImagePlus imagePlus3 = null;
        if (imagePlus.getCalibration().isSigned16Bit() || imagePlus2.getCalibration().isSigned16Bit()) {
            floatResult = true;
        }
        if (floatResult && (imagePlus.getBitDepth() != 32 || imagePlus2.getBitDepth() != 32)) {
            createWindow = true;
        }
        int n = imagePlus.getStackSize();
        int n2 = imagePlus2.getStackSize();
        if (bl) {
            imagePlus3 = this.processStack && (n > 1 || n2 > 1) ? this.doStackOperation(imagePlus, imagePlus2) : this.doOperation(imagePlus, imagePlus2);
            return imagePlus3;
        }
        boolean bl2 = false;
        if (n > 1) {
            int n3 = IJ.setupDialog(imagePlus, 0);
            if (n3 == 4096) {
                return null;
            }
            if (n3 == 32) {
                imagePlus3 = this.doStackOperation(imagePlus, imagePlus2);
                bl2 = true;
            } else {
                imagePlus3 = this.doOperation(imagePlus, imagePlus2);
            }
        } else {
            imagePlus3 = this.doOperation(imagePlus, imagePlus2);
        }
        if (Recorder.record) {
            String string = operators[operator];
            if (createWindow) {
                string = string + " create";
            }
            if (floatResult) {
                string = string + " 32-bit";
            }
            if (bl2) {
                string = string + " stack";
            }
            if (Recorder.scriptMode()) {
                Recorder.recordCall("ic = new ImageCalculator();\nimp3 = ic.run(\"" + string + "\", imp1, imp2);");
            } else {
                Recorder.record("imageCalculator", string, imagePlus.getTitle(), imagePlus2.getTitle());
            }
            Recorder.setCommand(null);
        }
        return imagePlus3;
    }

    ImagePlus doStackOperation(ImagePlus imagePlus, ImagePlus imagePlus2) {
        ImagePlus imagePlus3 = null;
        int n = imagePlus.getStackSize();
        int n2 = imagePlus2.getStackSize();
        if (n > 1 && n2 > 1 && n != n2) {
            IJ.error("Image Calculator", "'Image1' and 'image2' must be stacks with the same\nnumber of slices, or 'image2' must be a single image.");
            return null;
        }
        if (createWindow) {
            if ((imagePlus = this.duplicateStack(imagePlus)) == null) {
                IJ.error("Calculator", "Out of memory");
                return null;
            }
            imagePlus3 = imagePlus;
        }
        int n3 = this.getBlitterMode();
        ImageWindow imageWindow = imagePlus.getWindow();
        if (imageWindow != null) {
            WindowManager.setCurrentWindow(imageWindow);
        }
        Undo.reset();
        ImageStack imageStack = imagePlus.getStack();
        StackProcessor stackProcessor = new StackProcessor(imageStack, imagePlus.getProcessor());
        try {
            if (n2 == 1) {
                stackProcessor.copyBits(imagePlus2.getProcessor(), 0, 0, n3);
            } else {
                stackProcessor.copyBits(imagePlus2.getStack(), 0, 0, n3);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            IJ.error("\"" + imagePlus.getTitle() + "\": " + illegalArgumentException.getMessage());
            return null;
        }
        imagePlus.setStack(null, imageStack);
        if (imagePlus.getType() != 0) {
            imagePlus.getProcessor().resetMinAndMax();
        }
        if (imagePlus3 == null) {
            imagePlus.updateAndDraw();
        }
        return imagePlus3;
    }

    ImagePlus doOperation(ImagePlus imagePlus, ImagePlus imagePlus2) {
        ImagePlus imagePlus3 = null;
        int n = this.getBlitterMode();
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        ImageProcessor imageProcessor2 = imagePlus2.getProcessor();
        Calibration calibration = imagePlus.getCalibration();
        Calibration calibration2 = imagePlus2.getCalibration();
        if (createWindow) {
            imageProcessor = this.createNewImage(imageProcessor, imageProcessor2);
        } else {
            ImageWindow imageWindow = imagePlus.getWindow();
            if (imageWindow != null) {
                WindowManager.setCurrentWindow(imageWindow);
            }
            imageProcessor.snapshot();
            Undo.setup(1, imagePlus);
        }
        if (floatResult) {
            imageProcessor2 = imageProcessor2.convertToFloat();
        }
        try {
            imageProcessor.copyBits(imageProcessor2, 0, 0, n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            IJ.error("\"" + imagePlus.getTitle() + "\": " + illegalArgumentException.getMessage());
            return null;
        }
        if (!(imageProcessor instanceof ByteProcessor)) {
            imageProcessor.resetMinAndMax();
        }
        if (createWindow) {
            imagePlus3 = new ImagePlus("Result of " + imagePlus.getTitle(), imageProcessor);
            imagePlus3.setCalibration(calibration);
        } else {
            imagePlus.updateAndDraw();
        }
        return imagePlus3;
    }

    ImageProcessor createNewImage(ImageProcessor imageProcessor, ImageProcessor imageProcessor2) {
        int n = Math.min(imageProcessor.getWidth(), imageProcessor2.getWidth());
        int n2 = Math.min(imageProcessor.getHeight(), imageProcessor2.getHeight());
        ImageProcessor imageProcessor3 = imageProcessor.createProcessor(n, n2);
        if (floatResult) {
            imageProcessor = imageProcessor.convertToFloat();
            imageProcessor3 = imageProcessor3.convertToFloat();
        }
        imageProcessor3.insert(imageProcessor, 0, 0);
        return imageProcessor3;
    }

    private int getBlitterMode() {
        int n = 0;
        switch (operator) {
            case 0: {
                n = 3;
                break;
            }
            case 1: {
                n = 4;
                break;
            }
            case 2: {
                n = 5;
                break;
            }
            case 3: {
                n = 6;
                break;
            }
            case 4: {
                n = 9;
                break;
            }
            case 5: {
                n = 10;
                break;
            }
            case 6: {
                n = 11;
                break;
            }
            case 7: {
                n = 12;
                break;
            }
            case 8: {
                n = 13;
                break;
            }
            case 9: {
                n = 7;
                break;
            }
            case 10: {
                n = 8;
                break;
            }
            case 11: {
                n = 0;
                break;
            }
            case 12: {
                n = 14;
            }
        }
        return n;
    }

    ImagePlus duplicateStack(ImagePlus imagePlus) {
        Object object;
        Calibration calibration = imagePlus.getCalibration();
        ImageStack imageStack = imagePlus.getStack();
        int n = imageStack.getWidth();
        int n2 = imageStack.getHeight();
        int n3 = imageStack.getSize();
        ImageStack imageStack2 = imagePlus.createEmptyStack();
        try {
            for (int i = 1; i <= n3; ++i) {
                object = imageStack.getProcessor(i);
                ((ImageProcessor)object).resetRoi();
                ImageProcessor imageProcessor = ((ImageProcessor)object).crop();
                if (floatResult) {
                    imageProcessor.setCalibrationTable(calibration.getCTable());
                    imageProcessor = imageProcessor.convertToFloat();
                }
                imageStack2.addSlice(imageStack.getSliceLabel(i), imageProcessor);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            imageStack2.trim();
            imageStack2 = null;
            return null;
        }
        ImagePlus imagePlus2 = new ImagePlus("Result of " + imagePlus.getTitle(), imageStack2);
        imagePlus2.setCalibration(calibration);
        if (imagePlus2.getStackSize() == n3) {
            object = imagePlus.getDimensions();
            imagePlus2.setDimensions((int)object[2], (int)object[3], (int)object[4]);
            if (imagePlus.isComposite()) {
                imagePlus2 = new CompositeImage(imagePlus2, 0);
                ((CompositeImage)imagePlus2).copyLuts(imagePlus);
            }
            if (imagePlus.isHyperStack()) {
                imagePlus2.setOpenAsHyperStack(true);
            }
        }
        return imagePlus2;
    }

    static {
        title1 = "";
        title2 = "";
        createWindow = true;
    }
}

