/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.StackWindow;
import ij.plugin.CompositeConverter;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import ij.process.LUT;

public class HyperStackConverter
implements PlugIn {
    static final int C = 0;
    static final int Z = 1;
    static final int T = 2;
    static final int CZT = 0;
    static final int CTZ = 1;
    static final int ZCT = 2;
    static final int ZTC = 3;
    static final int TCZ = 4;
    static final int TZC = 5;
    static final String[] orders = new String[]{"xyczt(default)", "xyctz", "xyzct", "xyztc", "xytcz", "xytzc"};
    static int order = 0;
    static boolean splitRGB = true;

    public void run(String string) {
        if (string.equals("new")) {
            this.newHyperStack();
            return;
        }
        ImagePlus imagePlus = IJ.getImage();
        if (string.equals("stacktohs")) {
            this.convertStackToHS(imagePlus);
        } else if (string.equals("hstostack")) {
            this.convertHSToStack(imagePlus);
        }
    }

    void convertStackToHS(ImagePlus imagePlus) {
        int n = imagePlus.getNChannels();
        int n2 = imagePlus.getNSlices();
        int n3 = imagePlus.getNFrames();
        int n4 = imagePlus.getImageStackSize();
        if (n4 == 1) {
            IJ.error("Stack to HyperStack", "Stack required");
            return;
        }
        boolean bl = imagePlus.getBitDepth() == 24;
        String[] stringArray = new String[]{"Composite", "Color", "Grayscale"};
        GenericDialog genericDialog = new GenericDialog("Convert to HyperStack");
        genericDialog.addChoice("Order:", orders, orders[order]);
        genericDialog.addNumericField("Channels (c):", n, 0);
        genericDialog.addNumericField("Slices (z):", n2, 0);
        genericDialog.addNumericField("Frames (t):", n3, 0);
        genericDialog.addChoice("Display Mode:", stringArray, stringArray[1]);
        if (bl) {
            genericDialog.setInsets(15, 0, 0);
            genericDialog.addCheckbox("Convert RGB to 3 Channel Hyperstack", splitRGB);
        }
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        order = genericDialog.getNextChoiceIndex();
        n = (int)genericDialog.getNextNumber();
        n2 = (int)genericDialog.getNextNumber();
        n3 = (int)genericDialog.getNextNumber();
        int n5 = genericDialog.getNextChoiceIndex();
        if (bl) {
            splitRGB = genericDialog.getNextBoolean();
        }
        if (bl && splitRGB) {
            new CompositeConverter().run(n5 == 0 ? "composite" : "color");
            return;
        }
        if (bl && n > 1) {
            IJ.error("HyperStack Converter", "RGB stacks are limited to one channel");
            return;
        }
        if (n * n2 * n3 != n4) {
            IJ.error("HyperStack Converter", "channels x slices x frames <> stack size");
            return;
        }
        imagePlus.setDimensions(n, n2, n3);
        if (order != 0 && imagePlus.getStack().isVirtual()) {
            IJ.error("HyperStack Converter", "Virtual stacks must by in XYCZT order.");
        } else {
            this.shuffle(imagePlus, order);
            ImagePlus imagePlus2 = imagePlus;
            if (n > 1 && imagePlus.getBitDepth() != 24) {
                LUT[] lUTArray = imagePlus.getLuts();
                if (lUTArray != null && lUTArray.length < n) {
                    lUTArray = null;
                }
                imagePlus2 = new CompositeImage(imagePlus, n5 + 1);
                if (lUTArray != null) {
                    ((CompositeImage)imagePlus2).setLuts(lUTArray);
                }
            } else if (imagePlus.getClass().getName().indexOf("Image5D") != -1) {
                imagePlus2 = imagePlus.createImagePlus();
                imagePlus2.setStack(imagePlus.getTitle(), imagePlus.getImageStack());
                imagePlus2.setDimensions(imagePlus.getNChannels(), imagePlus.getNSlices(), imagePlus.getNFrames());
                imagePlus2.getProcessor().resetMinAndMax();
            }
            imagePlus2.setOpenAsHyperStack(true);
            new StackWindow(imagePlus2);
            if (imagePlus != imagePlus2) {
                imagePlus2.setOverlay(imagePlus.getOverlay());
                imagePlus.hide();
                WindowManager.setCurrentWindow(imagePlus2.getWindow());
            }
        }
    }

    public void shuffle(ImagePlus imagePlus, int n) {
        int n2 = imagePlus.getNChannels();
        int n3 = imagePlus.getNSlices();
        int n4 = imagePlus.getNFrames();
        int n5 = 0;
        int n6 = 1;
        int n7 = 2;
        int n8 = n2;
        int n9 = n3;
        int n10 = n4;
        switch (n) {
            case 1: {
                n5 = 0;
                n6 = 2;
                n7 = 1;
                n8 = n2;
                n9 = n4;
                n10 = n3;
                break;
            }
            case 2: {
                n5 = 1;
                n6 = 0;
                n7 = 2;
                n8 = n3;
                n9 = n2;
                n10 = n4;
                break;
            }
            case 3: {
                n5 = 1;
                n6 = 2;
                n7 = 0;
                n8 = n3;
                n9 = n4;
                n10 = n2;
                break;
            }
            case 4: {
                n5 = 2;
                n6 = 0;
                n7 = 1;
                n8 = n4;
                n9 = n2;
                n10 = n3;
                break;
            }
            case 5: {
                n5 = 2;
                n6 = 1;
                n7 = 0;
                n8 = n4;
                n9 = n3;
                n10 = n2;
            }
        }
        if (n != 0) {
            ImageStack imageStack = imagePlus.getImageStack();
            Object[] objectArray = imageStack.getImageArray();
            Object[] objectArray2 = new Object[objectArray.length];
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
            String[] stringArray = imageStack.getSliceLabels();
            String[] stringArray2 = new String[stringArray.length];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            int[] nArray = new int[3];
            nArray[2] = 0;
            while (nArray[2] < n4) {
                nArray[1] = 0;
                while (nArray[1] < n3) {
                    nArray[0] = 0;
                    while (nArray[0] < n2) {
                        int n11 = nArray[0] + nArray[1] * n2 + nArray[2] * n2 * n3;
                        int n12 = nArray[n5] + nArray[n6] * n8 + nArray[n7] * n8 * n9;
                        objectArray[n11] = objectArray2[n12];
                        stringArray[n11] = stringArray2[n12];
                        nArray[0] = nArray[0] + 1;
                    }
                    nArray[1] = nArray[1] + 1;
                }
                nArray[2] = nArray[2] + 1;
            }
        }
    }

    void convertHSToStack(ImagePlus imagePlus) {
        if (!imagePlus.isHyperStack()) {
            return;
        }
        ImagePlus imagePlus2 = imagePlus;
        if (imagePlus.isComposite()) {
            ImageStack imageStack = imagePlus.getStack();
            imagePlus2 = imagePlus.createImagePlus();
            imagePlus2.setStack(imagePlus.getTitle(), imageStack);
            int[] nArray = imagePlus.getDimensions();
            imagePlus2.setDimensions(nArray[2], nArray[3], nArray[4]);
            ImageProcessor imageProcessor = imagePlus2.getProcessor();
            imageProcessor.setColorModel(imageProcessor.getDefaultColorModel());
        }
        imagePlus2.setOpenAsHyperStack(false);
        new StackWindow(imagePlus2);
        if (imagePlus != imagePlus2) {
            imagePlus2.setOverlay(imagePlus.getOverlay());
            imagePlus.hide();
        }
    }

    void newHyperStack() {
        IJ.runMacroFile("ij.jar:HyperStackMaker", "");
    }
}

