/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.Executer;
import ij.IJ;
import ij.Menus;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.util.StringSorter;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;

public class Hotkeys
implements PlugIn {
    private static final String TITLE = "Hotkeys";
    private static String command = "";
    private static String shortcut = "";

    public void run(String string) {
        if (string.equals("install")) {
            this.installHotkey();
        } else if (string.equals("remove")) {
            this.removeHotkey();
        } else {
            Executer executer = new Executer(string);
            executer.run();
        }
        IJ.register(Hotkeys.class);
    }

    void installHotkey() {
        String[] stringArray = this.getAllCommands();
        GenericDialog genericDialog = new GenericDialog("Create Shortcut");
        genericDialog.addChoice("Command:", stringArray, command);
        genericDialog.addStringField("Shortcut:", shortcut, 3);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        command = genericDialog.getNextChoice();
        shortcut = genericDialog.getNextString();
        if (shortcut.equals("")) {
            IJ.showMessage(TITLE, "Shortcut required");
            return;
        }
        if (shortcut.length() > 1) {
            shortcut = shortcut.replace('f', 'F');
        }
        String string = "ij.plugin.Hotkeys(\"" + command + "\")";
        int n = Menus.installPlugin(string, 'h', "*" + command, shortcut, IJ.getInstance());
        switch (n) {
            case -1: {
                IJ.showMessage(TITLE, "The command *" + command + " is already installed");
                break;
            }
            case -2: {
                IJ.showMessage(TITLE, "The shortcut must be a single character or F1-F24.");
                break;
            }
            case -3: {
                IJ.showMessage("The \"" + shortcut + "\" shortcut is already being used.");
                break;
            }
            default: {
                shortcut = "";
            }
        }
    }

    void removeHotkey() {
        String[] stringArray = this.getInstalledCommands();
        if (stringArray == null) {
            IJ.showMessage("Remove...", "No installed commands found.");
            return;
        }
        GenericDialog genericDialog = new GenericDialog("Remove");
        genericDialog.addChoice("Command:", stringArray, "");
        genericDialog.addMessage("The command is not removed\nuntil ImageJ is restarted.");
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        command = genericDialog.getNextChoice();
        int n = Menus.uninstallPlugin(command);
        boolean bl = true;
        if (n == -5) {
            bl = this.deletePlugin(command);
        }
        if (bl) {
            IJ.showStatus("\"" + command + "\" removed; ImageJ restart required");
        } else {
            IJ.showStatus("\"" + command + "\" not removed");
        }
    }

    boolean deletePlugin(String string) {
        String string2 = (String)Menus.getCommands().get(string);
        String string3 = string2 + ".class";
        File file = new File(Menus.getPlugInsPath(), string3);
        if (file == null || !file.exists()) {
            return false;
        }
        return IJ.showMessageWithCancel("Delete Plugin?", "Permanently delete \"" + string3 + "\"?");
    }

    String[] getAllCommands() {
        Vector<String> vector = new Vector<String>();
        Object[] objectArray = Menus.getCommands().keys();
        while (objectArray.hasMoreElements()) {
            String string = (String)objectArray.nextElement();
            if (string.startsWith("*")) continue;
            vector.addElement(string);
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        StringSorter.sort((String[])objectArray);
        return objectArray;
    }

    String[] getInstalledCommands() {
        Vector<String> vector = new Vector<String>();
        Hashtable hashtable = Menus.getCommands();
        Object[] objectArray = hashtable.keys();
        while (objectArray.hasMoreElements()) {
            String string = (String)objectArray.nextElement();
            if (string.startsWith("*")) {
                vector.addElement(string);
                continue;
            }
            String string2 = (String)hashtable.get(string);
            if (string2.indexOf("_") < 0 || string2.startsWith("ij.")) continue;
            vector.addElement(string);
        }
        if (vector.size() == 0) {
            return null;
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        StringSorter.sort((String[])objectArray);
        return objectArray;
    }
}

