/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Undo;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.measure.Measurements;
import ij.plugin.PlugIn;
import ij.process.ColorProcessor;
import ij.process.FHT;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.StackProcessor;
import ij.util.Tools;

public class FFT
implements PlugIn,
Measurements {
    static boolean displayFFT = true;
    public static boolean displayRawPS;
    public static boolean displayFHT;
    public static boolean displayComplex;
    public static String fileName;
    private ImagePlus imp;
    private boolean padded;
    private int originalWidth;
    private int originalHeight;
    private int stackSize = 1;
    private int slice = 1;
    private boolean doFFT;

    public void run(String string) {
        boolean bl;
        if (string.equals("options")) {
            this.showDialog();
            if (this.doFFT) {
                string = "fft";
            } else {
                return;
            }
        }
        this.imp = IJ.getImage();
        if (string.equals("redisplay")) {
            this.redisplayPowerSpectrum();
            return;
        }
        if (string.equals("swap")) {
            this.swapQuadrants(this.imp.getStack());
            this.imp.updateAndDraw();
            return;
        }
        if (string.equals("inverse")) {
            if (this.imp.getTitle().startsWith("FHT of")) {
                this.doFHTInverseTransform();
                return;
            }
            if (this.imp.getStackSize() == 2) {
                this.doComplexInverseTransform();
                return;
            }
        }
        ImageProcessor imageProcessor = this.imp.getProcessor();
        Object object = this.imp.getProperty("FHT");
        FHT fHT = object instanceof FHT ? (FHT)object : null;
        this.stackSize = this.imp.getStackSize();
        if (fHT == null && string.equals("inverse")) {
            IJ.error("FFT", "Frequency domain image required");
            return;
        }
        if (fHT != null) {
            bl = true;
            this.imp.killRoi();
        } else {
            if (this.imp.getRoi() != null) {
                imageProcessor = imageProcessor.crop();
            }
            fHT = this.newFHT(imageProcessor);
            bl = false;
        }
        if (bl) {
            this.doInverseTransform(fHT);
        } else {
            fileName = this.imp.getTitle();
            this.doForewardTransform(fHT);
        }
        IJ.showProgress(1.0);
    }

    void doInverseTransform(FHT fHT) {
        Object object;
        fHT = fHT.getCopy();
        this.doMasking(fHT);
        this.showStatus("Inverse transform");
        fHT.inverseTransform();
        if (fHT.quadrantSwapNeeded) {
            fHT.swapQuadrants();
        }
        fHT.resetMinAndMax();
        Object object2 = fHT;
        if (fHT.originalWidth > 0) {
            fHT.setRoi(0, 0, fHT.originalWidth, fHT.originalHeight);
            object2 = fHT.crop();
        }
        int n = fHT.originalBitDepth > 0 ? fHT.originalBitDepth : this.imp.getBitDepth();
        switch (n) {
            case 8: {
                object2 = ((ImageProcessor)object2).convertToByte(false);
                break;
            }
            case 16: {
                object2 = ((ImageProcessor)object2).convertToShort(false);
                break;
            }
            case 24: {
                this.showStatus("Setting brightness");
                if (fHT.rgb == null || object2 == null) {
                    IJ.error("FFT", "Unable to set brightness");
                    return;
                }
                object = (ColorProcessor)fHT.rgb.duplicate();
                ((ColorProcessor)object).setBrightness((FloatProcessor)object2);
                object2 = object;
                fHT.rgb = null;
                break;
            }
        }
        if (n != 24 && fHT.originalColorModel != null) {
            ((ImageProcessor)object2).setColorModel(fHT.originalColorModel);
        }
        if (((String)(object = this.imp.getTitle())).startsWith("FFT of ")) {
            object = ((String)object).substring(7, ((String)object).length());
        }
        ImagePlus imagePlus = new ImagePlus("Inverse FFT of " + (String)object, (ImageProcessor)object2);
        imagePlus.setCalibration(this.imp.getCalibration());
        imagePlus.show();
    }

    void doForewardTransform(FHT fHT) {
        this.showStatus("Foreward transform");
        fHT.transform();
        this.showStatus("Calculating power spectrum");
        ImageProcessor imageProcessor = fHT.getPowerSpectrum();
        if (!(displayFHT || displayComplex || displayRawPS)) {
            displayFFT = true;
        }
        if (displayFFT) {
            ImagePlus imagePlus = new ImagePlus("FFT of " + this.imp.getTitle(), imageProcessor);
            imagePlus.show();
            imagePlus.setProperty("FHT", fHT);
            imagePlus.setCalibration(this.imp.getCalibration());
        }
    }

    FHT newFHT(ImageProcessor imageProcessor) {
        FHT fHT;
        if (imageProcessor instanceof ColorProcessor) {
            this.showStatus("Extracting brightness");
            FloatProcessor floatProcessor = ((ColorProcessor)imageProcessor).getBrightness();
            fHT = new FHT(this.pad(floatProcessor));
            fHT.rgb = (ColorProcessor)imageProcessor.duplicate();
        } else {
            fHT = new FHT(this.pad(imageProcessor));
        }
        if (this.padded) {
            fHT.originalWidth = this.originalWidth;
            fHT.originalHeight = this.originalHeight;
        }
        fHT.originalBitDepth = this.imp.getBitDepth();
        fHT.originalColorModel = imageProcessor.getColorModel();
        return fHT;
    }

    ImageProcessor pad(ImageProcessor imageProcessor) {
        int n;
        this.originalWidth = imageProcessor.getWidth();
        this.originalHeight = imageProcessor.getHeight();
        int n2 = Math.max(this.originalWidth, this.originalHeight);
        for (n = 2; n < n2; n *= 2) {
        }
        if (n == n2 && this.originalWidth == this.originalHeight) {
            this.padded = false;
            return imageProcessor;
        }
        n2 = n;
        this.showStatus("Padding to " + n2 + "x" + n2);
        ImageStatistics imageStatistics = ImageStatistics.getStatistics(imageProcessor, 2, null);
        ImageProcessor imageProcessor2 = imageProcessor.createProcessor(n2, n2);
        imageProcessor2.setValue(imageStatistics.mean);
        imageProcessor2.fill();
        imageProcessor2.insert(imageProcessor, 0, 0);
        this.padded = true;
        Undo.reset();
        return imageProcessor2;
    }

    void showStatus(String string) {
        if (this.stackSize > 1) {
            IJ.showStatus("FFT: " + this.slice + "/" + this.stackSize);
        } else {
            IJ.showStatus(string);
        }
    }

    void doMasking(FHT fHT) {
        if (this.stackSize > 1) {
            return;
        }
        float[] fArray = (float[])fHT.getPixels();
        ImageProcessor imageProcessor = this.imp.getProcessor();
        if ((imageProcessor = imageProcessor.convertToByte(false)).getWidth() != fHT.getWidth() || imageProcessor.getHeight() != fHT.getHeight()) {
            return;
        }
        ImageStatistics imageStatistics = ImageStatistics.getStatistics(imageProcessor, 16, null);
        if (imageStatistics.histogram[0] == 0 && imageStatistics.histogram[255] == 0) {
            return;
        }
        boolean bl = imageStatistics.histogram[255] != 0;
        IJ.showStatus("Masking: " + (bl ? "pass" : "filter"));
        imageProcessor = imageProcessor.duplicate();
        if (bl) {
            this.changeValuesAndSymmetrize(imageProcessor, (byte)-1, (byte)0);
        } else {
            this.changeValuesAndSymmetrize(imageProcessor, (byte)0, (byte)-1);
        }
        for (int i = 0; i < 3; ++i) {
            FFT.smooth(imageProcessor);
        }
        if (IJ.debugMode || IJ.altKeyDown()) {
            new ImagePlus("mask", imageProcessor.duplicate()).show();
        }
        fHT.swapQuadrants(imageProcessor);
        byte[] byArray = (byte[])imageProcessor.getPixels();
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = (float)((double)(fArray[i] * (float)(byArray[i] & 0xFF)) / 255.0);
        }
    }

    void changeValuesAndSymmetrize(ImageProcessor imageProcessor, byte by, byte by2) {
        byte[] byArray = (byte[])imageProcessor.getPixels();
        int n = imageProcessor.getWidth();
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == by) {
                if (i % n == 0) {
                    if (i <= 0) continue;
                    byArray[n * n - i] = by;
                    continue;
                }
                if (i < n) {
                    byArray[n - i] = by;
                    continue;
                }
                byArray[n * (n + 1) - i] = by;
                continue;
            }
            byArray[i] = by2;
        }
    }

    static void smooth(ImageProcessor imageProcessor) {
        int n;
        byte[] byArray = (byte[])imageProcessor.getPixels();
        byte[] byArray2 = (byte[])byArray.clone();
        int n2 = imageProcessor.getWidth();
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        for (n = 0; n < n2; ++n) {
            nArray[n] = (n - 1 + n2) % n2;
            nArray2[n] = (n + 1) % n2;
        }
        for (n = 0; n < n2; ++n) {
            int n3 = n2 * nArray[n];
            int n4 = n2 * n;
            int n5 = n2 * nArray2[n];
            for (int i = 0; i < n2; ++i) {
                int n6 = (byArray2[n3 + nArray[i]] & 0xFF) + (byArray2[n3 + i] & 0xFF) + (byArray2[n3 + nArray2[i]] & 0xFF) + (byArray2[n4 + nArray[i]] & 0xFF) + (byArray2[n4 + i] & 0xFF) + (byArray2[n4 + nArray2[i]] & 0xFF) + (byArray2[n5 + nArray[i]] & 0xFF) + (byArray2[n5 + i] & 0xFF) + (byArray2[n5 + nArray2[i]] & 0xFF);
                byArray[n4 + i] = (byte)((n6 + 4) / 9);
            }
        }
    }

    void redisplayPowerSpectrum() {
        FHT fHT = (FHT)this.imp.getProperty("FHT");
        if (fHT == null) {
            IJ.error("FFT", "Frequency domain image required");
            return;
        }
        ImageProcessor imageProcessor = fHT.getPowerSpectrum();
        this.imp.setProcessor(null, imageProcessor);
    }

    void swapQuadrants(ImageStack imageStack) {
        FHT fHT = new FHT(new FloatProcessor(1, 1));
        for (int i = 1; i <= imageStack.getSize(); ++i) {
            fHT.swapQuadrants(imageStack.getProcessor(i));
        }
    }

    void showDialog() {
        GenericDialog genericDialog = new GenericDialog("FFT Options");
        genericDialog.setInsets(0, 20, 0);
        genericDialog.addMessage("Display:");
        genericDialog.setInsets(5, 35, 0);
        genericDialog.addCheckbox("FFT window", displayFFT);
        genericDialog.setInsets(0, 35, 0);
        genericDialog.addCheckbox("Raw power spectrum", displayRawPS);
        genericDialog.setInsets(0, 35, 0);
        genericDialog.addCheckbox("Fast Hartley Transform", displayFHT);
        genericDialog.setInsets(0, 35, 0);
        genericDialog.addCheckbox("Complex Fourier Transform", displayComplex);
        genericDialog.setInsets(8, 20, 0);
        genericDialog.addCheckbox("Do forward transform", false);
        genericDialog.addHelp("http://imagej.nih.gov/ij/docs/menus/process.html#fft-options");
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        displayFFT = genericDialog.getNextBoolean();
        displayRawPS = genericDialog.getNextBoolean();
        displayFHT = genericDialog.getNextBoolean();
        displayComplex = genericDialog.getNextBoolean();
        this.doFFT = genericDialog.getNextBoolean();
    }

    void doFHTInverseTransform() {
        FHT fHT = new FHT(this.imp.getProcessor().duplicate());
        fHT.inverseTransform();
        fHT.resetMinAndMax();
        String string = WindowManager.getUniqueName(this.imp.getTitle().substring(7));
        new ImagePlus(string, fHT).show();
    }

    void doComplexInverseTransform() {
        ImageStack imageStack = this.imp.getStack();
        if (!imageStack.getSliceLabel(1).equals("Real")) {
            return;
        }
        int n = this.imp.getWidth();
        this.swapQuadrants(imageStack);
        float[] fArray = (float[])imageStack.getPixels(1);
        float[] fArray2 = (float[])imageStack.getPixels(2);
        float[] fArray3 = new float[n * n];
        float[] fArray4 = new float[n * n];
        this.c2c2DFFT(fArray, fArray2, n, fArray3, fArray4);
        ImageStack imageStack2 = new ImageStack(n, n);
        this.swapQuadrants(imageStack);
        imageStack2.addSlice("Real", fArray3);
        imageStack2.addSlice("Imaginary", fArray4);
        imageStack2 = this.unpad(imageStack2);
        String string = WindowManager.getUniqueName(this.imp.getTitle().substring(10));
        ImagePlus imagePlus = new ImagePlus(string, imageStack2);
        imagePlus.getProcessor().resetMinAndMax();
        imagePlus.show();
    }

    ImageStack unpad(ImageStack imageStack) {
        Object object = this.imp.getProperty("FFT width");
        Object object2 = this.imp.getProperty("FFT height");
        if (object == null || object2 == null) {
            return imageStack;
        }
        int n = (int)Tools.parseDouble((String)object, 0.0);
        int n2 = (int)Tools.parseDouble((String)object2, 0.0);
        if (n == 0 || n2 == 0 || n == imageStack.getWidth() && n2 == imageStack.getHeight()) {
            return imageStack;
        }
        StackProcessor stackProcessor = new StackProcessor(imageStack, null);
        ImageStack imageStack2 = stackProcessor.crop(0, 0, n, n2);
        return imageStack2;
    }

    void c2c2DFFT(float[] fArray, float[] fArray2, int n, float[] fArray3, float[] fArray4) {
        FHT fHT = new FHT(new FloatProcessor(n, n));
        float[] fArray5 = (float[])fHT.getPixels();
        for (int i = 0; i < n; ++i) {
            this.cplxFHT(i, n, fArray, fArray2, false, fArray5);
        }
        fHT.inverseTransform();
        float[] fArray6 = new float[n * n];
        System.arraycopy(fArray5, 0, fArray6, 0, n * n);
        for (int i = 0; i < n; ++i) {
            this.cplxFHT(i, n, fArray, fArray2, true, fArray5);
        }
        fHT.inverseTransform();
        System.arraycopy(fArray6, 0, fArray3, 0, n * n);
        System.arraycopy(fArray5, 0, fArray4, 0, n * n);
    }

    void cplxFHT(int n, int n2, float[] fArray, float[] fArray2, boolean bl, float[] fArray3) {
        int n3 = n * n2;
        int n4 = (n2 - n) % n2 * n2;
        if (!bl) {
            for (int i = 0; i < n2; ++i) {
                int n5 = n4 + (n2 - i) % n2;
                fArray3[n3 + i] = (fArray[n3 + i] + fArray[n5] - (fArray2[n3 + i] - fArray2[n5])) * 0.5f;
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                int n6 = n4 + (n2 - i) % n2;
                fArray3[n3 + i] = (fArray2[n3 + i] + fArray2[n6] + (fArray[n3 + i] - fArray[n6])) * 0.5f;
            }
        }
    }
}

